/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.base;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppId {
    private static final int APP_ID_MAX_LEN = 100;
    private static final Pattern DISPLAY_APP_ID_RE = Pattern.compile("[a-z\\d\\-]{1,100}", 2);
    private static final Pattern DOMAIN_RE = Pattern.compile("([a-z\\d\\-\\.]{1,100})?\\:", 2);
    private static final Pattern PARTITION_RE = Pattern.compile("([a-z\\d\\-]{1,100})?\\~", 2);
    private static final Pattern APP_ID_RE;
    private String appId;
    private String domain;
    private String longAppId;
    private String displayAppId;
    private String partition;

    private AppId(String appId) {
        this.appId = appId;
        if (appId == null || appId.length() == 0) {
            return;
        }
        Matcher matcher = APP_ID_RE.matcher(appId);
        if (!matcher.matches()) {
            return;
        }
        this.partition = matcher.group(1);
        this.longAppId = matcher.group(2);
        this.domain = matcher.group(3);
        this.displayAppId = matcher.group(4);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDisplayAppId() {
        return this.displayAppId;
    }

    public String getPartition() {
        return this.partition;
    }

    public String getLongAppId() {
        return this.longAppId;
    }

    public static AppId parse(String appId) {
        return new AppId(appId);
    }

    static {
        String string = String.valueOf(String.valueOf(PARTITION_RE));
        String string2 = String.valueOf(String.valueOf(DOMAIN_RE));
        String string3 = String.valueOf(String.valueOf(DISPLAY_APP_ID_RE));
        APP_ID_RE = Pattern.compile(new StringBuilder(14 + string.length() + string2.length() + string3.length()).append("(?:").append(string).append(")?((?:").append(string2).append(")?(").append(string3).append("))").toString(), 2);
    }
}

