/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.IllegalFieldValueException;
import com.google.appengine.repackaged.org.joda.time.Instant;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.chrono.AssembledChronology;
import com.google.appengine.repackaged.org.joda.time.field.BaseDateTimeField;
import com.google.appengine.repackaged.org.joda.time.field.BaseDurationField;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormat;
import java.util.HashMap;
import java.util.Locale;

public final class ZonedChronology
extends AssembledChronology {
    private static final long serialVersionUID = -1079258847191166848L;

    public static ZonedChronology getInstance(Chronology base, DateTimeZone zone) {
        if (base == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        if ((base = base.withUTC()) == null) {
            throw new IllegalArgumentException("UTC chronology must not be null");
        }
        if (zone == null) {
            throw new IllegalArgumentException("DateTimeZone must not be null");
        }
        return new ZonedChronology(base, zone);
    }

    static boolean useTimeArithmetic(DurationField field) {
        return field != null && field.getUnitMillis() < 43200000L;
    }

    private ZonedChronology(Chronology base, DateTimeZone zone) {
        super(base, zone);
    }

    @Override
    public DateTimeZone getZone() {
        return (DateTimeZone)this.getParam();
    }

    @Override
    public Chronology withUTC() {
        return this.getBase();
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getParam()) {
            return this;
        }
        if (zone == DateTimeZone.UTC) {
            return this.getBase();
        }
        return new ZonedChronology(this.getBase(), zone);
    }

    @Override
    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int millisOfDay) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(year, monthOfYear, dayOfMonth, millisOfDay));
    }

    @Override
    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond));
    }

    @Override
    public long getDateTimeMillis(long instant, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(instant + (long)this.getZone().getOffset(instant), hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond));
    }

    private long localToUTC(long instant) {
        DateTimeZone zone = this.getZone();
        int offset = zone.getOffsetFromLocal(instant);
        if (offset != zone.getOffset(instant -= (long)offset)) {
            String string = String.valueOf(DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").print(new Instant(instant)));
            throw new IllegalArgumentException(string.length() != 0 ? "Illegal instant due to time zone offset transition: ".concat(string) : new String("Illegal instant due to time zone offset transition: "));
        }
        return instant;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        HashMap<Object, Object> converted = new HashMap<Object, Object>();
        fields.eras = this.convertField(fields.eras, converted);
        fields.centuries = this.convertField(fields.centuries, converted);
        fields.years = this.convertField(fields.years, converted);
        fields.months = this.convertField(fields.months, converted);
        fields.weekyears = this.convertField(fields.weekyears, converted);
        fields.weeks = this.convertField(fields.weeks, converted);
        fields.days = this.convertField(fields.days, converted);
        fields.halfdays = this.convertField(fields.halfdays, converted);
        fields.hours = this.convertField(fields.hours, converted);
        fields.minutes = this.convertField(fields.minutes, converted);
        fields.seconds = this.convertField(fields.seconds, converted);
        fields.millis = this.convertField(fields.millis, converted);
        fields.year = this.convertField(fields.year, converted);
        fields.yearOfEra = this.convertField(fields.yearOfEra, converted);
        fields.yearOfCentury = this.convertField(fields.yearOfCentury, converted);
        fields.centuryOfEra = this.convertField(fields.centuryOfEra, converted);
        fields.era = this.convertField(fields.era, converted);
        fields.dayOfWeek = this.convertField(fields.dayOfWeek, converted);
        fields.dayOfMonth = this.convertField(fields.dayOfMonth, converted);
        fields.dayOfYear = this.convertField(fields.dayOfYear, converted);
        fields.monthOfYear = this.convertField(fields.monthOfYear, converted);
        fields.weekOfWeekyear = this.convertField(fields.weekOfWeekyear, converted);
        fields.weekyear = this.convertField(fields.weekyear, converted);
        fields.weekyearOfCentury = this.convertField(fields.weekyearOfCentury, converted);
        fields.millisOfSecond = this.convertField(fields.millisOfSecond, converted);
        fields.millisOfDay = this.convertField(fields.millisOfDay, converted);
        fields.secondOfMinute = this.convertField(fields.secondOfMinute, converted);
        fields.secondOfDay = this.convertField(fields.secondOfDay, converted);
        fields.minuteOfHour = this.convertField(fields.minuteOfHour, converted);
        fields.minuteOfDay = this.convertField(fields.minuteOfDay, converted);
        fields.hourOfDay = this.convertField(fields.hourOfDay, converted);
        fields.hourOfHalfday = this.convertField(fields.hourOfHalfday, converted);
        fields.clockhourOfDay = this.convertField(fields.clockhourOfDay, converted);
        fields.clockhourOfHalfday = this.convertField(fields.clockhourOfHalfday, converted);
        fields.halfdayOfDay = this.convertField(fields.halfdayOfDay, converted);
    }

    private DurationField convertField(DurationField field, HashMap<Object, Object> converted) {
        if (field == null || !field.isSupported()) {
            return field;
        }
        if (converted.containsKey(field)) {
            return (DurationField)converted.get(field);
        }
        ZonedDurationField zonedField = new ZonedDurationField(field, this.getZone());
        converted.put(field, zonedField);
        return zonedField;
    }

    private DateTimeField convertField(DateTimeField field, HashMap<Object, Object> converted) {
        if (field == null || !field.isSupported()) {
            return field;
        }
        if (converted.containsKey(field)) {
            return (DateTimeField)converted.get(field);
        }
        ZonedDateTimeField zonedField = new ZonedDateTimeField(field, this.getZone(), this.convertField(field.getDurationField(), converted), this.convertField(field.getRangeDurationField(), converted), this.convertField(field.getLeapDurationField(), converted));
        converted.put(field, zonedField);
        return zonedField;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ZonedChronology)) {
            return false;
        }
        ZonedChronology chrono = (ZonedChronology)obj;
        return this.getBase().equals(chrono.getBase()) && this.getZone().equals(chrono.getZone());
    }

    public int hashCode() {
        return 326565 + this.getZone().hashCode() * 11 + this.getBase().hashCode() * 7;
    }

    @Override
    public String toString() {
        String string = String.valueOf(this.getBase());
        String string2 = this.getZone().getID();
        return new StringBuilder(19 + String.valueOf(string).length() + String.valueOf(string2).length()).append("ZonedChronology[").append(string).append(", ").append(string2).append("]").toString();
    }

    static final class ZonedDateTimeField
    extends BaseDateTimeField {
        private static final long serialVersionUID = -3968986277775529794L;
        final DateTimeField iField;
        final DateTimeZone iZone;
        final DurationField iDurationField;
        final boolean iTimeField;
        final DurationField iRangeDurationField;
        final DurationField iLeapDurationField;

        ZonedDateTimeField(DateTimeField field, DateTimeZone zone, DurationField durationField, DurationField rangeDurationField, DurationField leapDurationField) {
            super(field.getType());
            if (!field.isSupported()) {
                throw new IllegalArgumentException();
            }
            this.iField = field;
            this.iZone = zone;
            this.iDurationField = durationField;
            this.iTimeField = ZonedChronology.useTimeArithmetic(durationField);
            this.iRangeDurationField = rangeDurationField;
            this.iLeapDurationField = leapDurationField;
        }

        @Override
        public boolean isLenient() {
            return this.iField.isLenient();
        }

        @Override
        public int get(long instant) {
            long localInstant = this.iZone.convertUTCToLocal(instant);
            return this.iField.get(localInstant);
        }

        @Override
        public String getAsText(long instant, Locale locale) {
            long localInstant = this.iZone.convertUTCToLocal(instant);
            return this.iField.getAsText(localInstant, locale);
        }

        @Override
        public String getAsShortText(long instant, Locale locale) {
            long localInstant = this.iZone.convertUTCToLocal(instant);
            return this.iField.getAsShortText(localInstant, locale);
        }

        @Override
        public String getAsText(int fieldValue, Locale locale) {
            return this.iField.getAsText(fieldValue, locale);
        }

        @Override
        public String getAsShortText(int fieldValue, Locale locale) {
            return this.iField.getAsShortText(fieldValue, locale);
        }

        @Override
        public long add(long instant, int value) {
            if (this.iTimeField) {
                int offset = this.getOffsetToAdd(instant);
                long localInstant = this.iField.add(instant + (long)offset, value);
                return localInstant - (long)offset;
            }
            long localInstant = this.iZone.convertUTCToLocal(instant);
            localInstant = this.iField.add(localInstant, value);
            return this.iZone.convertLocalToUTC(localInstant, false, instant);
        }

        @Override
        public long add(long instant, long value) {
            if (this.iTimeField) {
                int offset = this.getOffsetToAdd(instant);
                long localInstant = this.iField.add(instant + (long)offset, value);
                return localInstant - (long)offset;
            }
            long localInstant = this.iZone.convertUTCToLocal(instant);
            localInstant = this.iField.add(localInstant, value);
            return this.iZone.convertLocalToUTC(localInstant, false, instant);
        }

        @Override
        public long addWrapField(long instant, int value) {
            if (this.iTimeField) {
                int offset = this.getOffsetToAdd(instant);
                long localInstant = this.iField.addWrapField(instant + (long)offset, value);
                return localInstant - (long)offset;
            }
            long localInstant = this.iZone.convertUTCToLocal(instant);
            localInstant = this.iField.addWrapField(localInstant, value);
            return this.iZone.convertLocalToUTC(localInstant, false, instant);
        }

        @Override
        public long set(long instant, int value) {
            long localInstant = this.iZone.convertUTCToLocal(instant);
            long result = this.iZone.convertLocalToUTC(localInstant = this.iField.set(localInstant, value), false, instant);
            if (this.get(result) != value) {
                String string = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").print(new Instant(localInstant));
                String string2 = this.iZone.getID();
                throw new IllegalFieldValueException(this.iField.getType(), value, new StringBuilder(55 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Illegal instant due to time zone offset transition: ").append(string).append(" (").append(string2).append(")").toString());
            }
            return result;
        }

        @Override
        public long set(long instant, String text, Locale locale) {
            long localInstant = this.iZone.convertUTCToLocal(instant);
            localInstant = this.iField.set(localInstant, text, locale);
            return this.iZone.convertLocalToUTC(localInstant, false, instant);
        }

        @Override
        public int getDifference(long minuendInstant, long subtrahendInstant) {
            int offset = this.getOffsetToAdd(subtrahendInstant);
            return this.iField.getDifference(minuendInstant + (long)(this.iTimeField ? offset : this.getOffsetToAdd(minuendInstant)), subtrahendInstant + (long)offset);
        }

        @Override
        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            int offset = this.getOffsetToAdd(subtrahendInstant);
            return this.iField.getDifferenceAsLong(minuendInstant + (long)(this.iTimeField ? offset : this.getOffsetToAdd(minuendInstant)), subtrahendInstant + (long)offset);
        }

        @Override
        public final DurationField getDurationField() {
            return this.iDurationField;
        }

        @Override
        public final DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        @Override
        public boolean isLeap(long instant) {
            long localInstant = this.iZone.convertUTCToLocal(instant);
            return this.iField.isLeap(localInstant);
        }

        @Override
        public int getLeapAmount(long instant) {
            long localInstant = this.iZone.convertUTCToLocal(instant);
            return this.iField.getLeapAmount(localInstant);
        }

        @Override
        public final DurationField getLeapDurationField() {
            return this.iLeapDurationField;
        }

        @Override
        public long roundFloor(long instant) {
            if (this.iTimeField) {
                int offset = this.getOffsetToAdd(instant);
                instant = this.iField.roundFloor(instant + (long)offset);
                return instant - (long)offset;
            }
            long localInstant = this.iZone.convertUTCToLocal(instant);
            localInstant = this.iField.roundFloor(localInstant);
            return this.iZone.convertLocalToUTC(localInstant, false, instant);
        }

        @Override
        public long roundCeiling(long instant) {
            if (this.iTimeField) {
                int offset = this.getOffsetToAdd(instant);
                instant = this.iField.roundCeiling(instant + (long)offset);
                return instant - (long)offset;
            }
            long localInstant = this.iZone.convertUTCToLocal(instant);
            localInstant = this.iField.roundCeiling(localInstant);
            return this.iZone.convertLocalToUTC(localInstant, false, instant);
        }

        @Override
        public long remainder(long instant) {
            long localInstant = this.iZone.convertUTCToLocal(instant);
            return this.iField.remainder(localInstant);
        }

        @Override
        public int getMinimumValue() {
            return this.iField.getMinimumValue();
        }

        @Override
        public int getMinimumValue(long instant) {
            long localInstant = this.iZone.convertUTCToLocal(instant);
            return this.iField.getMinimumValue(localInstant);
        }

        @Override
        public int getMinimumValue(ReadablePartial instant) {
            return this.iField.getMinimumValue(instant);
        }

        @Override
        public int getMinimumValue(ReadablePartial instant, int[] values) {
            return this.iField.getMinimumValue(instant, values);
        }

        @Override
        public int getMaximumValue() {
            return this.iField.getMaximumValue();
        }

        @Override
        public int getMaximumValue(long instant) {
            long localInstant = this.iZone.convertUTCToLocal(instant);
            return this.iField.getMaximumValue(localInstant);
        }

        @Override
        public int getMaximumValue(ReadablePartial instant) {
            return this.iField.getMaximumValue(instant);
        }

        @Override
        public int getMaximumValue(ReadablePartial instant, int[] values) {
            return this.iField.getMaximumValue(instant, values);
        }

        @Override
        public int getMaximumTextLength(Locale locale) {
            return this.iField.getMaximumTextLength(locale);
        }

        @Override
        public int getMaximumShortTextLength(Locale locale) {
            return this.iField.getMaximumShortTextLength(locale);
        }

        private int getOffsetToAdd(long instant) {
            int offset = this.iZone.getOffset(instant);
            long sum = instant + (long)offset;
            if ((instant ^ sum) < 0L && (instant ^ (long)offset) >= 0L) {
                throw new ArithmeticException("Adding time zone offset caused overflow");
            }
            return offset;
        }
    }

    static class ZonedDurationField
    extends BaseDurationField {
        private static final long serialVersionUID = -485345310999208286L;
        final DurationField iField;
        final boolean iTimeField;
        final DateTimeZone iZone;

        ZonedDurationField(DurationField field, DateTimeZone zone) {
            super(field.getType());
            if (!field.isSupported()) {
                throw new IllegalArgumentException();
            }
            this.iField = field;
            this.iTimeField = ZonedChronology.useTimeArithmetic(field);
            this.iZone = zone;
        }

        @Override
        public boolean isPrecise() {
            return this.iTimeField ? this.iField.isPrecise() : this.iField.isPrecise() && this.iZone.isFixed();
        }

        @Override
        public long getUnitMillis() {
            return this.iField.getUnitMillis();
        }

        @Override
        public int getValue(long duration, long instant) {
            return this.iField.getValue(duration, this.addOffset(instant));
        }

        @Override
        public long getValueAsLong(long duration, long instant) {
            return this.iField.getValueAsLong(duration, this.addOffset(instant));
        }

        @Override
        public long getMillis(int value, long instant) {
            return this.iField.getMillis(value, this.addOffset(instant));
        }

        @Override
        public long getMillis(long value, long instant) {
            return this.iField.getMillis(value, this.addOffset(instant));
        }

        @Override
        public long add(long instant, int value) {
            int offset = this.getOffsetToAdd(instant);
            instant = this.iField.add(instant + (long)offset, value);
            return instant - (long)(this.iTimeField ? offset : this.getOffsetFromLocalToSubtract(instant));
        }

        @Override
        public long add(long instant, long value) {
            int offset = this.getOffsetToAdd(instant);
            instant = this.iField.add(instant + (long)offset, value);
            return instant - (long)(this.iTimeField ? offset : this.getOffsetFromLocalToSubtract(instant));
        }

        @Override
        public int getDifference(long minuendInstant, long subtrahendInstant) {
            int offset = this.getOffsetToAdd(subtrahendInstant);
            return this.iField.getDifference(minuendInstant + (long)(this.iTimeField ? offset : this.getOffsetToAdd(minuendInstant)), subtrahendInstant + (long)offset);
        }

        @Override
        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            int offset = this.getOffsetToAdd(subtrahendInstant);
            return this.iField.getDifferenceAsLong(minuendInstant + (long)(this.iTimeField ? offset : this.getOffsetToAdd(minuendInstant)), subtrahendInstant + (long)offset);
        }

        private int getOffsetToAdd(long instant) {
            int offset = this.iZone.getOffset(instant);
            long sum = instant + (long)offset;
            if ((instant ^ sum) < 0L && (instant ^ (long)offset) >= 0L) {
                throw new ArithmeticException("Adding time zone offset caused overflow");
            }
            return offset;
        }

        private int getOffsetFromLocalToSubtract(long instant) {
            int offset = this.iZone.getOffsetFromLocal(instant);
            long diff = instant - (long)offset;
            if ((instant ^ diff) < 0L && (instant ^ (long)offset) < 0L) {
                throw new ArithmeticException("Subtracting time zone offset caused overflow");
            }
            return offset;
        }

        private long addOffset(long instant) {
            return this.iZone.convertUTCToLocal(instant);
        }
    }
}

