/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.chrono.AssembledChronology;
import com.google.appengine.repackaged.org.joda.time.field.LenientDateTimeField;

public final class LenientChronology
extends AssembledChronology {
    private static final long serialVersionUID = -3148237568046877177L;
    private transient Chronology iWithUTC;

    public static LenientChronology getInstance(Chronology base) {
        if (base == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        return new LenientChronology(base);
    }

    private LenientChronology(Chronology base) {
        super(base, null);
    }

    @Override
    public Chronology withUTC() {
        if (this.iWithUTC == null) {
            this.iWithUTC = this.getZone() == DateTimeZone.UTC ? this : LenientChronology.getInstance(this.getBase().withUTC());
        }
        return this.iWithUTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == DateTimeZone.UTC) {
            return this.withUTC();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return LenientChronology.getInstance(this.getBase().withZone(zone));
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        fields.year = this.convertField(fields.year);
        fields.yearOfEra = this.convertField(fields.yearOfEra);
        fields.yearOfCentury = this.convertField(fields.yearOfCentury);
        fields.centuryOfEra = this.convertField(fields.centuryOfEra);
        fields.era = this.convertField(fields.era);
        fields.dayOfWeek = this.convertField(fields.dayOfWeek);
        fields.dayOfMonth = this.convertField(fields.dayOfMonth);
        fields.dayOfYear = this.convertField(fields.dayOfYear);
        fields.monthOfYear = this.convertField(fields.monthOfYear);
        fields.weekOfWeekyear = this.convertField(fields.weekOfWeekyear);
        fields.weekyear = this.convertField(fields.weekyear);
        fields.weekyearOfCentury = this.convertField(fields.weekyearOfCentury);
        fields.millisOfSecond = this.convertField(fields.millisOfSecond);
        fields.millisOfDay = this.convertField(fields.millisOfDay);
        fields.secondOfMinute = this.convertField(fields.secondOfMinute);
        fields.secondOfDay = this.convertField(fields.secondOfDay);
        fields.minuteOfHour = this.convertField(fields.minuteOfHour);
        fields.minuteOfDay = this.convertField(fields.minuteOfDay);
        fields.hourOfDay = this.convertField(fields.hourOfDay);
        fields.hourOfHalfday = this.convertField(fields.hourOfHalfday);
        fields.clockhourOfDay = this.convertField(fields.clockhourOfDay);
        fields.clockhourOfHalfday = this.convertField(fields.clockhourOfHalfday);
        fields.halfdayOfDay = this.convertField(fields.halfdayOfDay);
    }

    private final DateTimeField convertField(DateTimeField field) {
        return LenientDateTimeField.getInstance(field, this.getBase());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LenientChronology)) {
            return false;
        }
        LenientChronology chrono = (LenientChronology)obj;
        return this.getBase().equals(chrono.getBase());
    }

    public int hashCode() {
        return 236548278 + this.getBase().hashCode() * 7;
    }

    @Override
    public String toString() {
        String string = this.getBase().toString();
        return new StringBuilder(19 + String.valueOf(string).length()).append("LenientChronology[").append(string).append("]").toString();
    }
}

