/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1beta3.client;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.Datastore;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.DatastoreOptions;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.RemoteRpc;
import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

abstract class BaseDatastoreFactory<T> {
    private static final Logger logger = Logger.getLogger(BaseDatastoreFactory.class.getName());
    private static ConsoleHandler methodHandler;

    protected abstract String buildUrl(DatastoreOptions var1, String var2);

    public abstract T create(DatastoreOptions var1) throws IllegalArgumentException;

    private static synchronized StreamHandler getStreamHandler() {
        if (methodHandler == null) {
            methodHandler = new ConsoleHandler();
            methodHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return String.valueOf(record.getMessage()).concat("\n");
                }
            });
            methodHandler.setLevel(Level.FINE);
        }
        return methodHandler;
    }

    protected BaseDatastoreFactory() {
    }

    protected RemoteRpc newRemoteRpc(DatastoreOptions options) {
        return this.newRemoteRpc(options, System.getenv("DATASTORE_URL_INTERNAL_OVERRIDE"));
    }

    protected RemoteRpc newRemoteRpc(DatastoreOptions options, String urlOverride) {
        if (options == null) {
            throw new IllegalArgumentException("options not set");
        }
        HttpRequestFactory client = this.makeClient(options);
        return new RemoteRpc(client, options.getInitializer(), this.buildUrl(options, urlOverride));
    }

    public HttpRequestFactory makeClient(DatastoreOptions options) {
        HttpTransport transport;
        Credential credential = options.getCredential();
        if (credential == null) {
            logger.warning("Not using any credentials");
        }
        if ((transport = options.getTransport()) == null) {
            transport = credential == null ? new NetHttpTransport() : credential.getTransport();
        }
        return transport.createRequestFactory(credential);
    }

    public static void logMethodCalls() {
        Logger logger = Logger.getLogger(Datastore.class.getName());
        logger.setLevel(Level.FINE);
        if (!Arrays.asList(logger.getHandlers()).contains(BaseDatastoreFactory.getStreamHandler())) {
            logger.addHandler(BaseDatastoreFactory.getStreamHandler());
        }
    }
}

