/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

import com.google.appengine.api.urlfetch.HTTPHeader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTTPResponse
implements Serializable {
    static final long serialVersionUID = -4270789523885950851L;
    private final int responseCode;
    private final List<HTTPHeader> headers;
    private final HashMap<String, String> combinedHeadersMap;
    private byte[] content;
    private URL finalUrl;

    HTTPResponse(int responseCode) {
        this.responseCode = responseCode;
        this.headers = new ArrayList<HTTPHeader>();
        this.combinedHeadersMap = new HashMap();
        this.finalUrl = null;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public byte[] getContent() {
        return this.content;
    }

    public URL getFinalUrl() {
        return this.finalUrl;
    }

    public List<HTTPHeader> getHeadersUncombined() {
        return Collections.unmodifiableList(this.headers);
    }

    public List<HTTPHeader> getHeaders() {
        ArrayList<HTTPHeader> combinedHeaders = new ArrayList<HTTPHeader>();
        for (Map.Entry<String, String> entry : this.combinedHeadersMap.entrySet()) {
            combinedHeaders.add(new HTTPHeader(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableList(combinedHeaders);
    }

    void addHeader(String name, String value) {
        this.headers.add(new HTTPHeader(name, value));
        String combinedValue = this.combinedHeadersMap.get(name);
        if (combinedValue == null) {
            this.combinedHeadersMap.put(name, value);
        } else {
            String string = String.valueOf(String.valueOf(combinedValue));
            String string2 = String.valueOf(String.valueOf(value));
            this.combinedHeadersMap.put(name, new StringBuilder(2 + string.length() + string2.length()).append(string).append(", ").append(string2).toString());
        }
    }

    void setContent(byte[] content) {
        this.content = content;
    }

    void setFinalUrl(URL finalUrl) {
        this.finalUrl = finalUrl;
    }
}

