/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.query;

import java.util.NoSuchElementException;

public class ParserUtils {
    private static int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    private ParserUtils() {
    }

    public static String trimLast(String text) {
        return text.substring(0, text.length() - 1);
    }

    public static String normalizePhrase(String phrase) {
        PhraseCharIterator iter = new PhraseCharIterator(phrase);
        StringBuilder builder = new StringBuilder(phrase.length());
        block0: while (iter.hasNext()) {
            char c;
            while (iter.hasNext() && !Character.isWhitespace(c = iter.next())) {
                builder.append(c);
            }
            while (iter.hasNext()) {
                c = iter.next();
                if (Character.isWhitespace(c)) continue;
                builder.append(' ').append(c);
                continue block0;
            }
        }
        return builder.toString();
    }

    public static boolean isNumber(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        int i = 0;
        if (text.charAt(0) == '-') {
            if (text.length() == 1) {
                return false;
            }
            ++i;
        }
        if ((i = ParserUtils.consumeDigits(i, text)) >= text.length()) {
            return true;
        }
        if (text.charAt(i) == '.') {
            i = ParserUtils.consumeDigits(i + 1, text);
        }
        if (i >= text.length()) {
            return true;
        }
        if (text.charAt(i) != 'E' && text.charAt(i) != 'e') {
            return false;
        }
        if (++i >= text.length()) {
            return false;
        }
        if ((text.charAt(i) == '+' || text.charAt(i) == '-') && ++i >= text.length()) {
            return false;
        }
        return ParserUtils.consumeDigits(i, text) >= text.length();
    }

    private static int consumeDigits(int i, String text) {
        while (i < text.length() && Character.isDigit(text.charAt(i))) {
            ++i;
        }
        return i;
    }

    public static boolean isDate(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        int year = 0;
        int i = 0;
        char c = '\u0000';
        if (text.charAt(i) == '-') {
            ++i;
        }
        while (i < text.length() && Character.isDigit(c = text.charAt(i++))) {
            year = year * 10 + (c - 48);
        }
        if (i >= text.length()) {
            return false;
        }
        if (c != '-') {
            return false;
        }
        int month = 0;
        while (i < text.length() && Character.isDigit(c = text.charAt(i++))) {
            if ((month = month * 10 + (c - 48)) <= 12) continue;
            return false;
        }
        if (month <= 0) {
            return false;
        }
        if (i >= text.length()) {
            return false;
        }
        if (c != '-') {
            return false;
        }
        int day = 0;
        while (i < text.length()) {
            if (!Character.isDigit(c = text.charAt(i++))) {
                return false;
            }
            day = day * 10 + (c - 48);
        }
        if (day <= 0) {
            return false;
        }
        if (month == 2 && (year % 400 == 0 || year % 100 != 0 && year % 4 == 0)) {
            return day <= 29;
        }
        return day <= MONTH_LENGTH[month - 1];
    }

    private static class PhraseCharIterator {
        private final String text;
        private int i;
        private int n;
        private char leftOver;

        public PhraseCharIterator(String text) {
            this.text = text;
            this.i = 1;
            this.n = text.length() - 2;
            while (this.i < this.n && Character.isWhitespace(text.charAt(this.i))) {
                ++this.i;
            }
            while (this.n > this.i && Character.isWhitespace(text.charAt(this.n))) {
                --this.n;
            }
            this.leftOver = '\u0000';
        }

        private static boolean isOctal(char c) {
            return '0' < c && c < '8';
        }

        public boolean hasNext() {
            return this.leftOver != '\u0000' || this.i <= this.n;
        }

        public char next() {
            int c;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.leftOver != '\u0000') {
                c = this.leftOver;
                this.leftOver = '\u0000';
            } else if ((c = this.text.charAt(this.i++)) == 92) {
                if (this.i <= this.n) {
                    c = this.text.charAt(this.i++);
                    switch (c) {
                        case 39: {
                            c = 39;
                            break;
                        }
                        case 34: {
                            c = 34;
                            break;
                        }
                        case 117: {
                            if (this.i + 3 <= this.n) {
                                try {
                                    c = PhraseCharIterator.toChar(Integer.parseInt(this.text.substring(this.i, this.i + 4), 16));
                                    this.i += 4;
                                }
                                catch (NumberFormatException e) {
                                    c = 92;
                                    this.leftOver = (char)117;
                                }
                                break;
                            }
                            c = 92;
                            this.leftOver = (char)117;
                            break;
                        }
                        default: {
                            if (!PhraseCharIterator.isOctal((char)c)) {
                                this.leftOver = c;
                                c = 92;
                                break;
                            }
                            int codeSoFar = c - 48;
                            for (int countSoFar = 1; this.i <= this.n && countSoFar < 3; ++countSoFar) {
                                char nextChar;
                                if (!PhraseCharIterator.isOctal(nextChar = this.text.charAt(this.i++))) {
                                    this.leftOver = nextChar;
                                    break;
                                }
                                codeSoFar = codeSoFar * 8 + (nextChar - 48);
                            }
                            c = PhraseCharIterator.toChar(codeSoFar);
                            break;
                        }
                    }
                } else {
                    c = 92;
                }
            }
            return (char)c;
        }

        private static char toChar(int code) {
            char[] decoded = Character.toChars(code);
            if (decoded.length > 1) {
                int n = code;
                throw new RuntimeException(new StringBuilder(54).append("Decoded ").append(n).append(" does not return a single character").toString());
            }
            return decoded[0];
        }
    }
}

