/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.FacetOptions;
import com.google.appengine.api.search.FacetRefinement;
import com.google.appengine.api.search.FacetRequest;
import com.google.appengine.api.search.QueryOptions;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.search.checkers.QueryChecker;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class Query {
    private final String query;
    private final boolean enableFacetDiscovery;
    private final QueryOptions options;
    private final FacetOptions facetOptions;
    private final ImmutableList<FacetRequest> returnFacets;
    private final ImmutableList<FacetRefinement> refinements;

    protected Query(Builder builder) {
        this.query = builder.queryString;
        this.enableFacetDiscovery = builder.enableFacetDiscovery;
        this.options = builder.options;
        this.facetOptions = builder.facetOptions;
        this.returnFacets = ImmutableList.copyOf(builder.returnFacets);
        this.refinements = ImmutableList.copyOf(builder.refinements);
        this.checkValid();
    }

    public String getQueryString() {
        return this.query;
    }

    public QueryOptions getOptions() {
        return this.options;
    }

    public FacetOptions getFacetOptions() {
        return this.facetOptions;
    }

    public boolean getEnableFacetDiscovery() {
        return this.enableFacetDiscovery;
    }

    public ImmutableList<FacetRequest> getReturnFacets() {
        return this.returnFacets;
    }

    public ImmutableList<FacetRefinement> getRefinements() {
        return this.refinements;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Query query) {
        return new Builder(query);
    }

    private Query checkValid() {
        Preconditions.checkNotNull(this.query, "query cannot be null");
        return this;
    }

    SearchServicePb.SearchParams.Builder copyToProtocolBuffer() {
        SearchServicePb.SearchParams.Builder builder = SearchServicePb.SearchParams.newBuilder().setQuery(this.query);
        if (this.options == null) {
            QueryOptions.newBuilder().build().copyToProtocolBuffer(builder, this.query);
        } else {
            this.options.copyToProtocolBuffer(builder, this.query);
        }
        if (this.facetOptions == null) {
            FacetOptions.newBuilder().build().copyToProtocolBuffer(builder, this.enableFacetDiscovery);
        } else {
            this.facetOptions.copyToProtocolBuffer(builder, this.enableFacetDiscovery);
        }
        for (FacetRequest facet : this.returnFacets) {
            builder.addIncludeFacet(facet.copyToProtocolBuffer());
        }
        for (FacetRefinement ref : this.refinements) {
            builder.addFacetRefinement(ref.toProtocolBuffer());
        }
        return builder;
    }

    public String toString() {
        return new Util.ToStringHelper("Query").addField("queryString", this.query).addField("options", this.options).addField("enableFacetDiscovery", this.enableFacetDiscovery ? Boolean.TRUE : null).addField("facetOptions", this.facetOptions).addIterableField("returnFacets", this.returnFacets).addIterableField("refinements", this.refinements).finish();
    }

    public static class Builder {
        private String queryString;
        private boolean enableFacetDiscovery;
        private QueryOptions options;
        private FacetOptions facetOptions;
        private List<FacetRequest> returnFacets = new ArrayList<FacetRequest>();
        private List<FacetRefinement> refinements = new ArrayList<FacetRefinement>();

        protected Builder() {
        }

        private Builder(Query query) {
            this.queryString = query.getQueryString();
            this.enableFacetDiscovery = query.getEnableFacetDiscovery();
            this.options = query.getOptions();
            this.facetOptions = query.getFacetOptions();
            this.returnFacets = new ArrayList<FacetRequest>(query.getReturnFacets());
            this.refinements = new ArrayList<FacetRefinement>(query.getRefinements());
        }

        public Builder setOptions(QueryOptions options) {
            this.options = options;
            return this;
        }

        public Builder setOptions(QueryOptions.Builder optionsBuilder) {
            return this.setOptions(optionsBuilder.build());
        }

        public Builder setFacetOptions(FacetOptions options) {
            this.facetOptions = options;
            return this;
        }

        public Builder setFacetOptions(FacetOptions.Builder builder) {
            return this.setFacetOptions(builder.build());
        }

        public Builder setEnableFacetDiscovery(boolean value) {
            this.enableFacetDiscovery = value;
            return this;
        }

        public Builder addReturnFacet(FacetRequest facet) {
            this.returnFacets.add(facet);
            return this;
        }

        public Builder addFacetRefinementFromToken(String token) {
            return this.addFacetRefinement(FacetRefinement.fromTokenString(token));
        }

        public Builder addFacetRefinement(FacetRefinement refinement) {
            this.refinements.add(refinement);
            return this;
        }

        public Builder addReturnFacet(FacetRequest.Builder builder) {
            return this.addReturnFacet(builder.build());
        }

        public Builder addReturnFacet(String facetName) {
            this.returnFacets.add(FacetRequest.newBuilder().setName(facetName).build());
            return this;
        }

        protected Builder setQueryString(String query) {
            this.queryString = QueryChecker.checkQuery(query);
            return this;
        }

        public Query build(String queryString) {
            this.setQueryString(queryString);
            return new Query(this);
        }

        public Query build() {
            return new Query(this);
        }
    }
}

