/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.GetIndexesRequestChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;

public final class GetIndexesRequest {
    private final Integer offset;
    private final String indexNamePrefix;
    private final Boolean includeStartIndex;
    private final String startIndexName;
    private final Integer limit;
    private final Boolean schemaFetched;
    private final String namespace;

    private GetIndexesRequest(Builder builder) {
        this.offset = builder.offset;
        this.indexNamePrefix = builder.indexNamePrefix;
        this.startIndexName = builder.startIndexName;
        this.includeStartIndex = Util.defaultIfNull(builder.includeStartIndex, Boolean.TRUE);
        this.limit = Util.defaultIfNull(builder.limit, 20);
        this.schemaFetched = builder.schemaFetched;
        this.namespace = builder.namespace;
        this.checkValid();
    }

    public static final Builder newBuilder() {
        return new Builder();
    }

    public static final Builder newBuilder(GetIndexesRequest request) {
        return new Builder(request);
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getIndexNamePrefix() {
        return this.indexNamePrefix;
    }

    public boolean isIncludeStartIndex() {
        return this.includeStartIndex == null ? true : this.includeStartIndex;
    }

    public String getStartIndexName() {
        return this.startIndexName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean isSchemaFetched() {
        return this.schemaFetched;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private GetIndexesRequest checkValid() {
        if (this.limit != null) {
            Preconditions.checkArgument(this.limit > 0, "Limit must be positive");
        }
        if (this.offset != null) {
            Preconditions.checkArgument(this.offset >= 0, "Offset must be non-negative");
        }
        return this;
    }

    SearchServicePb.ListIndexesParams.Builder copyToProtocolBuffer() {
        SearchServicePb.ListIndexesParams.Builder builder = SearchServicePb.ListIndexesParams.newBuilder();
        if (this.schemaFetched != null) {
            builder.setFetchSchema(this.schemaFetched);
        }
        if (this.offset != null) {
            builder.setOffset(this.offset);
        }
        if (this.indexNamePrefix != null) {
            builder.setIndexNamePrefix(this.indexNamePrefix);
        }
        if (this.startIndexName != null) {
            builder.setStartIndexName(this.startIndexName);
            builder.setIncludeStartIndex(this.includeStartIndex);
        }
        if (this.limit != null) {
            builder.setLimit(this.limit);
        }
        if (this.namespace != null) {
            builder.setNamespace(this.namespace);
        }
        return builder;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includeStartIndex == null ? 0 : this.includeStartIndex.hashCode());
        result = 31 * result + (this.indexNamePrefix == null ? 0 : this.indexNamePrefix.hashCode());
        result = 31 * result + (this.limit == null ? 0 : this.limit.hashCode());
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.schemaFetched == null ? 0 : this.schemaFetched.hashCode());
        result = 31 * result + (this.startIndexName == null ? 0 : this.startIndexName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetIndexesRequest other = (GetIndexesRequest)obj;
        return Util.equalObjects(this.includeStartIndex, other.includeStartIndex) && Util.equalObjects(this.indexNamePrefix, other.indexNamePrefix) && Util.equalObjects(this.limit, other.limit) && Util.equalObjects(this.offset, other.offset) && Util.equalObjects(this.schemaFetched, other.schemaFetched) && Util.equalObjects(this.startIndexName, other.startIndexName);
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.offset));
        String string2 = String.valueOf(String.valueOf(this.indexNamePrefix));
        String string3 = String.valueOf(String.valueOf(this.includeStartIndex));
        String string4 = String.valueOf(String.valueOf(this.startIndexName));
        String string5 = String.valueOf(String.valueOf(this.limit));
        String string6 = String.valueOf(String.valueOf(this.schemaFetched));
        return new StringBuilder(105 + string.length() + string2.length() + string3.length() + string4.length() + string5.length() + string6.length()).append("GetIndexesRequest(offset=").append(string).append(", indexNamePrefix=").append(string2).append(", includeStartIndex=").append(string3).append(", startIndexName=").append(string4).append(", limit=").append(string5).append(", schemaFetched=").append(string6).append(")").toString();
    }

    public static final class Builder {
        private Integer offset;
        private String indexNamePrefix;
        private Boolean includeStartIndex;
        private String startIndexName;
        private Integer limit;
        private Boolean schemaFetched;
        private String namespace;

        private Builder() {
            this.includeStartIndex = true;
        }

        private Builder(GetIndexesRequest request) {
            this.offset = request.getOffset();
            this.indexNamePrefix = request.getIndexNamePrefix();
            this.includeStartIndex = request.isIncludeStartIndex();
            this.startIndexName = request.getStartIndexName();
            this.limit = request.getLimit();
            this.schemaFetched = request.isSchemaFetched();
            this.namespace = request.getNamespace();
        }

        public Builder setOffset(Integer offset) {
            this.offset = GetIndexesRequestChecker.checkOffset(offset);
            return this;
        }

        public Builder setIndexNamePrefix(String indexNamePrefix) {
            this.indexNamePrefix = GetIndexesRequestChecker.checkIndexNamePrefix(indexNamePrefix);
            return this;
        }

        public Builder setIncludeStartIndex(boolean includeStartIndex) {
            this.includeStartIndex = includeStartIndex;
            return this;
        }

        public Builder setStartIndexName(String startIndexName) {
            this.startIndexName = GetIndexesRequestChecker.checkStartIndexName(startIndexName);
            return this;
        }

        public Builder setLimit(Integer limit) {
            this.limit = GetIndexesRequestChecker.checkLimit(limit);
            return this;
        }

        public Builder setSchemaFetched(boolean schemaFetched) {
            this.schemaFetched = schemaFetched;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetIndexesRequest build() {
            return new GetIndexesRequest(this);
        }
    }
}

