/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Facet;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.Preconditions;

public final class FacetRange {
    private final String start;
    private final String end;

    private static boolean isFinite(Double number) {
        return !number.isNaN() && !number.isInfinite();
    }

    public static FacetRange withStartEnd(Double start, Double end) {
        Preconditions.checkArgument(FacetRange.isFinite(start), "start should be finite.");
        Preconditions.checkArgument(FacetRange.isFinite(end), "end should be finite.");
        return new FacetRange(Facet.numberToString(start), Facet.numberToString(end));
    }

    public static FacetRange withStart(Double start) {
        Preconditions.checkArgument(FacetRange.isFinite(start), "start should be finite.");
        return new FacetRange(Facet.numberToString(start), null);
    }

    public static FacetRange withEnd(Double end) {
        Preconditions.checkArgument(FacetRange.isFinite(end), "end should be finite.");
        return new FacetRange(null, Facet.numberToString(end));
    }

    private FacetRange(String start, String end) {
        this.start = start;
        this.end = end;
        this.checkValid();
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    private void checkValid() {
        Preconditions.checkArgument(this.getStart() != null || this.getEnd() != null, "range is unbounded.");
    }

    public String toString() {
        return new Util.ToStringHelper("FacetRange").addField("start", this.start).addField("end", this.end).finish();
    }
}

