/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseQueryResultsSource;
import com.google.appengine.api.datastore.CloudDatastoreV1Proxy;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.WrappedQueryResultCloudDatastoreV1;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.Query;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.QueryResultBatch;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RunQueryResponse;
import java.util.concurrent.Future;

class QueryResultsSourceCloudDatastoreV1
extends BaseQueryResultsSource<RunQueryResponse, RunQueryRequest, RunQueryResponse> {
    private final CloudDatastoreV1Proxy dsApiProxy;
    private final RunQueryRequest initialRequest;
    private int remainingLimit;

    QueryResultsSourceCloudDatastoreV1(DatastoreCallbacks callbacks, FetchOptions fetchOptions, Transaction txn, Query query, RunQueryRequest request, Future<RunQueryResponse> runQueryResponse, CloudDatastoreV1Proxy dsApiProxy) {
        super(callbacks, fetchOptions, txn, query, runQueryResponse);
        this.initialRequest = request;
        this.dsApiProxy = dsApiProxy;
        this.remainingLimit = fetchOptions.getLimit() != null ? fetchOptions.getLimit() : -1;
    }

    @Override
    RunQueryRequest buildNextCallPrototype(RunQueryResponse initialResponse) {
        return this.initialRequest;
    }

    @Override
    Future<RunQueryResponse> makeNextCall(RunQueryRequest prototype, BaseQueryResultsSource.WrappedQueryResult latestResult, Integer fetchCount, Integer offset) {
        RunQueryRequest.Builder runQueryRequest = prototype.toBuilder();
        Query.Builder query = runQueryRequest.getQueryBuilder();
        QueryResultBatch latestBatch = ((WrappedQueryResultCloudDatastoreV1)latestResult).getBatch();
        if (latestBatch.getEndCursor().isEmpty()) {
            throw new IllegalArgumentException();
        }
        query.setStartCursor(latestBatch.getEndCursor());
        if (query.hasLimit()) {
            this.remainingLimit -= latestBatch.getEntityResultsCount();
            query.getLimitBuilder().setValue(Math.max(this.remainingLimit, 0));
        }
        if (offset != null) {
            query.setOffset(offset);
        } else {
            query.clearOffset();
        }
        return this.dsApiProxy.runQuery(runQueryRequest.build());
    }

    @Override
    BaseQueryResultsSource.WrappedQueryResult wrapInitialResult(RunQueryResponse initialResponse) {
        return new WrappedQueryResultCloudDatastoreV1(initialResponse.getBatch());
    }

    @Override
    BaseQueryResultsSource.WrappedQueryResult wrapResult(RunQueryResponse res) {
        return new WrappedQueryResultCloudDatastoreV1(res.getBatch());
    }
}

