/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MultiQueryComponent
implements Comparable<MultiQueryComponent> {
    private final Order order;
    private final List<List<Query.FilterPredicate>> filters;

    public MultiQueryComponent(Order order) {
        this.order = order;
        this.filters = new ArrayList<List<Query.FilterPredicate>>();
    }

    public MultiQueryComponent(Order order, List<List<Query.FilterPredicate>> filters) {
        this.order = order;
        this.filters = filters;
    }

    public Order getOrder() {
        return this.order;
    }

    public void addFilters(Query.FilterPredicate ... filters) {
        this.filters.add(Arrays.asList(filters));
    }

    public List<List<Query.FilterPredicate>> getFilters() {
        return this.filters;
    }

    @Override
    public int compareTo(MultiQueryComponent o) {
        return this.order.compareTo(o.order);
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.filters));
        String string2 = String.valueOf(String.valueOf((Object)this.order));
        return new StringBuilder(38 + string.length() + string2.length()).append("MultiQueryComponent [filters=").append(string).append(", order=").append(string2).append("]").toString();
    }

    public static enum Order {
        SERIAL,
        PARALLEL;

    }
}

