/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CloudDatastoreV1Proxy;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.Datastore;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RunQueryResponse;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.ApiProxy;
import java.util.concurrent.Future;

final class LocalCloudDatastoreV1Proxy
implements CloudDatastoreV1Proxy {
    private final ApiProxy.ApiConfig apiConfig;

    LocalCloudDatastoreV1Proxy(ApiProxy.ApiConfig apiConfig) {
        this.apiConfig = apiConfig;
    }

    @Override
    public Future<BeginTransactionResponse> beginTransaction(BeginTransactionRequest request) {
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, Datastore.Method.BeginTransaction, request.toBuilder().setProjectId(DatastoreApiHelper.getCurrentProjectId()).build(), BeginTransactionResponse.PARSER);
    }

    @Override
    public Future<RollbackResponse> rollback(RollbackRequest request) {
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, Datastore.Method.Rollback, request.toBuilder().setProjectId(DatastoreApiHelper.getCurrentProjectId()).build(), RollbackResponse.PARSER);
    }

    @Override
    public Future<RunQueryResponse> runQuery(RunQueryRequest request) {
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, Datastore.Method.RunQuery, request.toBuilder().setProjectId(DatastoreApiHelper.getCurrentProjectId()).build(), RunQueryResponse.PARSER);
    }

    @Override
    public Future<LookupResponse> lookup(LookupRequest request) {
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, Datastore.Method.Lookup, request.toBuilder().setProjectId(DatastoreApiHelper.getCurrentProjectId()).build(), LookupResponse.PARSER);
    }

    @Override
    public Future<AllocateIdsResponse> allocateIds(AllocateIdsRequest request) {
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, Datastore.Method.AllocateIds, request.toBuilder().setProjectId(DatastoreApiHelper.getCurrentProjectId()).build(), AllocateIdsResponse.PARSER);
    }

    @Override
    public Future<CommitResponse> commit(CommitRequest request) {
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, Datastore.Method.Commit, request.toBuilder().setProjectId(DatastoreApiHelper.getCurrentProjectId()).build(), CommitResponse.PARSER);
    }

    @Override
    public Future<CommitResponse> rawCommit(byte[] request) {
        try {
            return this.commit(CommitRequest.parseFrom(request));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(e);
        }
    }
}

