/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CacheOnlyEntityCachingStrategy;
import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.DatastoreBackedEntityCachingStrategy;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityCacheConfig;
import com.google.appengine.api.datastore.EntityCachePolicy;
import com.google.appengine.api.datastore.EntityCachingCriteria;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

abstract class EntityCachingStrategy {
    static final double DEFAULT_DATASTORE_RPC_DEADLINE_SECS = 60.0;

    EntityCachingStrategy() {
    }

    public static EntityCachingStrategy createStrategy(DatastoreServiceConfig datastoreServiceConfig) {
        EntityCacheConfig cacheConfig = datastoreServiceConfig.getEntityCacheConfig();
        if (cacheConfig.getEntityCachePolicy() == EntityCachePolicy.CACHE) {
            return new DatastoreBackedEntityCachingStrategy(datastoreServiceConfig);
        }
        if (cacheConfig.getEntityCachePolicy() == EntityCachePolicy.CACHE_ONLY) {
            return new CacheOnlyEntityCachingStrategy(datastoreServiceConfig);
        }
        String string = String.valueOf(String.valueOf((Object)cacheConfig.getEntityCachePolicy()));
        throw new IllegalStateException(new StringBuilder(22 + string.length()).append("Unknown cache policy: ").append(string).toString());
    }

    public abstract PreGetCachingResult preGet(CurrentTransactionProvider var1, List<Key> var2, Map<Key, Entity> var3);

    protected abstract void postGet(PreGetCachingResult var1, Map<Key, Entity> var2);

    public abstract PreMutationCachingResult prePut(CurrentTransactionProvider var1, List<Entity> var2);

    public abstract PreMutationCachingResult preDelete(CurrentTransactionProvider var1, List<Key> var2);

    public abstract PreMutationCachingResult preCommit(List<Entity> var1, List<Key> var2);

    protected abstract void postMutation(PreMutationCachingResult var1);

    public Future<Map<Key, Entity>> createPostGetFuture(Future<Map<Key, Entity>> resultMap, final PreGetCachingResult preGetResult) {
        return new FutureWrapper<Map<Key, Entity>, Map<Key, Entity>>(resultMap){

            @Override
            protected Map<Key, Entity> wrap(Map<Key, Entity> resultMap) throws Exception {
                EntityCachingStrategy.this.postGet(preGetResult, resultMap);
                return resultMap;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    public <T> Future<T> createPostMutationFuture(Future<T> result, final PreMutationCachingResult preMutationResult) {
        return new FutureWrapper<T, T>(result){

            @Override
            protected T wrap(T result) throws Exception {
                EntityCachingStrategy.this.postMutation(preMutationResult);
                return result;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    protected static List<Entity> getCacheableEntities(DatastoreServiceConfig datastoreServiceConfig, List<Entity> entities) {
        EntityCachingCriteria cachingCriteria = datastoreServiceConfig.getEntityCacheConfig().getEntityCachingCriteria();
        ArrayList<Entity> filteredEntities = Lists.newArrayListWithExpectedSize(entities.size());
        for (Entity entity : entities) {
            Key key = entity.getKey();
            if (!cachingCriteria.isCacheable(key)) continue;
            filteredEntities.add(entity);
        }
        return filteredEntities;
    }

    protected static List<Key> getCacheableKeys(DatastoreServiceConfig datastoreServiceConfig, List<Key> keys) {
        EntityCachingCriteria cachingCriteria = datastoreServiceConfig.getEntityCacheConfig().getEntityCachingCriteria();
        ArrayList<Key> filteredKeys = Lists.newArrayListWithExpectedSize(keys.size());
        for (Key key : keys) {
            if (!cachingCriteria.isCacheable(key)) continue;
            filteredKeys.add(key);
        }
        return filteredKeys;
    }

    public static final class NoOpEntityCachingStrategy
    extends EntityCachingStrategy {
        public static final EntityCachingStrategy INSTANCE = new NoOpEntityCachingStrategy();

        @Override
        public PreGetCachingResult preGet(CurrentTransactionProvider currentTxnProvider, List<Key> keysToGet, Map<Key, Entity> resultMap) {
            return new PreGetCachingResult(ImmutableSet.of());
        }

        @Override
        protected void postGet(PreGetCachingResult preGetResult, Map<Key, Entity> resultMap) {
        }

        @Override
        public PreMutationCachingResult prePut(CurrentTransactionProvider currentTxnProvider, List<Entity> entitiesToPut) {
            return new PreMutationCachingResult(ImmutableSet.of());
        }

        @Override
        public PreMutationCachingResult preDelete(CurrentTransactionProvider currentTxnProvider, List<Key> keysToDelete) {
            return new PreMutationCachingResult(ImmutableSet.of());
        }

        @Override
        public PreMutationCachingResult preCommit(List<Entity> entitiesToPut, List<Key> keysToDelete) {
            return new PreMutationCachingResult(ImmutableSet.of());
        }

        @Override
        protected void postMutation(PreMutationCachingResult preMutationResult) {
        }
    }

    public static class PreMutationCachingResult {
        private Set<Key> mutationKeysToSkip;

        protected PreMutationCachingResult(Set<Key> mutationKeysToSkip) {
            this.mutationKeysToSkip = mutationKeysToSkip;
        }

        public void setMutationKeysToSkip(Set<Key> mutationKeysToSkip) {
            this.mutationKeysToSkip = mutationKeysToSkip;
        }

        public Set<Key> getMutationKeysToSkip() {
            return this.mutationKeysToSkip;
        }
    }

    public static class PreGetCachingResult {
        private Set<Key> keysToSkipLoading;

        protected PreGetCachingResult(Set<Key> keysToSkipLoading) {
            this.keysToSkipLoading = keysToSkipLoading;
        }

        public void setKeysToSkipLoading(Set<Key> keysToSkipLoading) {
            this.keysToSkipLoading = keysToSkipLoading;
        }

        public Set<Key> getKeysToSkipLoading() {
            return this.keysToSkipLoading;
        }
    }
}

