/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CacheValueUtil;
import com.google.appengine.api.datastore.EntityCache;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.apphosting.datastore.EntityStorage;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

final class EntityCacheTranslator {
    static Logger logger = Logger.getLogger(EntityCacheTranslator.class.getName());
    private static final Level LOG_LEVEL = Level.INFO;
    static final Expiration EVICT_IMMEDIATELY = Expiration.onDate(new GregorianCalendar(2013, 0, 1).getTime());
    static final byte[] READ_IN_PROGRESS_MEMCACHE_VALUE = CacheValueUtil.createCacheValue(EntityStorage.CacheValue.State.READ_IN_PROGRESS, null).toByteArray();
    static final byte[] MUTATION_IN_PROGRESS_MEMCACHE_VALUE = CacheValueUtil.createCacheValue(EntityStorage.CacheValue.State.MUTATION_IN_PROGRESS, null).toByteArray();
    static final byte[] EMPTY_MEMCACHE_VALUE = CacheValueUtil.createCacheValue(EntityStorage.CacheValue.State.EMPTY, null).toByteArray();

    public static byte[] toMemcacheValue(EntityStorage.CacheValue value) {
        if (value == null) {
            return EMPTY_MEMCACHE_VALUE;
        }
        switch (value.getStateEnum()) {
            case ENTITY: {
                return value.toByteArray();
            }
            case READ_IN_PROGRESS: {
                return READ_IN_PROGRESS_MEMCACHE_VALUE;
            }
            case MUTATION_IN_PROGRESS: {
                return MUTATION_IN_PROGRESS_MEMCACHE_VALUE;
            }
            case EMPTY: {
                return EMPTY_MEMCACHE_VALUE;
            }
        }
        String string = String.valueOf(String.valueOf(value.getStateEnum()));
        throw new IllegalArgumentException(new StringBuilder(30 + string.length()).append("Unexpected cache value state: ").append(string).toString());
    }

    public static MemcacheService.CasValues toMemcacheCasValues(EntityCache.CasCacheValues casCacheValues) {
        EntityStorage.CacheValue newValue = casCacheValues.getNewValue();
        EntityCache.IdentifiableCacheValue oldValue = casCacheValues.getOldValue();
        if (newValue == null) {
            return new MemcacheService.CasValues(oldValue.getMemcacheValue(), EMPTY_MEMCACHE_VALUE, EVICT_IMMEDIATELY);
        }
        return new MemcacheService.CasValues(oldValue.getMemcacheValue(), EntityCacheTranslator.toMemcacheValue(newValue));
    }

    public static EntityStorage.CacheValue fromMemcacheValue(byte[] memcacheValue) {
        if (memcacheValue == null) {
            return null;
        }
        EntityStorage.CacheValue cacheValue = new EntityStorage.CacheValue();
        if (!cacheValue.mergeFrom(memcacheValue)) {
            logger.log(LOG_LEVEL, "Cache value deserialization error");
            return null;
        }
        if (cacheValue.getStateEnum() == EntityStorage.CacheValue.State.EMPTY) {
            return null;
        }
        return cacheValue;
    }

    public static EntityCache.IdentifiableCacheValue fromMemcacheIdentifiableValue(MemcacheService.IdentifiableValue memcacheValue) {
        byte[] memcacheValueAsBytes;
        try {
            memcacheValueAsBytes = (byte[])memcacheValue.getValue();
        }
        catch (ClassCastException e) {
            logger.log(LOG_LEVEL, "Unexpected cache value type", e);
            return null;
        }
        EntityStorage.CacheValue cacheValue = EntityCacheTranslator.fromMemcacheValue(memcacheValueAsBytes);
        if (cacheValue == null) {
            return null;
        }
        return new EntityCache.IdentifiableCacheValue(memcacheValue, cacheValue);
    }

    public static final String toMemcacheKey(Key key) {
        return KeyFactory.keyToString(key);
    }

    public static final Key fromMemcacheKey(String memcacheKey) {
        return KeyFactory.stringToKey(memcacheKey);
    }

    private EntityCacheTranslator() {
    }
}

