/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.IndexComponent;
import com.google.appengine.api.datastore.UnorderedIndexComponent;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.FluentIterable;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompositeIndexManager {
    private static final String DATASTORE_INDEX_WITH_PROPERTIES_XML_FORMAT = "    <datastore-index kind=\"%s\" %s source=\"%s\">\n%s    </datastore-index>\n\n";
    private static final String ANCESTOR_ATTRIBUTE_FORMAT = "ancestor=\"%s\"";
    private static final String DATASTORE_INDEX_NO_PROPERTIES_XML_FORMAT = "    <datastore-index kind=\"%s\" ancestor=\"%s\" source=\"%s\"/>\n\n";
    private static final String PROPERTY_XML_FORMAT = "        <property name=\"%s\" %s/>\n";
    private static final String ASC_ATTRIBUTE = "direction=\"asc\"";
    private static final String DESC_ATTRIBUTE = "direction=\"desc\"";
    private static final String GEOSPATIAL_ATTRIBUTE = "mode=\"geospatial\"";
    private static final Comparator<OnestoreEntity.Index.Property> PROPERTY_NAME_COMPARATOR = new Comparator<OnestoreEntity.Index.Property>(){

        @Override
        public int compare(OnestoreEntity.Index.Property o1, OnestoreEntity.Index.Property o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final SearchPropertyTransform TO_MODELESS_PROPERTY = new SearchPropertyTransform(null);
    private static final SearchPropertyTransform TO_GEOSPATIAL_PROPERTY = new SearchPropertyTransform(OnestoreEntity.Index.Property.Mode.GEOSPATIAL);

    protected String generateXmlForIndex(OnestoreEntity.Index index, IndexSource source) {
        boolean isAncestor = index.isAncestor();
        if (index.propertySize() == 0) {
            return String.format(DATASTORE_INDEX_NO_PROPERTIES_XML_FORMAT, new Object[]{index.getEntityType(), isAncestor, source});
        }
        boolean isSearchIndex = false;
        StringBuilder sb = new StringBuilder();
        for (OnestoreEntity.Index.Property prop : index.propertys()) {
            String extraAttribute;
            if (prop.getDirectionEnum() == OnestoreEntity.Index.Property.Direction.ASCENDING) {
                extraAttribute = ASC_ATTRIBUTE;
            } else if (prop.getDirectionEnum() == OnestoreEntity.Index.Property.Direction.DESCENDING) {
                extraAttribute = DESC_ATTRIBUTE;
            } else if (prop.getModeEnum() == OnestoreEntity.Index.Property.Mode.GEOSPATIAL) {
                isSearchIndex = true;
                extraAttribute = GEOSPATIAL_ATTRIBUTE;
            } else {
                extraAttribute = "";
            }
            sb.append(String.format(PROPERTY_XML_FORMAT, prop.getName(), extraAttribute));
        }
        String ancestorAttribute = isSearchIndex ? "" : String.format(ANCESTOR_ATTRIBUTE_FORMAT, isAncestor);
        return String.format(DATASTORE_INDEX_WITH_PROPERTIES_XML_FORMAT, new Object[]{index.getEntityType(), ancestorAttribute, source, sb.toString()});
    }

    protected OnestoreEntity.Index compositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery) {
        List<OnestoreEntity.Index.Property> indexProperties;
        DatastorePb.Query query = indexOnlyQuery.getQuery();
        boolean hasKind = query.hasKind();
        boolean isAncestor = query.hasAncestor();
        List<DatastorePb.Query.Filter> filters = query.filters();
        List<DatastorePb.Query.Order> orders = query.orders();
        if (filters.isEmpty() && orders.isEmpty()) {
            return null;
        }
        List<String> eqProps = indexOnlyQuery.getPrefix();
        List<OnestoreEntity.Index.Property> list = indexProperties = indexOnlyQuery.isGeo() ? this.getNeededSearchProps(eqProps, indexOnlyQuery.getGeoProperties()) : this.getRecommendedIndexProps(indexOnlyQuery);
        if (hasKind && !eqProps.isEmpty() && eqProps.size() == filters.size() && !indexOnlyQuery.hasKeyProperty() && orders.isEmpty()) {
            return null;
        }
        if (!(!hasKind || isAncestor || indexProperties.size() > 1 || indexOnlyQuery.isGeo() || indexOnlyQuery.hasKeyProperty() && indexProperties.get(0).getDirectionEnum() != OnestoreEntity.Index.Property.Direction.ASCENDING)) {
            return null;
        }
        OnestoreEntity.Index index = new OnestoreEntity.Index();
        index.setEntityType(query.getKind());
        index.setAncestor(isAncestor);
        index.mutablePropertys().addAll(indexProperties);
        return index;
    }

    private List<OnestoreEntity.Index.Property> getRecommendedIndexProps(IndexComponentsOnlyQuery query) {
        ArrayList<OnestoreEntity.Index.Property> indexProps = new ArrayList<OnestoreEntity.Index.Property>();
        indexProps.addAll(new UnorderedIndexComponent(Sets.newHashSet(query.getPrefix())).preferredIndexProperties());
        for (IndexComponent component : query.getPostfix()) {
            indexProps.addAll(component.preferredIndexProperties());
        }
        return indexProps;
    }

    private List<OnestoreEntity.Index.Property> getNeededSearchProps(List<String> eqProps, List<String> searchProps) {
        ArrayList<OnestoreEntity.Index.Property> result = new ArrayList<OnestoreEntity.Index.Property>();
        result.addAll(FluentIterable.from(eqProps).transform(TO_MODELESS_PROPERTY).toSortedList(PROPERTY_NAME_COMPARATOR));
        result.addAll(FluentIterable.from(searchProps).transform(TO_GEOSPATIAL_PROPERTY).toSortedList(PROPERTY_NAME_COMPARATOR));
        return result;
    }

    protected OnestoreEntity.Index minimumCompositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery, Collection<OnestoreEntity.Index> indexes) {
        OnestoreEntity.Index suggestedIndex = this.compositeIndexForQuery(indexOnlyQuery);
        if (suggestedIndex == null) {
            return null;
        }
        if (indexOnlyQuery.isGeo()) {
            return suggestedIndex;
        }
        class EqPropsAndAncestorConstraint {
            final Set<String> equalityProperties;
            final boolean ancestorConstraint;

            EqPropsAndAncestorConstraint(Set<String> equalityProperties, boolean ancestorConstraint) {
                this.equalityProperties = equalityProperties;
                this.ancestorConstraint = ancestorConstraint;
            }
        }
        HashMap<List<OnestoreEntity.Index.Property>, EqPropsAndAncestorConstraint> remainingMap = new HashMap<List<OnestoreEntity.Index.Property>, EqPropsAndAncestorConstraint>();
        block0: for (OnestoreEntity.Index index : indexes) {
            boolean remainingAncestor;
            Set<String> remainingEqProps;
            if (!indexOnlyQuery.getQuery().getKind().equals(index.getEntityType()) || !indexOnlyQuery.getQuery().hasAncestor() && index.isAncestor()) continue;
            int postfixSplit = index.propertySize();
            for (IndexComponent component : Lists.reverse(indexOnlyQuery.getPostfix())) {
                if (!component.matches(index.propertys().subList(Math.max(postfixSplit - component.size(), 0), postfixSplit))) continue block0;
                postfixSplit -= component.size();
            }
            HashSet<String> indexEqProps = Sets.newHashSetWithExpectedSize(postfixSplit);
            for (OnestoreEntity.Index.Property prop : index.propertys().subList(0, postfixSplit)) {
                if (!indexOnlyQuery.getPrefix().contains(prop.getName())) continue block0;
                indexEqProps.add(prop.getName());
            }
            List<OnestoreEntity.Index.Property> indexPostfix = index.propertys().subList(postfixSplit, index.propertySize());
            EqPropsAndAncestorConstraint remaining = (EqPropsAndAncestorConstraint)remainingMap.get(indexPostfix);
            if (remaining == null) {
                remainingEqProps = Sets.newHashSet(indexOnlyQuery.getPrefix());
                remainingAncestor = indexOnlyQuery.getQuery().hasAncestor();
            } else {
                remainingEqProps = remaining.equalityProperties;
                remainingAncestor = remaining.ancestorConstraint;
            }
            boolean modified = remainingEqProps.removeAll(indexEqProps);
            if (remainingAncestor && index.isAncestor()) {
                modified = true;
                remainingAncestor = false;
            }
            if (remainingEqProps.isEmpty() && !remainingAncestor) {
                return null;
            }
            if (!modified) continue;
            remainingMap.put(indexPostfix, new EqPropsAndAncestorConstraint(remainingEqProps, remainingAncestor));
        }
        if (remainingMap.isEmpty()) {
            return suggestedIndex;
        }
        int minimumCost = Integer.MAX_VALUE;
        List minimumPostfix = null;
        EqPropsAndAncestorConstraint minimumRemaining = null;
        for (Map.Entry entry : remainingMap.entrySet()) {
            int cost = ((EqPropsAndAncestorConstraint)entry.getValue()).equalityProperties.size();
            if (((EqPropsAndAncestorConstraint)entry.getValue()).ancestorConstraint) {
                cost += 2;
            }
            if (cost >= minimumCost) continue;
            minimumCost = cost;
            minimumPostfix = (List)entry.getKey();
            minimumRemaining = (EqPropsAndAncestorConstraint)entry.getValue();
        }
        suggestedIndex.clearProperty();
        suggestedIndex.setAncestor(minimumRemaining.ancestorConstraint);
        for (String name : minimumRemaining.equalityProperties) {
            suggestedIndex.addProperty().setName(name).setDirection(OnestoreEntity.Index.Property.Direction.ASCENDING);
        }
        Collections.sort(suggestedIndex.mutablePropertys(), PROPERTY_NAME_COMPARATOR);
        suggestedIndex.mutablePropertys().addAll(minimumPostfix);
        return suggestedIndex;
    }

    protected static class KeyTranslator
    extends com.google.appengine.api.datastore.KeyTranslator {
        protected KeyTranslator() {
        }
    }

    protected static class ValidatedQuery
    extends com.google.appengine.api.datastore.ValidatedQuery {
        public ValidatedQuery(DatastorePb.Query query) {
            super(query);
        }
    }

    protected static class IndexComponentsOnlyQuery
    extends com.google.appengine.api.datastore.IndexComponentsOnlyQuery {
        public IndexComponentsOnlyQuery(DatastorePb.Query query) {
            super(query);
        }
    }

    static class SearchPropertyTransform
    implements Function<String, OnestoreEntity.Index.Property> {
        private OnestoreEntity.Index.Property.Mode mode;

        SearchPropertyTransform(OnestoreEntity.Index.Property.Mode mode) {
            this.mode = mode;
        }

        @Override
        public OnestoreEntity.Index.Property apply(String name) {
            OnestoreEntity.Index.Property p = new OnestoreEntity.Index.Property();
            p.setName(name);
            if (this.mode != null) {
                p.setMode(this.mode);
            }
            return p;
        }
    }

    protected static enum IndexSource {
        auto,
        manual;

    }
}

