/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.appidentity;

import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFailureException;
import com.google.appengine.api.appidentity.AppIdentityServicePb;
import com.google.appengine.api.appidentity.PublicCertificate;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilder;
import com.google.appengine.repackaged.com.google.common.cache.CacheLoader;
import com.google.appengine.repackaged.com.google.common.cache.LoadingCache;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.ApiProxy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;

class AppIdentityServiceImpl
implements AppIdentityService {
    public static final String PACKAGE_NAME = "app_identity_service";
    public static final String SIGN_FOR_APP_METHOD_NAME = "SignForApp";
    public static final String GET_SERVICE_ACCOUNT_NAME_METHOD_NAME = "GetServiceAccountName";
    public static final String GET_DEFAULT_GCS_BUCKET_NAME = "GetDefaultGcsBucketName";
    public static final String GET_CERTS_METHOD_NAME = "GetPublicCertificatesForApp";
    public static final String GET_ACCESS_TOKEN_METHOD_NAME = "GetAccessToken";
    public static final String MEMCACHE_NAMESPACE = "_ah_";
    public static final String MEMCACHE_KEY_PREFIX = "_ah_app_identity_";
    private static final char APP_PARTITION_SEPARATOR = '~';
    private static final char APP_DOMAIN_SEPARATOR = ':';
    private static final int TOKEN_EXPIRY_SAFETY_MARGIN_MILLIS = 300000;
    private static final int MAX_RANDOM_EXPIRY_DELTA_MILLIS = 60000;
    private static final int MEMCACHE_EXPIRATION_DELTA_MILLIS = 360000;
    private static final int INSTANCE_CACHE_EXPIRATION_DELTA_MILLIS = 300000 + new Random().nextInt(60000);
    private static final int MAX_INSTANCE_CACHE_ENTRIES = 100;
    private static final int MAX_CONCURRENT_LOAD_PER_KEY = 3;
    private static LoadingCache<String, CacheItem> cache = CacheBuilder.newBuilder().maximumSize(100L).build(new CacheLoader<String, CacheItem>(){

        @Override
        public CacheItem load(String key) {
            return new CacheItem();
        }
    });
    private final MemcacheService memcacheService = MemcacheServiceFactory.getMemcacheService("_ah_");

    AppIdentityServiceImpl() {
    }

    static void clearCache() {
        cache.invalidateAll();
    }

    private void handleApplicationError(ApiProxy.ApplicationException e) {
        AppIdentityServicePb.AppIdentityServiceError.ErrorCode errorCode = AppIdentityServicePb.AppIdentityServiceError.ErrorCode.valueOf(e.getApplicationError());
        if (errorCode == null) {
            String string = String.valueOf(e.getErrorDetail());
            throw new AppIdentityServiceFailureException(string.length() != 0 ? "The AppIdentity service threw an unexpected error. Details: ".concat(string) : new String("The AppIdentity service threw an unexpected error. Details: "));
        }
        switch (errorCode) {
            case BLOB_TOO_LARGE: {
                throw new AppIdentityServiceFailureException("The supplied blob was too long.");
            }
            case NOT_A_VALID_APP: {
                throw new AppIdentityServiceFailureException("The application is not valid.");
            }
            case DEADLINE_EXCEEDED: {
                throw new AppIdentityServiceFailureException("The deadline for the call was exceeded.");
            }
            case UNKNOWN_ERROR: {
                throw new AppIdentityServiceFailureException("There was an unknown error using the AppIdentity service.");
            }
            case UNKNOWN_SCOPE: {
                throw new AppIdentityServiceFailureException("An unknown scope was supplied.");
            }
        }
        String string = String.valueOf(e.getErrorDetail());
        throw new AppIdentityServiceFailureException(string.length() != 0 ? "The AppIdentity service threw an unexpected error. Details: ".concat(string) : new String("The AppIdentity service threw an unexpected error. Details: "));
    }

    public List<PublicCertificate> getPublicCertificatesForApp() {
        AppIdentityServicePb.GetPublicCertificateForAppRequest.Builder requestBuilder = AppIdentityServicePb.GetPublicCertificateForAppRequest.newBuilder();
        AppIdentityServicePb.GetPublicCertificateForAppResponse.Builder responseBuilder = AppIdentityServicePb.GetPublicCertificateForAppResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(PACKAGE_NAME, GET_CERTS_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.GetPublicCertificateForAppResponse response = responseBuilder.build();
        ArrayList<PublicCertificate> certs = Lists.newArrayList();
        for (AppIdentityServicePb.PublicCertificate cert : response.getPublicCertificateListList()) {
            certs.add(new PublicCertificate(cert.getKeyName(), cert.getX509CertificatePem()));
        }
        return certs;
    }

    @Override
    public AppIdentityService.SigningResult signForApp(byte[] signBlob) {
        AppIdentityServicePb.SignForAppRequest.Builder requestBuilder = AppIdentityServicePb.SignForAppRequest.newBuilder();
        requestBuilder.setBytesToSign(ByteString.copyFrom(signBlob));
        AppIdentityServicePb.SignForAppResponse.Builder responseBuilder = AppIdentityServicePb.SignForAppResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(PACKAGE_NAME, SIGN_FOR_APP_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.SignForAppResponse response = responseBuilder.build();
        return new AppIdentityService.SigningResult(response.getKeyName(), response.getSignatureBytes().toByteArray());
    }

    @Override
    public String getServiceAccountName() {
        AppIdentityServicePb.GetServiceAccountNameRequest.Builder requestBuilder = AppIdentityServicePb.GetServiceAccountNameRequest.newBuilder();
        AppIdentityServicePb.GetServiceAccountNameResponse.Builder responseBuilder = AppIdentityServicePb.GetServiceAccountNameResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(this.getAccessTokenPackageName(), GET_SERVICE_ACCOUNT_NAME_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.GetServiceAccountNameResponse response = responseBuilder.build();
        return response.getServiceAccountName();
    }

    @Override
    public String getDefaultGcsBucketName() {
        AppIdentityServicePb.GetDefaultGcsBucketNameRequest.Builder requestBuilder = AppIdentityServicePb.GetDefaultGcsBucketNameRequest.newBuilder();
        AppIdentityServicePb.GetDefaultGcsBucketNameResponse.Builder responseBuilder = AppIdentityServicePb.GetDefaultGcsBucketNameResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(PACKAGE_NAME, GET_DEFAULT_GCS_BUCKET_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.GetDefaultGcsBucketNameResponse response = responseBuilder.build();
        if (response.hasDefaultGcsBucketName()) {
            return response.getDefaultGcsBucketName();
        }
        throw new AppIdentityServiceFailureException("getDefaultGcsBucketNameResponse contained no data");
    }

    @Override
    public AppIdentityService.GetAccessTokenResult getAccessTokenUncached(Iterable<String> scopes) {
        AppIdentityServicePb.GetAccessTokenRequest.Builder requestBuilder = AppIdentityServicePb.GetAccessTokenRequest.newBuilder();
        for (String scope : scopes) {
            requestBuilder.addScope(scope);
        }
        if (requestBuilder.getScopeCount() == 0) {
            throw new AppIdentityServiceFailureException("No scopes specified.");
        }
        AppIdentityServicePb.GetAccessTokenResponse.Builder responseBuilder = AppIdentityServicePb.GetAccessTokenResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(this.getAccessTokenPackageName(), GET_ACCESS_TOKEN_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.GetAccessTokenResponse response = responseBuilder.build();
        return new AppIdentityService.GetAccessTokenResult(response.getAccessToken(), new Date(response.getExpirationTime() * 1000L));
    }

    private String getAccessTokenPackageName() {
        return Boolean.getBoolean("appengine.app_identity.use_robot") && SystemProperty.environment.value() != SystemProperty.Environment.Value.Production ? "robot_enabled_app_identity_service" : PACKAGE_NAME;
    }

    String memcacheKeyForScopes(Iterable<String> scopes) {
        StringBuilder builder = new StringBuilder();
        builder.append(MEMCACHE_KEY_PREFIX);
        builder.append('[');
        if (!Iterables.isEmpty(scopes)) {
            for (String scope : scopes) {
                builder.append('\'');
                builder.append(scope);
                builder.append("',");
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppIdentityService.GetAccessTokenResult getAccessToken(Iterable<String> scopes) {
        String cacheKey = this.memcacheKeyForScopes(scopes);
        CacheItem cacheItem = cache.getUnchecked(cacheKey);
        try {
            cacheItem.getAccessSemaphore().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        try {
            AppIdentityService.GetAccessTokenResult result = cacheItem.get();
            if (result != null) {
                AppIdentityService.GetAccessTokenResult getAccessTokenResult = result;
                return getAccessTokenResult;
            }
            result = (AppIdentityService.GetAccessTokenResult)this.memcacheService.get(cacheKey);
            if (result != null) {
                cacheItem.set(result);
                AppIdentityService.GetAccessTokenResult getAccessTokenResult = result;
                return getAccessTokenResult;
            }
            result = this.getAccessTokenUncached(scopes);
            Calendar cal = Calendar.getInstance();
            cal.setTime(result.getExpirationTime());
            cal.add(14, -360000);
            this.memcacheService.put(cacheKey, result, Expiration.onDate(cal.getTime()));
            cacheItem.set(result);
            AppIdentityService.GetAccessTokenResult getAccessTokenResult = result;
            return getAccessTokenResult;
        }
        finally {
            cacheItem.getAccessSemaphore().release();
        }
    }

    @Override
    public AppIdentityService.ParsedAppId parseFullAppId(String fullAppId) {
        String domain;
        String partition;
        int partitionIdx = fullAppId.indexOf(126);
        if (partitionIdx > 0) {
            partition = fullAppId.substring(0, partitionIdx);
            fullAppId = fullAppId.substring(partitionIdx + 1);
        } else {
            partition = "";
        }
        int domainIdx = fullAppId.indexOf(58);
        if (domainIdx > 0) {
            domain = fullAppId.substring(0, domainIdx);
            fullAppId = fullAppId.substring(domainIdx + 1);
        } else {
            domain = "";
        }
        return new AppIdentityService.ParsedAppId(partition, domain, fullAppId);
    }

    private static class CacheItem {
        private final Semaphore semaphore = new Semaphore(3);
        private final AtomicReference<AppIdentityService.GetAccessTokenResult> result = new AtomicReference();

        private CacheItem() {
        }

        public Semaphore getAccessSemaphore() {
            return this.semaphore;
        }

        public AppIdentityService.GetAccessTokenResult get() {
            AppIdentityService.GetAccessTokenResult value = this.result.get();
            if (value != null) {
                Calendar cal = Calendar.getInstance();
                cal.add(14, INSTANCE_CACHE_EXPIRATION_DELTA_MILLIS);
                if (cal.getTime().before(value.getExpirationTime())) {
                    return value;
                }
            }
            return null;
        }

        public void set(AppIdentityService.GetAccessTokenResult value) {
            this.result.set(value);
        }
    }
}

