/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class DatastoreClient {
    @VisibleForTesting
    public static final int INTERN_MAX_KEYS_PER_REQUEST = 300;
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.BeginTransactionResponse> BT_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "BeginTransaction", DatastoreV4.BeginTransactionResponse.PARSER);
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.LookupResponse> LOOKUP_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Lookup", DatastoreV4.LookupResponse.PARSER);
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.CommitResponse> COMMIT_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Commit", DatastoreV4.CommitResponse.PARSER);
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.AllocateIdsResponse> ALLOC_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "AllocateIds", DatastoreV4.AllocateIdsResponse.PARSER);
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.RollbackResponse> ROLLBACK_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Rollback", DatastoreV4.RollbackResponse.PARSER);
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.ContinueQueryResponse> CONTINUE_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "ContinueQuery", DatastoreV4.ContinueQueryResponse.PARSER);
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.RunQueryResponse> RUNQUERY_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "RunQuery", DatastoreV4.RunQueryResponse.PARSER);
    private final InternDatastoreRpcService internService;
    @VisibleForTesting
    public static final DatastoreV4.BeginTransactionRequest BEGIN_TXN_REQUEST = DatastoreV4.BeginTransactionRequest.newBuilder().setCrossGroup(true).setCrossRequest(true).build();

    public DatastoreClient(InternDatastoreRpcService internService) {
        this.internService = internService;
    }

    public ByteString beginTransaction() throws RpcException {
        InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.BeginTransactionResponse> internResponse = this.internService.call(BT_RPC_SPEC, BEGIN_TXN_REQUEST);
        ByteString transaction = null;
        if (internResponse != null && internResponse.getResponse() != null) {
            transaction = internResponse.getResponse().getTransaction();
        }
        if (transaction == null) {
            throw new RpcException(Codes.Code.ABORTED, "Internal Datastore error.  Could not get transaction handle.");
        }
        return transaction;
    }

    public DatastoreService.LookupResponse lookup(RpcHandler.CallOptions callOptions, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform, DatastoreV4.ReadOptions readOptions, Collection<EntityV4.Key> keys) throws RpcException {
        int remainingApiResponseBytes = callOptions.getMaxResponseBytes();
        ArrayList<EntityV4.Key> normalizedKeys = Lists.newArrayList(keys);
        for (EntityV4.Key key : normalizedKeys) {
            remainingApiResponseBytes -= this.getMaxResponseBytes(key);
        }
        if (remainingApiResponseBytes < 0) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Too many keys for the response size limit.");
        }
        DatastoreV4.LookupRequest internReq = this.createInternRequest(readOptions, normalizedKeys);
        InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.LookupResponse> internRpc = this.internService.call(LOOKUP_RPC_SPEC, internReq);
        DatastoreService.LookupResponse.Builder res = DatastoreService.LookupResponse.newBuilder();
        do {
            DatastoreV4.LookupResponse internRes = internRpc.getResponse();
            normalizedKeys.addAll(internRes.getDeferredList());
            if (normalizedKeys.isEmpty()) {
                internRpc = null;
            } else {
                internReq = this.createInternRequest(readOptions, normalizedKeys);
                internRpc = this.internService.call(LOOKUP_RPC_SPEC, internReq);
            }
            res.addAllMissing(Lists.transform(internRes.getMissingList(), resultTransform));
            for (DatastoreV4.EntityResult found : Lists.transform(internRes.getFoundList(), resultTransform)) {
                int nonKeyBytes = CodedOutputStream.computeMessageSize(1, found) - this.getMaxResponseBytes(found.getEntity().getKey());
                if (nonKeyBytes > remainingApiResponseBytes) {
                    internRpc = null;
                    res.addDeferred(found.getEntity().getKey());
                    continue;
                }
                res.addFound(found);
                remainingApiResponseBytes -= nonKeyBytes;
            }
        } while (internRpc != null);
        res.addAllDeferred(normalizedKeys);
        return res.build();
    }

    public DatastoreV4.CommitResponse commit(@Nullable ByteString transaction, DatastoreService.CommitRequest.Mode mode, List<DatastoreV4.Mutation> mutationList) throws RpcException {
        DatastoreV4.CommitRequest.Builder internReq = DatastoreV4.CommitRequest.newBuilder();
        if (transaction != null) {
            internReq.setTransaction(transaction);
        }
        if (mode.getNumber() != DatastoreV4.CommitRequest.getDefaultInstance().getMode().getNumber()) {
            internReq.setMode(DatastoreV4.CommitRequest.Mode.valueOf(mode.getNumber()));
        }
        internReq.addAllMutation(mutationList);
        DatastoreV4.CommitResponse internRes = this.internService.call(COMMIT_RPC_SPEC, internReq.build()).getResponse();
        return internRes;
    }

    public DatastoreService.AllocateIdsResponse allocateIds(int maxKeysPerBatch, List<EntityV4.Key> keys) throws RpcException {
        ArrayList<InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.AllocateIdsResponse>> futures = Lists.newArrayListWithExpectedSize(keys.size() / maxKeysPerBatch + 1);
        for (int fromIndex = 0; fromIndex < keys.size(); fromIndex += maxKeysPerBatch) {
            int toIndex = Math.min(keys.size(), fromIndex + maxKeysPerBatch);
            DatastoreV4.AllocateIdsRequest allocateIdsRequest = DatastoreV4.AllocateIdsRequest.newBuilder().addAllAllocate(keys.subList(fromIndex, toIndex)).build();
            futures.add(this.internService.call(ALLOC_RPC_SPEC, allocateIdsRequest));
        }
        DatastoreService.AllocateIdsResponse.Builder res = DatastoreService.AllocateIdsResponse.newBuilder();
        for (InternDatastoreRpcService.ResponseFutureWrapper responseFutureWrapper : futures) {
            res.addAllKey(((DatastoreV4.AllocateIdsResponse)responseFutureWrapper.getResponse()).getAllocatedList());
        }
        return res.build();
    }

    public void rollback(ByteString transaction) throws RpcException {
        DatastoreV4.RollbackRequest req = DatastoreV4.RollbackRequest.newBuilder().setTransaction(transaction).build();
        this.internService.call(ROLLBACK_RPC_SPEC, req).getResponse();
    }

    public DatastoreService.RunQueryResponse runQuery(RpcHandler.CallOptions options, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform, DatastoreV4.RunQueryRequest req) throws RpcException {
        DatastoreService.RunQueryResponse.Builder res = DatastoreService.RunQueryResponse.newBuilder();
        DatastoreV4.QueryResultBatch.Builder batch = res.getBatchBuilder();
        DatastoreV4.RunQueryResponse initialInternResp = this.internService.call(RUNQUERY_RPC_SPEC, req).getResponse();
        DatastoreV4.QueryResultBatch internBatch = initialInternResp.getBatch();
        batch.setEntityResultType(internBatch.getEntityResultType());
        DatastoreV4.ContinueQueryRequest continueReq = DatastoreV4.ContinueQueryRequest.newBuilder().setQueryHandle(initialInternResp.getQueryHandle()).build();
        int totalResultBytes = 0;
        while (true) {
            InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.ContinueQueryResponse> nextRpc = internBatch.getMoreResults() == DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED ? this.internService.call(CONTINUE_RPC_SPEC, continueReq) : null;
            ArrayList<DatastoreV4.EntityResult> results = Lists.newArrayListWithCapacity(internBatch.getEntityResultCount());
            for (DatastoreV4.EntityResult result : Lists.transform(internBatch.getEntityResultList(), resultTransform)) {
                int resultBytes = CodedOutputStream.computeMessageSize(2, result);
                if (totalResultBytes + resultBytes > options.getMaxResponseBytes()) {
                    batch.setMoreResults(DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED);
                    return res.build();
                }
                totalResultBytes += resultBytes;
                results.add(result);
            }
            batch.addAllEntityResult(results);
            batch.setEndCursor(internBatch.getEndCursor());
            if (internBatch.hasSkippedResults()) {
                batch.setSkippedResults(batch.getSkippedResults() + internBatch.getSkippedResults());
            }
            if (nextRpc == null) {
                batch.setMoreResults(internBatch.getMoreResults());
                return res.build();
            }
            internBatch = nextRpc.getResponse().getBatch();
        }
    }

    private int getMaxResponseBytes(EntityV4.Key key) {
        return CodedOutputStream.computeMessageSize(3, key);
    }

    private DatastoreV4.LookupRequest createInternRequest(@Nullable DatastoreV4.ReadOptions readOptions, List<EntityV4.Key> keyList) {
        DatastoreV4.LookupRequest.Builder req = DatastoreV4.LookupRequest.newBuilder();
        if (readOptions != null) {
            req.setReadOptions(readOptions);
        }
        List<EntityV4.Key> limitedKeyList = keyList.size() <= 300 ? keyList : keyList.subList(0, 300);
        req.addAllKey(limitedKeyList);
        limitedKeyList.clear();
        return req.build();
    }
}

