/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedInts;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedLongs;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.proto.ProtocolDescriptor;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class MutableBridge {

    public static class DescriptorDowngrader {
        private static final Logger logger = Logger.getLogger(DescriptorDowngrader.class.getName());

        public static ProtocolDescriptor downgrade(Descriptors.Descriptor proto2Descriptor) {
            if (DowngraderUtil.isGroup(proto2Descriptor)) {
                throw new IllegalArgumentException("Cannot downgrade group types.");
            }
            ProtocolDescriptor proto1Descriptor = new ProtocolDescriptor();
            Descriptors.FileDescriptor proto2File = proto2Descriptor.getFile();
            proto1Descriptor.setFilename(proto2File.getName());
            proto1Descriptor.setName(DowngraderUtil.getQualifiedProtoClassName(proto2Descriptor));
            DescriptorDowngrader.convertTypeId(proto2Descriptor, proto1Descriptor);
            HashSet<Integer> seenTags = Sets.newHashSet();
            HashMap<Descriptors.EnumDescriptor, Integer> enumMap = Maps.newHashMap();
            DescriptorDowngrader.convertChildren(proto2Descriptor, enumMap, -1, proto1Descriptor, seenTags);
            return proto1Descriptor;
        }

        private static void convertChildren(Descriptors.Descriptor proto2Descriptor, Map<Descriptors.EnumDescriptor, Integer> parentEnumMap, int parentIndex, ProtocolDescriptor proto1Descriptor, Set<Integer> seenTags) {
            HashMap<Descriptors.EnumDescriptor, Integer> enumMap = Maps.newHashMap(parentEnumMap);
            for (Descriptors.EnumDescriptor enumType : proto2Descriptor.getEnumTypes()) {
                enumMap.put(enumType, proto1Descriptor.enumTypeSize());
                DescriptorDowngrader.convertEnumType(enumType, parentIndex, proto1Descriptor.addEnumType());
            }
            for (Descriptors.FieldDescriptor field : proto2Descriptor.getFields()) {
                DescriptorDowngrader.convertField(field, enumMap, parentIndex, proto1Descriptor, seenTags);
            }
        }

        private static void convertTypeId(Descriptors.Descriptor proto2Descriptor, ProtocolDescriptor proto1Descriptor) {
            int typeId = 0;
            for (Descriptors.FieldDescriptor extension : proto2Descriptor.getExtensions()) {
                if (!extension.isOptional() || extension.getType() != Descriptors.FieldDescriptor.Type.MESSAGE || extension.getMessageType() != proto2Descriptor || !extension.getContainingType().getOptions().getMessageSetWireFormat()) continue;
                if (typeId == 0) {
                    typeId = extension.getNumber();
                    ProtocolDescriptor.EnumType proto1Enum = proto1Descriptor.addEnumType();
                    proto1Enum.setName("TypeId");
                    proto1Enum.setAllowAlias(true);
                    ProtocolDescriptor.EnumTypeTag proto1EnumValue = proto1Enum.addTag();
                    proto1EnumValue.setName("MESSAGE_TYPE_ID");
                    proto1EnumValue.setValue(typeId);
                    continue;
                }
                if (typeId == extension.getNumber()) continue;
                logger.warning(proto2Descriptor.getFullName() + " has multiple " + "extensions of MessageSet with different numbers. Only the " + "first will be used as the type ID in proto1.");
            }
        }

        private static void convertEnumType(Descriptors.EnumDescriptor proto2Enum, int parentIndex, ProtocolDescriptor.EnumType proto1Enum) {
            if (proto2Enum.getOptions().hasProto1Name()) {
                proto1Enum.setName(proto2Enum.getOptions().getProto1Name());
                proto1Enum.setProto2Name(proto2Enum.getName());
            } else {
                proto1Enum.setName(proto2Enum.getName());
            }
            if (proto2Enum.getOptions().hasAllowAlias()) {
                proto1Enum.setAllowAlias(proto2Enum.getOptions().getAllowAlias());
            }
            if (parentIndex >= 0) {
                proto1Enum.setParent(parentIndex);
            }
            for (Descriptors.EnumValueDescriptor value : proto2Enum.getValues()) {
                ProtocolDescriptor.EnumTypeTag proto1Value = proto1Enum.addTag();
                proto1Value.setName(value.getName());
                proto1Value.setValue(value.getNumber());
            }
        }

        private static void convertField(Descriptors.FieldDescriptor proto2Field, Map<Descriptors.EnumDescriptor, Integer> enumMap, int parentIndex, ProtocolDescriptor proto1Descriptor, Set<Integer> seenTags) {
            if (proto2Field.getNumber() > 16383) {
                logger.warning("Dropped field with overly large tag number: " + proto2Field.getFullName() + " = " + proto2Field.getNumber());
                return;
            }
            if (seenTags.contains(proto2Field.getNumber())) {
                logger.warning("Dropped field because its tag number conflicts with a field elsewhere in the same message:  " + proto2Field.getFullName() + " = " + proto2Field.getName());
                return;
            }
            seenTags.add(proto2Field.getNumber());
            ProtocolDescriptor.Tag proto1Field = proto1Descriptor.addTag();
            String namePrefix = "";
            if (parentIndex >= 0) {
                namePrefix = proto1Descriptor.getTag(parentIndex).getName() + ".";
            }
            if (proto2Field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                proto1Field.setName(namePrefix + proto2Field.getMessageType().getName());
            } else {
                proto1Field.setName(namePrefix + proto2Field.getName());
            }
            proto1Field.setWireType(proto2Field.getLiteType().getWireType());
            if (parentIndex >= 0) {
                proto1Field.setParent(parentIndex);
            }
            proto1Field.setNumber(proto2Field.getNumber());
            if (proto2Field.getOptions().getPacked()) {
                proto1Field.setLabel(ProtocolDescriptor.Label.LABEL_OPTIONAL.getValue());
                proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_STRING.getValue());
                proto1Field.setWireType(2);
            } else {
                if (proto2Field.isRequired()) {
                    proto1Field.setLabel(ProtocolDescriptor.Label.LABEL_REQUIRED.getValue());
                } else if (proto2Field.isOptional()) {
                    proto1Field.setLabel(ProtocolDescriptor.Label.LABEL_OPTIONAL.getValue());
                } else if (proto2Field.isRepeated()) {
                    proto1Field.setLabel(ProtocolDescriptor.Label.LABEL_REPEATED.getValue());
                } else {
                    throw new RuntimeException("Cannot get field label for " + proto2Field.getFullName());
                }
                switch (proto2Field.getType()) {
                    case GROUP: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_GROUP.getValue());
                        DescriptorDowngrader.convertChildren(proto2Field.getMessageType(), enumMap, proto1Descriptor.tagSize() - 1, proto1Descriptor, seenTags);
                        break;
                    }
                    case MESSAGE: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_FOREIGN.getValue());
                        if (proto2Field.getMessageType().getOptions().getMessageSetWireFormat()) {
                            proto1Field.setForeign("MessageSet");
                            break;
                        }
                        if (DowngraderUtil.isGroup(proto2Field.getMessageType())) {
                            logger.warning("Field " + proto2Field.getFullName() + " reuses a group type. Proto1 does not support this." + " The field's type will be an empty message in proto1.");
                            proto1Field.setForeign("OpaqueMessage");
                            break;
                        }
                        proto1Field.setForeign(DowngraderUtil.getQualifiedProtoClassName(proto2Field.getMessageType()));
                        break;
                    }
                    case ENUM: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_INT32.getValue());
                        if (!enumMap.containsKey(proto2Field.getEnumType())) break;
                        proto1Field.setEnumId(enumMap.get(proto2Field.getEnumType()));
                        break;
                    }
                    case DOUBLE: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_DOUBLE.getValue());
                        break;
                    }
                    case FLOAT: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_FLOAT.getValue());
                        break;
                    }
                    case INT64: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_INT64.getValue());
                        break;
                    }
                    case SINT32: 
                    case SINT64: 
                    case UINT32: 
                    case UINT64: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_UINT64.getValue());
                        break;
                    }
                    case INT32: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_INT32.getValue());
                        break;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_FIXED32.getValue());
                        break;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_FIXED64.getValue());
                        break;
                    }
                    case BOOL: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_BOOL.getValue());
                        break;
                    }
                    case STRING: 
                    case BYTES: {
                        proto1Field.setDeclaredType(ProtocolDescriptor.DeclaredType.TYPE_STRING.getValue());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Cannot handle the field type for: " + proto2Field.getFullName());
                    }
                }
            }
            if (proto2Field.hasDefaultValue()) {
                Object defaultValue = proto2Field.getDefaultValue();
                switch (proto2Field.getType()) {
                    case SINT32: {
                        proto1Field.setDefaultValue(UnsignedLongs.toString(CodedOutputStream.encodeZigZag64(((Integer)defaultValue).intValue())));
                        break;
                    }
                    case SINT64: {
                        proto1Field.setDefaultValue(UnsignedLongs.toString(CodedOutputStream.encodeZigZag64((Long)defaultValue)));
                        break;
                    }
                    case ENUM: {
                        proto1Field.setDefaultValue(String.valueOf(((Descriptors.EnumValueDescriptor)defaultValue).getNumber()));
                        break;
                    }
                    case SFIXED32: {
                        proto1Field.setDefaultValue(UnsignedInts.toString((Integer)defaultValue));
                        break;
                    }
                    case SFIXED64: {
                        proto1Field.setDefaultValue(UnsignedLongs.toString((Long)defaultValue));
                        break;
                    }
                    case STRING: {
                        proto1Field.setDefaultValue((String)defaultValue);
                        break;
                    }
                    case BYTES: {
                        proto1Field.setDefaultValueAsBytes(((ByteString)defaultValue).toByteArray());
                        break;
                    }
                    default: {
                        proto1Field.setDefaultValue(proto2Field.toProto().getDefaultValue());
                    }
                }
            }
            if (proto2Field.getOptions().hasDeprecated()) {
                proto1Field.setDeprecated(proto2Field.getOptions().getDeprecated());
            }
        }
    }

    static class DowngraderUtil {
        public static final int MAX_PROTO1_TAG_NUMBER = 16383;

        DowngraderUtil() {
        }

        public static boolean isGroup(Descriptors.Descriptor descriptor) {
            if (descriptor.getContainingType() == null) {
                return false;
            }
            Descriptors.Descriptor parent = descriptor.getContainingType();
            for (Descriptors.FieldDescriptor field : parent.getFields()) {
                if (field.getType() != Descriptors.FieldDescriptor.Type.GROUP || field.getMessageType() != descriptor) continue;
                return true;
            }
            return false;
        }

        public static String getQualifiedProtoClassName(Descriptors.Descriptor descriptor) {
            if (descriptor.getContainingType() != null) {
                if (DowngraderUtil.isGroup(descriptor)) {
                    String result = DowngraderUtil.getQualifiedProtoClassName(descriptor.getContainingType());
                    if (!DowngraderUtil.isGroup(descriptor.getContainingType())) {
                        result = result + "_";
                    }
                    result = result + descriptor.getName();
                    return result;
                }
                return DowngraderUtil.getQualifiedNestedProtoClassName(descriptor);
            }
            return descriptor.getFullName();
        }

        private static String getQualifiedNestedProtoClassName(Descriptors.Descriptor descriptor) {
            if (descriptor.getContainingType() != null) {
                return DowngraderUtil.getQualifiedNestedProtoClassName(descriptor.getContainingType()) + "_" + descriptor.getName();
            }
            return descriptor.getFullName();
        }
    }

    public static abstract class AbstractDowngradedMessage<DowngradedType extends AbstractDowngradedMessage<DowngradedType, Proto2Type>, Proto2Type extends MutableMessage>
    extends ProtocolMessage<DowngradedType> {
        private Proto2Type message;

        public AbstractDowngradedMessage(Proto2Type message) {
            this.message = message;
        }

        public Proto2Type unwrap() {
            return this.message;
        }

        @Override
        public abstract DowngradedType newInstance();

        @Override
        public abstract ProtocolType getProtocolType();

        protected abstract int getEndTag();

        @Override
        protected DowngradedType internalClear() {
            this.message.clear();
            return (DowngradedType)this;
        }

        @Override
        public boolean isInitialized() {
            return this.message.isInitialized();
        }

        @Override
        public int encodingSize() {
            int encodingSize = this.message.getSerializedSize();
            int endTag = this.getEndTag();
            if (endTag != 0) {
                encodingSize += Protocol.varIntSize(endTag);
            }
            return encodingSize;
        }

        @Override
        public int maxEncodingSize() {
            return this.encodingSize();
        }

        @Override
        public DowngradedType mergeFrom(DowngradedType that) {
            this.message.mergeFrom((MutableMessage)((AbstractDowngradedMessage)that).unwrap());
            return (DowngradedType)this;
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof AbstractDowngradedMessage && this.message.equals(((AbstractDowngradedMessage)that).message);
        }

        @Override
        public int hashCode() {
            return this.message.hashCode();
        }

        @Override
        public boolean equals(DowngradedType that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equalsIgnoreUninterpreted(DowngradedType that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(DowngradedType that, boolean ignoreUninterpreted) {
            return ProtocolSupport.compareMessage(this.message, ((AbstractDowngradedMessage)that).unwrap(), ignoreUninterpreted);
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            byte[] buffer = sink.array();
            int pos = sink.position();
            int len = buffer.length - pos;
            CodedOutputStream os = CodedOutputStream.newInstance(buffer, pos, len);
            try {
                this.message.writeTo(os);
                int endGroupTag = this.getEndTag();
                if (endGroupTag != 0) {
                    os.writeInt32NoTag(endGroupTag);
                }
                os.flush();
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Cannot reach here");
            }
            sink.skip(len - os.spaceLeft());
        }

        @Override
        protected boolean merge(ProtocolSource source) {
            CodedInputStream input = CodedInputStream.newInstance(source.array(), source.position(), source.remaining());
            if (this.mergeFrom((DowngradedType)input) != false) {
                source.skip(input.getTotalBytesRead());
                return input.getLastTag() == this.getEndTag();
            }
            return false;
        }

        @Override
        public boolean mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) {
            return this.message.mergeFrom(input, extensionRegistry);
        }

        @Override
        public boolean mergePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) {
            return this.mergeFrom(input, extensionRegistry);
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return this.message.getDescriptorForType();
        }

        @Override
        public Message immutableCopy() {
            return this.message.immutableCopy();
        }

        @Override
        public DowngradedType setField(Descriptors.FieldDescriptor field, Object value) {
            this.message.setField(field, value);
            return (DowngradedType)this;
        }

        @Override
        public DowngradedType clearField(Descriptors.FieldDescriptor field) {
            this.message.clearField(field);
            return (DowngradedType)this;
        }

        @Override
        public DowngradedType setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            this.message.setRepeatedField(field, index, value);
            return (DowngradedType)this;
        }

        @Override
        public DowngradedType addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            this.message.addRepeatedField(field, value);
            return (DowngradedType)this;
        }

        @Override
        public DowngradedType setUnknownFields(UnknownFieldSet unknownFields) {
            this.message.setUnknownFields(unknownFields);
            return (DowngradedType)this;
        }

        @Override
        public Object getMutableField(Descriptors.FieldDescriptor field) {
            return this.message.getMutableField(field);
        }

        @Override
        public MutableMessage newMessageForField(Descriptors.FieldDescriptor field) {
            return this.message.newMessageForField(field);
        }

        @Override
        public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
            return this.message.getAllFields();
        }

        @Override
        public boolean hasField(Descriptors.FieldDescriptor field) {
            return this.message.hasField(field);
        }

        @Override
        public Object getField(Descriptors.FieldDescriptor field) {
            return this.message.getField(field);
        }

        @Override
        public int getRepeatedFieldCount(Descriptors.FieldDescriptor field) {
            return this.message.getRepeatedFieldCount(field);
        }

        @Override
        public Object getRepeatedField(Descriptors.FieldDescriptor field, int index) {
            return this.message.getRepeatedField(field, index);
        }

        @Override
        public UnknownFieldSet getUnknownFields() {
            return this.message.getUnknownFields();
        }
    }
}

