/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;

class EquivalentMessageConverter<F extends MessageLite, T extends MessageLite>
extends Converter<F, T> {
    private final Parser<F> fromParser;
    private final Parser<T> toParser;

    public static <F extends MessageLite, T extends MessageLite> EquivalentMessageConverter<F, T> create(Parser<F> fromParser, Parser<T> toParser) {
        return new EquivalentMessageConverter<F, T>(fromParser, toParser);
    }

    private EquivalentMessageConverter(Parser<F> fromParser, Parser<T> toParser) {
        this.fromParser = fromParser;
        this.toParser = toParser;
    }

    @Override
    protected T doForward(F a) {
        try {
            return (T)((MessageLite)this.toParser.parseFrom(a.toByteString()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("The %s message could not be parsed with the %s parser.", a.getClass(), this.toParser.getClass()), e);
        }
    }

    @Override
    protected F doBackward(T b) {
        try {
            return (F)((MessageLite)this.fromParser.parseFrom(b.toByteString()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("The %s message could not be parsed with the %s parser.", b.getClass(), this.fromParser.getClass()), e);
        }
    }
}

