/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.intern.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.List;

class AllocateIdsHandler
extends DatastoreRpcHandler<DatastoreService.AllocateIdsRequest, DatastoreService.AllocateIdsResponse> {
    @VisibleForTesting
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.AllocateIdsResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "AllocateIds", DatastoreV4.AllocateIdsResponse.PARSER);
    private final Function<EntityV4.Key, EntityV4.Key> inputKeyTransform;
    private final int maxKeysPerBatch;

    public AllocateIdsHandler(InternDatastoreRpcService internService, Function<EntityV4.Key, EntityV4.Key> inputKeyTransform, int maxKeysPerBatch) {
        super(internService);
        this.inputKeyTransform = inputKeyTransform;
        this.maxKeysPerBatch = maxKeysPerBatch;
    }

    @Override
    public Parser<DatastoreService.AllocateIdsRequest> getParser() {
        return DatastoreService.AllocateIdsRequest.PARSER;
    }

    @Override
    public DatastoreService.AllocateIdsResponse call(RpcHandler.CallOptions options, DatastoreService.AllocateIdsRequest req) throws RpcException {
        ArrayList<InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.AllocateIdsResponse>> futures = Lists.newArrayListWithExpectedSize(req.getKeyCount() / this.maxKeysPerBatch + 1);
        for (int fromIndex = 0; fromIndex < req.getKeyCount(); fromIndex += this.maxKeysPerBatch) {
            int toIndex = Math.min(req.getKeyCount(), fromIndex + this.maxKeysPerBatch);
            List<EntityV4.Key> list = Lists.transform(req.getKeyList().subList(fromIndex, toIndex), this.inputKeyTransform);
            DatastoreV4.AllocateIdsRequest internReq = DatastoreV4.AllocateIdsRequest.newBuilder().addAllAllocate(list).build();
            futures.add(this.internService.call(INTERN_RPC_SPEC, internReq));
        }
        DatastoreService.AllocateIdsResponse.Builder respBuilder = DatastoreService.AllocateIdsResponse.newBuilder();
        for (InternDatastoreRpcService.ResponseFutureWrapper responseFutureWrapper : futures) {
            respBuilder.addAllKey(((DatastoreV4.AllocateIdsResponse)responseFutureWrapper.getResponse()).getAllocatedList());
        }
        return respBuilder.build();
    }

    @Override
    public DatastoreService.AllocateIdsResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.AllocateIdsResponse.newBuilder().setHeader(AllocateIdsHandler.makeErrorHeader(errorCode, message)).build();
    }
}

