/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.convert.ConverterManager;
import com.google.appengine.repackaged.org.joda.time.convert.InstantConverter;
import java.io.Serializable;
import java.util.Comparator;

public class DateTimeComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = -6097339773320178364L;
    private static final DateTimeComparator ALL_INSTANCE = new DateTimeComparator(null, null);
    private static final DateTimeComparator DATE_INSTANCE = new DateTimeComparator(DateTimeFieldType.dayOfYear(), null);
    private static final DateTimeComparator TIME_INSTANCE = new DateTimeComparator(null, DateTimeFieldType.dayOfYear());
    private final DateTimeFieldType iLowerLimit;
    private final DateTimeFieldType iUpperLimit;

    public static DateTimeComparator getInstance() {
        return ALL_INSTANCE;
    }

    public static DateTimeComparator getInstance(DateTimeFieldType lowerLimit) {
        return DateTimeComparator.getInstance(lowerLimit, null);
    }

    public static DateTimeComparator getInstance(DateTimeFieldType lowerLimit, DateTimeFieldType upperLimit) {
        if (lowerLimit == null && upperLimit == null) {
            return ALL_INSTANCE;
        }
        if (lowerLimit == DateTimeFieldType.dayOfYear() && upperLimit == null) {
            return DATE_INSTANCE;
        }
        if (lowerLimit == null && upperLimit == DateTimeFieldType.dayOfYear()) {
            return TIME_INSTANCE;
        }
        return new DateTimeComparator(lowerLimit, upperLimit);
    }

    public static DateTimeComparator getDateOnlyInstance() {
        return DATE_INSTANCE;
    }

    public static DateTimeComparator getTimeOnlyInstance() {
        return TIME_INSTANCE;
    }

    protected DateTimeComparator(DateTimeFieldType lowerLimit, DateTimeFieldType upperLimit) {
        this.iLowerLimit = lowerLimit;
        this.iUpperLimit = upperLimit;
    }

    public DateTimeFieldType getLowerLimit() {
        return this.iLowerLimit;
    }

    public DateTimeFieldType getUpperLimit() {
        return this.iUpperLimit;
    }

    @Override
    public int compare(Object lhsObj, Object rhsObj) {
        InstantConverter conv = ConverterManager.getInstance().getInstantConverter(lhsObj);
        Chronology lhsChrono = conv.getChronology(lhsObj, (Chronology)null);
        long lhsMillis = conv.getInstantMillis(lhsObj, lhsChrono);
        conv = ConverterManager.getInstance().getInstantConverter(rhsObj);
        Chronology rhsChrono = conv.getChronology(rhsObj, (Chronology)null);
        long rhsMillis = conv.getInstantMillis(rhsObj, rhsChrono);
        if (this.iLowerLimit != null) {
            lhsMillis = this.iLowerLimit.getField(lhsChrono).roundFloor(lhsMillis);
            rhsMillis = this.iLowerLimit.getField(rhsChrono).roundFloor(rhsMillis);
        }
        if (this.iUpperLimit != null) {
            lhsMillis = this.iUpperLimit.getField(lhsChrono).remainder(lhsMillis);
            rhsMillis = this.iUpperLimit.getField(rhsChrono).remainder(rhsMillis);
        }
        if (lhsMillis < rhsMillis) {
            return -1;
        }
        if (lhsMillis > rhsMillis) {
            return 1;
        }
        return 0;
    }

    private Object readResolve() {
        return DateTimeComparator.getInstance(this.iLowerLimit, this.iUpperLimit);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DateTimeComparator) {
            DateTimeComparator other = (DateTimeComparator)object;
            return (this.iLowerLimit == other.getLowerLimit() || this.iLowerLimit != null && this.iLowerLimit.equals(other.getLowerLimit())) && (this.iUpperLimit == other.getUpperLimit() || this.iUpperLimit != null && this.iUpperLimit.equals(other.getUpperLimit()));
        }
        return false;
    }

    public int hashCode() {
        return (this.iLowerLimit == null ? 0 : this.iLowerLimit.hashCode()) + 123 * (this.iUpperLimit == null ? 0 : this.iUpperLimit.hashCode());
    }

    public String toString() {
        if (this.iLowerLimit == this.iUpperLimit) {
            return "DateTimeComparator[" + (this.iLowerLimit == null ? "" : this.iLowerLimit.getName()) + "]";
        }
        return "DateTimeComparator[" + (this.iLowerLimit == null ? "" : this.iLowerLimit.getName()) + "-" + (this.iUpperLimit == null ? "" : this.iUpperLimit.getName()) + "]";
    }
}

