/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base.shell;

import java.util.logging.Logger;

public abstract class Shell {
    private static final Logger log = Logger.getLogger("com.google.appengine.repackaged.com.google.io.base.shell.Shell");
    private static final Shell platformShell;

    private Shell() {
    }

    public static Shell getPlatformShell() {
        if (platformShell == null) {
            throw new UnsupportedOperationException("OS is not supported");
        }
        return platformShell;
    }

    public abstract String[] shellify(String var1);

    static {
        String osName = System.getProperty("os.name");
        if ("Linux".equals(osName)) {
            platformShell = new SHShell();
        } else if ("Windows XP".equals(osName)) {
            platformShell = new WindowsCMDShell();
        } else {
            log.severe("OS not supported; will not be able to execute commands");
            platformShell = null;
        }
        log.config("Loaded shell support '" + platformShell + "' for OS '" + osName + "'");
    }

    private static final class WindowsCMDShell
    extends Shell {
        private WindowsCMDShell() {
        }

        @Override
        public String[] shellify(String command) {
            if (command == null || command.length() == 0) {
                throw new IllegalArgumentException("command is null or empty");
            }
            return new String[]{"cmd", "/S", "/C", command};
        }
    }

    private static final class SHShell
    extends Shell {
        private SHShell() {
        }

        @Override
        public String[] shellify(String command) {
            if (command == null || command.length() == 0) {
                throw new IllegalArgumentException("command is null or empty");
            }
            return new String[]{"/bin/sh", "-c", command};
        }
    }
}

