/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.hash;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.hash.AbstractStreamingHashFunction;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.HashCodes;
import com.google.appengine.repackaged.com.google.common.hash.Hasher;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@GoogleInternal
final class GoogleLegacy32HashFunction
extends AbstractStreamingHashFunction {
    private final int seed;
    private final FingerprintStrategy fingerprintStrategy;

    GoogleLegacy32HashFunction(int seed, FingerprintStrategy fingerprintStrategy) {
        this.seed = seed;
        this.fingerprintStrategy = Preconditions.checkNotNull(fingerprintStrategy);
    }

    @Override
    public int bits() {
        return 32;
    }

    @Override
    public Hasher newHasher() {
        return new GoogleLegacy32Hasher(new GoogleLegacy32Mixer(this.seed), this.fingerprintStrategy);
    }

    public String toString() {
        return "LegacyHashing.googleHash32(" + this.seed + ")";
    }

    @Override
    public HashCode hashLong(long input) {
        int a = -1640531527 + (byte)input + ((byte)(input >> 8) << 8) + ((byte)(input >> 16) << 16) + ((byte)(input >> 24) << 24);
        int b = -1640531527 + (byte)(input >> 32) + ((byte)(input >> 40) << 8) + ((byte)(input >> 48) << 16) + ((byte)(input >> 56) << 24);
        return HashCodes.fromInt(GoogleLegacy32HashFunction.mix32(a, b, this.seed + 8));
    }

    @Override
    public HashCode hashInt(int input) {
        int a = -1640531527 + (byte)input + ((byte)(input >> 8) << 8) + ((byte)(input >> 16) << 16) + ((byte)(input >> 24) << 24);
        return HashCodes.fromInt(GoogleLegacy32HashFunction.mix32(a, -1640531527, this.seed + 4));
    }

    @Override
    public HashCode hashString(CharSequence input, Charset charset) {
        return this.hashBytes(((Object)input).toString().getBytes(charset));
    }

    @Override
    public HashCode hashBytes(byte[] input) {
        return this.hashBytes(input, 0, input.length);
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, input.length);
        int a = -1640531527;
        int b = -1640531527;
        int c = this.seed;
        int keylen = len;
        while (keylen >= 12) {
            a += this.fingerprintStrategy.word32At(input, off);
            a -= (b += this.fingerprintStrategy.word32At(input, off + 4));
            a -= (c += this.fingerprintStrategy.word32At(input, off + 8));
            b -= c;
            b -= (a ^= c >>> 13);
            c -= a;
            c -= (b ^= a << 8);
            a -= b;
            a -= (c ^= b >>> 13);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 16);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 3);
            c -= a;
            c -= (b ^= a << 10);
            c ^= b >>> 15;
            keylen -= 12;
            off += 12;
        }
        c += len;
        switch (keylen) {
            case 11: {
                c += input[off + 10] << 24;
            }
            case 10: {
                c += (input[off + 9] & 0xFF) << 16;
            }
            case 9: {
                c += (input[off + 8] & 0xFF) << 8;
            }
            case 8: {
                b += this.fingerprintStrategy.word32At(input, off + 4);
                a += this.fingerprintStrategy.word32At(input, off);
                break;
            }
            case 7: {
                b += (input[off + 6] & 0xFF) << 16;
            }
            case 6: {
                b += (input[off + 5] & 0xFF) << 8;
            }
            case 5: {
                b += input[off + 4] & 0xFF;
            }
            case 4: {
                a += this.fingerprintStrategy.word32At(input, off);
                break;
            }
            case 3: {
                a += (input[off + 2] & 0xFF) << 16;
            }
            case 2: {
                a += (input[off + 1] & 0xFF) << 8;
            }
            case 1: {
                a += input[off + 0] & 0xFF;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return HashCodes.fromInt(GoogleLegacy32HashFunction.mix32(a, b, c));
    }

    static int mix32(int a, int b, int c) {
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >>> 13);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >>> 15;
    }

    private static final class GoogleLegacy32Hasher
    extends AbstractStreamingHashFunction.AbstractStreamingHasher {
        private static final int CHUNK_SIZE = 12;
        private final GoogleLegacy32Mixer mixer;
        private final FingerprintStrategy fingerprintStrategy;
        private int length = 0;

        private GoogleLegacy32Hasher(GoogleLegacy32Mixer mixer, FingerprintStrategy fingerprintStrategy) {
            super(12);
            this.mixer = mixer;
            this.fingerprintStrategy = fingerprintStrategy;
        }

        @Override
        protected void process(ByteBuffer buf) {
            this.length += 12;
            this.mixer.a += this.fingerprintStrategy.maybeAddSignCruft(buf.getInt());
            this.mixer.b += this.fingerprintStrategy.maybeAddSignCruft(buf.getInt());
            this.mixer.c += this.fingerprintStrategy.maybeAddSignCruft(buf.getInt());
            this.mixer.mix();
        }

        @Override
        protected void processRemaining(ByteBuffer buf) {
            this.length += buf.remaining();
            switch (buf.remaining()) {
                case 11: {
                    this.mixer.c += buf.get(10) << 24;
                }
                case 10: {
                    this.mixer.c += UnsignedBytes.toInt(buf.get(9)) << 16;
                }
                case 9: {
                    this.mixer.c += UnsignedBytes.toInt(buf.get(8)) << 8;
                }
                case 8: {
                    this.mixer.a += this.fingerprintStrategy.maybeAddSignCruft(buf.getInt());
                    this.mixer.b += this.fingerprintStrategy.maybeAddSignCruft(buf.getInt());
                    break;
                }
                case 7: {
                    this.mixer.b += UnsignedBytes.toInt(buf.get(6)) << 16;
                }
                case 6: {
                    this.mixer.b += UnsignedBytes.toInt(buf.get(5)) << 8;
                }
                case 5: {
                    this.mixer.b += UnsignedBytes.toInt(buf.get(4));
                }
                case 4: {
                    this.mixer.a += this.fingerprintStrategy.maybeAddSignCruft(buf.getInt());
                    break;
                }
                case 3: {
                    this.mixer.a += UnsignedBytes.toInt(buf.get(2)) << 16;
                }
                case 2: {
                    this.mixer.a += UnsignedBytes.toInt(buf.get(1)) << 8;
                }
                case 1: {
                    this.mixer.a += UnsignedBytes.toInt(buf.get(0));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here.");
                }
            }
        }

        @Override
        public HashCode makeHash() {
            this.mixer.c += this.length;
            return this.mixer.makeHash();
        }
    }

    static final class GoogleLegacy32Mixer {
        private int a = -1640531527;
        private int b = -1640531527;
        private int c;

        GoogleLegacy32Mixer(int c) {
            this.c = c;
        }

        HashCode makeHash() {
            return HashCodes.fromInt(this.mix());
        }

        private int mix() {
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 13;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 8;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 13;
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 12;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 16;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 5;
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 3;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 10;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 15;
            return this.c;
        }
    }

    static enum FingerprintStrategy {
        WORKING{

            @Override
            int maybeAddSignCruft(int i) {
                return (i & 0x7F7F7F7F) - (i & 0x80808080);
            }

            @Override
            int word32At(byte[] bytes, int offset) {
                return bytes[offset + 0] + (bytes[offset + 1] << 8) + (bytes[offset + 2] << 16) + (bytes[offset + 3] << 24);
            }
        }
        ,
        BROKEN{

            @Override
            int maybeAddSignCruft(int i) {
                return i;
            }

            @Override
            int word32At(byte[] bytes, int offset) {
                return Ints.fromBytes(bytes[offset + 3], bytes[offset + 2], bytes[offset + 1], bytes[offset]);
            }
        };


        abstract int maybeAddSignCruft(int var1);

        abstract int word32At(byte[] var1, int var2);
    }
}

