/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.prospectivesearch;

import com.google.appengine.api.prospectivesearch.ProspectiveSearchPb;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import java.util.Date;

public final class Subscription {
    String id;
    String query;
    long expirationTimeSec;
    State state;
    String errorMsg;

    @VisibleForTesting
    public Subscription(String id, String query, long expirationTimeSec) {
        this(id, query, expirationTimeSec, State.OK, "");
    }

    @VisibleForTesting
    public Subscription(String id, String query, long expirationTimeSec, State state, String errorMsg) {
        if (expirationTimeSec < 0L) {
            throw new IllegalArgumentException("Lease duration must be non-negative: " + expirationTimeSec);
        }
        this.id = id;
        this.query = query;
        this.expirationTimeSec = expirationTimeSec;
        this.state = state;
        this.errorMsg = errorMsg;
    }

    Subscription(ProspectiveSearchPb.SubscriptionRecord sr) {
        this(sr.getId(), sr.getVanillaQuery(), (long)sr.getExpirationTimeSec(), State.lookupState(sr.getStateEnum()), sr.getErrorMessage());
    }

    public String getId() {
        return this.id;
    }

    public String getQuery() {
        return this.query;
    }

    public long getExpirationTime() {
        return this.expirationTimeSec;
    }

    public State getState() {
        return this.state;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public String toString() {
        return String.format("%s@%d{id=%s, query=%s, expires=%s, state=%s}", new Object[]{this.getClass().getName(), System.identityHashCode(this), this.id, this.query, this.expirationTimeSec == 0L ? "NEVER" : new Date(this.expirationTimeSec * 1000L), this.state});
    }

    public static enum State {
        OK,
        PENDING,
        ERROR;


        static State lookupState(ProspectiveSearchPb.SubscriptionRecord.State internalState) {
            switch (internalState) {
                case OK: {
                    return OK;
                }
                case PENDING: {
                    return PENDING;
                }
            }
            return ERROR;
        }
    }
}

