/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AsyncDatastoreServiceImpl;
import com.google.appengine.api.datastore.BaseDatastoreServiceImpl;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.datastore.TransactionRunner;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.apphosting.api.DatastorePb;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class DatastoreServiceImpl
extends BaseDatastoreServiceImpl
implements DatastoreService {
    final AsyncDatastoreServiceImpl async;

    public DatastoreServiceImpl(DatastoreServiceConfig datastoreServiceConfig, TransactionStack defaultTxnProvider) {
        super(datastoreServiceConfig, defaultTxnProvider);
        this.async = new AsyncDatastoreServiceImpl(DatastoreServiceImpl.disableAutoTxnCreation(datastoreServiceConfig), defaultTxnProvider);
    }

    private static DatastoreServiceConfig disableAutoTxnCreation(DatastoreServiceConfig datastoreServiceConfig) {
        if (datastoreServiceConfig.getImplicitTransactionManagementPolicy() == ImplicitTransactionManagementPolicy.NONE) {
            return datastoreServiceConfig;
        }
        return new DatastoreServiceConfig(datastoreServiceConfig).implicitTransactionManagementPolicy(ImplicitTransactionManagementPolicy.NONE);
    }

    @Override
    public Entity get(Transaction txn, Key key) throws EntityNotFoundException {
        return FutureHelper.quietGet(this.async.get(txn, key), EntityNotFoundException.class);
    }

    @Override
    public Entity get(Key key) throws EntityNotFoundException {
        Entity result = this.get(Collections.singleton(key)).get(key);
        if (result == null) {
            throw new EntityNotFoundException(key);
        }
        return result;
    }

    @Override
    public Map<Key, Entity> get(final Iterable<Key> keys) {
        final BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return (Map)new TransactionRunner<Map<Key, Entity>>(result.getTransaction(), result.isNew()){

            @Override
            protected Map<Key, Entity> runInternal() {
                return FutureHelper.quietGet(DatastoreServiceImpl.this.async.get(result.getTransaction(), keys));
            }
        }.runInTransaction();
    }

    @Override
    public Map<Key, Entity> get(Transaction txn, Iterable<Key> keys) {
        return FutureHelper.quietGet(this.async.get(txn, keys));
    }

    @Override
    public Key put(Entity entity) {
        return this.put(Collections.singleton(entity)).get(0);
    }

    @Override
    public Key put(Transaction txn, Entity entity) {
        return FutureHelper.quietGet(this.async.put(txn, entity));
    }

    @Override
    public List<Key> put(final Iterable<Entity> entities) {
        final BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return (List)new TransactionRunner<List<Key>>(result.getTransaction(), result.isNew()){

            @Override
            protected List<Key> runInternal() {
                return FutureHelper.quietGet(DatastoreServiceImpl.this.async.put(result.getTransaction(), entities));
            }
        }.runInTransaction();
    }

    @Override
    public List<Key> put(Transaction txn, Iterable<Entity> entities) {
        return FutureHelper.quietGet(this.async.put(txn, entities));
    }

    @Override
    public void delete(Key ... keys) {
        this.delete(Arrays.asList(keys));
    }

    @Override
    public void delete(Transaction txn, Key ... keys) {
        FutureHelper.quietGet(this.async.delete(txn, keys));
    }

    @Override
    public void delete(final Iterable<Key> keys) {
        final BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        new TransactionRunner<Void>(result.getTransaction(), result.isNew()){

            @Override
            protected Void runInternal() {
                return FutureHelper.quietGet(DatastoreServiceImpl.this.async.delete(result.getTransaction(), keys));
            }
        }.runInTransaction();
    }

    @Override
    public void delete(Transaction txn, Iterable<Key> keys) {
        FutureHelper.quietGet(this.async.delete(txn, keys));
    }

    @Override
    public PreparedQuery prepare(Query query) {
        return this.async.prepare(query);
    }

    @Override
    public PreparedQuery prepare(Transaction txn, Query query) {
        return this.async.prepare(txn, query);
    }

    @Override
    public Collection<Transaction> getActiveTransactions() {
        return this.async.getActiveTransactions();
    }

    @Override
    public KeyRange allocateIds(String kind, long num) {
        return FutureHelper.quietGet(this.async.allocateIds(kind, num));
    }

    @Override
    public KeyRange allocateIds(Key parent, String kind, long num) {
        return FutureHelper.quietGet(this.async.allocateIds(parent, kind, num));
    }

    @Override
    public DatastoreService.KeyRangeState allocateIdRange(KeyRange range) {
        Key parent = range.getParent();
        String kind = range.getKind();
        long start = range.getStart().getId();
        long end = range.getEnd().getId();
        DatastorePb.AllocateIdsRequest req = new DatastorePb.AllocateIdsRequest().setModelKey(AsyncDatastoreServiceImpl.buildAllocateIdsRef(parent, kind, null)).setMax(end);
        DatastorePb.AllocateIdsResponse resp = new DatastorePb.AllocateIdsResponse();
        resp = FutureHelper.quietGet(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "AllocateIds", req, resp));
        Query query = new Query(kind).setKeysOnly();
        query.addFilter("__key__", Query.FilterOperator.GREATER_THAN_OR_EQUAL, range.getStart());
        query.addFilter("__key__", Query.FilterOperator.LESS_THAN_OR_EQUAL, range.getEnd());
        List<Entity> collision = this.prepare(query).asList(FetchOptions.Builder.withLimit(1));
        if (!collision.isEmpty()) {
            return DatastoreService.KeyRangeState.COLLISION;
        }
        boolean raceCondition = start < resp.getStart();
        return raceCondition ? DatastoreService.KeyRangeState.CONTENTION : DatastoreService.KeyRangeState.EMPTY;
    }

    @Override
    public Transaction beginTransaction() {
        return this.beginTransaction(TransactionOptions.Builder.withDefaults());
    }

    @Override
    public Transaction beginTransaction(TransactionOptions options) {
        return this.beginTransactionInternal(options);
    }

    @Override
    public DatastoreAttributes getDatastoreAttributes() {
        return FutureHelper.quietGet(this.async.getDatastoreAttributes());
    }

    @Override
    public Map<Index, Index.IndexState> getIndexes() {
        return FutureHelper.quietGet(this.async.getIndexes());
    }
}

