/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileReadChannel;
import com.google.appengine.api.files.FileServiceImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

class FileReadChannelImpl
implements FileReadChannel {
    private FileServiceImpl fileService;
    private AppEngineFile file;
    private long position;
    private boolean isOpen;
    private boolean reachedEOF;

    FileReadChannelImpl(AppEngineFile f, FileServiceImpl fs) {
        this.file = f;
        this.fileService = fs;
        this.isOpen = true;
        this.reachedEOF = false;
        if (null == this.file) {
            throw new NullPointerException("file is null");
        }
        if (null == fs) {
            throw new NullPointerException("fs is null");
        }
        if (!f.isReadable()) {
            throw new IllegalArgumentException("file is not readable");
        }
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen) {
            throw new ClosedChannelException();
        }
    }

    @Override
    public long position() throws IOException {
        this.checkOpen();
        return this.position;
    }

    @Override
    public FileReadChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("newPosition may not be negative");
        }
        this.checkOpen();
        this.position = newPosition;
        this.reachedEOF = false;
        return this;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.reachedEOF) {
            return -1;
        }
        int numBytesRead = this.fileService.read(this.file, dst, this.position);
        if (numBytesRead >= 0) {
            this.position += (long)numBytesRead;
        } else {
            this.reachedEOF = true;
        }
        return numBytesRead;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        this.fileService.close(this.file, false);
        this.isOpen = false;
    }
}

