/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.cloud.sql.jdbc.Connection;
import com.google.cloud.sql.jdbc.PreparedStatement;
import com.google.cloud.sql.jdbc.internal.BoundValue;
import com.google.cloud.sql.jdbc.internal.Charsets;
import com.google.cloud.sql.jdbc.internal.ClientSideBlob;
import com.google.cloud.sql.jdbc.internal.ClientSideClob;
import com.google.cloud.sql.jdbc.internal.ClientSideNClob;
import com.google.cloud.sql.jdbc.internal.DataTypeConverters;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.ExecRequest;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallableStatement
extends PreparedStatement
implements java.sql.CallableStatement {
    private boolean lastOutParameterWasNull;

    CallableStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, Connection conn, Url url) {
        super(sql, resultSetType, resultSetConcurrency, resultSetHoldability, conn, url);
        this.rpcOptions.setStatementType(ExecRequest.StatementType.CALLABLE_STATEMENT);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, BigDecimal.class);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.throwIfNotOpen();
        return this.getBigDecimal(parameterIndex).setScale(scale);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Blob.class);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Blob.class);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Boolean.class);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Boolean.class);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Byte.class);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Byte.class);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, byte[].class);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, byte[].class);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return new StringReader(this.getOutValue(parameterIndex, String.class));
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return new StringReader(this.getOutValue(parameterName, String.class));
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Clob.class);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Clob.class);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Date.class);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Date.class);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return Util.convertTime(this.getDate(parameterIndex), Calendar.getInstance(), cal);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return Util.convertTime(this.getDate(parameterName), Calendar.getInstance(), cal);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Double.class);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Double.class);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Float.class).floatValue();
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Float.class).floatValue();
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Integer.class);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Integer.class);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Long.class);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Long.class);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return new StringReader(this.getOutValue(parameterIndex, String.class));
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return new StringReader(this.getOutValue(parameterName, String.class));
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, NClob.class);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, NClob.class);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, String.class);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, String.class);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        Client.BindVariableProto variable = this.lookupOutBindVariable(parameterIndex);
        boolean bl = this.lastOutParameterWasNull = !variable.hasValue();
        if (this.lastOutParameterWasNull) {
            return null;
        }
        JdbcType jdbcType = JdbcType.fromCode(variable.getType());
        return jdbcType.getConverter().toObject(variable.getValue());
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getObject(this.getIndexForName(parameterName));
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Short.class);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Short.class);
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, String.class);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, String.class);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Time.class);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Time.class);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return Util.convertTime(this.getTime(parameterIndex), Calendar.getInstance(), cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return Util.convertTime(this.getTime(parameterName), Calendar.getInstance(), cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterIndex, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        this.throwIfNotOpen();
        return this.getOutValue(parameterName, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return Util.convertTime(this.getTimestamp(parameterIndex), Calendar.getInstance(), cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return Util.convertTime(this.getTimestamp(parameterName), Calendar.getInstance(), cal);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.nullValue(JdbcType.fromCode(sqlType), Client.BindVariableProto.Direction.OUT));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.nullValue(JdbcType.fromCode(sqlType), Client.BindVariableProto.Direction.OUT));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        throw Exceptions.newNotYetImplementedException("Registering an output parameter with scale is not implemented yet.");
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.throwIfNotOpen();
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw Exceptions.newNotYetImplementedException("Registering an output parameter with scale is not implemented yet.");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.throwIfNotOpen();
        this.registerOutParameter(parameterName, sqlType);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.throwIfNotOpen();
        return this.lastOutParameterWasNull;
    }

    @Override
    void bindParameter(int parameterIndex, BoundValue typedValue) throws SQLException {
        BoundValue previous;
        if (typedValue.getDirection() == Client.BindVariableProto.Direction.OUT) {
            Util.checkParameter(typedValue.isNull(), "Output parameter @ index {0} is not null", parameterIndex);
        }
        if ((previous = this.getIndexedBindParametersMap().get(parameterIndex)) == null) {
            super.bindParameter(parameterIndex, typedValue);
            return;
        }
        Util.checkParameter(previous.getDataType() == typedValue.getDataType(), "Found inconsistent type for parameter {0}", parameterIndex);
        if (previous.getDirection() == Client.BindVariableProto.Direction.IN && typedValue.getDirection() == Client.BindVariableProto.Direction.OUT) {
            super.bindParameter(parameterIndex, BoundValue.of(previous.getValue(), previous.getDataType(), Client.BindVariableProto.Direction.INOUT));
        } else {
            super.bindParameter(parameterIndex, typedValue);
        }
    }

    @Override
    void bindParameter(String parameterName, BoundValue typedValue) throws SQLException {
        BoundValue previous;
        if (typedValue.getDirection() == Client.BindVariableProto.Direction.OUT) {
            Util.checkParameter(typedValue.isNull(), "Output parameter @ index {0} is not null", parameterName);
        }
        if ((previous = this.getNamedBindParametersMap().get(parameterName)) == null) {
            super.bindParameter(parameterName, typedValue);
            return;
        }
        Util.checkParameter(previous.getDataType() == typedValue.getDataType(), "Found inconsistent type for parameter {0}", parameterName);
        if (previous.getDirection() == Client.BindVariableProto.Direction.IN && typedValue.getDirection() == Client.BindVariableProto.Direction.OUT) {
            super.bindParameter(parameterName, BoundValue.of(previous.getValue(), previous.getDataType(), Client.BindVariableProto.Direction.INOUT));
        } else {
            super.bindParameter(parameterName, typedValue);
        }
    }

    private void updateParameterType(String parameterName, JdbcType dataType) {
        BoundValue old = this.getNamedBindParametersMap().get(parameterName);
        Util.checkNotNull(old, "Unable to find parameter named " + parameterName);
        this.getNamedBindParametersMap().put(parameterName, BoundValue.withNewType(old, dataType));
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream is) throws SQLException {
        this.throwIfNotOpen();
        String data = new String(CallableStatement.toByteArray(is, 4096L), Charsets.US_ASCII);
        this.bindParameter(parameterName, BoundValue.of(data, JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream is, int length) throws SQLException {
        this.throwIfNotOpen();
        String data = new String(CallableStatement.toByteArray(is, length), Charsets.US_ASCII);
        this.bindParameter(parameterName, BoundValue.of(data, JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream is, long length) throws SQLException {
        this.throwIfNotOpen();
        String data = new String(CallableStatement.toByteArray(is, length), Charsets.US_ASCII);
        this.bindParameter(parameterName, BoundValue.of(data, JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(x, JdbcType.JDBC_TYPE_DECIMAL));
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream is) throws SQLException {
        this.throwIfNotOpen();
        byte[] bytes = CallableStatement.toByteArray(is, 4096L);
        this.bindParameter(parameterName, BoundValue.of(bytes, JdbcType.JDBC_TYPE_LONGVARBINARY));
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream is, int length) throws SQLException {
        this.throwIfNotOpen();
        byte[] bytes = CallableStatement.toByteArray(is, length);
        this.bindParameter(parameterName, BoundValue.of(bytes, JdbcType.JDBC_TYPE_LONGVARBINARY));
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream is, long length) throws SQLException {
        this.throwIfNotOpen();
        byte[] bytes = CallableStatement.toByteArray(is, length);
        this.bindParameter(parameterName, BoundValue.of(bytes, JdbcType.JDBC_TYPE_LONGVARBINARY));
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(x, JdbcType.JDBC_TYPE_BLOB));
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.throwIfNotOpen();
        this.setBlob(parameterName, inputStream, 4096L);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.throwIfNotOpen();
        ClientSideBlob blob = new ClientSideBlob(CallableStatement.toByteArray(inputStream, (int)length));
        this.bindParameter(parameterName, BoundValue.of(blob, JdbcType.JDBC_TYPE_BLOB));
    }

    @Override
    public void setBoolean(String parameterName, boolean b) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(b, JdbcType.JDBC_TYPE_BOOLEAN));
    }

    @Override
    public void setByte(String parameterName, byte b) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(b, JdbcType.JDBC_TYPE_TINYINT));
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(x, JdbcType.JDBC_TYPE_VARBINARY));
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.throwIfNotOpen();
        char[] data = CallableStatement.toCharArray(reader, 4096L);
        this.bindParameter(parameterName, BoundValue.of(new String(data), JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.throwIfNotOpen();
        char[] data = CallableStatement.toCharArray(reader, length);
        this.bindParameter(parameterName, BoundValue.of(new String(data), JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.throwIfNotOpen();
        char[] data = CallableStatement.toCharArray(reader, length);
        this.bindParameter(parameterName, BoundValue.of(new String(data), JdbcType.JDBC_TYPE_LONGVARCHAR));
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(x, JdbcType.JDBC_TYPE_CLOB));
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.throwIfNotOpen();
        this.setClob(parameterName, reader, 4096L);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.throwIfNotOpen();
        ClientSideClob clob = new ClientSideClob(CallableStatement.toCharArray(reader, (int)length));
        this.bindParameter(parameterName, BoundValue.of(clob, JdbcType.JDBC_TYPE_CLOB));
    }

    @Override
    public void setDate(String parameterName, Date d) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(d, JdbcType.JDBC_TYPE_DATE));
    }

    @Override
    public void setDate(String parameterName, Date d, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        this.setDate(parameterName, Util.convertTime(d, cal, Calendar.getInstance()));
    }

    @Override
    public void setDouble(String parameterName, double d) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(d, JdbcType.JDBC_TYPE_DOUBLE));
    }

    @Override
    public void setFloat(String parameterName, float f) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(Float.valueOf(f), JdbcType.JDBC_TYPE_FLOAT));
    }

    @Override
    public void setInt(String parameterName, int i) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(i, JdbcType.JDBC_TYPE_INTEGER));
    }

    @Override
    public void setLong(String parameterName, long l) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(l, JdbcType.JDBC_TYPE_BIGINT));
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.throwIfNotOpen();
        char[] data = CallableStatement.toCharArray(reader, 4096L);
        this.bindParameter(parameterName, BoundValue.of(new String(data), JdbcType.JDBC_TYPE_LONGNVARCHAR));
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.throwIfNotOpen();
        char[] data = CallableStatement.toCharArray(reader, length);
        this.bindParameter(parameterName, BoundValue.of(new String(data), JdbcType.JDBC_TYPE_LONGNVARCHAR));
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(value, JdbcType.JDBC_TYPE_NCLOB));
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.throwIfNotOpen();
        this.setNClob(parameterName, reader, 4096L);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.throwIfNotOpen();
        ClientSideNClob clob = new ClientSideNClob(CallableStatement.toCharArray(reader, (int)length));
        this.bindParameter(parameterName, BoundValue.of(clob, JdbcType.JDBC_TYPE_NCLOB));
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(value, JdbcType.JDBC_TYPE_NCHAR));
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.throwIfNotOpen();
        this.setNull(parameterName, sqlType, null);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.nullValue(JdbcType.fromCode(sqlType)));
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.throwIfNotOpen();
        Class<?> clazz = x.getClass();
        if (clazz == String.class) {
            this.setString(parameterName, (String)x);
        } else if (clazz == Boolean.class) {
            this.setBoolean(parameterName, (boolean)((Boolean)x));
        } else if (clazz == Byte.class) {
            this.setByte(parameterName, (byte)((Byte)x));
        } else if (clazz == Short.class) {
            this.setShort(parameterName, (short)((Short)x));
        } else if (clazz == Integer.class) {
            this.setInt(parameterName, (int)((Integer)x));
        } else if (clazz == Long.class) {
            this.setLong(parameterName, (long)((Long)x));
        } else if (clazz == Float.class) {
            this.setFloat(parameterName, ((Float)x).floatValue());
        } else if (clazz == Double.class) {
            this.setDouble(parameterName, (double)((Double)x));
        } else if (clazz == byte[].class) {
            this.setBytes(parameterName, (byte[])x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterName, (BigDecimal)x);
        } else if (x instanceof Date) {
            this.setDate(parameterName, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterName, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterName, (Timestamp)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterName, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterName, (Clob)x);
        } else if (x instanceof NClob) {
            this.setNClob(parameterName, (NClob)x);
        } else {
            if (x instanceof Struct) {
                throw Exceptions.newNotYetImplementedException();
            }
            if (x instanceof URL) {
                this.setURL(parameterName, (URL)x);
            } else if (x instanceof RowId) {
                this.setRowId(parameterName, (RowId)x);
            } else if (x instanceof RowId) {
                this.setRowId(parameterName, (RowId)x);
            } else if (x instanceof SQLXML) {
                this.setSQLXML(parameterName, (SQLXML)x);
            } else {
                throw Exceptions.newInvalidParameterException("setObject", x.getClass());
            }
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.throwIfNotOpen();
        this.setObject(parameterName, x, targetSqlType, 0);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.throwIfNotOpen();
        switch (JdbcType.fromCode(targetSqlType)) {
            case JDBC_TYPE_BIGINT: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setLong(parameterName, CallableStatement.boolAsNumber((Boolean)x).longValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setLong(parameterName, ((Number)x).longValue());
                    break;
                }
                this.setLong(parameterName, (long)Long.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_BINARY: 
            case JDBC_TYPE_LONGVARBINARY: 
            case JDBC_TYPE_VARBINARY: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, byte[].class);
                Class<?> clazz = x.getClass();
                if (clazz == byte[].class) {
                    this.setBytes(parameterName, (byte[])x);
                    break;
                }
                this.setString(parameterName, (String)x);
                break;
            }
            case JDBC_TYPE_BIT: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                this.setInt(parameterName, CallableStatement.toBoolean(x) ? 1 : 0);
                break;
            }
            case JDBC_TYPE_BLOB: {
                CallableStatement.throwIfNotOfClass(x, "setObject", Blob.class);
                this.setBlob(parameterName, (Blob)x);
                break;
            }
            case JDBC_TYPE_BOOLEAN: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                this.setBoolean(parameterName, CallableStatement.toBoolean(x));
                break;
            }
            case JDBC_TYPE_CHAR: 
            case JDBC_TYPE_LONGVARCHAR: 
            case JDBC_TYPE_VARCHAR: 
            case JDBC_TYPE_NVARCHAR: 
            case JDBC_TYPE_LONGNVARCHAR: 
            case JDBC_TYPE_NCHAR: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Number.class, Boolean.class, Date.class, Time.class, Timestamp.class);
                if (x instanceof Boolean) {
                    this.setString(parameterName, (Boolean)x != false ? "1" : "0");
                } else if (x instanceof BigDecimal) {
                    this.setString(parameterName, ((BigDecimal)x).toPlainString());
                }
                this.setString(parameterName, String.valueOf(x));
                break;
            }
            case JDBC_TYPE_CLOB: {
                CallableStatement.throwIfNotOfClass(x, "setObject", Clob.class);
                this.setClob(parameterName, (Clob)x);
                break;
            }
            case JDBC_TYPE_NCLOB: {
                CallableStatement.throwIfNotOfClass(x, "setObject", NClob.class);
                this.setNClob(parameterName, (NClob)x);
                break;
            }
            case JDBC_TYPE_DATALINK: {
                CallableStatement.throwIfNotOfClass(x, "setObject", URL.class);
                this.setURL(parameterName, (URL)x);
                break;
            }
            case JDBC_TYPE_DATE: {
                CallableStatement.throwIfNotOfClass(x, "setObject", Date.class, String.class, Timestamp.class);
                if (x instanceof Date) {
                    this.setDate(parameterName, (Date)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTimestamp(parameterName, (Timestamp)x);
                    break;
                }
                this.setString(parameterName, (String)x);
                break;
            }
            case JDBC_TYPE_DECIMAL: 
            case JDBC_TYPE_NUMERIC: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setBigDecimal(parameterName, (Boolean)x != false ? BigDecimal.ONE.setScale(scaleOrLength) : BigDecimal.ZERO.setScale(scaleOrLength));
                    break;
                }
                if (x instanceof Number) {
                    this.setBigDecimal(parameterName, Util.createBigDecimalWithScale(this.toBigDecimal((Number)x), scaleOrLength));
                    break;
                }
                this.setBigDecimal(parameterName, Util.createBigDecimalWithScale(new BigDecimal((String)x), scaleOrLength));
                break;
            }
            case JDBC_TYPE_DOUBLE: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setDouble(parameterName, CallableStatement.boolAsNumber((Boolean)x).doubleValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setDouble(parameterName, ((Number)x).doubleValue());
                    break;
                }
                this.setDouble(parameterName, (double)Double.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_FLOAT: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setDouble(parameterName, CallableStatement.boolAsNumber((Boolean)x).doubleValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setDouble(parameterName, ((Number)x).doubleValue());
                    break;
                }
                this.setDouble(parameterName, (double)Double.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_INTEGER: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setInt(parameterName, CallableStatement.boolAsNumber((Boolean)x).intValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setInt(parameterName, ((Number)x).intValue());
                    break;
                }
                this.setInt(parameterName, (int)Integer.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_REAL: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setFloat(parameterName, CallableStatement.boolAsNumber((Boolean)x).floatValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setFloat(parameterName, ((Number)x).floatValue());
                    break;
                }
                this.setFloat(parameterName, Float.valueOf((String)x).floatValue());
                break;
            }
            case JDBC_TYPE_ROWID: {
                CallableStatement.throwIfNotOfClass(x, "setObject", RowId.class);
                this.setRowId(parameterName, (RowId)x);
                break;
            }
            case JDBC_TYPE_SMALLINT: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setShort(parameterName, CallableStatement.boolAsNumber((Boolean)x).shortValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setShort(parameterName, ((Number)x).shortValue());
                    break;
                }
                this.setShort(parameterName, (short)Short.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_TINYINT: {
                CallableStatement.throwIfNotOfClass(x, "setObject", String.class, Boolean.class, Number.class);
                if (x instanceof Boolean) {
                    this.setByte(parameterName, CallableStatement.boolAsNumber((Boolean)x).byteValue());
                    break;
                }
                if (x instanceof Number) {
                    this.setByte(parameterName, ((Number)x).byteValue());
                    break;
                }
                this.setByte(parameterName, (byte)Byte.valueOf((String)x));
                break;
            }
            case JDBC_TYPE_SQLXML: {
                CallableStatement.throwIfNotOfClass(x, "setObject", SQLXML.class);
                this.setSQLXML(parameterName, (SQLXML)x);
                break;
            }
            case JDBC_TYPE_TIME: {
                CallableStatement.throwIfNotOfClass(x, "setObject", Time.class, String.class, Timestamp.class);
                if (x instanceof Time) {
                    this.setTime(parameterName, (Time)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTime(parameterName, new Time(((Timestamp)x).getTime()));
                    break;
                }
                this.setString(parameterName, (String)x);
                break;
            }
            case JDBC_TYPE_TIMESTAMP: {
                CallableStatement.throwIfNotOfClass(x, "setObject", Date.class, String.class, Timestamp.class);
                if (x instanceof Date) {
                    this.setDate(parameterName, (Date)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTimestamp(parameterName, (Timestamp)x);
                    break;
                }
                this.setString(parameterName, (String)x);
                break;
            }
            case JDBC_TYPE_JAVA_OBJECT: 
            case JDBC_TYPE_STRUCT: {
                throw Exceptions.newNotYetImplementedException();
            }
            case JDBC_TYPE_DISTINCT: 
            case JDBC_TYPE_NULL: 
            case JDBC_TYPE_OTHER: {
                throw Exceptions.newNotYetImplementedException();
            }
            default: {
                throw Exceptions.newInvalidParameterException("targetSqlType", targetSqlType);
            }
        }
        this.updateParameterType(parameterName, JdbcType.fromCode(targetSqlType));
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setShort(String parameterName, short s) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(s, JdbcType.JDBC_TYPE_SMALLINT));
    }

    @Override
    public void setString(String parameterName, String s) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(s, JdbcType.JDBC_TYPE_VARCHAR));
    }

    @Override
    public void setTime(String parameterName, Time t) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(t, JdbcType.JDBC_TYPE_TIME));
    }

    @Override
    public void setTime(String parameterName, Time t, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        this.setTime(parameterName, Util.convertTime(t, cal, Calendar.getInstance()));
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp ts) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterName, BoundValue.of(ts, JdbcType.JDBC_TYPE_TIMESTAMP));
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp ts, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        this.setTimestamp(parameterName, Util.convertTime(ts, cal, Calendar.getInstance()));
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    private <C> C getOutValue(int parameterIndex, Class<C> clazz) throws SQLException {
        Client.BindVariableProto variable = this.lookupOutBindVariable(parameterIndex);
        this.lastOutParameterWasNull = !variable.hasValue();
        return DataTypeConverters.getConverter(clazz).toObject(variable.getValue());
    }

    private <C> C getOutValue(String parameterName, Class<C> clazz) throws SQLException {
        Client.BindVariableProto variable = this.lookupOutBindVariable(this.getIndexForName(parameterName));
        this.lastOutParameterWasNull = !variable.hasValue();
        return DataTypeConverters.getConverter(clazz).toObject(variable.getValue());
    }

    private int getIndexForName(String parameterName) throws SQLException {
        Integer parameterIndex = (Integer)this.parameterIndexMap.get(parameterName);
        Util.checkParameter(parameterIndex != null, "Unable to find parameter {0}", parameterName);
        return parameterIndex;
    }

    private Client.BindVariableProto lookupOutBindVariable(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        Client.BindVariableProto variable = (Client.BindVariableProto)this.outParametersMap.get(parameterIndex);
        if (variable == null) {
            throw Exceptions.newSqlException("No out parameter at index " + parameterIndex);
        }
        return variable;
    }
}

