/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import com.google.protos.speckle.Client;
import com.google.storage.speckle.jdbc.SpeckleSavepoint;

public final class ConnectionOperationHelper {
    public static Client.OpProto nativeSQL(String sql) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.NATIVE_SQL).setSql(sql).build();
    }

    public static Client.OpProto rollback() {
        return ConnectionOperationHelper.rollback(null);
    }

    public static Client.OpProto rollback(String savepointName) {
        Client.OpProto.Builder builder = Client.OpProto.newBuilder().setType(Client.OpProto.OpType.ROLLBACK);
        if (savepointName != null && savepointName.length() > 0) {
            builder.setSavepoint(Client.SavePoint.newBuilder().setName(savepointName).build());
        }
        return builder.build();
    }

    public static Client.OpProto commit() {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.COMMIT).build();
    }

    public static Client.OpProto savePoint() {
        return ConnectionOperationHelper.savePoint(null);
    }

    public static Client.OpProto savePoint(String savepointName) {
        Client.OpProto.Builder builder = Client.OpProto.newBuilder().setType(Client.OpProto.OpType.SET_SAVEPOINT);
        if (savepointName != null && savepointName.length() > 0) {
            builder.setSavepoint(Client.SavePoint.newBuilder().setName(savepointName).build());
        }
        return builder.build();
    }

    public static Client.OpProto autoCommit(boolean autoCommit) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.SET_AUTO_COMMIT).setAutoCommit(autoCommit).build();
    }

    public static Client.OpProto readOnly(boolean readOnly) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.SET_READ_ONLY).setReadOnly(readOnly).build();
    }

    public static Client.OpProto transactionIsolation(int level) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.SET_TRANSACTION_ISOLATION_LEVEL).setTransactionIsolationLevel(Client.TransactionIsolationLevel.valueOf(level)).build();
    }

    public static Client.OpProto setCatalog(String catalog) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.SET_CATALOG).setCatalog(catalog).build();
    }

    public static Client.OpProto closeStatement(long statementId) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.CLOSE_STATEMENT).setStatementId(statementId).build();
    }

    public static SpeckleSavepoint asJdbcSavePoint(Client.SavePoint s) {
        return new SpeckleSavepoint(Long.valueOf(s.getId()).intValue(), s.getName());
    }
}

