/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.plus.model;

import com.google.api.client.json.GenericJson;

/**
 * Model definition for PlusAclentryResource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlusAclentryResource extends GenericJson {

  /**
   * A descriptive name for this entry. Suitable for display.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String displayName;

  /**
   * The ID of the entry. For entries of type "person" or "circle", this is the ID of the resource.
   * For other types, this property is not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * The type of entry describing to whom access is granted. Possible values are: - "person" -
   * Access to an individual.  - "circle" - Access to members of a circle.  - "myCircles" - Access
   * to members of all the person's circles.  - "extendedCircles" - Access to members of everyone in
   * a person's circles, plus all of the people in their circles.  - "public" - Access to anyone on
   * the web.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String type;

  /**
   * A descriptive name for this entry. Suitable for display.
   * The value returned may be {@code null}.
   */
  public String getDisplayName() {
    return displayName;
  }

  /**
   * A descriptive name for this entry. Suitable for display.
   * The value set may be {@code null}.
   */
  public PlusAclentryResource setDisplayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The ID of the entry. For entries of type "person" or "circle", this is the ID of the resource.
   * For other types, this property is not set.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The ID of the entry. For entries of type "person" or "circle", this is the ID of the resource.
   * For other types, this property is not set.
   * The value set may be {@code null}.
   */
  public PlusAclentryResource setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The type of entry describing to whom access is granted. Possible values are: - "person" -
   * Access to an individual.  - "circle" - Access to members of a circle.  - "myCircles" - Access
   * to members of all the person's circles.  - "extendedCircles" - Access to members of everyone in
   * a person's circles, plus all of the people in their circles.  - "public" - Access to anyone on
   * the web.
   * The value returned may be {@code null}.
   */
  public String getType() {
    return type;
  }

  /**
   * The type of entry describing to whom access is granted. Possible values are: - "person" -
   * Access to an individual.  - "circle" - Access to members of a circle.  - "myCircles" - Access
   * to members of all the person's circles.  - "extendedCircles" - Access to members of everyone in
   * a person's circles, plus all of the people in their circles.  - "public" - Access to anyone on
   * the web.
   * The value set may be {@code null}.
   */
  public PlusAclentryResource setType(String type) {
    this.type = type;
    return this;
  }

}
