/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-11-17 18:43:33 UTC)
 * on 2015-01-22 at 22:30:27 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * Style for lines.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LineStyle extends com.google.api.client.json.GenericJson {

  /**
   * Border of the line. 0 < border.width <= 5.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Border border;

  /**
   * Dash defines the pattern of the line, the values are pixel lengths of alternating dash and gap.
   * If dash is not provided, then it means a solid line. Dash can contain up to 10 values and must
   * contain even number of values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> dash;

  /**
   * Label style for the line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LabelStyle label;

  /**
   * Stroke of the line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Stroke stroke;

  /**
   * Border of the line. 0 < border.width <= 5.
   * @return value or {@code null} for none
   */
  public Border getBorder() {
    return border;
  }

  /**
   * Border of the line. 0 < border.width <= 5.
   * @param border border or {@code null} for none
   */
  public LineStyle setBorder(Border border) {
    this.border = border;
    return this;
  }

  /**
   * Dash defines the pattern of the line, the values are pixel lengths of alternating dash and gap.
   * If dash is not provided, then it means a solid line. Dash can contain up to 10 values and must
   * contain even number of values.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getDash() {
    return dash;
  }

  /**
   * Dash defines the pattern of the line, the values are pixel lengths of alternating dash and gap.
   * If dash is not provided, then it means a solid line. Dash can contain up to 10 values and must
   * contain even number of values.
   * @param dash dash or {@code null} for none
   */
  public LineStyle setDash(java.util.List<java.lang.Double> dash) {
    this.dash = dash;
    return this;
  }

  /**
   * Label style for the line.
   * @return value or {@code null} for none
   */
  public LabelStyle getLabel() {
    return label;
  }

  /**
   * Label style for the line.
   * @param label label or {@code null} for none
   */
  public LineStyle setLabel(LabelStyle label) {
    this.label = label;
    return this;
  }

  /**
   * Stroke of the line.
   * @return value or {@code null} for none
   */
  public Stroke getStroke() {
    return stroke;
  }

  /**
   * Stroke of the line.
   * @param stroke stroke or {@code null} for none
   */
  public LineStyle setStroke(Stroke stroke) {
    this.stroke = stroke;
    return this;
  }

  @Override
  public LineStyle set(String fieldName, Object value) {
    return (LineStyle) super.set(fieldName, value);
  }

  @Override
  public LineStyle clone() {
    return (LineStyle) super.clone();
  }

  /**
   * Stroke of the line.
   */
  public static final class Stroke extends com.google.api.client.json.GenericJson {

    /**
     * Color of the line.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String color;

    /**
     * Opacity of the line.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double opacity;

    /**
     * Width of the line, in pixels. 0 <= width <= 10. If width is set to 0, the line will be
     * invisible.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double width;

    /**
     * Color of the line.
     * @return value or {@code null} for none
     */
    public java.lang.String getColor() {
      return color;
    }

    /**
     * Color of the line.
     * @param color color or {@code null} for none
     */
    public Stroke setColor(java.lang.String color) {
      this.color = color;
      return this;
    }

    /**
     * Opacity of the line.
     * @return value or {@code null} for none
     */
    public java.lang.Double getOpacity() {
      return opacity;
    }

    /**
     * Opacity of the line.
     * @param opacity opacity or {@code null} for none
     */
    public Stroke setOpacity(java.lang.Double opacity) {
      this.opacity = opacity;
      return this;
    }

    /**
     * Width of the line, in pixels. 0 <= width <= 10. If width is set to 0, the line will be
     * invisible.
     * @return value or {@code null} for none
     */
    public java.lang.Double getWidth() {
      return width;
    }

    /**
     * Width of the line, in pixels. 0 <= width <= 10. If width is set to 0, the line will be
     * invisible.
     * @param width width or {@code null} for none
     */
    public Stroke setWidth(java.lang.Double width) {
      this.width = width;
      return this;
    }

    @Override
    public Stroke set(String fieldName, Object value) {
      return (Stroke) super.set(fieldName, value);
    }

    @Override
    public Stroke clone() {
      return (Stroke) super.clone();
    }

  }
}
