/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-09 17:08:39 UTC)
 * on 2014-07-17 at 07:58:54 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A Map is a collection of Layers, optionally contained within folders.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Map extends com.google.api.client.json.GenericJson {

  /**
   * A rectangular bounding box which contains all of the data in this Map. The numbers represent
   * latitude and longitude in decimal degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> bbox;

  /**
   * The contents of this Map.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MapItem> contents;

  /**
   * The creation time of this map. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime creationTime;

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> defaultViewport;

  /**
   * The description of this Map, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Read About access lists in the
   * Google Maps Engine help center for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String draftAccessList;

  /**
   * The ETag, used to refer to the current version of the asset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * A globally unique ID, used to refer to this Map.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The last modified time of this map. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastModifiedTime;

  /**
   * The name of this Map, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The processing status of this map. Map processing is automatically started once a map becomes
   * ready for processing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processingStatus;

  /**
   * The ID of the project that this Map is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Deprecated: The access list to whom view permissions are granted. The value must be the name of
   * a Maps Engine access list of the Map Viewer type, and the user must be a viewer on that list.
   * Read About access lists in the Google Maps Engine help center for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publishedAccessList;

  /**
   * Tags of this Map.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * An array containing the available versions of this Map. Currently may only contain "published".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> versions;

  /**
   * A rectangular bounding box which contains all of the data in this Map. The numbers represent
   * latitude and longitude in decimal degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getBbox() {
    return bbox;
  }

  /**
   * A rectangular bounding box which contains all of the data in this Map. The numbers represent
   * latitude and longitude in decimal degrees.
   * @param bbox bbox or {@code null} for none
   */
  public Map setBbox(java.util.List<java.lang.Double> bbox) {
    this.bbox = bbox;
    return this;
  }

  /**
   * The contents of this Map.
   * @return value or {@code null} for none
   */
  public java.util.List<MapItem> getContents() {
    return contents;
  }

  /**
   * The contents of this Map.
   * @param contents contents or {@code null} for none
   */
  public Map setContents(java.util.List<MapItem> contents) {
    this.contents = contents;
    return this;
  }

  /**
   * The creation time of this map. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreationTime() {
    return creationTime;
  }

  /**
   * The creation time of this map. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param creationTime creationTime or {@code null} for none
   */
  public Map setCreationTime(com.google.api.client.util.DateTime creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getDefaultViewport() {
    return defaultViewport;
  }

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * @param defaultViewport defaultViewport or {@code null} for none
   */
  public Map setDefaultViewport(java.util.List<java.lang.Double> defaultViewport) {
    this.defaultViewport = defaultViewport;
    return this;
  }

  /**
   * The description of this Map, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this Map, supplied by the author.
   * @param description description or {@code null} for none
   */
  public Map setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Read About access lists in the
   * Google Maps Engine help center for more information.
   * @return value or {@code null} for none
   */
  public java.lang.String getDraftAccessList() {
    return draftAccessList;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Read About access lists in the
   * Google Maps Engine help center for more information.
   * @param draftAccessList draftAccessList or {@code null} for none
   */
  public Map setDraftAccessList(java.lang.String draftAccessList) {
    this.draftAccessList = draftAccessList;
    return this;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @param etag etag or {@code null} for none
   */
  public Map setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * A globally unique ID, used to refer to this Map.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A globally unique ID, used to refer to this Map.
   * @param id id or {@code null} for none
   */
  public Map setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The last modified time of this map. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * The last modified time of this map. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Map setLastModifiedTime(com.google.api.client.util.DateTime lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The name of this Map, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this Map, supplied by the author.
   * @param name name or {@code null} for none
   */
  public Map setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The processing status of this map. Map processing is automatically started once a map becomes
   * ready for processing.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessingStatus() {
    return processingStatus;
  }

  /**
   * The processing status of this map. Map processing is automatically started once a map becomes
   * ready for processing.
   * @param processingStatus processingStatus or {@code null} for none
   */
  public Map setProcessingStatus(java.lang.String processingStatus) {
    this.processingStatus = processingStatus;
    return this;
  }

  /**
   * The ID of the project that this Map is in.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the project that this Map is in.
   * @param projectId projectId or {@code null} for none
   */
  public Map setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Deprecated: The access list to whom view permissions are granted. The value must be the name of
   * a Maps Engine access list of the Map Viewer type, and the user must be a viewer on that list.
   * Read About access lists in the Google Maps Engine help center for more information.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublishedAccessList() {
    return publishedAccessList;
  }

  /**
   * Deprecated: The access list to whom view permissions are granted. The value must be the name of
   * a Maps Engine access list of the Map Viewer type, and the user must be a viewer on that list.
   * Read About access lists in the Google Maps Engine help center for more information.
   * @param publishedAccessList publishedAccessList or {@code null} for none
   */
  public Map setPublishedAccessList(java.lang.String publishedAccessList) {
    this.publishedAccessList = publishedAccessList;
    return this;
  }

  /**
   * Tags of this Map.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * Tags of this Map.
   * @param tags tags or {@code null} for none
   */
  public Map setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  /**
   * An array containing the available versions of this Map. Currently may only contain "published".
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getVersions() {
    return versions;
  }

  /**
   * An array containing the available versions of this Map. Currently may only contain "published".
   * @param versions versions or {@code null} for none
   */
  public Map setVersions(java.util.List<java.lang.String> versions) {
    this.versions = versions;
    return this;
  }

  @Override
  public Map set(String fieldName, Object value) {
    return (Map) super.set(fieldName, value);
  }

  @Override
  public Map clone() {
    return (Map) super.clone();
  }

}
