/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-04-15 19:10:39 UTC)
 * on 2014-04-29 at 00:21:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * The response returned by a call to features.List.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FeaturesListResponse extends com.google.api.client.json.GenericJson {

  /**
   * An indicator of the maximum rate at which queries may be made, if all queries were as expensive
   * as this query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double allowedQueriesPerSecond;

  /**
   * Resources returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Feature> features;

  static {
    // hack to force ProGuard to consider Feature used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Feature.class);
  }

  /**
   * Next page token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The feature schema.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Schema schema;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * An indicator of the maximum rate at which queries may be made, if all queries were as expensive
   * as this query.
   * @return value or {@code null} for none
   */
  public java.lang.Double getAllowedQueriesPerSecond() {
    return allowedQueriesPerSecond;
  }

  /**
   * An indicator of the maximum rate at which queries may be made, if all queries were as expensive
   * as this query.
   * @param allowedQueriesPerSecond allowedQueriesPerSecond or {@code null} for none
   */
  public FeaturesListResponse setAllowedQueriesPerSecond(java.lang.Double allowedQueriesPerSecond) {
    this.allowedQueriesPerSecond = allowedQueriesPerSecond;
    return this;
  }

  /**
   * Resources returned.
   * @return value or {@code null} for none
   */
  public java.util.List<Feature> getFeatures() {
    return features;
  }

  /**
   * Resources returned.
   * @param features features or {@code null} for none
   */
  public FeaturesListResponse setFeatures(java.util.List<Feature> features) {
    this.features = features;
    return this;
  }

  /**
   * Next page token.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Next page token.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public FeaturesListResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The feature schema.
   * @return value or {@code null} for none
   */
  public Schema getSchema() {
    return schema;
  }

  /**
   * The feature schema.
   * @param schema schema or {@code null} for none
   */
  public FeaturesListResponse setSchema(Schema schema) {
    this.schema = schema;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * @param type type or {@code null} for none
   */
  public FeaturesListResponse setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public FeaturesListResponse set(String fieldName, Object value) {
    return (FeaturesListResponse) super.set(fieldName, value);
  }

  @Override
  public FeaturesListResponse clone() {
    return (FeaturesListResponse) super.clone();
  }

}
