/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-08-21 at 08:56:47 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * Parameters for scaling scaled shapes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ScalingFunction extends com.google.api.client.json.GenericJson {

  /**
   * Name of the numeric column used to scale a shape.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String column;

  /**
   * The type of scaling function to use. Defaults to SQRT. Currently only linear and square root
   * scaling are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scalingType;

  /**
   * The range of shape sizes, in pixels. For circles, the size corresponds to the diameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SizeRange sizeRange;

  /**
   * The range of values to display across the size range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ValueRange valueRange;

  /**
   * Name of the numeric column used to scale a shape.
   * @return value or {@code null} for none
   */
  public java.lang.String getColumn() {
    return column;
  }

  /**
   * Name of the numeric column used to scale a shape.
   * @param column column or {@code null} for none
   */
  public ScalingFunction setColumn(java.lang.String column) {
    this.column = column;
    return this;
  }

  /**
   * The type of scaling function to use. Defaults to SQRT. Currently only linear and square root
   * scaling are supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getScalingType() {
    return scalingType;
  }

  /**
   * The type of scaling function to use. Defaults to SQRT. Currently only linear and square root
   * scaling are supported.
   * @param scalingType scalingType or {@code null} for none
   */
  public ScalingFunction setScalingType(java.lang.String scalingType) {
    this.scalingType = scalingType;
    return this;
  }

  /**
   * The range of shape sizes, in pixels. For circles, the size corresponds to the diameter.
   * @return value or {@code null} for none
   */
  public SizeRange getSizeRange() {
    return sizeRange;
  }

  /**
   * The range of shape sizes, in pixels. For circles, the size corresponds to the diameter.
   * @param sizeRange sizeRange or {@code null} for none
   */
  public ScalingFunction setSizeRange(SizeRange sizeRange) {
    this.sizeRange = sizeRange;
    return this;
  }

  /**
   * The range of values to display across the size range.
   * @return value or {@code null} for none
   */
  public ValueRange getValueRange() {
    return valueRange;
  }

  /**
   * The range of values to display across the size range.
   * @param valueRange valueRange or {@code null} for none
   */
  public ScalingFunction setValueRange(ValueRange valueRange) {
    this.valueRange = valueRange;
    return this;
  }

  @Override
  public ScalingFunction set(String fieldName, Object value) {
    return (ScalingFunction) super.set(fieldName, value);
  }

  @Override
  public ScalingFunction clone() {
    return (ScalingFunction) super.clone();
  }

}
