/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-11-17 18:43:33 UTC)
 * on 2014-11-18 at 18:13:27 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * Acquisition time represents acquired time of a raster.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AcquisitionTime extends com.google.api.client.json.GenericJson {

  /**
   * The end time if acquisition time is a range. The value is an RFC 3339 formatted date-time value
   * (1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime end;

  /**
   * The precision of acquisition time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String precision;

  /**
   * The acquisition time, or start time if acquisition time is a range. The value is an RFC 3339
   * formatted date-time value (1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime start;

  /**
   * The end time if acquisition time is a range. The value is an RFC 3339 formatted date-time value
   * (1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getEnd() {
    return end;
  }

  /**
   * The end time if acquisition time is a range. The value is an RFC 3339 formatted date-time value
   * (1970-01-01T00:00:00Z).
   * @param end end or {@code null} for none
   */
  public AcquisitionTime setEnd(com.google.api.client.util.DateTime end) {
    this.end = end;
    return this;
  }

  /**
   * The precision of acquisition time.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrecision() {
    return precision;
  }

  /**
   * The precision of acquisition time.
   * @param precision precision or {@code null} for none
   */
  public AcquisitionTime setPrecision(java.lang.String precision) {
    this.precision = precision;
    return this;
  }

  /**
   * The acquisition time, or start time if acquisition time is a range. The value is an RFC 3339
   * formatted date-time value (1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getStart() {
    return start;
  }

  /**
   * The acquisition time, or start time if acquisition time is a range. The value is an RFC 3339
   * formatted date-time value (1970-01-01T00:00:00Z).
   * @param start start or {@code null} for none
   */
  public AcquisitionTime setStart(com.google.api.client.util.DateTime start) {
    this.start = start;
    return this;
  }

  @Override
  public AcquisitionTime set(String fieldName, Object value) {
    return (AcquisitionTime) super.set(fieldName, value);
  }

  @Override
  public AcquisitionTime clone() {
    return (AcquisitionTime) super.clone();
  }

}
