/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.mapsengine;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.mapsengine.MapsEngineRequest;
import com.google.api.services.mapsengine.MapsEngineRequestInitializer;
import com.google.api.services.mapsengine.model.Asset;
import com.google.api.services.mapsengine.model.AssetsListResponse;
import com.google.api.services.mapsengine.model.Feature;
import com.google.api.services.mapsengine.model.FeaturesBatchDeleteRequest;
import com.google.api.services.mapsengine.model.FeaturesBatchInsertRequest;
import com.google.api.services.mapsengine.model.FeaturesBatchPatchRequest;
import com.google.api.services.mapsengine.model.FeaturesListResponse;
import com.google.api.services.mapsengine.model.Icon;
import com.google.api.services.mapsengine.model.IconsListResponse;
import com.google.api.services.mapsengine.model.Layer;
import com.google.api.services.mapsengine.model.LayersListResponse;
import com.google.api.services.mapsengine.model.Map;
import com.google.api.services.mapsengine.model.MapsListResponse;
import com.google.api.services.mapsengine.model.ParentsListResponse;
import com.google.api.services.mapsengine.model.PermissionsBatchDeleteRequest;
import com.google.api.services.mapsengine.model.PermissionsBatchDeleteResponse;
import com.google.api.services.mapsengine.model.PermissionsBatchUpdateRequest;
import com.google.api.services.mapsengine.model.PermissionsBatchUpdateResponse;
import com.google.api.services.mapsengine.model.PermissionsGetIdForEmailResponse;
import com.google.api.services.mapsengine.model.PermissionsListResponse;
import com.google.api.services.mapsengine.model.ProcessResponse;
import com.google.api.services.mapsengine.model.ProjectsListResponse;
import com.google.api.services.mapsengine.model.PublishResponse;
import com.google.api.services.mapsengine.model.PublishedLayer;
import com.google.api.services.mapsengine.model.PublishedLayersListResponse;
import com.google.api.services.mapsengine.model.PublishedMap;
import com.google.api.services.mapsengine.model.PublishedMapsListResponse;
import com.google.api.services.mapsengine.model.Raster;
import com.google.api.services.mapsengine.model.RasterCollection;
import com.google.api.services.mapsengine.model.RasterCollectionsListResponse;
import com.google.api.services.mapsengine.model.RasterCollectionsRasterBatchDeleteRequest;
import com.google.api.services.mapsengine.model.RasterCollectionsRastersBatchDeleteResponse;
import com.google.api.services.mapsengine.model.RasterCollectionsRastersBatchInsertRequest;
import com.google.api.services.mapsengine.model.RasterCollectionsRastersBatchInsertResponse;
import com.google.api.services.mapsengine.model.RasterCollectionsRastersListResponse;
import com.google.api.services.mapsengine.model.RastersListResponse;
import com.google.api.services.mapsengine.model.Table;
import com.google.api.services.mapsengine.model.TablesListResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapsEngine
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "mapsengine/exp2/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/mapsengine/exp2/";

    public MapsEngine(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    MapsEngine(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Assets assets() {
        return new Assets();
    }

    public Layers layers() {
        return new Layers();
    }

    public Maps maps() {
        return new Maps();
    }

    public PermissionIds permissionIds() {
        return new PermissionIds();
    }

    public Projects projects() {
        return new Projects();
    }

    public RasterCollections rasterCollections() {
        return new RasterCollections();
    }

    public Rasters rasters() {
        return new Rasters();
    }

    public Tables tables() {
        return new Tables();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.15.0-rc of the Google Maps Engine API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, MapsEngine.DEFAULT_ROOT_URL, MapsEngine.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public MapsEngine build() {
            return new MapsEngine(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setMapsEngineRequestInitializer(MapsEngineRequestInitializer mapsEngineRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)mapsEngineRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Tables {
        public Create create(Table table) throws IOException {
            Create create = new Create(table);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, Table table) throws IOException {
            Patch patch = new Patch(string, table);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Process process(String string) throws IOException {
            Process process = new Process(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)process);
            return process;
        }

        public Upload upload(Table table) throws IOException {
            Upload upload = new Upload(table);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)upload);
            return upload;
        }

        public Features features() {
            return new Features();
        }

        public Files files() {
            return new Files();
        }

        public Parents parents() {
            return new Parents();
        }

        public Permissions permissions() {
            return new Permissions();
        }

        public class Permissions {
            public BatchDelete batchDelete(String string, PermissionsBatchDeleteRequest permissionsBatchDeleteRequest) throws IOException {
                BatchDelete batchDelete = new BatchDelete(string, permissionsBatchDeleteRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                return batchDelete;
            }

            public BatchUpdate batchUpdate(String string, PermissionsBatchUpdateRequest permissionsBatchUpdateRequest) throws IOException {
                BatchUpdate batchUpdate = new BatchUpdate(string, permissionsBatchUpdateRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                return batchUpdate;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<PermissionsListResponse> {
                private static final String REST_PATH = "tables/{id}/permissions";
                @Key
                private String id;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, PermissionsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchUpdate
            extends MapsEngineRequest<PermissionsBatchUpdateResponse> {
                private static final String REST_PATH = "tables/{id}/permissions/batchUpdate";
                @Key
                private String id;

                protected BatchUpdate(String string, PermissionsBatchUpdateRequest permissionsBatchUpdateRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)permissionsBatchUpdateRequest, PermissionsBatchUpdateResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchUpdate setAlt(String string) {
                    return (BatchUpdate)super.setAlt(string);
                }

                public BatchUpdate setFields(String string) {
                    return (BatchUpdate)super.setFields(string);
                }

                public BatchUpdate setKey(String string) {
                    return (BatchUpdate)super.setKey(string);
                }

                public BatchUpdate setOauthToken(String string) {
                    return (BatchUpdate)super.setOauthToken(string);
                }

                public BatchUpdate setPrettyPrint(Boolean bl) {
                    return (BatchUpdate)super.setPrettyPrint(bl);
                }

                public BatchUpdate setQuotaUser(String string) {
                    return (BatchUpdate)super.setQuotaUser(string);
                }

                public BatchUpdate setUserIp(String string) {
                    return (BatchUpdate)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchUpdate setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchUpdate set(String string, Object object) {
                    return (BatchUpdate)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchDelete
            extends MapsEngineRequest<PermissionsBatchDeleteResponse> {
                private static final String REST_PATH = "tables/{id}/permissions/batchDelete";
                @Key
                private String id;

                protected BatchDelete(String string, PermissionsBatchDeleteRequest permissionsBatchDeleteRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)permissionsBatchDeleteRequest, PermissionsBatchDeleteResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchDelete setAlt(String string) {
                    return (BatchDelete)super.setAlt(string);
                }

                public BatchDelete setFields(String string) {
                    return (BatchDelete)super.setFields(string);
                }

                public BatchDelete setKey(String string) {
                    return (BatchDelete)super.setKey(string);
                }

                public BatchDelete setOauthToken(String string) {
                    return (BatchDelete)super.setOauthToken(string);
                }

                public BatchDelete setPrettyPrint(Boolean bl) {
                    return (BatchDelete)super.setPrettyPrint(bl);
                }

                public BatchDelete setQuotaUser(String string) {
                    return (BatchDelete)super.setQuotaUser(string);
                }

                public BatchDelete setUserIp(String string) {
                    return (BatchDelete)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchDelete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchDelete set(String string, Object object) {
                    return (BatchDelete)super.set(string, object);
                }
            }
        }

        public class Parents {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<ParentsListResponse> {
                private static final String REST_PATH = "tables/{id}/parents";
                @Key
                private String id;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, ParentsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Files {
            public Insert insert(String string, String string2) throws IOException {
                Insert insert = new Insert(string, string2);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public Insert insert(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Insert insert = new Insert(string, string2, abstractInputStreamContent);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends MapsEngineRequest<Void> {
                private static final String REST_PATH = "tables/{id}/files";
                @Key
                private String id;
                @Key
                private String filename;

                protected Insert(String string, String string2) {
                    super(MapsEngine.this, "POST", REST_PATH, null, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                    this.filename = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filename must be specified.");
                }

                protected Insert(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) {
                    super(MapsEngine.this, "POST", "/upload/" + MapsEngine.this.getServicePath() + REST_PATH, null, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                    this.filename = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filename must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public Insert setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getFilename() {
                    return this.filename;
                }

                public Insert setFilename(String string) {
                    this.filename = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }
        }

        public class Features {
            public BatchDelete batchDelete(String string, FeaturesBatchDeleteRequest featuresBatchDeleteRequest) throws IOException {
                BatchDelete batchDelete = new BatchDelete(string, featuresBatchDeleteRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                return batchDelete;
            }

            public BatchInsert batchInsert(String string, FeaturesBatchInsertRequest featuresBatchInsertRequest) throws IOException {
                BatchInsert batchInsert = new BatchInsert(string, featuresBatchInsertRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchInsert);
                return batchInsert;
            }

            public BatchPatch batchPatch(String string, FeaturesBatchPatchRequest featuresBatchPatchRequest) throws IOException {
                BatchPatch batchPatch = new BatchPatch(string, featuresBatchPatchRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchPatch);
                return batchPatch;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<FeaturesListResponse> {
                private static final String REST_PATH = "tables/{id}/features";
                @Key
                private String id;
                @Key
                private String orderBy;
                @Key
                private String intersects;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String version;
                @Key
                private Long limit;
                @Key
                private String include;
                @Key
                private String where;
                @Key
                private String select;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, FeaturesListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String string) {
                    this.orderBy = string;
                    return this;
                }

                public String getIntersects() {
                    return this.intersects;
                }

                public List setIntersects(String string) {
                    this.intersects = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getVersion() {
                    return this.version;
                }

                public List setVersion(String string) {
                    this.version = string;
                    return this;
                }

                public Long getLimit() {
                    return this.limit;
                }

                public List setLimit(Long l) {
                    this.limit = l;
                    return this;
                }

                public String getInclude() {
                    return this.include;
                }

                public List setInclude(String string) {
                    this.include = string;
                    return this;
                }

                public String getWhere() {
                    return this.where;
                }

                public List setWhere(String string) {
                    this.where = string;
                    return this;
                }

                public String getSelect() {
                    return this.select;
                }

                public List setSelect(String string) {
                    this.select = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends MapsEngineRequest<Feature> {
                private static final String REST_PATH = "tables/{tableId}/features/{id}";
                @Key
                private String tableId;
                @Key
                private String id;
                @Key
                private String version;
                @Key
                private String select;

                protected Get(String string, String string2) {
                    super(MapsEngine.this, "GET", REST_PATH, null, Feature.class);
                    this.tableId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tableId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getTableId() {
                    return this.tableId;
                }

                public Get setTableId(String string) {
                    this.tableId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getVersion() {
                    return this.version;
                }

                public Get setVersion(String string) {
                    this.version = string;
                    return this;
                }

                public String getSelect() {
                    return this.select;
                }

                public Get setSelect(String string) {
                    this.select = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchPatch
            extends MapsEngineRequest<Void> {
                private static final String REST_PATH = "tables/{id}/features/batchPatch";
                @Key
                private String id;

                protected BatchPatch(String string, FeaturesBatchPatchRequest featuresBatchPatchRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)featuresBatchPatchRequest, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchPatch setAlt(String string) {
                    return (BatchPatch)super.setAlt(string);
                }

                public BatchPatch setFields(String string) {
                    return (BatchPatch)super.setFields(string);
                }

                public BatchPatch setKey(String string) {
                    return (BatchPatch)super.setKey(string);
                }

                public BatchPatch setOauthToken(String string) {
                    return (BatchPatch)super.setOauthToken(string);
                }

                public BatchPatch setPrettyPrint(Boolean bl) {
                    return (BatchPatch)super.setPrettyPrint(bl);
                }

                public BatchPatch setQuotaUser(String string) {
                    return (BatchPatch)super.setQuotaUser(string);
                }

                public BatchPatch setUserIp(String string) {
                    return (BatchPatch)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchPatch setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchPatch set(String string, Object object) {
                    return (BatchPatch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchInsert
            extends MapsEngineRequest<Void> {
                private static final String REST_PATH = "tables/{id}/features/batchInsert";
                @Key
                private String id;

                protected BatchInsert(String string, FeaturesBatchInsertRequest featuresBatchInsertRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)featuresBatchInsertRequest, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchInsert setAlt(String string) {
                    return (BatchInsert)super.setAlt(string);
                }

                public BatchInsert setFields(String string) {
                    return (BatchInsert)super.setFields(string);
                }

                public BatchInsert setKey(String string) {
                    return (BatchInsert)super.setKey(string);
                }

                public BatchInsert setOauthToken(String string) {
                    return (BatchInsert)super.setOauthToken(string);
                }

                public BatchInsert setPrettyPrint(Boolean bl) {
                    return (BatchInsert)super.setPrettyPrint(bl);
                }

                public BatchInsert setQuotaUser(String string) {
                    return (BatchInsert)super.setQuotaUser(string);
                }

                public BatchInsert setUserIp(String string) {
                    return (BatchInsert)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchInsert setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchInsert set(String string, Object object) {
                    return (BatchInsert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchDelete
            extends MapsEngineRequest<Void> {
                private static final String REST_PATH = "tables/{id}/features/batchDelete";
                @Key
                private String id;

                protected BatchDelete(String string, FeaturesBatchDeleteRequest featuresBatchDeleteRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)featuresBatchDeleteRequest, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchDelete setAlt(String string) {
                    return (BatchDelete)super.setAlt(string);
                }

                public BatchDelete setFields(String string) {
                    return (BatchDelete)super.setFields(string);
                }

                public BatchDelete setKey(String string) {
                    return (BatchDelete)super.setKey(string);
                }

                public BatchDelete setOauthToken(String string) {
                    return (BatchDelete)super.setOauthToken(string);
                }

                public BatchDelete setPrettyPrint(Boolean bl) {
                    return (BatchDelete)super.setPrettyPrint(bl);
                }

                public BatchDelete setQuotaUser(String string) {
                    return (BatchDelete)super.setQuotaUser(string);
                }

                public BatchDelete setUserIp(String string) {
                    return (BatchDelete)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchDelete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchDelete set(String string, Object object) {
                    return (BatchDelete)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Upload
        extends MapsEngineRequest<Table> {
            private static final String REST_PATH = "tables/upload";

            protected Upload(Table table) {
                super(MapsEngine.this, "POST", REST_PATH, (Object)table, Table.class);
                this.checkRequiredParameter((Object)table, "content");
                this.checkRequiredParameter(table.getName(), "Table.getName()");
                this.checkRequiredParameter((Object)table, "content");
                this.checkRequiredParameter(table.getProjectId(), "Table.getProjectId()");
            }

            public Upload setAlt(String string) {
                return (Upload)super.setAlt(string);
            }

            public Upload setFields(String string) {
                return (Upload)super.setFields(string);
            }

            public Upload setKey(String string) {
                return (Upload)super.setKey(string);
            }

            public Upload setOauthToken(String string) {
                return (Upload)super.setOauthToken(string);
            }

            public Upload setPrettyPrint(Boolean bl) {
                return (Upload)super.setPrettyPrint(bl);
            }

            public Upload setQuotaUser(String string) {
                return (Upload)super.setQuotaUser(string);
            }

            public Upload setUserIp(String string) {
                return (Upload)super.setUserIp(string);
            }

            @Override
            public Upload set(String string, Object object) {
                return (Upload)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Process
        extends MapsEngineRequest<ProcessResponse> {
            private static final String REST_PATH = "tables/{id}/process";
            @Key
            private String id;

            protected Process(String string) {
                super(MapsEngine.this, "POST", REST_PATH, null, ProcessResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Process setAlt(String string) {
                return (Process)super.setAlt(string);
            }

            public Process setFields(String string) {
                return (Process)super.setFields(string);
            }

            public Process setKey(String string) {
                return (Process)super.setKey(string);
            }

            public Process setOauthToken(String string) {
                return (Process)super.setOauthToken(string);
            }

            public Process setPrettyPrint(Boolean bl) {
                return (Process)super.setPrettyPrint(bl);
            }

            public Process setQuotaUser(String string) {
                return (Process)super.setQuotaUser(string);
            }

            public Process setUserIp(String string) {
                return (Process)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Process setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Process set(String string, Object object) {
                return (Process)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends MapsEngineRequest<Void> {
            private static final String REST_PATH = "tables/{id}";
            @Key
            private String id;

            protected Patch(String string, Table table) {
                super(MapsEngine.this, "PATCH", REST_PATH, (Object)table, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<TablesListResponse> {
            private static final String REST_PATH = "tables";
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String processingStatus;
            @Key
            private String projectId;
            @Key
            private String tags;
            @Key
            private String search;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;
            @Key
            private String role;

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, TablesListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getProcessingStatus() {
                return this.processingStatus;
            }

            public List setProcessingStatus(String string) {
                this.processingStatus = string;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getTags() {
                return this.tags;
            }

            public List setTags(String string) {
                this.tags = string;
                return this;
            }

            public String getSearch() {
                return this.search;
            }

            public List setSearch(String string) {
                this.search = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            public String getRole() {
                return this.role;
            }

            public List setRole(String string) {
                this.role = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<Table> {
            private static final String REST_PATH = "tables/{id}";
            @Key
            private String id;
            @Key
            private String version;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, Table.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public Get setVersion(String string) {
                this.version = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends MapsEngineRequest<Void> {
            private static final String REST_PATH = "tables/{id}";
            @Key
            private String id;

            protected Delete(String string) {
                super(MapsEngine.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends MapsEngineRequest<Table> {
            private static final String REST_PATH = "tables";

            protected Create(Table table) {
                super(MapsEngine.this, "POST", REST_PATH, (Object)table, Table.class);
                this.checkRequiredParameter((Object)table, "content");
                this.checkRequiredParameter(table.getName(), "Table.getName()");
                this.checkRequiredParameter((Object)table, "content");
                this.checkRequiredParameter(table.getProjectId(), "Table.getProjectId()");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Rasters {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, Raster raster) throws IOException {
            Patch patch = new Patch(string, raster);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Process process(String string) throws IOException {
            Process process = new Process(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)process);
            return process;
        }

        public Upload upload(Raster raster) throws IOException {
            Upload upload = new Upload(raster);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)upload);
            return upload;
        }

        public Files files() {
            return new Files();
        }

        public Parents parents() {
            return new Parents();
        }

        public Permissions permissions() {
            return new Permissions();
        }

        public class Permissions {
            public BatchDelete batchDelete(String string, PermissionsBatchDeleteRequest permissionsBatchDeleteRequest) throws IOException {
                BatchDelete batchDelete = new BatchDelete(string, permissionsBatchDeleteRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                return batchDelete;
            }

            public BatchUpdate batchUpdate(String string, PermissionsBatchUpdateRequest permissionsBatchUpdateRequest) throws IOException {
                BatchUpdate batchUpdate = new BatchUpdate(string, permissionsBatchUpdateRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                return batchUpdate;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<PermissionsListResponse> {
                private static final String REST_PATH = "rasters/{id}/permissions";
                @Key
                private String id;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, PermissionsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchUpdate
            extends MapsEngineRequest<PermissionsBatchUpdateResponse> {
                private static final String REST_PATH = "rasters/{id}/permissions/batchUpdate";
                @Key
                private String id;

                protected BatchUpdate(String string, PermissionsBatchUpdateRequest permissionsBatchUpdateRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)permissionsBatchUpdateRequest, PermissionsBatchUpdateResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchUpdate setAlt(String string) {
                    return (BatchUpdate)super.setAlt(string);
                }

                public BatchUpdate setFields(String string) {
                    return (BatchUpdate)super.setFields(string);
                }

                public BatchUpdate setKey(String string) {
                    return (BatchUpdate)super.setKey(string);
                }

                public BatchUpdate setOauthToken(String string) {
                    return (BatchUpdate)super.setOauthToken(string);
                }

                public BatchUpdate setPrettyPrint(Boolean bl) {
                    return (BatchUpdate)super.setPrettyPrint(bl);
                }

                public BatchUpdate setQuotaUser(String string) {
                    return (BatchUpdate)super.setQuotaUser(string);
                }

                public BatchUpdate setUserIp(String string) {
                    return (BatchUpdate)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchUpdate setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchUpdate set(String string, Object object) {
                    return (BatchUpdate)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchDelete
            extends MapsEngineRequest<PermissionsBatchDeleteResponse> {
                private static final String REST_PATH = "rasters/{id}/permissions/batchDelete";
                @Key
                private String id;

                protected BatchDelete(String string, PermissionsBatchDeleteRequest permissionsBatchDeleteRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)permissionsBatchDeleteRequest, PermissionsBatchDeleteResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchDelete setAlt(String string) {
                    return (BatchDelete)super.setAlt(string);
                }

                public BatchDelete setFields(String string) {
                    return (BatchDelete)super.setFields(string);
                }

                public BatchDelete setKey(String string) {
                    return (BatchDelete)super.setKey(string);
                }

                public BatchDelete setOauthToken(String string) {
                    return (BatchDelete)super.setOauthToken(string);
                }

                public BatchDelete setPrettyPrint(Boolean bl) {
                    return (BatchDelete)super.setPrettyPrint(bl);
                }

                public BatchDelete setQuotaUser(String string) {
                    return (BatchDelete)super.setQuotaUser(string);
                }

                public BatchDelete setUserIp(String string) {
                    return (BatchDelete)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchDelete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchDelete set(String string, Object object) {
                    return (BatchDelete)super.set(string, object);
                }
            }
        }

        public class Parents {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<ParentsListResponse> {
                private static final String REST_PATH = "rasters/{id}/parents";
                @Key
                private String id;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, ParentsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Files {
            public Insert insert(String string, String string2) throws IOException {
                Insert insert = new Insert(string, string2);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public Insert insert(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Insert insert = new Insert(string, string2, abstractInputStreamContent);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends MapsEngineRequest<Void> {
                private static final String REST_PATH = "rasters/{id}/files";
                @Key
                private String id;
                @Key
                private String filename;

                protected Insert(String string, String string2) {
                    super(MapsEngine.this, "POST", REST_PATH, null, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                    this.filename = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filename must be specified.");
                }

                protected Insert(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) {
                    super(MapsEngine.this, "POST", "/upload/" + MapsEngine.this.getServicePath() + REST_PATH, null, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                    this.filename = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filename must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public Insert setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getFilename() {
                    return this.filename;
                }

                public Insert setFilename(String string) {
                    this.filename = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Upload
        extends MapsEngineRequest<Raster> {
            private static final String REST_PATH = "rasters/upload";

            protected Upload(Raster raster) {
                super(MapsEngine.this, "POST", REST_PATH, (Object)raster, Raster.class);
                this.checkRequiredParameter((Object)raster, "content");
                this.checkRequiredParameter(raster.getName(), "Raster.getName()");
                this.checkRequiredParameter((Object)raster, "content");
                this.checkRequiredParameter(raster.getProjectId(), "Raster.getProjectId()");
                this.checkRequiredParameter((Object)raster, "content");
                this.checkRequiredParameter(raster.getRasterType(), "Raster.getRasterType()");
            }

            public Upload setAlt(String string) {
                return (Upload)super.setAlt(string);
            }

            public Upload setFields(String string) {
                return (Upload)super.setFields(string);
            }

            public Upload setKey(String string) {
                return (Upload)super.setKey(string);
            }

            public Upload setOauthToken(String string) {
                return (Upload)super.setOauthToken(string);
            }

            public Upload setPrettyPrint(Boolean bl) {
                return (Upload)super.setPrettyPrint(bl);
            }

            public Upload setQuotaUser(String string) {
                return (Upload)super.setQuotaUser(string);
            }

            public Upload setUserIp(String string) {
                return (Upload)super.setUserIp(string);
            }

            @Override
            public Upload set(String string, Object object) {
                return (Upload)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Process
        extends MapsEngineRequest<ProcessResponse> {
            private static final String REST_PATH = "rasters/{id}/process";
            @Key
            private String id;

            protected Process(String string) {
                super(MapsEngine.this, "POST", REST_PATH, null, ProcessResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Process setAlt(String string) {
                return (Process)super.setAlt(string);
            }

            public Process setFields(String string) {
                return (Process)super.setFields(string);
            }

            public Process setKey(String string) {
                return (Process)super.setKey(string);
            }

            public Process setOauthToken(String string) {
                return (Process)super.setOauthToken(string);
            }

            public Process setPrettyPrint(Boolean bl) {
                return (Process)super.setPrettyPrint(bl);
            }

            public Process setQuotaUser(String string) {
                return (Process)super.setQuotaUser(string);
            }

            public Process setUserIp(String string) {
                return (Process)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Process setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Process set(String string, Object object) {
                return (Process)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends MapsEngineRequest<Void> {
            private static final String REST_PATH = "rasters/{id}";
            @Key
            private String id;

            protected Patch(String string, Raster raster) {
                super(MapsEngine.this, "PATCH", REST_PATH, (Object)raster, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<RastersListResponse> {
            private static final String REST_PATH = "rasters";
            @Key
            private String projectId;
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String processingStatus;
            @Key
            private String tags;
            @Key
            private String search;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;
            @Key
            private String role;

            protected List(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, RastersListResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getProcessingStatus() {
                return this.processingStatus;
            }

            public List setProcessingStatus(String string) {
                this.processingStatus = string;
                return this;
            }

            public String getTags() {
                return this.tags;
            }

            public List setTags(String string) {
                this.tags = string;
                return this;
            }

            public String getSearch() {
                return this.search;
            }

            public List setSearch(String string) {
                this.search = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            public String getRole() {
                return this.role;
            }

            public List setRole(String string) {
                this.role = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<Raster> {
            private static final String REST_PATH = "rasters/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, Raster.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends MapsEngineRequest<Void> {
            private static final String REST_PATH = "rasters/{id}";
            @Key
            private String id;

            protected Delete(String string) {
                super(MapsEngine.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class RasterCollections {
        public CancelProcessing cancelProcessing(String string) throws IOException {
            CancelProcessing cancelProcessing = new CancelProcessing(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)cancelProcessing);
            return cancelProcessing;
        }

        public Create create(RasterCollection rasterCollection) throws IOException {
            Create create = new Create(rasterCollection);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, RasterCollection rasterCollection) throws IOException {
            Patch patch = new Patch(string, rasterCollection);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Process process(String string) throws IOException {
            Process process = new Process(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)process);
            return process;
        }

        public Parents parents() {
            return new Parents();
        }

        public Permissions permissions() {
            return new Permissions();
        }

        public Rasters rasters() {
            return new Rasters();
        }

        public class Rasters {
            public BatchDelete batchDelete(String string, RasterCollectionsRasterBatchDeleteRequest rasterCollectionsRasterBatchDeleteRequest) throws IOException {
                BatchDelete batchDelete = new BatchDelete(string, rasterCollectionsRasterBatchDeleteRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                return batchDelete;
            }

            public BatchInsert batchInsert(String string, RasterCollectionsRastersBatchInsertRequest rasterCollectionsRastersBatchInsertRequest) throws IOException {
                BatchInsert batchInsert = new BatchInsert(string, rasterCollectionsRastersBatchInsertRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchInsert);
                return batchInsert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<RasterCollectionsRastersListResponse> {
                private static final String REST_PATH = "rasterCollections/{id}/rasters";
                @Key
                private String id;
                @Key
                private DateTime modifiedAfter;
                @Key
                private DateTime createdAfter;
                @Key
                private String tags;
                @Key
                private String search;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String creatorEmail;
                @Key
                private String bbox;
                @Key
                private DateTime modifiedBefore;
                @Key
                private DateTime createdBefore;
                @Key
                private String role;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, RasterCollectionsRastersListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public DateTime getModifiedAfter() {
                    return this.modifiedAfter;
                }

                public List setModifiedAfter(DateTime dateTime) {
                    this.modifiedAfter = dateTime;
                    return this;
                }

                public DateTime getCreatedAfter() {
                    return this.createdAfter;
                }

                public List setCreatedAfter(DateTime dateTime) {
                    this.createdAfter = dateTime;
                    return this;
                }

                public String getTags() {
                    return this.tags;
                }

                public List setTags(String string) {
                    this.tags = string;
                    return this;
                }

                public String getSearch() {
                    return this.search;
                }

                public List setSearch(String string) {
                    this.search = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getCreatorEmail() {
                    return this.creatorEmail;
                }

                public List setCreatorEmail(String string) {
                    this.creatorEmail = string;
                    return this;
                }

                public String getBbox() {
                    return this.bbox;
                }

                public List setBbox(String string) {
                    this.bbox = string;
                    return this;
                }

                public DateTime getModifiedBefore() {
                    return this.modifiedBefore;
                }

                public List setModifiedBefore(DateTime dateTime) {
                    this.modifiedBefore = dateTime;
                    return this;
                }

                public DateTime getCreatedBefore() {
                    return this.createdBefore;
                }

                public List setCreatedBefore(DateTime dateTime) {
                    this.createdBefore = dateTime;
                    return this;
                }

                public String getRole() {
                    return this.role;
                }

                public List setRole(String string) {
                    this.role = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchInsert
            extends MapsEngineRequest<RasterCollectionsRastersBatchInsertResponse> {
                private static final String REST_PATH = "rasterCollections/{id}/rasters/batchInsert";
                @Key
                private String id;

                protected BatchInsert(String string, RasterCollectionsRastersBatchInsertRequest rasterCollectionsRastersBatchInsertRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)rasterCollectionsRastersBatchInsertRequest, RasterCollectionsRastersBatchInsertResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchInsert setAlt(String string) {
                    return (BatchInsert)super.setAlt(string);
                }

                public BatchInsert setFields(String string) {
                    return (BatchInsert)super.setFields(string);
                }

                public BatchInsert setKey(String string) {
                    return (BatchInsert)super.setKey(string);
                }

                public BatchInsert setOauthToken(String string) {
                    return (BatchInsert)super.setOauthToken(string);
                }

                public BatchInsert setPrettyPrint(Boolean bl) {
                    return (BatchInsert)super.setPrettyPrint(bl);
                }

                public BatchInsert setQuotaUser(String string) {
                    return (BatchInsert)super.setQuotaUser(string);
                }

                public BatchInsert setUserIp(String string) {
                    return (BatchInsert)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchInsert setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchInsert set(String string, Object object) {
                    return (BatchInsert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchDelete
            extends MapsEngineRequest<RasterCollectionsRastersBatchDeleteResponse> {
                private static final String REST_PATH = "rasterCollections/{id}/rasters/batchDelete";
                @Key
                private String id;

                protected BatchDelete(String string, RasterCollectionsRasterBatchDeleteRequest rasterCollectionsRasterBatchDeleteRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)rasterCollectionsRasterBatchDeleteRequest, RasterCollectionsRastersBatchDeleteResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchDelete setAlt(String string) {
                    return (BatchDelete)super.setAlt(string);
                }

                public BatchDelete setFields(String string) {
                    return (BatchDelete)super.setFields(string);
                }

                public BatchDelete setKey(String string) {
                    return (BatchDelete)super.setKey(string);
                }

                public BatchDelete setOauthToken(String string) {
                    return (BatchDelete)super.setOauthToken(string);
                }

                public BatchDelete setPrettyPrint(Boolean bl) {
                    return (BatchDelete)super.setPrettyPrint(bl);
                }

                public BatchDelete setQuotaUser(String string) {
                    return (BatchDelete)super.setQuotaUser(string);
                }

                public BatchDelete setUserIp(String string) {
                    return (BatchDelete)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchDelete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchDelete set(String string, Object object) {
                    return (BatchDelete)super.set(string, object);
                }
            }
        }

        public class Permissions {
            public BatchDelete batchDelete(String string, PermissionsBatchDeleteRequest permissionsBatchDeleteRequest) throws IOException {
                BatchDelete batchDelete = new BatchDelete(string, permissionsBatchDeleteRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                return batchDelete;
            }

            public BatchUpdate batchUpdate(String string, PermissionsBatchUpdateRequest permissionsBatchUpdateRequest) throws IOException {
                BatchUpdate batchUpdate = new BatchUpdate(string, permissionsBatchUpdateRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                return batchUpdate;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<PermissionsListResponse> {
                private static final String REST_PATH = "rasterCollections/{id}/permissions";
                @Key
                private String id;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, PermissionsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchUpdate
            extends MapsEngineRequest<PermissionsBatchUpdateResponse> {
                private static final String REST_PATH = "rasterCollections/{id}/permissions/batchUpdate";
                @Key
                private String id;

                protected BatchUpdate(String string, PermissionsBatchUpdateRequest permissionsBatchUpdateRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)permissionsBatchUpdateRequest, PermissionsBatchUpdateResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchUpdate setAlt(String string) {
                    return (BatchUpdate)super.setAlt(string);
                }

                public BatchUpdate setFields(String string) {
                    return (BatchUpdate)super.setFields(string);
                }

                public BatchUpdate setKey(String string) {
                    return (BatchUpdate)super.setKey(string);
                }

                public BatchUpdate setOauthToken(String string) {
                    return (BatchUpdate)super.setOauthToken(string);
                }

                public BatchUpdate setPrettyPrint(Boolean bl) {
                    return (BatchUpdate)super.setPrettyPrint(bl);
                }

                public BatchUpdate setQuotaUser(String string) {
                    return (BatchUpdate)super.setQuotaUser(string);
                }

                public BatchUpdate setUserIp(String string) {
                    return (BatchUpdate)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchUpdate setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchUpdate set(String string, Object object) {
                    return (BatchUpdate)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchDelete
            extends MapsEngineRequest<PermissionsBatchDeleteResponse> {
                private static final String REST_PATH = "rasterCollections/{id}/permissions/batchDelete";
                @Key
                private String id;

                protected BatchDelete(String string, PermissionsBatchDeleteRequest permissionsBatchDeleteRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)permissionsBatchDeleteRequest, PermissionsBatchDeleteResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchDelete setAlt(String string) {
                    return (BatchDelete)super.setAlt(string);
                }

                public BatchDelete setFields(String string) {
                    return (BatchDelete)super.setFields(string);
                }

                public BatchDelete setKey(String string) {
                    return (BatchDelete)super.setKey(string);
                }

                public BatchDelete setOauthToken(String string) {
                    return (BatchDelete)super.setOauthToken(string);
                }

                public BatchDelete setPrettyPrint(Boolean bl) {
                    return (BatchDelete)super.setPrettyPrint(bl);
                }

                public BatchDelete setQuotaUser(String string) {
                    return (BatchDelete)super.setQuotaUser(string);
                }

                public BatchDelete setUserIp(String string) {
                    return (BatchDelete)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchDelete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchDelete set(String string, Object object) {
                    return (BatchDelete)super.set(string, object);
                }
            }
        }

        public class Parents {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<ParentsListResponse> {
                private static final String REST_PATH = "rasterCollections/{id}/parents";
                @Key
                private String id;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, ParentsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Process
        extends MapsEngineRequest<ProcessResponse> {
            private static final String REST_PATH = "rasterCollections/{id}/process";
            @Key
            private String id;

            protected Process(String string) {
                super(MapsEngine.this, "POST", REST_PATH, null, ProcessResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Process setAlt(String string) {
                return (Process)super.setAlt(string);
            }

            public Process setFields(String string) {
                return (Process)super.setFields(string);
            }

            public Process setKey(String string) {
                return (Process)super.setKey(string);
            }

            public Process setOauthToken(String string) {
                return (Process)super.setOauthToken(string);
            }

            public Process setPrettyPrint(Boolean bl) {
                return (Process)super.setPrettyPrint(bl);
            }

            public Process setQuotaUser(String string) {
                return (Process)super.setQuotaUser(string);
            }

            public Process setUserIp(String string) {
                return (Process)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Process setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Process set(String string, Object object) {
                return (Process)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends MapsEngineRequest<Void> {
            private static final String REST_PATH = "rasterCollections/{id}";
            @Key
            private String id;

            protected Patch(String string, RasterCollection rasterCollection) {
                super(MapsEngine.this, "PATCH", REST_PATH, (Object)rasterCollection, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<RasterCollectionsListResponse> {
            private static final String REST_PATH = "rasterCollections";
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String processingStatus;
            @Key
            private String projectId;
            @Key
            private String tags;
            @Key
            private String search;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;
            @Key
            private String role;

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, RasterCollectionsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getProcessingStatus() {
                return this.processingStatus;
            }

            public List setProcessingStatus(String string) {
                this.processingStatus = string;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getTags() {
                return this.tags;
            }

            public List setTags(String string) {
                this.tags = string;
                return this;
            }

            public String getSearch() {
                return this.search;
            }

            public List setSearch(String string) {
                this.search = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            public String getRole() {
                return this.role;
            }

            public List setRole(String string) {
                this.role = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<RasterCollection> {
            private static final String REST_PATH = "rasterCollections/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, RasterCollection.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends MapsEngineRequest<Void> {
            private static final String REST_PATH = "rasterCollections/{id}";
            @Key
            private String id;

            protected Delete(String string) {
                super(MapsEngine.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends MapsEngineRequest<RasterCollection> {
            private static final String REST_PATH = "rasterCollections";

            protected Create(RasterCollection rasterCollection) {
                super(MapsEngine.this, "POST", REST_PATH, (Object)rasterCollection, RasterCollection.class);
                this.checkRequiredParameter((Object)rasterCollection, "content");
                this.checkRequiredParameter(rasterCollection.getMosaic(), "RasterCollection.getMosaic()");
                this.checkRequiredParameter((Object)rasterCollection, "content");
                this.checkRequiredParameter(rasterCollection.getName(), "RasterCollection.getName()");
                this.checkRequiredParameter((Object)rasterCollection, "content");
                this.checkRequiredParameter(rasterCollection.getProjectId(), "RasterCollection.getProjectId()");
                this.checkRequiredParameter((Object)rasterCollection, "content");
                this.checkRequiredParameter(rasterCollection.getRasterType(), "RasterCollection.getRasterType()");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CancelProcessing
        extends MapsEngineRequest<ProcessResponse> {
            private static final String REST_PATH = "rasterCollections/{id}/cancelProcessing";
            @Key
            private String id;

            protected CancelProcessing(String string) {
                super(MapsEngine.this, "POST", REST_PATH, null, ProcessResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public CancelProcessing setAlt(String string) {
                return (CancelProcessing)super.setAlt(string);
            }

            public CancelProcessing setFields(String string) {
                return (CancelProcessing)super.setFields(string);
            }

            public CancelProcessing setKey(String string) {
                return (CancelProcessing)super.setKey(string);
            }

            public CancelProcessing setOauthToken(String string) {
                return (CancelProcessing)super.setOauthToken(string);
            }

            public CancelProcessing setPrettyPrint(Boolean bl) {
                return (CancelProcessing)super.setPrettyPrint(bl);
            }

            public CancelProcessing setQuotaUser(String string) {
                return (CancelProcessing)super.setQuotaUser(string);
            }

            public CancelProcessing setUserIp(String string) {
                return (CancelProcessing)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public CancelProcessing setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public CancelProcessing set(String string, Object object) {
                return (CancelProcessing)super.set(string, object);
            }
        }
    }

    public class Projects {
        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Icons icons() {
            return new Icons();
        }

        public class Icons {
            public Create create(String string, Icon icon) throws IOException {
                Create create = new Create(string, icon);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Create create(String string, Icon icon, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Create create = new Create(string, icon, abstractInputStreamContent);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<IconsListResponse> {
                private static final String REST_PATH = "projects/{projectId}/icons";
                @Key
                private String projectId;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, IconsListResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends MapsEngineRequest<Icon> {
                private static final String REST_PATH = "projects/{projectId}/icons/{id}";
                @Key
                private String projectId;
                @Key
                private String id;

                protected Get(String string, String string2) {
                    super(MapsEngine.this, "GET", REST_PATH, null, Icon.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                    this.initializeMediaDownload();
                }

                public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                    super.executeMediaAndDownloadTo(outputStream);
                }

                public InputStream executeMediaAsInputStream() throws IOException {
                    return super.executeMediaAsInputStream();
                }

                public HttpResponse executeMedia() throws IOException {
                    return super.executeMedia();
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends MapsEngineRequest<Icon> {
                private static final String REST_PATH = "projects/{projectId}/icons";
                @Key
                private String projectId;

                protected Create(String string, Icon icon) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)icon, Icon.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.checkRequiredParameter((Object)icon, "content");
                    this.checkRequiredParameter(icon.getName(), "Icon.getName()");
                }

                protected Create(String string, Icon icon, AbstractInputStreamContent abstractInputStreamContent) {
                    super(MapsEngine.this, "POST", "/upload/" + MapsEngine.this.getServicePath() + REST_PATH, (Object)icon, Icon.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUserIp(String string) {
                    return (Create)super.setUserIp(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<ProjectsListResponse> {
            private static final String REST_PATH = "projects";

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, ProjectsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class PermissionIds {
        public GetIdForEmail getIdForEmail(String string) throws IOException {
            GetIdForEmail getIdForEmail = new GetIdForEmail(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)getIdForEmail);
            return getIdForEmail;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIdForEmail
        extends MapsEngineRequest<PermissionsGetIdForEmailResponse> {
            private static final String REST_PATH = "permissionIds/{email}";
            @Key
            private String email;

            protected GetIdForEmail(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, PermissionsGetIdForEmailResponse.class);
                this.email = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter email must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIdForEmail setAlt(String string) {
                return (GetIdForEmail)super.setAlt(string);
            }

            public GetIdForEmail setFields(String string) {
                return (GetIdForEmail)super.setFields(string);
            }

            public GetIdForEmail setKey(String string) {
                return (GetIdForEmail)super.setKey(string);
            }

            public GetIdForEmail setOauthToken(String string) {
                return (GetIdForEmail)super.setOauthToken(string);
            }

            public GetIdForEmail setPrettyPrint(Boolean bl) {
                return (GetIdForEmail)super.setPrettyPrint(bl);
            }

            public GetIdForEmail setQuotaUser(String string) {
                return (GetIdForEmail)super.setQuotaUser(string);
            }

            public GetIdForEmail setUserIp(String string) {
                return (GetIdForEmail)super.setUserIp(string);
            }

            public String getEmail() {
                return this.email;
            }

            public GetIdForEmail setEmail(String string) {
                this.email = string;
                return this;
            }

            @Override
            public GetIdForEmail set(String string, Object object) {
                return (GetIdForEmail)super.set(string, object);
            }
        }
    }

    public class Maps {
        public Create create(Map map) throws IOException {
            Create create = new Create(map);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetPublished getPublished(String string) throws IOException {
            GetPublished getPublished = new GetPublished(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)getPublished);
            return getPublished;
        }

        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ListPublished listPublished() throws IOException {
            ListPublished listPublished = new ListPublished();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)listPublished);
            return listPublished;
        }

        public Patch patch(String string, Map map) throws IOException {
            Patch patch = new Patch(string, map);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Publish publish(String string) throws IOException {
            Publish publish = new Publish(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)publish);
            return publish;
        }

        public Unpublish unpublish(String string) throws IOException {
            Unpublish unpublish = new Unpublish(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)unpublish);
            return unpublish;
        }

        public Permissions permissions() {
            return new Permissions();
        }

        public class Permissions {
            public BatchDelete batchDelete(String string, PermissionsBatchDeleteRequest permissionsBatchDeleteRequest) throws IOException {
                BatchDelete batchDelete = new BatchDelete(string, permissionsBatchDeleteRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                return batchDelete;
            }

            public BatchUpdate batchUpdate(String string, PermissionsBatchUpdateRequest permissionsBatchUpdateRequest) throws IOException {
                BatchUpdate batchUpdate = new BatchUpdate(string, permissionsBatchUpdateRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                return batchUpdate;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<PermissionsListResponse> {
                private static final String REST_PATH = "maps/{id}/permissions";
                @Key
                private String id;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, PermissionsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchUpdate
            extends MapsEngineRequest<PermissionsBatchUpdateResponse> {
                private static final String REST_PATH = "maps/{id}/permissions/batchUpdate";
                @Key
                private String id;

                protected BatchUpdate(String string, PermissionsBatchUpdateRequest permissionsBatchUpdateRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)permissionsBatchUpdateRequest, PermissionsBatchUpdateResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchUpdate setAlt(String string) {
                    return (BatchUpdate)super.setAlt(string);
                }

                public BatchUpdate setFields(String string) {
                    return (BatchUpdate)super.setFields(string);
                }

                public BatchUpdate setKey(String string) {
                    return (BatchUpdate)super.setKey(string);
                }

                public BatchUpdate setOauthToken(String string) {
                    return (BatchUpdate)super.setOauthToken(string);
                }

                public BatchUpdate setPrettyPrint(Boolean bl) {
                    return (BatchUpdate)super.setPrettyPrint(bl);
                }

                public BatchUpdate setQuotaUser(String string) {
                    return (BatchUpdate)super.setQuotaUser(string);
                }

                public BatchUpdate setUserIp(String string) {
                    return (BatchUpdate)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchUpdate setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchUpdate set(String string, Object object) {
                    return (BatchUpdate)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchDelete
            extends MapsEngineRequest<PermissionsBatchDeleteResponse> {
                private static final String REST_PATH = "maps/{id}/permissions/batchDelete";
                @Key
                private String id;

                protected BatchDelete(String string, PermissionsBatchDeleteRequest permissionsBatchDeleteRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)permissionsBatchDeleteRequest, PermissionsBatchDeleteResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchDelete setAlt(String string) {
                    return (BatchDelete)super.setAlt(string);
                }

                public BatchDelete setFields(String string) {
                    return (BatchDelete)super.setFields(string);
                }

                public BatchDelete setKey(String string) {
                    return (BatchDelete)super.setKey(string);
                }

                public BatchDelete setOauthToken(String string) {
                    return (BatchDelete)super.setOauthToken(string);
                }

                public BatchDelete setPrettyPrint(Boolean bl) {
                    return (BatchDelete)super.setPrettyPrint(bl);
                }

                public BatchDelete setQuotaUser(String string) {
                    return (BatchDelete)super.setQuotaUser(string);
                }

                public BatchDelete setUserIp(String string) {
                    return (BatchDelete)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchDelete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchDelete set(String string, Object object) {
                    return (BatchDelete)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Unpublish
        extends MapsEngineRequest<PublishResponse> {
            private static final String REST_PATH = "maps/{id}/unpublish";
            @Key
            private String id;

            protected Unpublish(String string) {
                super(MapsEngine.this, "POST", REST_PATH, null, PublishResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Unpublish setAlt(String string) {
                return (Unpublish)super.setAlt(string);
            }

            public Unpublish setFields(String string) {
                return (Unpublish)super.setFields(string);
            }

            public Unpublish setKey(String string) {
                return (Unpublish)super.setKey(string);
            }

            public Unpublish setOauthToken(String string) {
                return (Unpublish)super.setOauthToken(string);
            }

            public Unpublish setPrettyPrint(Boolean bl) {
                return (Unpublish)super.setPrettyPrint(bl);
            }

            public Unpublish setQuotaUser(String string) {
                return (Unpublish)super.setQuotaUser(string);
            }

            public Unpublish setUserIp(String string) {
                return (Unpublish)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Unpublish setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Unpublish set(String string, Object object) {
                return (Unpublish)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Publish
        extends MapsEngineRequest<PublishResponse> {
            private static final String REST_PATH = "maps/{id}/publish";
            @Key
            private String id;
            @Key
            private Boolean force;

            protected Publish(String string) {
                super(MapsEngine.this, "POST", REST_PATH, null, PublishResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Publish setAlt(String string) {
                return (Publish)super.setAlt(string);
            }

            public Publish setFields(String string) {
                return (Publish)super.setFields(string);
            }

            public Publish setKey(String string) {
                return (Publish)super.setKey(string);
            }

            public Publish setOauthToken(String string) {
                return (Publish)super.setOauthToken(string);
            }

            public Publish setPrettyPrint(Boolean bl) {
                return (Publish)super.setPrettyPrint(bl);
            }

            public Publish setQuotaUser(String string) {
                return (Publish)super.setQuotaUser(string);
            }

            public Publish setUserIp(String string) {
                return (Publish)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Publish setId(String string) {
                this.id = string;
                return this;
            }

            public Boolean getForce() {
                return this.force;
            }

            public Publish setForce(Boolean bl) {
                this.force = bl;
                return this;
            }

            @Override
            public Publish set(String string, Object object) {
                return (Publish)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends MapsEngineRequest<Void> {
            private static final String REST_PATH = "maps/{id}";
            @Key
            private String id;

            protected Patch(String string, Map map) {
                super(MapsEngine.this, "PATCH", REST_PATH, (Object)map, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListPublished
        extends MapsEngineRequest<PublishedMapsListResponse> {
            private static final String REST_PATH = "maps/published";
            @Key
            private String pageToken;
            @Key
            private Long maxResults;
            @Key
            private String projectId;

            protected ListPublished() {
                super(MapsEngine.this, "GET", REST_PATH, null, PublishedMapsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListPublished setAlt(String string) {
                return (ListPublished)super.setAlt(string);
            }

            public ListPublished setFields(String string) {
                return (ListPublished)super.setFields(string);
            }

            public ListPublished setKey(String string) {
                return (ListPublished)super.setKey(string);
            }

            public ListPublished setOauthToken(String string) {
                return (ListPublished)super.setOauthToken(string);
            }

            public ListPublished setPrettyPrint(Boolean bl) {
                return (ListPublished)super.setPrettyPrint(bl);
            }

            public ListPublished setQuotaUser(String string) {
                return (ListPublished)super.setQuotaUser(string);
            }

            public ListPublished setUserIp(String string) {
                return (ListPublished)super.setUserIp(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListPublished setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListPublished setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public ListPublished setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public ListPublished set(String string, Object object) {
                return (ListPublished)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<MapsListResponse> {
            private static final String REST_PATH = "maps";
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String processingStatus;
            @Key
            private String projectId;
            @Key
            private String tags;
            @Key
            private String search;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String version;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;
            @Key
            private String role;

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, MapsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getProcessingStatus() {
                return this.processingStatus;
            }

            public List setProcessingStatus(String string) {
                this.processingStatus = string;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getTags() {
                return this.tags;
            }

            public List setTags(String string) {
                this.tags = string;
                return this;
            }

            public String getSearch() {
                return this.search;
            }

            public List setSearch(String string) {
                this.search = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public List setVersion(String string) {
                this.version = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            public String getRole() {
                return this.role;
            }

            public List setRole(String string) {
                this.role = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetPublished
        extends MapsEngineRequest<PublishedMap> {
            private static final String REST_PATH = "maps/{id}/published";
            @Key
            private String id;

            protected GetPublished(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, PublishedMap.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetPublished setAlt(String string) {
                return (GetPublished)super.setAlt(string);
            }

            public GetPublished setFields(String string) {
                return (GetPublished)super.setFields(string);
            }

            public GetPublished setKey(String string) {
                return (GetPublished)super.setKey(string);
            }

            public GetPublished setOauthToken(String string) {
                return (GetPublished)super.setOauthToken(string);
            }

            public GetPublished setPrettyPrint(Boolean bl) {
                return (GetPublished)super.setPrettyPrint(bl);
            }

            public GetPublished setQuotaUser(String string) {
                return (GetPublished)super.setQuotaUser(string);
            }

            public GetPublished setUserIp(String string) {
                return (GetPublished)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public GetPublished setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public GetPublished set(String string, Object object) {
                return (GetPublished)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<Map> {
            private static final String REST_PATH = "maps/{id}";
            @Key
            private String id;
            @Key
            private String version;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, Map.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public Get setVersion(String string) {
                this.version = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends MapsEngineRequest<Void> {
            private static final String REST_PATH = "maps/{id}";
            @Key
            private String id;

            protected Delete(String string) {
                super(MapsEngine.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends MapsEngineRequest<Map> {
            private static final String REST_PATH = "maps";

            protected Create(Map map) {
                super(MapsEngine.this, "POST", REST_PATH, (Object)map, Map.class);
                this.checkRequiredParameter((Object)map, "content");
                this.checkRequiredParameter(map.getName(), "Map.getName()");
                this.checkRequiredParameter((Object)map, "content");
                this.checkRequiredParameter(map.getProjectId(), "Map.getProjectId()");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Layers {
        public CancelProcessing cancelProcessing(String string) throws IOException {
            CancelProcessing cancelProcessing = new CancelProcessing(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)cancelProcessing);
            return cancelProcessing;
        }

        public Create create(Layer layer) throws IOException {
            Create create = new Create(layer);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetPublished getPublished(String string) throws IOException {
            GetPublished getPublished = new GetPublished(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)getPublished);
            return getPublished;
        }

        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ListPublished listPublished() throws IOException {
            ListPublished listPublished = new ListPublished();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)listPublished);
            return listPublished;
        }

        public Patch patch(String string, Layer layer) throws IOException {
            Patch patch = new Patch(string, layer);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Process process(String string) throws IOException {
            Process process = new Process(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)process);
            return process;
        }

        public Publish publish(String string) throws IOException {
            Publish publish = new Publish(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)publish);
            return publish;
        }

        public Unpublish unpublish(String string) throws IOException {
            Unpublish unpublish = new Unpublish(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)unpublish);
            return unpublish;
        }

        public Parents parents() {
            return new Parents();
        }

        public Permissions permissions() {
            return new Permissions();
        }

        public class Permissions {
            public BatchDelete batchDelete(String string, PermissionsBatchDeleteRequest permissionsBatchDeleteRequest) throws IOException {
                BatchDelete batchDelete = new BatchDelete(string, permissionsBatchDeleteRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                return batchDelete;
            }

            public BatchUpdate batchUpdate(String string, PermissionsBatchUpdateRequest permissionsBatchUpdateRequest) throws IOException {
                BatchUpdate batchUpdate = new BatchUpdate(string, permissionsBatchUpdateRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                return batchUpdate;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<PermissionsListResponse> {
                private static final String REST_PATH = "layers/{id}/permissions";
                @Key
                private String id;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, PermissionsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchUpdate
            extends MapsEngineRequest<PermissionsBatchUpdateResponse> {
                private static final String REST_PATH = "layers/{id}/permissions/batchUpdate";
                @Key
                private String id;

                protected BatchUpdate(String string, PermissionsBatchUpdateRequest permissionsBatchUpdateRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)permissionsBatchUpdateRequest, PermissionsBatchUpdateResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchUpdate setAlt(String string) {
                    return (BatchUpdate)super.setAlt(string);
                }

                public BatchUpdate setFields(String string) {
                    return (BatchUpdate)super.setFields(string);
                }

                public BatchUpdate setKey(String string) {
                    return (BatchUpdate)super.setKey(string);
                }

                public BatchUpdate setOauthToken(String string) {
                    return (BatchUpdate)super.setOauthToken(string);
                }

                public BatchUpdate setPrettyPrint(Boolean bl) {
                    return (BatchUpdate)super.setPrettyPrint(bl);
                }

                public BatchUpdate setQuotaUser(String string) {
                    return (BatchUpdate)super.setQuotaUser(string);
                }

                public BatchUpdate setUserIp(String string) {
                    return (BatchUpdate)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchUpdate setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchUpdate set(String string, Object object) {
                    return (BatchUpdate)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchDelete
            extends MapsEngineRequest<PermissionsBatchDeleteResponse> {
                private static final String REST_PATH = "layers/{id}/permissions/batchDelete";
                @Key
                private String id;

                protected BatchDelete(String string, PermissionsBatchDeleteRequest permissionsBatchDeleteRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)permissionsBatchDeleteRequest, PermissionsBatchDeleteResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchDelete setAlt(String string) {
                    return (BatchDelete)super.setAlt(string);
                }

                public BatchDelete setFields(String string) {
                    return (BatchDelete)super.setFields(string);
                }

                public BatchDelete setKey(String string) {
                    return (BatchDelete)super.setKey(string);
                }

                public BatchDelete setOauthToken(String string) {
                    return (BatchDelete)super.setOauthToken(string);
                }

                public BatchDelete setPrettyPrint(Boolean bl) {
                    return (BatchDelete)super.setPrettyPrint(bl);
                }

                public BatchDelete setQuotaUser(String string) {
                    return (BatchDelete)super.setQuotaUser(string);
                }

                public BatchDelete setUserIp(String string) {
                    return (BatchDelete)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchDelete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchDelete set(String string, Object object) {
                    return (BatchDelete)super.set(string, object);
                }
            }
        }

        public class Parents {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<ParentsListResponse> {
                private static final String REST_PATH = "layers/{id}/parents";
                @Key
                private String id;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, ParentsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Unpublish
        extends MapsEngineRequest<PublishResponse> {
            private static final String REST_PATH = "layers/{id}/unpublish";
            @Key
            private String id;

            protected Unpublish(String string) {
                super(MapsEngine.this, "POST", REST_PATH, null, PublishResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Unpublish setAlt(String string) {
                return (Unpublish)super.setAlt(string);
            }

            public Unpublish setFields(String string) {
                return (Unpublish)super.setFields(string);
            }

            public Unpublish setKey(String string) {
                return (Unpublish)super.setKey(string);
            }

            public Unpublish setOauthToken(String string) {
                return (Unpublish)super.setOauthToken(string);
            }

            public Unpublish setPrettyPrint(Boolean bl) {
                return (Unpublish)super.setPrettyPrint(bl);
            }

            public Unpublish setQuotaUser(String string) {
                return (Unpublish)super.setQuotaUser(string);
            }

            public Unpublish setUserIp(String string) {
                return (Unpublish)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Unpublish setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Unpublish set(String string, Object object) {
                return (Unpublish)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Publish
        extends MapsEngineRequest<PublishResponse> {
            private static final String REST_PATH = "layers/{id}/publish";
            @Key
            private String id;
            @Key
            private Boolean force;

            protected Publish(String string) {
                super(MapsEngine.this, "POST", REST_PATH, null, PublishResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Publish setAlt(String string) {
                return (Publish)super.setAlt(string);
            }

            public Publish setFields(String string) {
                return (Publish)super.setFields(string);
            }

            public Publish setKey(String string) {
                return (Publish)super.setKey(string);
            }

            public Publish setOauthToken(String string) {
                return (Publish)super.setOauthToken(string);
            }

            public Publish setPrettyPrint(Boolean bl) {
                return (Publish)super.setPrettyPrint(bl);
            }

            public Publish setQuotaUser(String string) {
                return (Publish)super.setQuotaUser(string);
            }

            public Publish setUserIp(String string) {
                return (Publish)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Publish setId(String string) {
                this.id = string;
                return this;
            }

            public Boolean getForce() {
                return this.force;
            }

            public Publish setForce(Boolean bl) {
                this.force = bl;
                return this;
            }

            @Override
            public Publish set(String string, Object object) {
                return (Publish)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Process
        extends MapsEngineRequest<ProcessResponse> {
            private static final String REST_PATH = "layers/{id}/process";
            @Key
            private String id;

            protected Process(String string) {
                super(MapsEngine.this, "POST", REST_PATH, null, ProcessResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Process setAlt(String string) {
                return (Process)super.setAlt(string);
            }

            public Process setFields(String string) {
                return (Process)super.setFields(string);
            }

            public Process setKey(String string) {
                return (Process)super.setKey(string);
            }

            public Process setOauthToken(String string) {
                return (Process)super.setOauthToken(string);
            }

            public Process setPrettyPrint(Boolean bl) {
                return (Process)super.setPrettyPrint(bl);
            }

            public Process setQuotaUser(String string) {
                return (Process)super.setQuotaUser(string);
            }

            public Process setUserIp(String string) {
                return (Process)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Process setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Process set(String string, Object object) {
                return (Process)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends MapsEngineRequest<Void> {
            private static final String REST_PATH = "layers/{id}";
            @Key
            private String id;

            protected Patch(String string, Layer layer) {
                super(MapsEngine.this, "PATCH", REST_PATH, (Object)layer, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListPublished
        extends MapsEngineRequest<PublishedLayersListResponse> {
            private static final String REST_PATH = "layers/published";
            @Key
            private String pageToken;
            @Key
            private Long maxResults;
            @Key
            private String projectId;

            protected ListPublished() {
                super(MapsEngine.this, "GET", REST_PATH, null, PublishedLayersListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListPublished setAlt(String string) {
                return (ListPublished)super.setAlt(string);
            }

            public ListPublished setFields(String string) {
                return (ListPublished)super.setFields(string);
            }

            public ListPublished setKey(String string) {
                return (ListPublished)super.setKey(string);
            }

            public ListPublished setOauthToken(String string) {
                return (ListPublished)super.setOauthToken(string);
            }

            public ListPublished setPrettyPrint(Boolean bl) {
                return (ListPublished)super.setPrettyPrint(bl);
            }

            public ListPublished setQuotaUser(String string) {
                return (ListPublished)super.setQuotaUser(string);
            }

            public ListPublished setUserIp(String string) {
                return (ListPublished)super.setUserIp(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListPublished setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListPublished setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public ListPublished setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public ListPublished set(String string, Object object) {
                return (ListPublished)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<LayersListResponse> {
            private static final String REST_PATH = "layers";
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String processingStatus;
            @Key
            private String projectId;
            @Key
            private String tags;
            @Key
            private String search;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;
            @Key
            private String role;

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, LayersListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getProcessingStatus() {
                return this.processingStatus;
            }

            public List setProcessingStatus(String string) {
                this.processingStatus = string;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getTags() {
                return this.tags;
            }

            public List setTags(String string) {
                this.tags = string;
                return this;
            }

            public String getSearch() {
                return this.search;
            }

            public List setSearch(String string) {
                this.search = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            public String getRole() {
                return this.role;
            }

            public List setRole(String string) {
                this.role = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetPublished
        extends MapsEngineRequest<PublishedLayer> {
            private static final String REST_PATH = "layers/{id}/published";
            @Key
            private String id;

            protected GetPublished(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, PublishedLayer.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetPublished setAlt(String string) {
                return (GetPublished)super.setAlt(string);
            }

            public GetPublished setFields(String string) {
                return (GetPublished)super.setFields(string);
            }

            public GetPublished setKey(String string) {
                return (GetPublished)super.setKey(string);
            }

            public GetPublished setOauthToken(String string) {
                return (GetPublished)super.setOauthToken(string);
            }

            public GetPublished setPrettyPrint(Boolean bl) {
                return (GetPublished)super.setPrettyPrint(bl);
            }

            public GetPublished setQuotaUser(String string) {
                return (GetPublished)super.setQuotaUser(string);
            }

            public GetPublished setUserIp(String string) {
                return (GetPublished)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public GetPublished setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public GetPublished set(String string, Object object) {
                return (GetPublished)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<Layer> {
            private static final String REST_PATH = "layers/{id}";
            @Key
            private String id;
            @Key
            private String version;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, Layer.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public Get setVersion(String string) {
                this.version = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends MapsEngineRequest<Void> {
            private static final String REST_PATH = "layers/{id}";
            @Key
            private String id;

            protected Delete(String string) {
                super(MapsEngine.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends MapsEngineRequest<Layer> {
            private static final String REST_PATH = "layers";
            @Key
            private Boolean process;

            protected Create(Layer layer) {
                super(MapsEngine.this, "POST", REST_PATH, (Object)layer, Layer.class);
                this.checkRequiredParameter((Object)layer, "content");
                this.checkRequiredParameter(layer.getLayerType(), "Layer.getLayerType()");
                this.checkRequiredParameter((Object)layer, "content");
                this.checkRequiredParameter(layer.getName(), "Layer.getName()");
                this.checkRequiredParameter((Object)layer, "content");
                this.checkRequiredParameter(layer.getProjectId(), "Layer.getProjectId()");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public Boolean getProcess() {
                return this.process;
            }

            public Create setProcess(Boolean bl) {
                this.process = bl;
                return this;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CancelProcessing
        extends MapsEngineRequest<ProcessResponse> {
            private static final String REST_PATH = "layers/{id}/cancelProcessing";
            @Key
            private String id;

            protected CancelProcessing(String string) {
                super(MapsEngine.this, "POST", REST_PATH, null, ProcessResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public CancelProcessing setAlt(String string) {
                return (CancelProcessing)super.setAlt(string);
            }

            public CancelProcessing setFields(String string) {
                return (CancelProcessing)super.setFields(string);
            }

            public CancelProcessing setKey(String string) {
                return (CancelProcessing)super.setKey(string);
            }

            public CancelProcessing setOauthToken(String string) {
                return (CancelProcessing)super.setOauthToken(string);
            }

            public CancelProcessing setPrettyPrint(Boolean bl) {
                return (CancelProcessing)super.setPrettyPrint(bl);
            }

            public CancelProcessing setQuotaUser(String string) {
                return (CancelProcessing)super.setQuotaUser(string);
            }

            public CancelProcessing setUserIp(String string) {
                return (CancelProcessing)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public CancelProcessing setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public CancelProcessing set(String string, Object object) {
                return (CancelProcessing)super.set(string, object);
            }
        }
    }

    public class Assets {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Parents parents() {
            return new Parents();
        }

        public Permissions permissions() {
            return new Permissions();
        }

        public class Permissions {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<PermissionsListResponse> {
                private static final String REST_PATH = "assets/{id}/permissions";
                @Key
                private String id;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, PermissionsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Parents {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<ParentsListResponse> {
                private static final String REST_PATH = "assets/{id}/parents";
                @Key
                private String id;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, ParentsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<AssetsListResponse> {
            private static final String REST_PATH = "assets";
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String tags;
            @Key
            private String projectId;
            @Key
            private String search;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;
            @Key
            private String role;
            @Key
            private String type;

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, AssetsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getTags() {
                return this.tags;
            }

            public List setTags(String string) {
                this.tags = string;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getSearch() {
                return this.search;
            }

            public List setSearch(String string) {
                this.search = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            public String getRole() {
                return this.role;
            }

            public List setRole(String string) {
                this.role = string;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public List setType(String string) {
                this.type = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<Asset> {
            private static final String REST_PATH = "assets/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, Asset.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

