/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-09-12 at 05:29:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * The published version of a map asset.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PublishedMap extends com.google.api.client.json.GenericJson {

  /**
   * The contents of this Map.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MapItem> contents;

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> defaultViewport;

  /**
   * The description of this Map, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A globally unique ID, used to refer to this Map.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The name of this Map, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The ID of the project that this Map is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * The contents of this Map.
   * @return value or {@code null} for none
   */
  public java.util.List<MapItem> getContents() {
    return contents;
  }

  /**
   * The contents of this Map.
   * @param contents contents or {@code null} for none
   */
  public PublishedMap setContents(java.util.List<MapItem> contents) {
    this.contents = contents;
    return this;
  }

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getDefaultViewport() {
    return defaultViewport;
  }

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * @param defaultViewport defaultViewport or {@code null} for none
   */
  public PublishedMap setDefaultViewport(java.util.List<java.lang.Double> defaultViewport) {
    this.defaultViewport = defaultViewport;
    return this;
  }

  /**
   * The description of this Map, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this Map, supplied by the author.
   * @param description description or {@code null} for none
   */
  public PublishedMap setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A globally unique ID, used to refer to this Map.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A globally unique ID, used to refer to this Map.
   * @param id id or {@code null} for none
   */
  public PublishedMap setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The name of this Map, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this Map, supplied by the author.
   * @param name name or {@code null} for none
   */
  public PublishedMap setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The ID of the project that this Map is in.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the project that this Map is in.
   * @param projectId projectId or {@code null} for none
   */
  public PublishedMap setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  @Override
  public PublishedMap set(String fieldName, Object value) {
    return (PublishedMap) super.set(fieldName, value);
  }

  @Override
  public PublishedMap clone() {
    return (PublishedMap) super.clone();
  }

}
