/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.docs.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.docs.v1.DocsRequest;
import com.google.api.services.docs.v1.DocsRequestInitializer;
import com.google.api.services.docs.v1.model.BatchUpdateDocumentRequest;
import com.google.api.services.docs.v1.model.BatchUpdateDocumentResponse;
import com.google.api.services.docs.v1.model.Document;
import java.io.IOException;

public class Docs
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://docs.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://docs.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://docs.googleapis.com/";

    public Docs(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Docs(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Documents documents() {
        return new Documents();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Google Docs API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Docs.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://docs.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Docs.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Docs.DEFAULT_BATCH_PATH);
        }

        public Docs build() {
            return new Docs(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDocsRequestInitializer(DocsRequestInitializer docsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)docsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Documents {
        public BatchUpdate batchUpdate(String documentId, BatchUpdateDocumentRequest content) throws IOException {
            BatchUpdate result = new BatchUpdate(documentId, content);
            Docs.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Document content) throws IOException {
            Create result = new Create(content);
            Docs.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String documentId) throws IOException {
            Get result = new Get(documentId);
            Docs.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends DocsRequest<Document> {
            private static final String REST_PATH = "v1/documents/{documentId}";
            @Key
            private String documentId;
            @Key
            private String suggestionsViewMode;

            protected Get(String documentId) {
                super(Docs.this, "GET", REST_PATH, null, Document.class);
                this.documentId = (String)Preconditions.checkNotNull((Object)documentId, (Object)"Required parameter documentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getDocumentId() {
                return this.documentId;
            }

            public Get setDocumentId(String documentId) {
                this.documentId = documentId;
                return this;
            }

            public String getSuggestionsViewMode() {
                return this.suggestionsViewMode;
            }

            public Get setSuggestionsViewMode(String suggestionsViewMode) {
                this.suggestionsViewMode = suggestionsViewMode;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Create
        extends DocsRequest<Document> {
            private static final String REST_PATH = "v1/documents";

            protected Create(Document content) {
                super(Docs.this, "POST", REST_PATH, (Object)content, Document.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class BatchUpdate
        extends DocsRequest<BatchUpdateDocumentResponse> {
            private static final String REST_PATH = "v1/documents/{documentId}:batchUpdate";
            @Key
            private String documentId;

            protected BatchUpdate(String documentId, BatchUpdateDocumentRequest content) {
                super(Docs.this, "POST", REST_PATH, (Object)content, BatchUpdateDocumentResponse.class);
                this.documentId = (String)Preconditions.checkNotNull((Object)documentId, (Object)"Required parameter documentId must be specified.");
            }

            public BatchUpdate set$Xgafv(String $Xgafv) {
                return (BatchUpdate)super.set$Xgafv($Xgafv);
            }

            public BatchUpdate setAccessToken(String accessToken) {
                return (BatchUpdate)super.setAccessToken(accessToken);
            }

            public BatchUpdate setAlt(String alt) {
                return (BatchUpdate)super.setAlt(alt);
            }

            public BatchUpdate setCallback(String callback) {
                return (BatchUpdate)super.setCallback(callback);
            }

            public BatchUpdate setFields(String fields) {
                return (BatchUpdate)super.setFields(fields);
            }

            public BatchUpdate setKey(String key) {
                return (BatchUpdate)super.setKey(key);
            }

            public BatchUpdate setOauthToken(String oauthToken) {
                return (BatchUpdate)super.setOauthToken(oauthToken);
            }

            public BatchUpdate setPrettyPrint(Boolean prettyPrint) {
                return (BatchUpdate)super.setPrettyPrint(prettyPrint);
            }

            public BatchUpdate setQuotaUser(String quotaUser) {
                return (BatchUpdate)super.setQuotaUser(quotaUser);
            }

            public BatchUpdate setUploadType(String uploadType) {
                return (BatchUpdate)super.setUploadType(uploadType);
            }

            public BatchUpdate setUploadProtocol(String uploadProtocol) {
                return (BatchUpdate)super.setUploadProtocol(uploadProtocol);
            }

            public String getDocumentId() {
                return this.documentId;
            }

            public BatchUpdate setDocumentId(String documentId) {
                this.documentId = documentId;
                return this;
            }

            @Override
            public BatchUpdate set(String parameterName, Object value) {
                return (BatchUpdate)super.set(parameterName, value);
            }
        }
    }
}

