/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-18 at 00:39:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Represents a group of metric filters. Set the operator value to specify how the filters are
 * logically combined.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MetricFilterClause extends com.google.api.client.json.GenericJson {

  /**
   * The repeated set of filters. They are logically combined based on the operator specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetricFilter> filters;

  static {
    // hack to force ProGuard to consider MetricFilter used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MetricFilter.class);
  }

  /**
   * The operator for combining multiple metric filters. If unspecified, it is treated as an `OR`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operator;

  /**
   * The repeated set of filters. They are logically combined based on the operator specified.
   * @return value or {@code null} for none
   */
  public java.util.List<MetricFilter> getFilters() {
    return filters;
  }

  /**
   * The repeated set of filters. They are logically combined based on the operator specified.
   * @param filters filters or {@code null} for none
   */
  public MetricFilterClause setFilters(java.util.List<MetricFilter> filters) {
    this.filters = filters;
    return this;
  }

  /**
   * The operator for combining multiple metric filters. If unspecified, it is treated as an `OR`.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperator() {
    return operator;
  }

  /**
   * The operator for combining multiple metric filters. If unspecified, it is treated as an `OR`.
   * @param operator operator or {@code null} for none
   */
  public MetricFilterClause setOperator(java.lang.String operator) {
    this.operator = operator;
    return this;
  }

  @Override
  public MetricFilterClause set(String fieldName, Object value) {
    return (MetricFilterClause) super.set(fieldName, value);
  }

  @Override
  public MetricFilterClause clone() {
    return (MetricFilterClause) super.clone();
  }

}
