/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-08-26 17:13:51 UTC)
 * on 2013-09-09 at 19:13:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics view (profile).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Profile extends com.google.api.client.json.GenericJson {

  /**
   * Account ID to which this view (profile) belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * Child link for this view (profile). Points to the list of goals for this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChildLink childLink;

  /**
   * Time this view (profile) was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime created;

  /**
   * The currency type associated with this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currency;

  /**
   * Default page for this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultPage;

  /**
   * Indicates whether ecommerce tracking is enabled for this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean eCommerceTracking;

  /**
   * The query parameters that are excluded from this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String excludeQueryParameters;

  /**
   * View (Profile) ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Internal ID for the web property to which this view (profile) belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String internalWebPropertyId;

  /**
   * Resource type for Analytics profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Parent link for this view (profile). Points to the web property to which this view (profile)
   * belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * Link for this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Site search category parameters for this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String siteSearchCategoryParameters;

  /**
   * The site search query parameters for this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String siteSearchQueryParameters;

  /**
   * Time zone for which this profile has been configured.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timezone;

  /**
   * View (Profile) type. Supported types: WEB or APP.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Time this view (profile) was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webPropertyId;

  /**
   * Website URL for this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String websiteUrl;

  /**
   * Account ID to which this view (profile) belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this view (profile) belongs.
   * @param accountId accountId or {@code null} for none
   */
  public Profile setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Child link for this view (profile). Points to the list of goals for this view (profile).
   * @return value or {@code null} for none
   */
  public ChildLink getChildLink() {
    return childLink;
  }

  /**
   * Child link for this view (profile). Points to the list of goals for this view (profile).
   * @param childLink childLink or {@code null} for none
   */
  public Profile setChildLink(ChildLink childLink) {
    this.childLink = childLink;
    return this;
  }

  /**
   * Time this view (profile) was created.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreated() {
    return created;
  }

  /**
   * Time this view (profile) was created.
   * @param created created or {@code null} for none
   */
  public Profile setCreated(com.google.api.client.util.DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * The currency type associated with this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrency() {
    return currency;
  }

  /**
   * The currency type associated with this view (profile).
   * @param currency currency or {@code null} for none
   */
  public Profile setCurrency(java.lang.String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Default page for this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultPage() {
    return defaultPage;
  }

  /**
   * Default page for this view (profile).
   * @param defaultPage defaultPage or {@code null} for none
   */
  public Profile setDefaultPage(java.lang.String defaultPage) {
    this.defaultPage = defaultPage;
    return this;
  }

  /**
   * Indicates whether ecommerce tracking is enabled for this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getECommerceTracking() {
    return eCommerceTracking;
  }

  /**
   * Indicates whether ecommerce tracking is enabled for this view (profile).
   * @param eCommerceTracking eCommerceTracking or {@code null} for none
   */
  public Profile setECommerceTracking(java.lang.Boolean eCommerceTracking) {
    this.eCommerceTracking = eCommerceTracking;
    return this;
  }

  /**
   * The query parameters that are excluded from this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.String getExcludeQueryParameters() {
    return excludeQueryParameters;
  }

  /**
   * The query parameters that are excluded from this view (profile).
   * @param excludeQueryParameters excludeQueryParameters or {@code null} for none
   */
  public Profile setExcludeQueryParameters(java.lang.String excludeQueryParameters) {
    this.excludeQueryParameters = excludeQueryParameters;
    return this;
  }

  /**
   * View (Profile) ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * View (Profile) ID.
   * @param id id or {@code null} for none
   */
  public Profile setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Internal ID for the web property to which this view (profile) belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for the web property to which this view (profile) belongs.
   * @param internalWebPropertyId internalWebPropertyId or {@code null} for none
   */
  public Profile setInternalWebPropertyId(java.lang.String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Resource type for Analytics profile.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics profile.
   * @param kind kind or {@code null} for none
   */
  public Profile setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this view (profile).
   * @param name name or {@code null} for none
   */
  public Profile setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Parent link for this view (profile). Points to the web property to which this view (profile)
   * belongs.
   * @return value or {@code null} for none
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for this view (profile). Points to the web property to which this view (profile)
   * belongs.
   * @param parentLink parentLink or {@code null} for none
   */
  public Profile setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * Link for this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this view (profile).
   * @param selfLink selfLink or {@code null} for none
   */
  public Profile setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Site search category parameters for this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.String getSiteSearchCategoryParameters() {
    return siteSearchCategoryParameters;
  }

  /**
   * Site search category parameters for this view (profile).
   * @param siteSearchCategoryParameters siteSearchCategoryParameters or {@code null} for none
   */
  public Profile setSiteSearchCategoryParameters(java.lang.String siteSearchCategoryParameters) {
    this.siteSearchCategoryParameters = siteSearchCategoryParameters;
    return this;
  }

  /**
   * The site search query parameters for this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.String getSiteSearchQueryParameters() {
    return siteSearchQueryParameters;
  }

  /**
   * The site search query parameters for this view (profile).
   * @param siteSearchQueryParameters siteSearchQueryParameters or {@code null} for none
   */
  public Profile setSiteSearchQueryParameters(java.lang.String siteSearchQueryParameters) {
    this.siteSearchQueryParameters = siteSearchQueryParameters;
    return this;
  }

  /**
   * Time zone for which this profile has been configured.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimezone() {
    return timezone;
  }

  /**
   * Time zone for which this profile has been configured.
   * @param timezone timezone or {@code null} for none
   */
  public Profile setTimezone(java.lang.String timezone) {
    this.timezone = timezone;
    return this;
  }

  /**
   * View (Profile) type. Supported types: WEB or APP.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * View (Profile) type. Supported types: WEB or APP.
   * @param type type or {@code null} for none
   */
  public Profile setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Time this view (profile) was last modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Time this view (profile) was last modified.
   * @param updated updated or {@code null} for none
   */
  public Profile setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.
   * @param webPropertyId webPropertyId or {@code null} for none
   */
  public Profile setWebPropertyId(java.lang.String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  /**
   * Website URL for this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.String getWebsiteUrl() {
    return websiteUrl;
  }

  /**
   * Website URL for this view (profile).
   * @param websiteUrl websiteUrl or {@code null} for none
   */
  public Profile setWebsiteUrl(java.lang.String websiteUrl) {
    this.websiteUrl = websiteUrl;
    return this;
  }

  @Override
  public Profile set(String fieldName, Object value) {
    return (Profile) super.set(fieldName, value);
  }

  @Override
  public Profile clone() {
    return (Profile) super.clone();
  }

  /**
   * Child link for this view (profile). Points to the list of goals for this view (profile).
   */
  public static final class ChildLink extends com.google.api.client.json.GenericJson {

    /**
     * Link to the list of goals for this view (profile).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String href;

    /**
     * Value is "analytics#goals".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Link to the list of goals for this view (profile).
     * @return value or {@code null} for none
     */
    public java.lang.String getHref() {
      return href;
    }

    /**
     * Link to the list of goals for this view (profile).
     * @param href href or {@code null} for none
     */
    public ChildLink setHref(java.lang.String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#goals".
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Value is "analytics#goals".
     * @param type type or {@code null} for none
     */
    public ChildLink setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public ChildLink set(String fieldName, Object value) {
      return (ChildLink) super.set(fieldName, value);
    }

    @Override
    public ChildLink clone() {
      return (ChildLink) super.clone();
    }

  }

  /**
   * Parent link for this view (profile). Points to the web property to which this view (profile)
   * belongs.
   */
  public static final class ParentLink extends com.google.api.client.json.GenericJson {

    /**
     * Link to the web property to which this view (profile) belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String href;

    /**
     * Value is "analytics#webproperty".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Link to the web property to which this view (profile) belongs.
     * @return value or {@code null} for none
     */
    public java.lang.String getHref() {
      return href;
    }

    /**
     * Link to the web property to which this view (profile) belongs.
     * @param href href or {@code null} for none
     */
    public ParentLink setHref(java.lang.String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#webproperty".
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Value is "analytics#webproperty".
     * @param type type or {@code null} for none
     */
    public ParentLink setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public ParentLink set(String fieldName, Object value) {
      return (ParentLink) super.set(fieldName, value);
    }

    @Override
    public ParentLink clone() {
      return (ParentLink) super.clone();
    }

  }

}
