/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * JSON template for an Analytics advanced segment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Segment extends GenericJson {

  /**
   * Time the advanced segment was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime created;

  /**
   * Advanced segment definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String definition;

  /**
   * Advanced segment ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * Resource type for Analytics advanced segment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Advanced segment name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Segment ID. Can be used with the 'segment' parameter in Data Feed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String segmentId;

  /**
   * Link for this advanced segment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Time the advanced segment was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime updated;

  /**
   * Time the advanced segment was created.
   * The value returned may be {@code null}.
   */
  public DateTime getCreated() {
    return created;
  }

  /**
   * Time the advanced segment was created.
   * The value set may be {@code null}.
   */
  public Segment setCreated(DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Advanced segment definition.
   * The value returned may be {@code null}.
   */
  public String getDefinition() {
    return definition;
  }

  /**
   * Advanced segment definition.
   * The value set may be {@code null}.
   */
  public Segment setDefinition(String definition) {
    this.definition = definition;
    return this;
  }

  /**
   * Advanced segment ID.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * Advanced segment ID.
   * The value set may be {@code null}.
   */
  public Segment setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Resource type for Analytics advanced segment.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics advanced segment.
   * The value set may be {@code null}.
   */
  public Segment setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Advanced segment name.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Advanced segment name.
   * The value set may be {@code null}.
   */
  public Segment setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Segment ID. Can be used with the 'segment' parameter in Data Feed.
   * The value returned may be {@code null}.
   */
  public String getSegmentId() {
    return segmentId;
  }

  /**
   * Segment ID. Can be used with the 'segment' parameter in Data Feed.
   * The value set may be {@code null}.
   */
  public Segment setSegmentId(String segmentId) {
    this.segmentId = segmentId;
    return this;
  }

  /**
   * Link for this advanced segment.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this advanced segment.
   * The value set may be {@code null}.
   */
  public Segment setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Time the advanced segment was last modified.
   * The value returned may be {@code null}.
   */
  public DateTime getUpdated() {
    return updated;
  }

  /**
   * Time the advanced segment was last modified.
   * The value set may be {@code null}.
   */
  public Segment setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }

}
