/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * JSON template for Analytics experiment resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Experiment extends GenericJson {

  /**
   * Account ID to which this experiment belongs. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String accountId;

  /**
   * Time the experiment was created. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime created;

  /**
   * Notes about this experiment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * If true, the end user will be able to edit the experiment via the Google Analytics user
   * interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Object editableInGaUi;

  /**
   * The ending time of the experiment (the time the status changed from RUNNING to ENDED). This
   * field is present only if the experiment has ended. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime endTime;

  /**
   * Experiment ID. Required for patch and update. Disallowed for create.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * Internal ID for the web property to which this experiment belongs. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String internalWebPropertyId;

  /**
   * Resource type for an Analytics experiment. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Specifies the minimum length of the experiment. Can be changed for a running experiment. This
   * field may not be changed for an experiments whose status is ENDED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer minimumExperimentLengthInDays;

  /**
   * Experiment name. This field may not be changed for an experiment whose status is ENDED. This
   * field is required when creating an experiment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * The metric that the experiment is optimizing. Valid values: "ga:goal(n)Completions",
   * "ga:bounces", "ga:pageviews", "ga:timeOnSite", "ga:transactions", "ga:transactionRevenue". This
   * field is required if status is "RUNNING" and servingFramework is one of "REDIRECT" or "API".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String objectiveMetric;

  /**
   * Whether the objectiveMetric should be minimized or maximized. Possible values: "MAXIMUM",
   * "MINIMUM". Optional--defaults to "MAXIMUM". Cannot be specified without objectiveMetric. Cannot
   * be modified when status is "RUNNING" or "ENDED".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String optimizationType;

  /**
   * Parent link for an experiment. Points to the profile to which this experiment belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * Profile ID to which this experiment belongs. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String profileId;

  /**
   * Why the experiment ended. Possible values: "STOPPED_BY_USER", "WINNER_FOUND",
   * "EXPERIMENT_EXPIRED", "ENDED_WITH_NO_WINNER", "GOAL_OBJECTIVE_CHANGED". "ENDED_WITH_NO_WINNER"
   * means that the experiment didn't expire but no winner was projected to be found. If the
   * experiment status is changed via the API to ENDED this field is set to STOPPED_BY_USER. This
   * field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String reasonExperimentEnded;

  /**
   * Boolean specifying whether variations URLS are rewritten to match those of the original. This
   * field may not be changed for an experiments whose status is ENDED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean rewriteVariationUrlsAsOriginal;

  /**
   * Link for this experiment. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The framework used to serve the experiment variations and evaluate the results. One of: -
   * REDIRECT: Google Analytics redirects traffic to different variation pages, reports the chosen
   * variation and evaluates the results. - API: Google Analytics chooses and reports the variation
   * to serve and evaluates the results; the caller is responsible for serving the selected
   * variation. - EXTERNAL: The variations will be served externally and the chosen variation
   * reported to Google Analytics. The caller is responsible for serving the selected variation and
   * evaluating the results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Object servingFramework;

  /**
   * The snippet of code to include on the control page(s). This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String snippet;

  /**
   * The starting time of the experiment (the time the status changed from READY_TO_RUN to RUNNING).
   * This field is present only if the experiment has started. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime startTime;

  /**
   * Experiment status. Possible values: "DRAFT", "READY_TO_RUN", "RUNNING", "ENDED". Experiments
   * can be created in the "DRAFT", "READY_TO_RUN" or "RUNNING" state. This field is required when
   * creating an experiment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String status;

  /**
   * A floating-point number between 0 and 1. Specifies the fraction of the traffic that
   * participates in the experiment. Can be changed for a running experiment. This field may not be
   * changed for an experiments whose status is ENDED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Double trafficCoverage;

  /**
   * Time the experiment was last modified. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime updated;

  /**
   * Array of variations. The first variation in the array is the original. The number of variations
   * may not change once an experiment is in the RUNNING state. At least two variations are required
   * before status can be set to RUNNING.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Variations> variations;

  static {
    // hack to force ProGuard to consider Variations used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Variations.class);
  }

  /**
   * Web property ID to which this experiment belongs. The web property ID is of the form UA-XXXXX-
   * YY. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String webPropertyId;

  /**
   * A floating-point number between 0 and 1. Specifies the necessary confidence level to choose a
   * winner. This field may not be changed for an experiments whose status is ENDED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Double winnerConfidenceLevel;

  /**
   * Boolean specifying whether a winner has been found for this experiment. This field is read-
   * only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean winnerFound;

  /**
   * Account ID to which this experiment belongs. This field is read-only.
   * The value returned may be {@code null}.
   */
  public String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this experiment belongs. This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setAccountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Time the experiment was created. This field is read-only.
   * The value returned may be {@code null}.
   */
  public DateTime getCreated() {
    return created;
  }

  /**
   * Time the experiment was created. This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setCreated(DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Notes about this experiment.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * Notes about this experiment.
   * The value set may be {@code null}.
   */
  public Experiment setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * If true, the end user will be able to edit the experiment via the Google Analytics user
   * interface.
   * The value returned may be {@code null}.
   */
  public Object getEditableInGaUi() {
    return editableInGaUi;
  }

  /**
   * If true, the end user will be able to edit the experiment via the Google Analytics user
   * interface.
   * The value set may be {@code null}.
   */
  public Experiment setEditableInGaUi(Object editableInGaUi) {
    this.editableInGaUi = editableInGaUi;
    return this;
  }

  /**
   * The ending time of the experiment (the time the status changed from RUNNING to ENDED). This
   * field is present only if the experiment has ended. This field is read-only.
   * The value returned may be {@code null}.
   */
  public DateTime getEndTime() {
    return endTime;
  }

  /**
   * The ending time of the experiment (the time the status changed from RUNNING to ENDED). This
   * field is present only if the experiment has ended. This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setEndTime(DateTime endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Experiment ID. Required for patch and update. Disallowed for create.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * Experiment ID. Required for patch and update. Disallowed for create.
   * The value set may be {@code null}.
   */
  public Experiment setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Internal ID for the web property to which this experiment belongs. This field is read-only.
   * The value returned may be {@code null}.
   */
  public String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for the web property to which this experiment belongs. This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setInternalWebPropertyId(String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Resource type for an Analytics experiment. This field is read-only.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Resource type for an Analytics experiment. This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Specifies the minimum length of the experiment. Can be changed for a running experiment. This
   * field may not be changed for an experiments whose status is ENDED.
   * The value returned may be {@code null}.
   */
  public Integer getMinimumExperimentLengthInDays() {
    return minimumExperimentLengthInDays;
  }

  /**
   * Specifies the minimum length of the experiment. Can be changed for a running experiment. This
   * field may not be changed for an experiments whose status is ENDED.
   * The value set may be {@code null}.
   */
  public Experiment setMinimumExperimentLengthInDays(Integer minimumExperimentLengthInDays) {
    this.minimumExperimentLengthInDays = minimumExperimentLengthInDays;
    return this;
  }

  /**
   * Experiment name. This field may not be changed for an experiment whose status is ENDED. This
   * field is required when creating an experiment.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Experiment name. This field may not be changed for an experiment whose status is ENDED. This
   * field is required when creating an experiment.
   * The value set may be {@code null}.
   */
  public Experiment setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * The metric that the experiment is optimizing. Valid values: "ga:goal(n)Completions",
   * "ga:bounces", "ga:pageviews", "ga:timeOnSite", "ga:transactions", "ga:transactionRevenue". This
   * field is required if status is "RUNNING" and servingFramework is one of "REDIRECT" or "API".
   * The value returned may be {@code null}.
   */
  public String getObjectiveMetric() {
    return objectiveMetric;
  }

  /**
   * The metric that the experiment is optimizing. Valid values: "ga:goal(n)Completions",
   * "ga:bounces", "ga:pageviews", "ga:timeOnSite", "ga:transactions", "ga:transactionRevenue". This
   * field is required if status is "RUNNING" and servingFramework is one of "REDIRECT" or "API".
   * The value set may be {@code null}.
   */
  public Experiment setObjectiveMetric(String objectiveMetric) {
    this.objectiveMetric = objectiveMetric;
    return this;
  }

  /**
   * Whether the objectiveMetric should be minimized or maximized. Possible values: "MAXIMUM",
   * "MINIMUM". Optional--defaults to "MAXIMUM". Cannot be specified without objectiveMetric. Cannot
   * be modified when status is "RUNNING" or "ENDED".
   * The value returned may be {@code null}.
   */
  public String getOptimizationType() {
    return optimizationType;
  }

  /**
   * Whether the objectiveMetric should be minimized or maximized. Possible values: "MAXIMUM",
   * "MINIMUM". Optional--defaults to "MAXIMUM". Cannot be specified without objectiveMetric. Cannot
   * be modified when status is "RUNNING" or "ENDED".
   * The value set may be {@code null}.
   */
  public Experiment setOptimizationType(String optimizationType) {
    this.optimizationType = optimizationType;
    return this;
  }

  /**
   * Parent link for an experiment. Points to the profile to which this experiment belongs.
   * The value returned may be {@code null}.
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for an experiment. Points to the profile to which this experiment belongs.
   * The value set may be {@code null}.
   */
  public Experiment setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * Profile ID to which this experiment belongs. This field is read-only.
   * The value returned may be {@code null}.
   */
  public String getProfileId() {
    return profileId;
  }

  /**
   * Profile ID to which this experiment belongs. This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setProfileId(String profileId) {
    this.profileId = profileId;
    return this;
  }

  /**
   * Why the experiment ended. Possible values: "STOPPED_BY_USER", "WINNER_FOUND",
   * "EXPERIMENT_EXPIRED", "ENDED_WITH_NO_WINNER", "GOAL_OBJECTIVE_CHANGED". "ENDED_WITH_NO_WINNER"
   * means that the experiment didn't expire but no winner was projected to be found. If the
   * experiment status is changed via the API to ENDED this field is set to STOPPED_BY_USER. This
   * field is read-only.
   * The value returned may be {@code null}.
   */
  public String getReasonExperimentEnded() {
    return reasonExperimentEnded;
  }

  /**
   * Why the experiment ended. Possible values: "STOPPED_BY_USER", "WINNER_FOUND",
   * "EXPERIMENT_EXPIRED", "ENDED_WITH_NO_WINNER", "GOAL_OBJECTIVE_CHANGED". "ENDED_WITH_NO_WINNER"
   * means that the experiment didn't expire but no winner was projected to be found. If the
   * experiment status is changed via the API to ENDED this field is set to STOPPED_BY_USER. This
   * field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setReasonExperimentEnded(String reasonExperimentEnded) {
    this.reasonExperimentEnded = reasonExperimentEnded;
    return this;
  }

  /**
   * Boolean specifying whether variations URLS are rewritten to match those of the original. This
   * field may not be changed for an experiments whose status is ENDED.
   * The value returned may be {@code null}.
   */
  public Boolean getRewriteVariationUrlsAsOriginal() {
    return rewriteVariationUrlsAsOriginal;
  }

  /**
   * Boolean specifying whether variations URLS are rewritten to match those of the original. This
   * field may not be changed for an experiments whose status is ENDED.
   * The value set may be {@code null}.
   */
  public Experiment setRewriteVariationUrlsAsOriginal(Boolean rewriteVariationUrlsAsOriginal) {
    this.rewriteVariationUrlsAsOriginal = rewriteVariationUrlsAsOriginal;
    return this;
  }

  /**
   * Link for this experiment. This field is read-only.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this experiment. This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The framework used to serve the experiment variations and evaluate the results. One of: -
   * REDIRECT: Google Analytics redirects traffic to different variation pages, reports the chosen
   * variation and evaluates the results. - API: Google Analytics chooses and reports the variation
   * to serve and evaluates the results; the caller is responsible for serving the selected
   * variation. - EXTERNAL: The variations will be served externally and the chosen variation
   * reported to Google Analytics. The caller is responsible for serving the selected variation and
   * evaluating the results.
   * The value returned may be {@code null}.
   */
  public Object getServingFramework() {
    return servingFramework;
  }

  /**
   * The framework used to serve the experiment variations and evaluate the results. One of: -
   * REDIRECT: Google Analytics redirects traffic to different variation pages, reports the chosen
   * variation and evaluates the results. - API: Google Analytics chooses and reports the variation
   * to serve and evaluates the results; the caller is responsible for serving the selected
   * variation. - EXTERNAL: The variations will be served externally and the chosen variation
   * reported to Google Analytics. The caller is responsible for serving the selected variation and
   * evaluating the results.
   * The value set may be {@code null}.
   */
  public Experiment setServingFramework(Object servingFramework) {
    this.servingFramework = servingFramework;
    return this;
  }

  /**
   * The snippet of code to include on the control page(s). This field is read-only.
   * The value returned may be {@code null}.
   */
  public String getSnippet() {
    return snippet;
  }

  /**
   * The snippet of code to include on the control page(s). This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setSnippet(String snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The starting time of the experiment (the time the status changed from READY_TO_RUN to RUNNING).
   * This field is present only if the experiment has started. This field is read-only.
   * The value returned may be {@code null}.
   */
  public DateTime getStartTime() {
    return startTime;
  }

  /**
   * The starting time of the experiment (the time the status changed from READY_TO_RUN to RUNNING).
   * This field is present only if the experiment has started. This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setStartTime(DateTime startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Experiment status. Possible values: "DRAFT", "READY_TO_RUN", "RUNNING", "ENDED". Experiments
   * can be created in the "DRAFT", "READY_TO_RUN" or "RUNNING" state. This field is required when
   * creating an experiment.
   * The value returned may be {@code null}.
   */
  public String getStatus() {
    return status;
  }

  /**
   * Experiment status. Possible values: "DRAFT", "READY_TO_RUN", "RUNNING", "ENDED". Experiments
   * can be created in the "DRAFT", "READY_TO_RUN" or "RUNNING" state. This field is required when
   * creating an experiment.
   * The value set may be {@code null}.
   */
  public Experiment setStatus(String status) {
    this.status = status;
    return this;
  }

  /**
   * A floating-point number between 0 and 1. Specifies the fraction of the traffic that
   * participates in the experiment. Can be changed for a running experiment. This field may not be
   * changed for an experiments whose status is ENDED.
   * The value returned may be {@code null}.
   */
  public Double getTrafficCoverage() {
    return trafficCoverage;
  }

  /**
   * A floating-point number between 0 and 1. Specifies the fraction of the traffic that
   * participates in the experiment. Can be changed for a running experiment. This field may not be
   * changed for an experiments whose status is ENDED.
   * The value set may be {@code null}.
   */
  public Experiment setTrafficCoverage(Double trafficCoverage) {
    this.trafficCoverage = trafficCoverage;
    return this;
  }

  /**
   * Time the experiment was last modified. This field is read-only.
   * The value returned may be {@code null}.
   */
  public DateTime getUpdated() {
    return updated;
  }

  /**
   * Time the experiment was last modified. This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Array of variations. The first variation in the array is the original. The number of variations
   * may not change once an experiment is in the RUNNING state. At least two variations are required
   * before status can be set to RUNNING.
   * The value returned may be {@code null}.
   */
  public java.util.List<Variations> getVariations() {
    return variations;
  }

  /**
   * Array of variations. The first variation in the array is the original. The number of variations
   * may not change once an experiment is in the RUNNING state. At least two variations are required
   * before status can be set to RUNNING.
   * The value set may be {@code null}.
   */
  public Experiment setVariations(java.util.List<Variations> variations) {
    this.variations = variations;
    return this;
  }

  /**
   * Web property ID to which this experiment belongs. The web property ID is of the form UA-XXXXX-
   * YY. This field is read-only.
   * The value returned may be {@code null}.
   */
  public String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID to which this experiment belongs. The web property ID is of the form UA-XXXXX-
   * YY. This field is read-only.
   * The value set may be {@code null}.
   */
  public Experiment setWebPropertyId(String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  /**
   * A floating-point number between 0 and 1. Specifies the necessary confidence level to choose a
   * winner. This field may not be changed for an experiments whose status is ENDED.
   * The value returned may be {@code null}.
   */
  public Double getWinnerConfidenceLevel() {
    return winnerConfidenceLevel;
  }

  /**
   * A floating-point number between 0 and 1. Specifies the necessary confidence level to choose a
   * winner. This field may not be changed for an experiments whose status is ENDED.
   * The value set may be {@code null}.
   */
  public Experiment setWinnerConfidenceLevel(Double winnerConfidenceLevel) {
    this.winnerConfidenceLevel = winnerConfidenceLevel;
    return this;
  }

  /**
   * Boolean specifying whether a winner has been found for this experiment. This field is read-
   * only.
   * The value returned may be {@code null}.
   */
  public Boolean getWinnerFound() {
    return winnerFound;
  }

  /**
   * Boolean specifying whether a winner has been found for this experiment. This field is read-
   * only.
   * The value set may be {@code null}.
   */
  public Experiment setWinnerFound(Boolean winnerFound) {
    this.winnerFound = winnerFound;
    return this;
  }

  /**
   * Parent link for an experiment. Points to the profile to which this experiment belongs.
   */
  public static final class ParentLink extends GenericJson {

    /**
     * Link to the profile to which this experiment belongs. This field is read-only.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String href;

    /**
     * Value is "analytics#profile". This field is read-only.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * Link to the profile to which this experiment belongs. This field is read-only.
     * The value returned may be {@code null}.
     */
    public String getHref() {
      return href;
    }

    /**
     * Link to the profile to which this experiment belongs. This field is read-only.
     * The value set may be {@code null}.
     */
    public ParentLink setHref(String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#profile". This field is read-only.
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * Value is "analytics#profile". This field is read-only.
     * The value set may be {@code null}.
     */
    public ParentLink setType(String type) {
      this.type = type;
      return this;
    }

  }

  /**
   * Model definition for ExperimentVariations.
   */
  public static final class Variations extends GenericJson {

    /**
     * The name of the variation. This field is required when creating an experiment. This field may
     * not be changed for an experiment whose status is ENDED.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String name;

    /**
     * Status of the variation. Possible values: "ACTIVE", "INACTIVE". INACTIVE variations are not
     * served. This field may not be changed for an experiment whose status is ENDED.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String status;

    /**
     * The URL of the variation. This field may not be changed for an experiment whose status is
     * RUNNING or ENDED.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String url;

    /**
     * Weight that this variation should receive. Only present if the experiment is running. This
     * field is read-only.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Double weight;

    /**
     * True if the experiment has ended and this variation performed (statistically) significantly
     * better than the original. This field is read-only.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean won;

    /**
     * The name of the variation. This field is required when creating an experiment. This field may
     * not be changed for an experiment whose status is ENDED.
     * The value returned may be {@code null}.
     */
    public String getName() {
      return name;
    }

    /**
     * The name of the variation. This field is required when creating an experiment. This field may
     * not be changed for an experiment whose status is ENDED.
     * The value set may be {@code null}.
     */
    public Variations setName(String name) {
      this.name = name;
      return this;
    }

    /**
     * Status of the variation. Possible values: "ACTIVE", "INACTIVE". INACTIVE variations are not
     * served. This field may not be changed for an experiment whose status is ENDED.
     * The value returned may be {@code null}.
     */
    public String getStatus() {
      return status;
    }

    /**
     * Status of the variation. Possible values: "ACTIVE", "INACTIVE". INACTIVE variations are not
     * served. This field may not be changed for an experiment whose status is ENDED.
     * The value set may be {@code null}.
     */
    public Variations setStatus(String status) {
      this.status = status;
      return this;
    }

    /**
     * The URL of the variation. This field may not be changed for an experiment whose status is
     * RUNNING or ENDED.
     * The value returned may be {@code null}.
     */
    public String getUrl() {
      return url;
    }

    /**
     * The URL of the variation. This field may not be changed for an experiment whose status is
     * RUNNING or ENDED.
     * The value set may be {@code null}.
     */
    public Variations setUrl(String url) {
      this.url = url;
      return this;
    }

    /**
     * Weight that this variation should receive. Only present if the experiment is running. This
     * field is read-only.
     * The value returned may be {@code null}.
     */
    public Double getWeight() {
      return weight;
    }

    /**
     * Weight that this variation should receive. Only present if the experiment is running. This
     * field is read-only.
     * The value set may be {@code null}.
     */
    public Variations setWeight(Double weight) {
      this.weight = weight;
      return this;
    }

    /**
     * True if the experiment has ended and this variation performed (statistically) significantly
     * better than the original. This field is read-only.
     * The value returned may be {@code null}.
     */
    public Boolean getWon() {
      return won;
    }

    /**
     * True if the experiment has ended and this variation performed (statistically) significantly
     * better than the original. This field is read-only.
     * The value set may be {@code null}.
     */
    public Variations setWon(Boolean won) {
      this.won = won;
      return this;
    }

  }

}
