/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * JSON template for an Analytics custom data source.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomDataSource extends GenericJson {

  /**
   * Account ID to which this custom data source belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String accountId;

  /**
   * Child link for this custom data source. Points to the list of daily uploads for this custom
   * data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChildLink childLink;

  /**
   * Time this custom data source was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime created;

  /**
   * Description of custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Custom data source ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * Resource type for Analytics custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of this custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Parent link for this custom data source. Points to the web property to which this custom data
   * source belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * IDs of profiles linked to the custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> profilesLinked;

  /**
   * Link for this Analytics custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Time this custom data source was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime updated;

  /**
   * Web property ID of the form UA-XXXXX-YY to which this custom data source belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String webPropertyId;

  /**
   * Account ID to which this custom data source belongs.
   * The value returned may be {@code null}.
   */
  public String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this custom data source belongs.
   * The value set may be {@code null}.
   */
  public CustomDataSource setAccountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Child link for this custom data source. Points to the list of daily uploads for this custom
   * data source.
   * The value returned may be {@code null}.
   */
  public ChildLink getChildLink() {
    return childLink;
  }

  /**
   * Child link for this custom data source. Points to the list of daily uploads for this custom
   * data source.
   * The value set may be {@code null}.
   */
  public CustomDataSource setChildLink(ChildLink childLink) {
    this.childLink = childLink;
    return this;
  }

  /**
   * Time this custom data source was created.
   * The value returned may be {@code null}.
   */
  public DateTime getCreated() {
    return created;
  }

  /**
   * Time this custom data source was created.
   * The value set may be {@code null}.
   */
  public CustomDataSource setCreated(DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Description of custom data source.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * Description of custom data source.
   * The value set may be {@code null}.
   */
  public CustomDataSource setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Custom data source ID.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * Custom data source ID.
   * The value set may be {@code null}.
   */
  public CustomDataSource setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Resource type for Analytics custom data source.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics custom data source.
   * The value set may be {@code null}.
   */
  public CustomDataSource setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this custom data source.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of this custom data source.
   * The value set may be {@code null}.
   */
  public CustomDataSource setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Parent link for this custom data source. Points to the web property to which this custom data
   * source belongs.
   * The value returned may be {@code null}.
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for this custom data source. Points to the web property to which this custom data
   * source belongs.
   * The value set may be {@code null}.
   */
  public CustomDataSource setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * IDs of profiles linked to the custom data source.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getProfilesLinked() {
    return profilesLinked;
  }

  /**
   * IDs of profiles linked to the custom data source.
   * The value set may be {@code null}.
   */
  public CustomDataSource setProfilesLinked(java.util.List<String> profilesLinked) {
    this.profilesLinked = profilesLinked;
    return this;
  }

  /**
   * Link for this Analytics custom data source.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this Analytics custom data source.
   * The value set may be {@code null}.
   */
  public CustomDataSource setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Time this custom data source was last modified.
   * The value returned may be {@code null}.
   */
  public DateTime getUpdated() {
    return updated;
  }

  /**
   * Time this custom data source was last modified.
   * The value set may be {@code null}.
   */
  public CustomDataSource setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this custom data source belongs.
   * The value returned may be {@code null}.
   */
  public String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this custom data source belongs.
   * The value set may be {@code null}.
   */
  public CustomDataSource setWebPropertyId(String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  /**
   * Child link for this custom data source. Points to the list of daily uploads for this custom data
   * source.
   */
  public static final class ChildLink extends GenericJson {

    /**
     * Link to the list of daily uploads for this custom data source.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String href;

    /**
     * Value is "analytics#dailyUploads".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * Link to the list of daily uploads for this custom data source.
     * The value returned may be {@code null}.
     */
    public String getHref() {
      return href;
    }

    /**
     * Link to the list of daily uploads for this custom data source.
     * The value set may be {@code null}.
     */
    public ChildLink setHref(String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#dailyUploads".
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * Value is "analytics#dailyUploads".
     * The value set may be {@code null}.
     */
    public ChildLink setType(String type) {
      this.type = type;
      return this;
    }

  }

  /**
   * Parent link for this custom data source. Points to the web property to which this custom data
   * source belongs.
   */
  public static final class ParentLink extends GenericJson {

    /**
     * Link to the web property to which this custom data source belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String href;

    /**
     * Value is "analytics#webproperty".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * Link to the web property to which this custom data source belongs.
     * The value returned may be {@code null}.
     */
    public String getHref() {
      return href;
    }

    /**
     * Link to the web property to which this custom data source belongs.
     * The value set may be {@code null}.
     */
    public ParentLink setHref(String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#webproperty".
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * Value is "analytics#webproperty".
     * The value set may be {@code null}.
     */
    public ParentLink setType(String type) {
      this.type = type;
      return this;
    }

  }

}
