/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * JSON template for Analytics account entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Account extends GenericJson {

  /**
   * Child link for an account entry. Points to the list of web properties for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChildLink childLink;

  /**
   * Time the account was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime created;

  /**
   * Account ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * Resource type for Analytics account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Account name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Link for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Time the account was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime updated;

  /**
   * Child link for an account entry. Points to the list of web properties for this account.
   * The value returned may be {@code null}.
   */
  public ChildLink getChildLink() {
    return childLink;
  }

  /**
   * Child link for an account entry. Points to the list of web properties for this account.
   * The value set may be {@code null}.
   */
  public Account setChildLink(ChildLink childLink) {
    this.childLink = childLink;
    return this;
  }

  /**
   * Time the account was created.
   * The value returned may be {@code null}.
   */
  public DateTime getCreated() {
    return created;
  }

  /**
   * Time the account was created.
   * The value set may be {@code null}.
   */
  public Account setCreated(DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Account ID.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * Account ID.
   * The value set may be {@code null}.
   */
  public Account setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Resource type for Analytics account.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics account.
   * The value set may be {@code null}.
   */
  public Account setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Account name.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Account name.
   * The value set may be {@code null}.
   */
  public Account setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Link for this account.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this account.
   * The value set may be {@code null}.
   */
  public Account setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Time the account was last modified.
   * The value returned may be {@code null}.
   */
  public DateTime getUpdated() {
    return updated;
  }

  /**
   * Time the account was last modified.
   * The value set may be {@code null}.
   */
  public Account setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Child link for an account entry. Points to the list of web properties for this account.
   */
  public static final class ChildLink extends GenericJson {

    /**
     * Link to the list of web properties for this account.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String href;

    /**
     * Type of the child link. Its value is "analytics#webproperties".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * Link to the list of web properties for this account.
     * The value returned may be {@code null}.
     */
    public String getHref() {
      return href;
    }

    /**
     * Link to the list of web properties for this account.
     * The value set may be {@code null}.
     */
    public ChildLink setHref(String href) {
      this.href = href;
      return this;
    }

    /**
     * Type of the child link. Its value is "analytics#webproperties".
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * Type of the child link. Its value is "analytics#webproperties".
     * The value set may be {@code null}.
     */
    public ChildLink setType(String type) {
      this.type = type;
      return this;
    }

  }

}
