/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-01-30 at 07:10:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * An unsampled report collection lists Analytics unsampled reports to which the user has access.
 * Each view (profile) can have a set of unsampled reports. Each resource in the unsampled report
 * collection corresponds to a single Analytics unsampled report.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UnsampledReports extends com.google.api.client.json.GenericJson {

  /**
   * A list of unsampled reports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UnsampledReport> items;

  static {
    // hack to force ProGuard to consider UnsampledReport used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(UnsampledReport.class);
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer itemsPerPage;

  /**
   * Collection type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Link to next page for this unsampled report collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextLink;

  /**
   * Link to previous page for this unsampled report collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String previousLink;

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * The total number of results for the query, regardless of the number of resources in the result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalResults;

  /**
   * Email ID of the authenticated user
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String username;

  /**
   * A list of unsampled reports.
   * @return value or {@code null} for none
   */
  public java.util.List<UnsampledReport> getItems() {
    return items;
  }

  /**
   * A list of unsampled reports.
   * @param items items or {@code null} for none
   */
  public UnsampledReports setItems(java.util.List<UnsampledReport> items) {
    this.items = items;
    return this;
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getItemsPerPage() {
    return itemsPerPage;
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * @param itemsPerPage itemsPerPage or {@code null} for none
   */
  public UnsampledReports setItemsPerPage(java.lang.Integer itemsPerPage) {
    this.itemsPerPage = itemsPerPage;
    return this;
  }

  /**
   * Collection type.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Collection type.
   * @param kind kind or {@code null} for none
   */
  public UnsampledReports setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Link to next page for this unsampled report collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextLink() {
    return nextLink;
  }

  /**
   * Link to next page for this unsampled report collection.
   * @param nextLink nextLink or {@code null} for none
   */
  public UnsampledReports setNextLink(java.lang.String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * Link to previous page for this unsampled report collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getPreviousLink() {
    return previousLink;
  }

  /**
   * Link to previous page for this unsampled report collection.
   * @param previousLink previousLink or {@code null} for none
   */
  public UnsampledReports setPreviousLink(java.lang.String previousLink) {
    this.previousLink = previousLink;
    return this;
  }

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * @param startIndex startIndex or {@code null} for none
   */
  public UnsampledReports setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * The total number of results for the query, regardless of the number of resources in the result.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalResults() {
    return totalResults;
  }

  /**
   * The total number of results for the query, regardless of the number of resources in the result.
   * @param totalResults totalResults or {@code null} for none
   */
  public UnsampledReports setTotalResults(java.lang.Integer totalResults) {
    this.totalResults = totalResults;
    return this;
  }

  /**
   * Email ID of the authenticated user
   * @return value or {@code null} for none
   */
  public java.lang.String getUsername() {
    return username;
  }

  /**
   * Email ID of the authenticated user
   * @param username username or {@code null} for none
   */
  public UnsampledReports setUsername(java.lang.String username) {
    this.username = username;
    return this;
  }

  @Override
  public UnsampledReports set(String fieldName, Object value) {
    return (UnsampledReports) super.set(fieldName, value);
  }

  @Override
  public UnsampledReports clone() {
    return (UnsampledReports) super.clone();
  }

}
