/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-20 at 11:23:34 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics profile filter link.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProfileFilterLink extends com.google.api.client.json.GenericJson {

  /**
   * Filter for this link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FilterRef filterRef;

  /**
   * Profile filter link ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Resource type for Analytics filter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * View (Profile) for this link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProfileRef profileRef;

  /**
   * The rank of this profile filter link relative to the other filters linked to the same profile.
   * For readonly (i.e., list and get) operations, the rank always starts at 1. For write (i.e.,
   * create, update, or delete) operations, you may specify a value between 0 and 255 inclusively,
   * [0, 255]. In order to insert a link at the end of the list, either don't specify a rank or set
   * a rank to a number greater than the largest rank in the list. In order to insert a link to the
   * beginning of the list specify a rank that is less than or equal to 1. The new link will move
   * all existing filters with the same or lower rank down the list. After the link is
   * inserted/updated/deleted all profile filter links will be renumbered starting at 1.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer rank;

  /**
   * Link for this profile filter link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Filter for this link.
   * @return value or {@code null} for none
   */
  public FilterRef getFilterRef() {
    return filterRef;
  }

  /**
   * Filter for this link.
   * @param filterRef filterRef or {@code null} for none
   */
  public ProfileFilterLink setFilterRef(FilterRef filterRef) {
    this.filterRef = filterRef;
    return this;
  }

  /**
   * Profile filter link ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Profile filter link ID.
   * @param id id or {@code null} for none
   */
  public ProfileFilterLink setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Resource type for Analytics filter.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics filter.
   * @param kind kind or {@code null} for none
   */
  public ProfileFilterLink setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * View (Profile) for this link.
   * @return value or {@code null} for none
   */
  public ProfileRef getProfileRef() {
    return profileRef;
  }

  /**
   * View (Profile) for this link.
   * @param profileRef profileRef or {@code null} for none
   */
  public ProfileFilterLink setProfileRef(ProfileRef profileRef) {
    this.profileRef = profileRef;
    return this;
  }

  /**
   * The rank of this profile filter link relative to the other filters linked to the same profile.
   * For readonly (i.e., list and get) operations, the rank always starts at 1. For write (i.e.,
   * create, update, or delete) operations, you may specify a value between 0 and 255 inclusively,
   * [0, 255]. In order to insert a link at the end of the list, either don't specify a rank or set
   * a rank to a number greater than the largest rank in the list. In order to insert a link to the
   * beginning of the list specify a rank that is less than or equal to 1. The new link will move
   * all existing filters with the same or lower rank down the list. After the link is
   * inserted/updated/deleted all profile filter links will be renumbered starting at 1.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRank() {
    return rank;
  }

  /**
   * The rank of this profile filter link relative to the other filters linked to the same profile.
   * For readonly (i.e., list and get) operations, the rank always starts at 1. For write (i.e.,
   * create, update, or delete) operations, you may specify a value between 0 and 255 inclusively,
   * [0, 255]. In order to insert a link at the end of the list, either don't specify a rank or set
   * a rank to a number greater than the largest rank in the list. In order to insert a link to the
   * beginning of the list specify a rank that is less than or equal to 1. The new link will move
   * all existing filters with the same or lower rank down the list. After the link is
   * inserted/updated/deleted all profile filter links will be renumbered starting at 1.
   * @param rank rank or {@code null} for none
   */
  public ProfileFilterLink setRank(java.lang.Integer rank) {
    this.rank = rank;
    return this;
  }

  /**
   * Link for this profile filter link.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this profile filter link.
   * @param selfLink selfLink or {@code null} for none
   */
  public ProfileFilterLink setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public ProfileFilterLink set(String fieldName, Object value) {
    return (ProfileFilterLink) super.set(fieldName, value);
  }

  @Override
  public ProfileFilterLink clone() {
    return (ProfileFilterLink) super.clone();
  }

}
