/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-29 at 18:51:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics Remarketing Include Conditions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IncludeConditions extends com.google.api.client.json.GenericJson {

  /**
   * The look-back window lets you specify a time frame for evaluating the behavior that qualifies
   * users for your audience. For example, if your filters include users from Central Asia, and
   * Transactions Greater than 2, and you set the look-back window to 14 days, then any user from
   * Central Asia whose cumulative transactions exceed 2 during the last 14 days is added to the
   * audience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer daysToLookBack;

  /**
   * Boolean indicating whether this segment is a smart list.
   * https://support.google.com/analytics/answer/4628577
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isSmartList;

  /**
   * Resource type for include conditions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Number of days (in the range 1 to 540) a user remains in the audience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer membershipDurationDays;

  /**
   * The segment condition that will cause a user to be added to an audience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String segment;

  /**
   * The look-back window lets you specify a time frame for evaluating the behavior that qualifies
   * users for your audience. For example, if your filters include users from Central Asia, and
   * Transactions Greater than 2, and you set the look-back window to 14 days, then any user from
   * Central Asia whose cumulative transactions exceed 2 during the last 14 days is added to the
   * audience.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDaysToLookBack() {
    return daysToLookBack;
  }

  /**
   * The look-back window lets you specify a time frame for evaluating the behavior that qualifies
   * users for your audience. For example, if your filters include users from Central Asia, and
   * Transactions Greater than 2, and you set the look-back window to 14 days, then any user from
   * Central Asia whose cumulative transactions exceed 2 during the last 14 days is added to the
   * audience.
   * @param daysToLookBack daysToLookBack or {@code null} for none
   */
  public IncludeConditions setDaysToLookBack(java.lang.Integer daysToLookBack) {
    this.daysToLookBack = daysToLookBack;
    return this;
  }

  /**
   * Boolean indicating whether this segment is a smart list.
   * https://support.google.com/analytics/answer/4628577
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsSmartList() {
    return isSmartList;
  }

  /**
   * Boolean indicating whether this segment is a smart list.
   * https://support.google.com/analytics/answer/4628577
   * @param isSmartList isSmartList or {@code null} for none
   */
  public IncludeConditions setIsSmartList(java.lang.Boolean isSmartList) {
    this.isSmartList = isSmartList;
    return this;
  }

  /**
   * Resource type for include conditions.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for include conditions.
   * @param kind kind or {@code null} for none
   */
  public IncludeConditions setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Number of days (in the range 1 to 540) a user remains in the audience.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMembershipDurationDays() {
    return membershipDurationDays;
  }

  /**
   * Number of days (in the range 1 to 540) a user remains in the audience.
   * @param membershipDurationDays membershipDurationDays or {@code null} for none
   */
  public IncludeConditions setMembershipDurationDays(java.lang.Integer membershipDurationDays) {
    this.membershipDurationDays = membershipDurationDays;
    return this;
  }

  /**
   * The segment condition that will cause a user to be added to an audience.
   * @return value or {@code null} for none
   */
  public java.lang.String getSegment() {
    return segment;
  }

  /**
   * The segment condition that will cause a user to be added to an audience.
   * @param segment segment or {@code null} for none
   */
  public IncludeConditions setSegment(java.lang.String segment) {
    this.segment = segment;
    return this;
  }

  @Override
  public IncludeConditions set(String fieldName, Object value) {
    return (IncludeConditions) super.set(fieldName, value);
  }

  @Override
  public IncludeConditions clone() {
    return (IncludeConditions) super.clone();
  }

}
