/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-05-05 at 19:05:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics;

/**
 * Service definition for Analytics (v3).
 *
 * <p>
 * View and manage your Google Analytics data
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/analytics/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link AnalyticsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Analytics extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.20.0 of the Google Analytics API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "analytics/v3/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Analytics(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Analytics(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Data collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Data.List request = analytics.data().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Data data() {
    return new Data();
  }

  /**
   * The "data" collection of methods.
   */
  public class Data {

    /**
     * An accessor for creating requests from the Ga collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Ga.List request = analytics.ga().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Ga ga() {
      return new Ga();
    }

    /**
     * The "ga" collection of methods.
     */
    public class Ga {

      /**
       * Returns Analytics data for a view (profile).
       *
       * Create a request for the method "ga.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
       * @param startDate Start date for fetching Analytics data. Requests can specify a start date formatted as YYYY-MM-DD,
       *        or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is
       *        7daysAgo.
       * @param endDate End date for fetching Analytics data. Request can should specify an end date formatted as YYYY-MM-
       *        DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is
       *        yesterday.
       * @param metrics A comma-separated list of Analytics metrics. E.g., 'ga:sessions,ga:pageviews'. At least one metric
       *        must be specified.
       * @return the request
       */
      public Get get(java.lang.String ids, java.lang.String startDate, java.lang.String endDate, java.lang.String metrics) throws java.io.IOException {
        Get result = new Get(ids, startDate, endDate, metrics);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.GaData> {

        private static final String REST_PATH = "data/ga";

        private final java.util.regex.Pattern IDS_PATTERN =
            java.util.regex.Pattern.compile("ga:[0-9]+");

        private final java.util.regex.Pattern START_DATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");

        private final java.util.regex.Pattern END_DATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");

        private final java.util.regex.Pattern METRICS_PATTERN =
            java.util.regex.Pattern.compile("ga:.+");

        private final java.util.regex.Pattern SORT_PATTERN =
            java.util.regex.Pattern.compile("(-)?ga:.+");

        private final java.util.regex.Pattern DIMENSIONS_PATTERN =
            java.util.regex.Pattern.compile("(ga:.+)?");

        private final java.util.regex.Pattern FILTERS_PATTERN =
            java.util.regex.Pattern.compile("ga:.+");

        /**
         * Returns Analytics data for a view (profile).
         *
         * Create a request for the method "ga.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
         * @param startDate Start date for fetching Analytics data. Requests can specify a start date formatted as YYYY-MM-DD,
       *        or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is
       *        7daysAgo.
         * @param endDate End date for fetching Analytics data. Request can should specify an end date formatted as YYYY-MM-
       *        DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is
       *        yesterday.
         * @param metrics A comma-separated list of Analytics metrics. E.g., 'ga:sessions,ga:pageviews'. At least one metric
       *        must be specified.
         * @since 1.13
         */
        protected Get(java.lang.String ids, java.lang.String startDate, java.lang.String endDate, java.lang.String metrics) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.GaData.class);
          this.ids = com.google.api.client.util.Preconditions.checkNotNull(ids, "Required parameter ids must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.startDate = com.google.api.client.util.Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(START_DATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
          }
          this.endDate = com.google.api.client.util.Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(END_DATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
          }
          this.metrics = com.google.api.client.util.Preconditions.checkNotNull(metrics, "Required parameter metrics must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "ga:.+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /**
         * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String ids;

        /** Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       Analytics view (profile) ID.
         */
        public java.lang.String getIds() {
          return ids;
        }

        /**
         * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        public Get setIds(java.lang.String ids) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.ids = ids;
          return this;
        }

        /**
         * Start date for fetching Analytics data. Requests can specify a start date formatted as
         * YYYY-MM-DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default
         * value is 7daysAgo.
         */
        @com.google.api.client.util.Key("start-date")
        private java.lang.String startDate;

        /** Start date for fetching Analytics data. Requests can specify a start date formatted as YYYY-MM-DD,
       or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is 7daysAgo.
         */
        public java.lang.String getStartDate() {
          return startDate;
        }

        /**
         * Start date for fetching Analytics data. Requests can specify a start date formatted as
         * YYYY-MM-DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default
         * value is 7daysAgo.
         */
        public Get setStartDate(java.lang.String startDate) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(START_DATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
          }
          this.startDate = startDate;
          return this;
        }

        /**
         * End date for fetching Analytics data. Request can should specify an end date formatted as
         * YYYY-MM-DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default
         * value is yesterday.
         */
        @com.google.api.client.util.Key("end-date")
        private java.lang.String endDate;

        /** End date for fetching Analytics data. Request can should specify an end date formatted as YYYY-MM-
       DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is yesterday.
         */
        public java.lang.String getEndDate() {
          return endDate;
        }

        /**
         * End date for fetching Analytics data. Request can should specify an end date formatted as
         * YYYY-MM-DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default
         * value is yesterday.
         */
        public Get setEndDate(java.lang.String endDate) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(END_DATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
          }
          this.endDate = endDate;
          return this;
        }

        /**
         * A comma-separated list of Analytics metrics. E.g., 'ga:sessions,ga:pageviews'. At least
         * one metric must be specified.
         */
        @com.google.api.client.util.Key
        private java.lang.String metrics;

        /** A comma-separated list of Analytics metrics. E.g., 'ga:sessions,ga:pageviews'. At least one metric
       must be specified.
         */
        public java.lang.String getMetrics() {
          return metrics;
        }

        /**
         * A comma-separated list of Analytics metrics. E.g., 'ga:sessions,ga:pageviews'. At least
         * one metric must be specified.
         */
        public Get setMetrics(java.lang.String metrics) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "ga:.+");
          }
          this.metrics = metrics;
          return this;
        }

        /** The maximum number of entries to include in this feed. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of entries to include in this feed.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of entries to include in this feed. */
        public Get setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for
         * Analytics data.
         */
        @com.google.api.client.util.Key
        private java.lang.String sort;

        /** A comma-separated list of dimensions or metrics that determine the sort order for Analytics data.
         */
        public java.lang.String getSort() {
          return sort;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for
         * Analytics data.
         */
        public Get setSort(java.lang.String sort) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SORT_PATTERN.matcher(sort).matches(),
                "Parameter sort must conform to the pattern " +
                "(-)?ga:.+");
          }
          this.sort = sort;
          return this;
        }

        /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'. */
        @com.google.api.client.util.Key
        private java.lang.String dimensions;

        /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'.
         */
        public java.lang.String getDimensions() {
          return dimensions;
        }

        /** A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'. */
        public Get setDimensions(java.lang.String dimensions) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(DIMENSIONS_PATTERN.matcher(dimensions).matches(),
                "Parameter dimensions must conform to the pattern " +
                "(ga:.+)?");
          }
          this.dimensions = dimensions;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public Get setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        /** An Analytics segment to be applied to data. */
        @com.google.api.client.util.Key
        private java.lang.String segment;

        /** An Analytics segment to be applied to data.
         */
        public java.lang.String getSegment() {
          return segment;
        }

        /** An Analytics segment to be applied to data. */
        public Get setSegment(java.lang.String segment) {
          this.segment = segment;
          return this;
        }

        /** The desired sampling level. */
        @com.google.api.client.util.Key
        private java.lang.String samplingLevel;

        /** The desired sampling level.
         */
        public java.lang.String getSamplingLevel() {
          return samplingLevel;
        }

        /** The desired sampling level. */
        public Get setSamplingLevel(java.lang.String samplingLevel) {
          this.samplingLevel = samplingLevel;
          return this;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to Analytics data.
         */
        @com.google.api.client.util.Key
        private java.lang.String filters;

        /** A comma-separated list of dimension or metric filters to be applied to Analytics data.
         */
        public java.lang.String getFilters() {
          return filters;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to Analytics data.
         */
        public Get setFilters(java.lang.String filters) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(FILTERS_PATTERN.matcher(filters).matches(),
                "Parameter filters must conform to the pattern " +
                "ga:.+");
          }
          this.filters = filters;
          return this;
        }

        /** The selected format for the response. Default format is JSON. */
        @com.google.api.client.util.Key
        private java.lang.String output;

        /** The selected format for the response. Default format is JSON.
         */
        public java.lang.String getOutput() {
          return output;
        }

        /** The selected format for the response. Default format is JSON. */
        public Get setOutput(java.lang.String output) {
          this.output = output;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Mcf collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Mcf.List request = analytics.mcf().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Mcf mcf() {
      return new Mcf();
    }

    /**
     * The "mcf" collection of methods.
     */
    public class Mcf {

      /**
       * Returns Analytics Multi-Channel Funnels data for a view (profile).
       *
       * Create a request for the method "mcf.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
       * @param startDate Start date for fetching Analytics data. Requests can specify a start date formatted as YYYY-MM-DD,
       *        or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is
       *        7daysAgo.
       * @param endDate End date for fetching Analytics data. Requests can specify a start date formatted as YYYY-MM-DD, or
       *        as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is 7daysAgo.
       * @param metrics A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       *        'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
       * @return the request
       */
      public Get get(java.lang.String ids, java.lang.String startDate, java.lang.String endDate, java.lang.String metrics) throws java.io.IOException {
        Get result = new Get(ids, startDate, endDate, metrics);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.McfData> {

        private static final String REST_PATH = "data/mcf";

        private final java.util.regex.Pattern IDS_PATTERN =
            java.util.regex.Pattern.compile("ga:[0-9]+");

        private final java.util.regex.Pattern START_DATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");

        private final java.util.regex.Pattern END_DATE_PATTERN =
            java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");

        private final java.util.regex.Pattern METRICS_PATTERN =
            java.util.regex.Pattern.compile("mcf:.+");

        private final java.util.regex.Pattern SORT_PATTERN =
            java.util.regex.Pattern.compile("(-)?mcf:.+");

        private final java.util.regex.Pattern DIMENSIONS_PATTERN =
            java.util.regex.Pattern.compile("(mcf:.+)?");

        private final java.util.regex.Pattern FILTERS_PATTERN =
            java.util.regex.Pattern.compile("mcf:.+");

        /**
         * Returns Analytics Multi-Channel Funnels data for a view (profile).
         *
         * Create a request for the method "mcf.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
         * @param startDate Start date for fetching Analytics data. Requests can specify a start date formatted as YYYY-MM-DD,
       *        or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is
       *        7daysAgo.
         * @param endDate End date for fetching Analytics data. Requests can specify a start date formatted as YYYY-MM-DD, or
       *        as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is 7daysAgo.
         * @param metrics A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       *        'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
         * @since 1.13
         */
        protected Get(java.lang.String ids, java.lang.String startDate, java.lang.String endDate, java.lang.String metrics) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.McfData.class);
          this.ids = com.google.api.client.util.Preconditions.checkNotNull(ids, "Required parameter ids must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.startDate = com.google.api.client.util.Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(START_DATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
          }
          this.endDate = com.google.api.client.util.Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(END_DATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
          }
          this.metrics = com.google.api.client.util.Preconditions.checkNotNull(metrics, "Required parameter metrics must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "mcf:.+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /**
         * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String ids;

        /** Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the
       Analytics view (profile) ID.
         */
        public java.lang.String getIds() {
          return ids;
        }

        /**
         * Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        public Get setIds(java.lang.String ids) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.ids = ids;
          return this;
        }

        /**
         * Start date for fetching Analytics data. Requests can specify a start date formatted as
         * YYYY-MM-DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default
         * value is 7daysAgo.
         */
        @com.google.api.client.util.Key("start-date")
        private java.lang.String startDate;

        /** Start date for fetching Analytics data. Requests can specify a start date formatted as YYYY-MM-DD,
       or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is 7daysAgo.
         */
        public java.lang.String getStartDate() {
          return startDate;
        }

        /**
         * Start date for fetching Analytics data. Requests can specify a start date formatted as
         * YYYY-MM-DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default
         * value is 7daysAgo.
         */
        public Get setStartDate(java.lang.String startDate) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(START_DATE_PATTERN.matcher(startDate).matches(),
                "Parameter startDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
          }
          this.startDate = startDate;
          return this;
        }

        /**
         * End date for fetching Analytics data. Requests can specify a start date formatted as
         * YYYY-MM-DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default
         * value is 7daysAgo.
         */
        @com.google.api.client.util.Key("end-date")
        private java.lang.String endDate;

        /** End date for fetching Analytics data. Requests can specify a start date formatted as YYYY-MM-DD, or
       as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is 7daysAgo.
         */
        public java.lang.String getEndDate() {
          return endDate;
        }

        /**
         * End date for fetching Analytics data. Requests can specify a start date formatted as
         * YYYY-MM-DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default
         * value is 7daysAgo.
         */
        public Get setEndDate(java.lang.String endDate) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(END_DATE_PATTERN.matcher(endDate).matches(),
                "Parameter endDate must conform to the pattern " +
                "[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
          }
          this.endDate = endDate;
          return this;
        }

        /**
         * A comma-separated list of Multi-Channel Funnels metrics. E.g.,
         * 'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
         */
        @com.google.api.client.util.Key
        private java.lang.String metrics;

        /** A comma-separated list of Multi-Channel Funnels metrics. E.g.,
       'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
         */
        public java.lang.String getMetrics() {
          return metrics;
        }

        /**
         * A comma-separated list of Multi-Channel Funnels metrics. E.g.,
         * 'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
         */
        public Get setMetrics(java.lang.String metrics) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "mcf:.+");
          }
          this.metrics = metrics;
          return this;
        }

        /** The maximum number of entries to include in this feed. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of entries to include in this feed.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of entries to include in this feed. */
        public Get setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for the
         * Analytics data.
         */
        @com.google.api.client.util.Key
        private java.lang.String sort;

        /** A comma-separated list of dimensions or metrics that determine the sort order for the Analytics
       data.
         */
        public java.lang.String getSort() {
          return sort;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for the
         * Analytics data.
         */
        public Get setSort(java.lang.String sort) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SORT_PATTERN.matcher(sort).matches(),
                "Parameter sort must conform to the pattern " +
                "(-)?mcf:.+");
          }
          this.sort = sort;
          return this;
        }

        /**
         * A comma-separated list of Multi-Channel Funnels dimensions. E.g.,
         * 'mcf:source,mcf:medium'.
         */
        @com.google.api.client.util.Key
        private java.lang.String dimensions;

        /** A comma-separated list of Multi-Channel Funnels dimensions. E.g., 'mcf:source,mcf:medium'.
         */
        public java.lang.String getDimensions() {
          return dimensions;
        }

        /**
         * A comma-separated list of Multi-Channel Funnels dimensions. E.g.,
         * 'mcf:source,mcf:medium'.
         */
        public Get setDimensions(java.lang.String dimensions) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(DIMENSIONS_PATTERN.matcher(dimensions).matches(),
                "Parameter dimensions must conform to the pattern " +
                "(mcf:.+)?");
          }
          this.dimensions = dimensions;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public Get setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        /** The desired sampling level. */
        @com.google.api.client.util.Key
        private java.lang.String samplingLevel;

        /** The desired sampling level.
         */
        public java.lang.String getSamplingLevel() {
          return samplingLevel;
        }

        /** The desired sampling level. */
        public Get setSamplingLevel(java.lang.String samplingLevel) {
          this.samplingLevel = samplingLevel;
          return this;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to the Analytics
         * data.
         */
        @com.google.api.client.util.Key
        private java.lang.String filters;

        /** A comma-separated list of dimension or metric filters to be applied to the Analytics data.
         */
        public java.lang.String getFilters() {
          return filters;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to the Analytics
         * data.
         */
        public Get setFilters(java.lang.String filters) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(FILTERS_PATTERN.matcher(filters).matches(),
                "Parameter filters must conform to the pattern " +
                "mcf:.+");
          }
          this.filters = filters;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Realtime collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Realtime.List request = analytics.realtime().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Realtime realtime() {
      return new Realtime();
    }

    /**
     * The "realtime" collection of methods.
     */
    public class Realtime {

      /**
       * Returns real time data for a view (profile).
       *
       * Create a request for the method "realtime.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param ids Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
       * @param metrics A comma-separated list of real time metrics. E.g., 'rt:activeUsers'. At least one metric must be
       *        specified.
       * @return the request
       */
      public Get get(java.lang.String ids, java.lang.String metrics) throws java.io.IOException {
        Get result = new Get(ids, metrics);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.RealtimeData> {

        private static final String REST_PATH = "data/realtime";

        private final java.util.regex.Pattern IDS_PATTERN =
            java.util.regex.Pattern.compile("ga:[0-9]+");

        private final java.util.regex.Pattern METRICS_PATTERN =
            java.util.regex.Pattern.compile("(ga:.+)|(rt:.+)");

        private final java.util.regex.Pattern SORT_PATTERN =
            java.util.regex.Pattern.compile("(-)?((ga:.+)|(rt:.+))");

        private final java.util.regex.Pattern DIMENSIONS_PATTERN =
            java.util.regex.Pattern.compile("(ga:.+)|(rt:.+)");

        private final java.util.regex.Pattern FILTERS_PATTERN =
            java.util.regex.Pattern.compile("(ga:.+)|(rt:.+)");

        /**
         * Returns real time data for a view (profile).
         *
         * Create a request for the method "realtime.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param ids Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where XXXX is the
       *        Analytics view (profile) ID.
         * @param metrics A comma-separated list of real time metrics. E.g., 'rt:activeUsers'. At least one metric must be
       *        specified.
         * @since 1.13
         */
        protected Get(java.lang.String ids, java.lang.String metrics) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.RealtimeData.class);
          this.ids = com.google.api.client.util.Preconditions.checkNotNull(ids, "Required parameter ids must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.metrics = com.google.api.client.util.Preconditions.checkNotNull(metrics, "Required parameter metrics must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "(ga:.+)|(rt:.+)");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /**
         * Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String ids;

        /** Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where XXXX is the
       Analytics view (profile) ID.
         */
        public java.lang.String getIds() {
          return ids;
        }

        /**
         * Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where
         * XXXX is the Analytics view (profile) ID.
         */
        public Get setIds(java.lang.String ids) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
                "Parameter ids must conform to the pattern " +
                "ga:[0-9]+");
          }
          this.ids = ids;
          return this;
        }

        /**
         * A comma-separated list of real time metrics. E.g., 'rt:activeUsers'. At least one metric
         * must be specified.
         */
        @com.google.api.client.util.Key
        private java.lang.String metrics;

        /** A comma-separated list of real time metrics. E.g., 'rt:activeUsers'. At least one metric must be
       specified.
         */
        public java.lang.String getMetrics() {
          return metrics;
        }

        /**
         * A comma-separated list of real time metrics. E.g., 'rt:activeUsers'. At least one metric
         * must be specified.
         */
        public Get setMetrics(java.lang.String metrics) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
                "Parameter metrics must conform to the pattern " +
                "(ga:.+)|(rt:.+)");
          }
          this.metrics = metrics;
          return this;
        }

        /** The maximum number of entries to include in this feed. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of entries to include in this feed.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of entries to include in this feed. */
        public Get setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for real
         * time data.
         */
        @com.google.api.client.util.Key
        private java.lang.String sort;

        /** A comma-separated list of dimensions or metrics that determine the sort order for real time data.
         */
        public java.lang.String getSort() {
          return sort;
        }

        /**
         * A comma-separated list of dimensions or metrics that determine the sort order for real
         * time data.
         */
        public Get setSort(java.lang.String sort) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SORT_PATTERN.matcher(sort).matches(),
                "Parameter sort must conform to the pattern " +
                "(-)?((ga:.+)|(rt:.+))");
          }
          this.sort = sort;
          return this;
        }

        /** A comma-separated list of real time dimensions. E.g., 'rt:medium,rt:city'. */
        @com.google.api.client.util.Key
        private java.lang.String dimensions;

        /** A comma-separated list of real time dimensions. E.g., 'rt:medium,rt:city'.
         */
        public java.lang.String getDimensions() {
          return dimensions;
        }

        /** A comma-separated list of real time dimensions. E.g., 'rt:medium,rt:city'. */
        public Get setDimensions(java.lang.String dimensions) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(DIMENSIONS_PATTERN.matcher(dimensions).matches(),
                "Parameter dimensions must conform to the pattern " +
                "(ga:.+)|(rt:.+)");
          }
          this.dimensions = dimensions;
          return this;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to real time data.
         */
        @com.google.api.client.util.Key
        private java.lang.String filters;

        /** A comma-separated list of dimension or metric filters to be applied to real time data.
         */
        public java.lang.String getFilters() {
          return filters;
        }

        /**
         * A comma-separated list of dimension or metric filters to be applied to real time data.
         */
        public Get setFilters(java.lang.String filters) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(FILTERS_PATTERN.matcher(filters).matches(),
                "Parameter filters must conform to the pattern " +
                "(ga:.+)|(rt:.+)");
          }
          this.filters = filters;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Management collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Management.List request = analytics.management().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Management management() {
    return new Management();
  }

  /**
   * The "management" collection of methods.
   */
  public class Management {

    /**
     * An accessor for creating requests from the AccountSummaries collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.AccountSummaries.List request = analytics.accountSummaries().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public AccountSummaries accountSummaries() {
      return new AccountSummaries();
    }

    /**
     * The "accountSummaries" collection of methods.
     */
    public class AccountSummaries {

      /**
       * Lists account summaries (lightweight tree comprised of accounts/properties/profiles) to which the
       * user has access.
       *
       * Create a request for the method "accountSummaries.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @return the request
       */
      public List list() throws java.io.IOException {
        List result = new List();
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.AccountSummaries> {

        private static final String REST_PATH = "management/accountSummaries";

        /**
         * Lists account summaries (lightweight tree comprised of accounts/properties/profiles) to which
         * the user has access.
         *
         * Create a request for the method "accountSummaries.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @since 1.13
         */
        protected List() {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.AccountSummaries.class);
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
         * The maximum number of account summaries to include in this response, where the largest
         * acceptable value is 1000.
         */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of account summaries to include in this response, where the largest acceptable
       value is 1000.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /**
         * The maximum number of account summaries to include in this response, where the largest
         * acceptable value is 1000.
         */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the AccountUserLinks collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.AccountUserLinks.List request = analytics.accountUserLinks().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public AccountUserLinks accountUserLinks() {
      return new AccountUserLinks();
    }

    /**
     * The "accountUserLinks" collection of methods.
     */
    public class AccountUserLinks {

      /**
       * Removes a user from the given account.
       *
       * Create a request for the method "accountUserLinks.delete".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to delete the user link for.
       * @param linkId Link ID to delete the user link for.
       * @return the request
       */
      public Delete delete(java.lang.String accountId, java.lang.String linkId) throws java.io.IOException {
        Delete result = new Delete(accountId, linkId);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks/{linkId}";

        /**
         * Removes a user from the given account.
         *
         * Create a request for the method "accountUserLinks.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to delete the user link for.
         * @param linkId Link ID to delete the user link for.
         * @since 1.13
         */
        protected Delete(java.lang.String accountId, java.lang.String linkId) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.linkId = com.google.api.client.util.Preconditions.checkNotNull(linkId, "Required parameter linkId must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account ID to delete the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to delete the user link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to delete the user link for. */
        public Delete setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Link ID to delete the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String linkId;

        /** Link ID to delete the user link for.
         */
        public java.lang.String getLinkId() {
          return linkId;
        }

        /** Link ID to delete the user link for. */
        public Delete setLinkId(java.lang.String linkId) {
          this.linkId = linkId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Adds a new user to the given account.
       *
       * Create a request for the method "accountUserLinks.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create the user link for.
       * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, com.google.api.services.analytics.model.EntityUserLink content) throws java.io.IOException {
        Insert result = new Insert(accountId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.EntityUserLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks";

        /**
         * Adds a new user to the given account.
         *
         * Create a request for the method "accountUserLinks.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create the user link for.
         * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, com.google.api.services.analytics.model.EntityUserLink content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.EntityUserLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create the user link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create the user link for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists account-user links for a given account.
       *
       * Create a request for the method "accountUserLinks.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve the user links for.
       * @return the request
       */
      public List list(java.lang.String accountId) throws java.io.IOException {
        List result = new List(accountId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.EntityUserLinks> {

        private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks";

        /**
         * Lists account-user links for a given account.
         *
         * Create a request for the method "accountUserLinks.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve the user links for.
         * @since 1.13
         */
        protected List(java.lang.String accountId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.EntityUserLinks.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account ID to retrieve the user links for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve the user links for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve the user links for. */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** The maximum number of account-user links to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of account-user links to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of account-user links to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first account-user link to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first account-user link to retrieve. Use this parameter as a pagination mechanism
       along with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first account-user link to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates permissions for an existing user on the given account.
       *
       * Create a request for the method "accountUserLinks.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to update the account-user link for.
       * @param linkId Link ID to update the account-user link for.
       * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String linkId, com.google.api.services.analytics.model.EntityUserLink content) throws java.io.IOException {
        Update result = new Update(accountId, linkId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.EntityUserLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks/{linkId}";

        /**
         * Updates permissions for an existing user on the given account.
         *
         * Create a request for the method "accountUserLinks.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to update the account-user link for.
         * @param linkId Link ID to update the account-user link for.
         * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String linkId, com.google.api.services.analytics.model.EntityUserLink content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.EntityUserLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.linkId = com.google.api.client.util.Preconditions.checkNotNull(linkId, "Required parameter linkId must be specified.");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID to update the account-user link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to update the account-user link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to update the account-user link for. */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Link ID to update the account-user link for. */
        @com.google.api.client.util.Key
        private java.lang.String linkId;

        /** Link ID to update the account-user link for.
         */
        public java.lang.String getLinkId() {
          return linkId;
        }

        /** Link ID to update the account-user link for. */
        public Update setLinkId(java.lang.String linkId) {
          this.linkId = linkId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Accounts collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Accounts.List request = analytics.accounts().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Accounts accounts() {
      return new Accounts();
    }

    /**
     * The "accounts" collection of methods.
     */
    public class Accounts {

      /**
       * Lists all accounts to which the user has access.
       *
       * Create a request for the method "accounts.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @return the request
       */
      public List list() throws java.io.IOException {
        List result = new List();
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Accounts> {

        private static final String REST_PATH = "management/accounts";

        /**
         * Lists all accounts to which the user has access.
         *
         * Create a request for the method "accounts.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @since 1.13
         */
        protected List() {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Accounts.class);
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** The maximum number of accounts to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of accounts to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of accounts to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first account to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first account to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first account to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the CustomDataSources collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.CustomDataSources.List request = analytics.customDataSources().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public CustomDataSources customDataSources() {
      return new CustomDataSources();
    }

    /**
     * The "customDataSources" collection of methods.
     */
    public class CustomDataSources {

      /**
       * List custom data sources to which the user has access.
       *
       * Create a request for the method "customDataSources.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id for the custom data sources to retrieve.
       * @param webPropertyId Web property Id for the custom data sources to retrieve.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDataSources> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        /**
         * List custom data sources to which the user has access.
         *
         * Create a request for the method "customDataSources.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id for the custom data sources to retrieve.
         * @param webPropertyId Web property Id for the custom data sources to retrieve.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomDataSources.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account Id for the custom data sources to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account Id for the custom data sources to retrieve.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account Id for the custom data sources to retrieve. */
        public List setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id for the custom data sources to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id for the custom data sources to retrieve.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id for the custom data sources to retrieve. */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of custom data sources to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of custom data sources to include in this response.

       [minimum: 1]
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of custom data sources to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A 1-based index of the first custom data source to retrieve. Use this parameter as a
         * pagination mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** A 1-based index of the first custom data source to retrieve. Use this parameter as a pagination
       mechanism along with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * A 1-based index of the first custom data source to retrieve. Use this parameter as a
         * pagination mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the CustomDimensions collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.CustomDimensions.List request = analytics.customDimensions().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public CustomDimensions customDimensions() {
      return new CustomDimensions();
    }

    /**
     * The "customDimensions" collection of methods.
     */
    public class CustomDimensions {

      /**
       * Get a custom dimension to which the user has access.
       *
       * Create a request for the method "customDimensions.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the custom dimension to retrieve.
       * @param webPropertyId Web property ID for the custom dimension to retrieve.
       * @param customDimensionId The ID of the custom dimension to retrieve.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDimensionId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, customDimensionId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDimension> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions/{customDimensionId}";

        /**
         * Get a custom dimension to which the user has access.
         *
         * Create a request for the method "customDimensions.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the custom dimension to retrieve.
         * @param webPropertyId Web property ID for the custom dimension to retrieve.
         * @param customDimensionId The ID of the custom dimension to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDimensionId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomDimension.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.customDimensionId = com.google.api.client.util.Preconditions.checkNotNull(customDimensionId, "Required parameter customDimensionId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID for the custom dimension to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the custom dimension to retrieve.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID for the custom dimension to retrieve. */
        public Get setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID for the custom dimension to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the custom dimension to retrieve.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID for the custom dimension to retrieve. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The ID of the custom dimension to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String customDimensionId;

        /** The ID of the custom dimension to retrieve.
         */
        public java.lang.String getCustomDimensionId() {
          return customDimensionId;
        }

        /** The ID of the custom dimension to retrieve. */
        public Get setCustomDimensionId(java.lang.String customDimensionId) {
          this.customDimensionId = customDimensionId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Create a new custom dimension.
       *
       * Create a request for the method "customDimensions.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the custom dimension to create.
       * @param webPropertyId Web property ID for the custom dimension to create.
       * @param content the {@link com.google.api.services.analytics.model.CustomDimension}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.CustomDimension content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDimension> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions";

        /**
         * Create a new custom dimension.
         *
         * Create a request for the method "customDimensions.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the custom dimension to create.
         * @param webPropertyId Web property ID for the custom dimension to create.
         * @param content the {@link com.google.api.services.analytics.model.CustomDimension}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.CustomDimension content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.CustomDimension.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID for the custom dimension to create. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the custom dimension to create.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID for the custom dimension to create. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID for the custom dimension to create. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the custom dimension to create.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID for the custom dimension to create. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists custom dimensions to which the user has access.
       *
       * Create a request for the method "customDimensions.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the custom dimensions to retrieve.
       * @param webPropertyId Web property ID for the custom dimensions to retrieve.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDimensions> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions";

        /**
         * Lists custom dimensions to which the user has access.
         *
         * Create a request for the method "customDimensions.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the custom dimensions to retrieve.
         * @param webPropertyId Web property ID for the custom dimensions to retrieve.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomDimensions.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account ID for the custom dimensions to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the custom dimensions to retrieve.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID for the custom dimensions to retrieve. */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID for the custom dimensions to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the custom dimensions to retrieve.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID for the custom dimensions to retrieve. */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of custom dimensions to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of custom dimensions to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of custom dimensions to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing custom dimension. This method supports patch semantics.
       *
       * Create a request for the method "customDimensions.patch".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the custom dimension to update.
       * @param webPropertyId Web property ID for the custom dimension to update.
       * @param customDimensionId Custom dimension ID for the custom dimension to update.
       * @param content the {@link com.google.api.services.analytics.model.CustomDimension}
       * @return the request
       */
      public Patch patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDimensionId, com.google.api.services.analytics.model.CustomDimension content) throws java.io.IOException {
        Patch result = new Patch(accountId, webPropertyId, customDimensionId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDimension> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions/{customDimensionId}";

        /**
         * Updates an existing custom dimension. This method supports patch semantics.
         *
         * Create a request for the method "customDimensions.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the custom dimension to update.
         * @param webPropertyId Web property ID for the custom dimension to update.
         * @param customDimensionId Custom dimension ID for the custom dimension to update.
         * @param content the {@link com.google.api.services.analytics.model.CustomDimension}
         * @since 1.13
         */
        protected Patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDimensionId, com.google.api.services.analytics.model.CustomDimension content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.CustomDimension.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.customDimensionId = com.google.api.client.util.Preconditions.checkNotNull(customDimensionId, "Required parameter customDimensionId must be specified.");
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** Account ID for the custom dimension to update. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the custom dimension to update.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID for the custom dimension to update. */
        public Patch setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID for the custom dimension to update. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the custom dimension to update.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID for the custom dimension to update. */
        public Patch setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom dimension ID for the custom dimension to update. */
        @com.google.api.client.util.Key
        private java.lang.String customDimensionId;

        /** Custom dimension ID for the custom dimension to update.
         */
        public java.lang.String getCustomDimensionId() {
          return customDimensionId;
        }

        /** Custom dimension ID for the custom dimension to update. */
        public Patch setCustomDimensionId(java.lang.String customDimensionId) {
          this.customDimensionId = customDimensionId;
          return this;
        }

        /**
         * Force the update and ignore any warnings related to the custom dimension being linked to
         * a custom data source / data set.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean ignoreCustomDataSourceLinks;

        /** Force the update and ignore any warnings related to the custom dimension being linked to a custom
       data source / data set. [default: false]
         */
        public java.lang.Boolean getIgnoreCustomDataSourceLinks() {
          return ignoreCustomDataSourceLinks;
        }

        /**
         * Force the update and ignore any warnings related to the custom dimension being linked to
         * a custom data source / data set.
         */
        public Patch setIgnoreCustomDataSourceLinks(java.lang.Boolean ignoreCustomDataSourceLinks) {
          this.ignoreCustomDataSourceLinks = ignoreCustomDataSourceLinks;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Force the update and ignore any warnings related to the custom dimension being linked to a custom
       data source / data set.
         * </p>
         */
        public boolean isIgnoreCustomDataSourceLinks() {
          if (ignoreCustomDataSourceLinks == null || ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return ignoreCustomDataSourceLinks;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing custom dimension.
       *
       * Create a request for the method "customDimensions.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the custom dimension to update.
       * @param webPropertyId Web property ID for the custom dimension to update.
       * @param customDimensionId Custom dimension ID for the custom dimension to update.
       * @param content the {@link com.google.api.services.analytics.model.CustomDimension}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDimensionId, com.google.api.services.analytics.model.CustomDimension content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, customDimensionId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDimension> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions/{customDimensionId}";

        /**
         * Updates an existing custom dimension.
         *
         * Create a request for the method "customDimensions.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the custom dimension to update.
         * @param webPropertyId Web property ID for the custom dimension to update.
         * @param customDimensionId Custom dimension ID for the custom dimension to update.
         * @param content the {@link com.google.api.services.analytics.model.CustomDimension}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDimensionId, com.google.api.services.analytics.model.CustomDimension content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.CustomDimension.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.customDimensionId = com.google.api.client.util.Preconditions.checkNotNull(customDimensionId, "Required parameter customDimensionId must be specified.");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID for the custom dimension to update. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the custom dimension to update.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID for the custom dimension to update. */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID for the custom dimension to update. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the custom dimension to update.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID for the custom dimension to update. */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom dimension ID for the custom dimension to update. */
        @com.google.api.client.util.Key
        private java.lang.String customDimensionId;

        /** Custom dimension ID for the custom dimension to update.
         */
        public java.lang.String getCustomDimensionId() {
          return customDimensionId;
        }

        /** Custom dimension ID for the custom dimension to update. */
        public Update setCustomDimensionId(java.lang.String customDimensionId) {
          this.customDimensionId = customDimensionId;
          return this;
        }

        /**
         * Force the update and ignore any warnings related to the custom dimension being linked to
         * a custom data source / data set.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean ignoreCustomDataSourceLinks;

        /** Force the update and ignore any warnings related to the custom dimension being linked to a custom
       data source / data set. [default: false]
         */
        public java.lang.Boolean getIgnoreCustomDataSourceLinks() {
          return ignoreCustomDataSourceLinks;
        }

        /**
         * Force the update and ignore any warnings related to the custom dimension being linked to
         * a custom data source / data set.
         */
        public Update setIgnoreCustomDataSourceLinks(java.lang.Boolean ignoreCustomDataSourceLinks) {
          this.ignoreCustomDataSourceLinks = ignoreCustomDataSourceLinks;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Force the update and ignore any warnings related to the custom dimension being linked to a custom
       data source / data set.
         * </p>
         */
        public boolean isIgnoreCustomDataSourceLinks() {
          if (ignoreCustomDataSourceLinks == null || ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return ignoreCustomDataSourceLinks;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the CustomMetrics collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.CustomMetrics.List request = analytics.customMetrics().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public CustomMetrics customMetrics() {
      return new CustomMetrics();
    }

    /**
     * The "customMetrics" collection of methods.
     */
    public class CustomMetrics {

      /**
       * Get a custom metric to which the user has access.
       *
       * Create a request for the method "customMetrics.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the custom metric to retrieve.
       * @param webPropertyId Web property ID for the custom metric to retrieve.
       * @param customMetricId The ID of the custom metric to retrieve.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customMetricId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, customMetricId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.CustomMetric> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics/{customMetricId}";

        /**
         * Get a custom metric to which the user has access.
         *
         * Create a request for the method "customMetrics.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the custom metric to retrieve.
         * @param webPropertyId Web property ID for the custom metric to retrieve.
         * @param customMetricId The ID of the custom metric to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customMetricId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomMetric.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.customMetricId = com.google.api.client.util.Preconditions.checkNotNull(customMetricId, "Required parameter customMetricId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID for the custom metric to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the custom metric to retrieve.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID for the custom metric to retrieve. */
        public Get setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID for the custom metric to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the custom metric to retrieve.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID for the custom metric to retrieve. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The ID of the custom metric to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String customMetricId;

        /** The ID of the custom metric to retrieve.
         */
        public java.lang.String getCustomMetricId() {
          return customMetricId;
        }

        /** The ID of the custom metric to retrieve. */
        public Get setCustomMetricId(java.lang.String customMetricId) {
          this.customMetricId = customMetricId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Create a new custom metric.
       *
       * Create a request for the method "customMetrics.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the custom metric to create.
       * @param webPropertyId Web property ID for the custom dimension to create.
       * @param content the {@link com.google.api.services.analytics.model.CustomMetric}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.CustomMetric content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.CustomMetric> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics";

        /**
         * Create a new custom metric.
         *
         * Create a request for the method "customMetrics.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the custom metric to create.
         * @param webPropertyId Web property ID for the custom dimension to create.
         * @param content the {@link com.google.api.services.analytics.model.CustomMetric}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.CustomMetric content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.CustomMetric.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID for the custom metric to create. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the custom metric to create.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID for the custom metric to create. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID for the custom dimension to create. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the custom dimension to create.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID for the custom dimension to create. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists custom metrics to which the user has access.
       *
       * Create a request for the method "customMetrics.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the custom metrics to retrieve.
       * @param webPropertyId Web property ID for the custom metrics to retrieve.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.CustomMetrics> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics";

        /**
         * Lists custom metrics to which the user has access.
         *
         * Create a request for the method "customMetrics.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the custom metrics to retrieve.
         * @param webPropertyId Web property ID for the custom metrics to retrieve.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomMetrics.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account ID for the custom metrics to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the custom metrics to retrieve.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID for the custom metrics to retrieve. */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID for the custom metrics to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the custom metrics to retrieve.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID for the custom metrics to retrieve. */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of custom metrics to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of custom metrics to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of custom metrics to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing custom metric. This method supports patch semantics.
       *
       * Create a request for the method "customMetrics.patch".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the custom metric to update.
       * @param webPropertyId Web property ID for the custom metric to update.
       * @param customMetricId Custom metric ID for the custom metric to update.
       * @param content the {@link com.google.api.services.analytics.model.CustomMetric}
       * @return the request
       */
      public Patch patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customMetricId, com.google.api.services.analytics.model.CustomMetric content) throws java.io.IOException {
        Patch result = new Patch(accountId, webPropertyId, customMetricId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.CustomMetric> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics/{customMetricId}";

        /**
         * Updates an existing custom metric. This method supports patch semantics.
         *
         * Create a request for the method "customMetrics.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the custom metric to update.
         * @param webPropertyId Web property ID for the custom metric to update.
         * @param customMetricId Custom metric ID for the custom metric to update.
         * @param content the {@link com.google.api.services.analytics.model.CustomMetric}
         * @since 1.13
         */
        protected Patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customMetricId, com.google.api.services.analytics.model.CustomMetric content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.CustomMetric.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.customMetricId = com.google.api.client.util.Preconditions.checkNotNull(customMetricId, "Required parameter customMetricId must be specified.");
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** Account ID for the custom metric to update. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the custom metric to update.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID for the custom metric to update. */
        public Patch setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID for the custom metric to update. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the custom metric to update.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID for the custom metric to update. */
        public Patch setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom metric ID for the custom metric to update. */
        @com.google.api.client.util.Key
        private java.lang.String customMetricId;

        /** Custom metric ID for the custom metric to update.
         */
        public java.lang.String getCustomMetricId() {
          return customMetricId;
        }

        /** Custom metric ID for the custom metric to update. */
        public Patch setCustomMetricId(java.lang.String customMetricId) {
          this.customMetricId = customMetricId;
          return this;
        }

        /**
         * Force the update and ignore any warnings related to the custom metric being linked to a
         * custom data source / data set.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean ignoreCustomDataSourceLinks;

        /** Force the update and ignore any warnings related to the custom metric being linked to a custom data
       source / data set. [default: false]
         */
        public java.lang.Boolean getIgnoreCustomDataSourceLinks() {
          return ignoreCustomDataSourceLinks;
        }

        /**
         * Force the update and ignore any warnings related to the custom metric being linked to a
         * custom data source / data set.
         */
        public Patch setIgnoreCustomDataSourceLinks(java.lang.Boolean ignoreCustomDataSourceLinks) {
          this.ignoreCustomDataSourceLinks = ignoreCustomDataSourceLinks;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Force the update and ignore any warnings related to the custom metric being linked to a custom data
       source / data set.
         * </p>
         */
        public boolean isIgnoreCustomDataSourceLinks() {
          if (ignoreCustomDataSourceLinks == null || ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return ignoreCustomDataSourceLinks;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing custom metric.
       *
       * Create a request for the method "customMetrics.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the custom metric to update.
       * @param webPropertyId Web property ID for the custom metric to update.
       * @param customMetricId Custom metric ID for the custom metric to update.
       * @param content the {@link com.google.api.services.analytics.model.CustomMetric}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customMetricId, com.google.api.services.analytics.model.CustomMetric content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, customMetricId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.CustomMetric> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics/{customMetricId}";

        /**
         * Updates an existing custom metric.
         *
         * Create a request for the method "customMetrics.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the custom metric to update.
         * @param webPropertyId Web property ID for the custom metric to update.
         * @param customMetricId Custom metric ID for the custom metric to update.
         * @param content the {@link com.google.api.services.analytics.model.CustomMetric}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customMetricId, com.google.api.services.analytics.model.CustomMetric content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.CustomMetric.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.customMetricId = com.google.api.client.util.Preconditions.checkNotNull(customMetricId, "Required parameter customMetricId must be specified.");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID for the custom metric to update. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the custom metric to update.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID for the custom metric to update. */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID for the custom metric to update. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the custom metric to update.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID for the custom metric to update. */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom metric ID for the custom metric to update. */
        @com.google.api.client.util.Key
        private java.lang.String customMetricId;

        /** Custom metric ID for the custom metric to update.
         */
        public java.lang.String getCustomMetricId() {
          return customMetricId;
        }

        /** Custom metric ID for the custom metric to update. */
        public Update setCustomMetricId(java.lang.String customMetricId) {
          this.customMetricId = customMetricId;
          return this;
        }

        /**
         * Force the update and ignore any warnings related to the custom metric being linked to a
         * custom data source / data set.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean ignoreCustomDataSourceLinks;

        /** Force the update and ignore any warnings related to the custom metric being linked to a custom data
       source / data set. [default: false]
         */
        public java.lang.Boolean getIgnoreCustomDataSourceLinks() {
          return ignoreCustomDataSourceLinks;
        }

        /**
         * Force the update and ignore any warnings related to the custom metric being linked to a
         * custom data source / data set.
         */
        public Update setIgnoreCustomDataSourceLinks(java.lang.Boolean ignoreCustomDataSourceLinks) {
          this.ignoreCustomDataSourceLinks = ignoreCustomDataSourceLinks;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Force the update and ignore any warnings related to the custom metric being linked to a custom data
       source / data set.
         * </p>
         */
        public boolean isIgnoreCustomDataSourceLinks() {
          if (ignoreCustomDataSourceLinks == null || ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return ignoreCustomDataSourceLinks;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Experiments collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Experiments.List request = analytics.experiments().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Experiments experiments() {
      return new Experiments();
    }

    /**
     * The "experiments" collection of methods.
     */
    public class Experiments {

      /**
       * Delete an experiment.
       *
       * Create a request for the method "experiments.delete".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which the experiment belongs
       * @param webPropertyId Web property ID to which the experiment belongs
       * @param profileId View (Profile) ID to which the experiment belongs
       * @param experimentId ID of the experiment to delete
       * @return the request
       */
      public Delete delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId) throws java.io.IOException {
        Delete result = new Delete(accountId, webPropertyId, profileId, experimentId);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Delete an experiment.
         *
         * Create a request for the method "experiments.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which the experiment belongs
         * @param webPropertyId Web property ID to which the experiment belongs
         * @param profileId View (Profile) ID to which the experiment belongs
         * @param experimentId ID of the experiment to delete
         * @since 1.13
         */
        protected Delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = com.google.api.client.util.Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account ID to which the experiment belongs */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which the experiment belongs
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which the experiment belongs */
        public Delete setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to which the experiment belongs */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to which the experiment belongs
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to which the experiment belongs */
        public Delete setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to which the experiment belongs */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to which the experiment belongs
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to which the experiment belongs */
        public Delete setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** ID of the experiment to delete */
        @com.google.api.client.util.Key
        private java.lang.String experimentId;

        /** ID of the experiment to delete
         */
        public java.lang.String getExperimentId() {
          return experimentId;
        }

        /** ID of the experiment to delete */
        public Delete setExperimentId(java.lang.String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns an experiment to which the user has access.
       *
       * Create a request for the method "experiments.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve the experiment for.
       * @param webPropertyId Web property ID to retrieve the experiment for.
       * @param profileId View (Profile) ID to retrieve the experiment for.
       * @param experimentId Experiment ID to retrieve the experiment for.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, profileId, experimentId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Returns an experiment to which the user has access.
         *
         * Create a request for the method "experiments.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve the experiment for.
         * @param webPropertyId Web property ID to retrieve the experiment for.
         * @param profileId View (Profile) ID to retrieve the experiment for.
         * @param experimentId Experiment ID to retrieve the experiment for.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = com.google.api.client.util.Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve the experiment for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve the experiment for. */
        public Get setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve the experiment for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve the experiment for. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve the experiment for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to retrieve the experiment for. */
        public Get setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Experiment ID to retrieve the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String experimentId;

        /** Experiment ID to retrieve the experiment for.
         */
        public java.lang.String getExperimentId() {
          return experimentId;
        }

        /** Experiment ID to retrieve the experiment for. */
        public Get setExperimentId(java.lang.String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Create a new experiment.
       *
       * Create a request for the method "experiments.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create the experiment for.
       * @param webPropertyId Web property ID to create the experiment for.
       * @param profileId View (Profile) ID to create the experiment for.
       * @param content the {@link com.google.api.services.analytics.model.Experiment}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.Experiment content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, profileId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";

        /**
         * Create a new experiment.
         *
         * Create a request for the method "experiments.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create the experiment for.
         * @param webPropertyId Web property ID to create the experiment for.
         * @param profileId View (Profile) ID to create the experiment for.
         * @param content the {@link com.google.api.services.analytics.model.Experiment}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.Experiment content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "Experiment.getName()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getStatus(), "Experiment.getStatus()");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create the experiment for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create the experiment for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to create the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to create the experiment for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to create the experiment for. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to create the experiment for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to create the experiment for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to create the experiment for. */
        public Insert setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists experiments to which the user has access.
       *
       * Create a request for the method "experiments.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve experiments for.
       * @param webPropertyId Web property ID to retrieve experiments for.
       * @param profileId View (Profile) ID to retrieve experiments for.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Experiments> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern PROFILE_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        /**
         * Lists experiments to which the user has access.
         *
         * Create a request for the method "experiments.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve experiments for.
         * @param webPropertyId Web property ID to retrieve experiments for.
         * @param profileId View (Profile) ID to retrieve experiments for.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Experiments.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account ID to retrieve experiments for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve experiments for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve experiments for. */
        public List setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve experiments for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve experiments for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve experiments for. */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to retrieve experiments for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve experiments for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to retrieve experiments for. */
        public List setProfileId(java.lang.String profileId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.profileId = profileId;
          return this;
        }

        /** The maximum number of experiments to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of experiments to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of experiments to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first experiment to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first experiment to retrieve. Use this parameter as a pagination mechanism along
       with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first experiment to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Update an existing experiment. This method supports patch semantics.
       *
       * Create a request for the method "experiments.patch".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID of the experiment to update.
       * @param webPropertyId Web property ID of the experiment to update.
       * @param profileId View (Profile) ID of the experiment to update.
       * @param experimentId Experiment ID of the experiment to update.
       * @param content the {@link com.google.api.services.analytics.model.Experiment}
       * @return the request
       */
      public Patch patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId, com.google.api.services.analytics.model.Experiment content) throws java.io.IOException {
        Patch result = new Patch(accountId, webPropertyId, profileId, experimentId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Update an existing experiment. This method supports patch semantics.
         *
         * Create a request for the method "experiments.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID of the experiment to update.
         * @param webPropertyId Web property ID of the experiment to update.
         * @param profileId View (Profile) ID of the experiment to update.
         * @param experimentId Experiment ID of the experiment to update.
         * @param content the {@link com.google.api.services.analytics.model.Experiment}
         * @since 1.13
         */
        protected Patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId, com.google.api.services.analytics.model.Experiment content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = com.google.api.client.util.Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getId(), "Experiment.getId()");
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** Account ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID of the experiment to update.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID of the experiment to update. */
        public Patch setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID of the experiment to update.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID of the experiment to update. */
        public Patch setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID of the experiment to update.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID of the experiment to update. */
        public Patch setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Experiment ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String experimentId;

        /** Experiment ID of the experiment to update.
         */
        public java.lang.String getExperimentId() {
          return experimentId;
        }

        /** Experiment ID of the experiment to update. */
        public Patch setExperimentId(java.lang.String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Update an existing experiment.
       *
       * Create a request for the method "experiments.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID of the experiment to update.
       * @param webPropertyId Web property ID of the experiment to update.
       * @param profileId View (Profile) ID of the experiment to update.
       * @param experimentId Experiment ID of the experiment to update.
       * @param content the {@link com.google.api.services.analytics.model.Experiment}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId, com.google.api.services.analytics.model.Experiment content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, profileId, experimentId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.Experiment> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";

        /**
         * Update an existing experiment.
         *
         * Create a request for the method "experiments.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID of the experiment to update.
         * @param webPropertyId Web property ID of the experiment to update.
         * @param profileId View (Profile) ID of the experiment to update.
         * @param experimentId Experiment ID of the experiment to update.
         * @param content the {@link com.google.api.services.analytics.model.Experiment}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String experimentId, com.google.api.services.analytics.model.Experiment content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.Experiment.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.experimentId = com.google.api.client.util.Preconditions.checkNotNull(experimentId, "Required parameter experimentId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getId(), "Experiment.getId()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "Experiment.getName()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getStatus(), "Experiment.getStatus()");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID of the experiment to update.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID of the experiment to update. */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID of the experiment to update.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID of the experiment to update. */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID of the experiment to update.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID of the experiment to update. */
        public Update setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Experiment ID of the experiment to update. */
        @com.google.api.client.util.Key
        private java.lang.String experimentId;

        /** Experiment ID of the experiment to update.
         */
        public java.lang.String getExperimentId() {
          return experimentId;
        }

        /** Experiment ID of the experiment to update. */
        public Update setExperimentId(java.lang.String experimentId) {
          this.experimentId = experimentId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Filters collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Filters.List request = analytics.filters().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Filters filters() {
      return new Filters();
    }

    /**
     * The "filters" collection of methods.
     */
    public class Filters {

      /**
       * Delete a filter.
       *
       * Create a request for the method "filters.delete".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to delete the filter for.
       * @param filterId ID of the filter to be deleted.
       * @return the request
       */
      public Delete delete(java.lang.String accountId, java.lang.String filterId) throws java.io.IOException {
        Delete result = new Delete(accountId, filterId);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<com.google.api.services.analytics.model.Filter> {

        private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";

        /**
         * Delete a filter.
         *
         * Create a request for the method "filters.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to delete the filter for.
         * @param filterId ID of the filter to be deleted.
         * @since 1.13
         */
        protected Delete(java.lang.String accountId, java.lang.String filterId) {
          super(Analytics.this, "DELETE", REST_PATH, null, com.google.api.services.analytics.model.Filter.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.filterId = com.google.api.client.util.Preconditions.checkNotNull(filterId, "Required parameter filterId must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account ID to delete the filter for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to delete the filter for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to delete the filter for. */
        public Delete setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** ID of the filter to be deleted. */
        @com.google.api.client.util.Key
        private java.lang.String filterId;

        /** ID of the filter to be deleted.
         */
        public java.lang.String getFilterId() {
          return filterId;
        }

        /** ID of the filter to be deleted. */
        public Delete setFilterId(java.lang.String filterId) {
          this.filterId = filterId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns a filters to which the user has access.
       *
       * Create a request for the method "filters.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve filters for.
       * @param filterId Filter ID to retrieve filters for.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String filterId) throws java.io.IOException {
        Get result = new Get(accountId, filterId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.Filter> {

        private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";

        /**
         * Returns a filters to which the user has access.
         *
         * Create a request for the method "filters.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve filters for.
         * @param filterId Filter ID to retrieve filters for.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String filterId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Filter.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.filterId = com.google.api.client.util.Preconditions.checkNotNull(filterId, "Required parameter filterId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID to retrieve filters for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve filters for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve filters for. */
        public Get setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Filter ID to retrieve filters for. */
        @com.google.api.client.util.Key
        private java.lang.String filterId;

        /** Filter ID to retrieve filters for.
         */
        public java.lang.String getFilterId() {
          return filterId;
        }

        /** Filter ID to retrieve filters for. */
        public Get setFilterId(java.lang.String filterId) {
          this.filterId = filterId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Create a new filter.
       *
       * Create a request for the method "filters.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create filter for.
       * @param content the {@link com.google.api.services.analytics.model.Filter}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, com.google.api.services.analytics.model.Filter content) throws java.io.IOException {
        Insert result = new Insert(accountId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.Filter> {

        private static final String REST_PATH = "management/accounts/{accountId}/filters";

        /**
         * Create a new filter.
         *
         * Create a request for the method "filters.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create filter for.
         * @param content the {@link com.google.api.services.analytics.model.Filter}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, com.google.api.services.analytics.model.Filter content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.Filter.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "Filter.getName()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getType(), "Filter.getType()");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create filter for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create filter for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create filter for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists all filters for an account
       *
       * Create a request for the method "filters.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve filters for.
       * @return the request
       */
      public List list(java.lang.String accountId) throws java.io.IOException {
        List result = new List(accountId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Filters> {

        private static final String REST_PATH = "management/accounts/{accountId}/filters";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        /**
         * Lists all filters for an account
         *
         * Create a request for the method "filters.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve filters for.
         * @since 1.13
         */
        protected List(java.lang.String accountId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Filters.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account ID to retrieve filters for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve filters for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve filters for. */
        public List setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** The maximum number of filters to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of filters to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of filters to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing filter. This method supports patch semantics.
       *
       * Create a request for the method "filters.patch".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which the filter belongs.
       * @param filterId ID of the filter to be updated.
       * @param content the {@link com.google.api.services.analytics.model.Filter}
       * @return the request
       */
      public Patch patch(java.lang.String accountId, java.lang.String filterId, com.google.api.services.analytics.model.Filter content) throws java.io.IOException {
        Patch result = new Patch(accountId, filterId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.Filter> {

        private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";

        /**
         * Updates an existing filter. This method supports patch semantics.
         *
         * Create a request for the method "filters.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which the filter belongs.
         * @param filterId ID of the filter to be updated.
         * @param content the {@link com.google.api.services.analytics.model.Filter}
         * @since 1.13
         */
        protected Patch(java.lang.String accountId, java.lang.String filterId, com.google.api.services.analytics.model.Filter content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.Filter.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.filterId = com.google.api.client.util.Preconditions.checkNotNull(filterId, "Required parameter filterId must be specified.");
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** Account ID to which the filter belongs. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which the filter belongs.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which the filter belongs. */
        public Patch setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** ID of the filter to be updated. */
        @com.google.api.client.util.Key
        private java.lang.String filterId;

        /** ID of the filter to be updated.
         */
        public java.lang.String getFilterId() {
          return filterId;
        }

        /** ID of the filter to be updated. */
        public Patch setFilterId(java.lang.String filterId) {
          this.filterId = filterId;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing filter.
       *
       * Create a request for the method "filters.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which the filter belongs.
       * @param filterId ID of the filter to be updated.
       * @param content the {@link com.google.api.services.analytics.model.Filter}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String filterId, com.google.api.services.analytics.model.Filter content) throws java.io.IOException {
        Update result = new Update(accountId, filterId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.Filter> {

        private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";

        /**
         * Updates an existing filter.
         *
         * Create a request for the method "filters.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which the filter belongs.
         * @param filterId ID of the filter to be updated.
         * @param content the {@link com.google.api.services.analytics.model.Filter}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String filterId, com.google.api.services.analytics.model.Filter content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.Filter.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.filterId = com.google.api.client.util.Preconditions.checkNotNull(filterId, "Required parameter filterId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "Filter.getName()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getType(), "Filter.getType()");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID to which the filter belongs. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which the filter belongs.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which the filter belongs. */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** ID of the filter to be updated. */
        @com.google.api.client.util.Key
        private java.lang.String filterId;

        /** ID of the filter to be updated.
         */
        public java.lang.String getFilterId() {
          return filterId;
        }

        /** ID of the filter to be updated. */
        public Update setFilterId(java.lang.String filterId) {
          this.filterId = filterId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Goals collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Goals.List request = analytics.goals().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Goals goals() {
      return new Goals();
    }

    /**
     * The "goals" collection of methods.
     */
    public class Goals {

      /**
       * Gets a goal to which the user has access.
       *
       * Create a request for the method "goals.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve the goal for.
       * @param webPropertyId Web property ID to retrieve the goal for.
       * @param profileId View (Profile) ID to retrieve the goal for.
       * @param goalId Goal ID to retrieve the goal for.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String goalId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, profileId, goalId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.Goal> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals/{goalId}";

        /**
         * Gets a goal to which the user has access.
         *
         * Create a request for the method "goals.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve the goal for.
         * @param webPropertyId Web property ID to retrieve the goal for.
         * @param profileId View (Profile) ID to retrieve the goal for.
         * @param goalId Goal ID to retrieve the goal for.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String goalId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Goal.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.goalId = com.google.api.client.util.Preconditions.checkNotNull(goalId, "Required parameter goalId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID to retrieve the goal for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve the goal for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve the goal for. */
        public Get setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve the goal for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve the goal for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve the goal for. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to retrieve the goal for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve the goal for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to retrieve the goal for. */
        public Get setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Goal ID to retrieve the goal for. */
        @com.google.api.client.util.Key
        private java.lang.String goalId;

        /** Goal ID to retrieve the goal for.
         */
        public java.lang.String getGoalId() {
          return goalId;
        }

        /** Goal ID to retrieve the goal for. */
        public Get setGoalId(java.lang.String goalId) {
          this.goalId = goalId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Create a new goal.
       *
       * Create a request for the method "goals.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create the goal for.
       * @param webPropertyId Web property ID to create the goal for.
       * @param profileId View (Profile) ID to create the goal for.
       * @param content the {@link com.google.api.services.analytics.model.Goal}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.Goal content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, profileId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.Goal> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";

        /**
         * Create a new goal.
         *
         * Create a request for the method "goals.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create the goal for.
         * @param webPropertyId Web property ID to create the goal for.
         * @param profileId View (Profile) ID to create the goal for.
         * @param content the {@link com.google.api.services.analytics.model.Goal}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.Goal content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.Goal.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create the goal for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create the goal for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create the goal for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to create the goal for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to create the goal for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to create the goal for. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to create the goal for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to create the goal for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to create the goal for. */
        public Insert setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists goals to which the user has access.
       *
       * Create a request for the method "goals.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all
       *        the accounts that user has access to.
       * @param webPropertyId Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       *        refers to all the web properties that user has access to.
       * @param profileId View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or '~all', which
       *        refers to all the views (profiles) that user has access to.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Goals> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";

        /**
         * Lists goals to which the user has access.
         *
         * Create a request for the method "goals.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all
       *        the accounts that user has access to.
         * @param webPropertyId Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       *        refers to all the web properties that user has access to.
         * @param profileId View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or '~all', which
       *        refers to all the views (profiles) that user has access to.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Goals.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
         * Account ID to retrieve goals for. Can either be a specific account ID or '~all', which
         * refers to all the accounts that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to
       all the accounts that user has access to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /**
         * Account ID to retrieve goals for. Can either be a specific account ID or '~all', which
         * refers to all the accounts that user has access to.
         */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
         * Web property ID to retrieve goals for. Can either be a specific web property ID or
         * '~all', which refers to all the web properties that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which
       refers to all the web properties that user has access to.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /**
         * Web property ID to retrieve goals for. Can either be a specific web property ID or
         * '~all', which refers to all the web properties that user has access to.
         */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /**
         * View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or
         * '~all', which refers to all the views (profiles) that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or '~all',
       which refers to all the views (profiles) that user has access to.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /**
         * View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or
         * '~all', which refers to all the views (profiles) that user has access to.
         */
        public List setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** The maximum number of goals to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of goals to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of goals to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first goal to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first goal to retrieve. Use this parameter as a pagination mechanism along with the
       max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first goal to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing view (profile). This method supports patch semantics.
       *
       * Create a request for the method "goals.patch".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to update the goal.
       * @param webPropertyId Web property ID to update the goal.
       * @param profileId View (Profile) ID to update the goal.
       * @param goalId Index of the goal to be updated.
       * @param content the {@link com.google.api.services.analytics.model.Goal}
       * @return the request
       */
      public Patch patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String goalId, com.google.api.services.analytics.model.Goal content) throws java.io.IOException {
        Patch result = new Patch(accountId, webPropertyId, profileId, goalId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.Goal> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals/{goalId}";

        /**
         * Updates an existing view (profile). This method supports patch semantics.
         *
         * Create a request for the method "goals.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to update the goal.
         * @param webPropertyId Web property ID to update the goal.
         * @param profileId View (Profile) ID to update the goal.
         * @param goalId Index of the goal to be updated.
         * @param content the {@link com.google.api.services.analytics.model.Goal}
         * @since 1.13
         */
        protected Patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String goalId, com.google.api.services.analytics.model.Goal content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.Goal.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.goalId = com.google.api.client.util.Preconditions.checkNotNull(goalId, "Required parameter goalId must be specified.");
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** Account ID to update the goal. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to update the goal.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to update the goal. */
        public Patch setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to update the goal. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to update the goal.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to update the goal. */
        public Patch setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to update the goal. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to update the goal.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to update the goal. */
        public Patch setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Index of the goal to be updated. */
        @com.google.api.client.util.Key
        private java.lang.String goalId;

        /** Index of the goal to be updated.
         */
        public java.lang.String getGoalId() {
          return goalId;
        }

        /** Index of the goal to be updated. */
        public Patch setGoalId(java.lang.String goalId) {
          this.goalId = goalId;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing view (profile).
       *
       * Create a request for the method "goals.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to update the goal.
       * @param webPropertyId Web property ID to update the goal.
       * @param profileId View (Profile) ID to update the goal.
       * @param goalId Index of the goal to be updated.
       * @param content the {@link com.google.api.services.analytics.model.Goal}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String goalId, com.google.api.services.analytics.model.Goal content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, profileId, goalId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.Goal> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals/{goalId}";

        /**
         * Updates an existing view (profile).
         *
         * Create a request for the method "goals.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to update the goal.
         * @param webPropertyId Web property ID to update the goal.
         * @param profileId View (Profile) ID to update the goal.
         * @param goalId Index of the goal to be updated.
         * @param content the {@link com.google.api.services.analytics.model.Goal}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String goalId, com.google.api.services.analytics.model.Goal content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.Goal.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.goalId = com.google.api.client.util.Preconditions.checkNotNull(goalId, "Required parameter goalId must be specified.");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID to update the goal. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to update the goal.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to update the goal. */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to update the goal. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to update the goal.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to update the goal. */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to update the goal. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to update the goal.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to update the goal. */
        public Update setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Index of the goal to be updated. */
        @com.google.api.client.util.Key
        private java.lang.String goalId;

        /** Index of the goal to be updated.
         */
        public java.lang.String getGoalId() {
          return goalId;
        }

        /** Index of the goal to be updated. */
        public Update setGoalId(java.lang.String goalId) {
          this.goalId = goalId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the ProfileFilterLinks collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.ProfileFilterLinks.List request = analytics.profileFilterLinks().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public ProfileFilterLinks profileFilterLinks() {
      return new ProfileFilterLinks();
    }

    /**
     * The "profileFilterLinks" collection of methods.
     */
    public class ProfileFilterLinks {

      /**
       * Delete a profile filter link.
       *
       * Create a request for the method "profileFilterLinks.delete".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which the profile filter link belongs.
       * @param webPropertyId Web property Id to which the profile filter link belongs.
       * @param profileId Profile ID to which the filter link belongs.
       * @param linkId ID of the profile filter link to delete.
       * @return the request
       */
      public Delete delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId) throws java.io.IOException {
        Delete result = new Delete(accountId, webPropertyId, profileId, linkId);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern PROFILE_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern LINK_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+:\\d+");

        /**
         * Delete a profile filter link.
         *
         * Create a request for the method "profileFilterLinks.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which the profile filter link belongs.
         * @param webPropertyId Web property Id to which the profile filter link belongs.
         * @param profileId Profile ID to which the filter link belongs.
         * @param linkId ID of the profile filter link to delete.
         * @since 1.13
         */
        protected Delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.linkId = com.google.api.client.util.Preconditions.checkNotNull(linkId, "Required parameter linkId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(LINK_ID_PATTERN.matcher(linkId).matches(),
                "Parameter linkId must conform to the pattern " +
                "\\d+:\\d+");
          }
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account ID to which the profile filter link belongs. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which the profile filter link belongs.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which the profile filter link belongs. */
        public Delete setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id to which the profile filter link belongs. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id to which the profile filter link belongs.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id to which the profile filter link belongs. */
        public Delete setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID to which the filter link belongs. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** Profile ID to which the filter link belongs.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** Profile ID to which the filter link belongs. */
        public Delete setProfileId(java.lang.String profileId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.profileId = profileId;
          return this;
        }

        /** ID of the profile filter link to delete. */
        @com.google.api.client.util.Key
        private java.lang.String linkId;

        /** ID of the profile filter link to delete.
         */
        public java.lang.String getLinkId() {
          return linkId;
        }

        /** ID of the profile filter link to delete. */
        public Delete setLinkId(java.lang.String linkId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(LINK_ID_PATTERN.matcher(linkId).matches(),
                "Parameter linkId must conform to the pattern " +
                "\\d+:\\d+");
          }
          this.linkId = linkId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns a single profile filter link.
       *
       * Create a request for the method "profileFilterLinks.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve profile filter link for.
       * @param webPropertyId Web property Id to retrieve profile filter link for.
       * @param profileId Profile ID to retrieve filter link for.
       * @param linkId ID of the profile filter link.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, profileId, linkId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.ProfileFilterLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern PROFILE_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern LINK_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+:\\d+");

        /**
         * Returns a single profile filter link.
         *
         * Create a request for the method "profileFilterLinks.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve profile filter link for.
         * @param webPropertyId Web property Id to retrieve profile filter link for.
         * @param profileId Profile ID to retrieve filter link for.
         * @param linkId ID of the profile filter link.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.ProfileFilterLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.linkId = com.google.api.client.util.Preconditions.checkNotNull(linkId, "Required parameter linkId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(LINK_ID_PATTERN.matcher(linkId).matches(),
                "Parameter linkId must conform to the pattern " +
                "\\d+:\\d+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID to retrieve profile filter link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve profile filter link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve profile filter link for. */
        public Get setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id to retrieve profile filter link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id to retrieve profile filter link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id to retrieve profile filter link for. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID to retrieve filter link for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** Profile ID to retrieve filter link for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** Profile ID to retrieve filter link for. */
        public Get setProfileId(java.lang.String profileId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.profileId = profileId;
          return this;
        }

        /** ID of the profile filter link. */
        @com.google.api.client.util.Key
        private java.lang.String linkId;

        /** ID of the profile filter link.
         */
        public java.lang.String getLinkId() {
          return linkId;
        }

        /** ID of the profile filter link. */
        public Get setLinkId(java.lang.String linkId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(LINK_ID_PATTERN.matcher(linkId).matches(),
                "Parameter linkId must conform to the pattern " +
                "\\d+:\\d+");
          }
          this.linkId = linkId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Create a new profile filter link.
       *
       * Create a request for the method "profileFilterLinks.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create profile filter link for.
       * @param webPropertyId Web property Id to create profile filter link for.
       * @param profileId Profile ID to create filter link for.
       * @param content the {@link com.google.api.services.analytics.model.ProfileFilterLink}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.ProfileFilterLink content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, profileId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.ProfileFilterLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern PROFILE_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        /**
         * Create a new profile filter link.
         *
         * Create a request for the method "profileFilterLinks.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create profile filter link for.
         * @param webPropertyId Web property Id to create profile filter link for.
         * @param profileId Profile ID to create filter link for.
         * @param content the {@link com.google.api.services.analytics.model.ProfileFilterLink}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.ProfileFilterLink content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.ProfileFilterLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create profile filter link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create profile filter link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create profile filter link for. */
        public Insert setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id to create profile filter link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id to create profile filter link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id to create profile filter link for. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID to create filter link for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** Profile ID to create filter link for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** Profile ID to create filter link for. */
        public Insert setProfileId(java.lang.String profileId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.profileId = profileId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists all profile filter links for a profile.
       *
       * Create a request for the method "profileFilterLinks.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve profile filter links for.
       * @param webPropertyId Web property Id for profile filter links for. Can either be a specific web property ID or '~all',
       *        which refers to all the web properties that user has access to.
       * @param profileId Profile ID to retrieve filter links for. Can either be a specific profile ID or '~all', which refers
       *        to all the profiles that user has access to.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.ProfileFilterLinks> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        /**
         * Lists all profile filter links for a profile.
         *
         * Create a request for the method "profileFilterLinks.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve profile filter links for.
         * @param webPropertyId Web property Id for profile filter links for. Can either be a specific web property ID or '~all',
       *        which refers to all the web properties that user has access to.
         * @param profileId Profile ID to retrieve filter links for. Can either be a specific profile ID or '~all', which refers
       *        to all the profiles that user has access to.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.ProfileFilterLinks.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account ID to retrieve profile filter links for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve profile filter links for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve profile filter links for. */
        public List setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /**
         * Web property Id for profile filter links for. Can either be a specific web property ID or
         * '~all', which refers to all the web properties that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id for profile filter links for. Can either be a specific web property ID or '~all',
       which refers to all the web properties that user has access to.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /**
         * Web property Id for profile filter links for. Can either be a specific web property ID or
         * '~all', which refers to all the web properties that user has access to.
         */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /**
         * Profile ID to retrieve filter links for. Can either be a specific profile ID or '~all',
         * which refers to all the profiles that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** Profile ID to retrieve filter links for. Can either be a specific profile ID or '~all', which
       refers to all the profiles that user has access to.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /**
         * Profile ID to retrieve filter links for. Can either be a specific profile ID or '~all',
         * which refers to all the profiles that user has access to.
         */
        public List setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** The maximum number of profile filter links to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of profile filter links to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of profile filter links to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Update an existing profile filter link. This method supports patch semantics.
       *
       * Create a request for the method "profileFilterLinks.patch".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which profile filter link belongs.
       * @param webPropertyId Web property Id to which profile filter link belongs
       * @param profileId Profile ID to which filter link belongs
       * @param linkId ID of the profile filter link to be updated.
       * @param content the {@link com.google.api.services.analytics.model.ProfileFilterLink}
       * @return the request
       */
      public Patch patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId, com.google.api.services.analytics.model.ProfileFilterLink content) throws java.io.IOException {
        Patch result = new Patch(accountId, webPropertyId, profileId, linkId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.ProfileFilterLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern PROFILE_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern LINK_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+:\\d+");

        /**
         * Update an existing profile filter link. This method supports patch semantics.
         *
         * Create a request for the method "profileFilterLinks.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which profile filter link belongs.
         * @param webPropertyId Web property Id to which profile filter link belongs
         * @param profileId Profile ID to which filter link belongs
         * @param linkId ID of the profile filter link to be updated.
         * @param content the {@link com.google.api.services.analytics.model.ProfileFilterLink}
         * @since 1.13
         */
        protected Patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId, com.google.api.services.analytics.model.ProfileFilterLink content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.ProfileFilterLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.linkId = com.google.api.client.util.Preconditions.checkNotNull(linkId, "Required parameter linkId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(LINK_ID_PATTERN.matcher(linkId).matches(),
                "Parameter linkId must conform to the pattern " +
                "\\d+:\\d+");
          }
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** Account ID to which profile filter link belongs. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which profile filter link belongs.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which profile filter link belongs. */
        public Patch setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id to which profile filter link belongs */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id to which profile filter link belongs
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id to which profile filter link belongs */
        public Patch setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID to which filter link belongs */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** Profile ID to which filter link belongs
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** Profile ID to which filter link belongs */
        public Patch setProfileId(java.lang.String profileId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.profileId = profileId;
          return this;
        }

        /** ID of the profile filter link to be updated. */
        @com.google.api.client.util.Key
        private java.lang.String linkId;

        /** ID of the profile filter link to be updated.
         */
        public java.lang.String getLinkId() {
          return linkId;
        }

        /** ID of the profile filter link to be updated. */
        public Patch setLinkId(java.lang.String linkId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(LINK_ID_PATTERN.matcher(linkId).matches(),
                "Parameter linkId must conform to the pattern " +
                "\\d+:\\d+");
          }
          this.linkId = linkId;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Update an existing profile filter link.
       *
       * Create a request for the method "profileFilterLinks.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which profile filter link belongs.
       * @param webPropertyId Web property Id to which profile filter link belongs
       * @param profileId Profile ID to which filter link belongs
       * @param linkId ID of the profile filter link to be updated.
       * @param content the {@link com.google.api.services.analytics.model.ProfileFilterLink}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId, com.google.api.services.analytics.model.ProfileFilterLink content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, profileId, linkId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.ProfileFilterLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern PROFILE_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern LINK_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+:\\d+");

        /**
         * Update an existing profile filter link.
         *
         * Create a request for the method "profileFilterLinks.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which profile filter link belongs.
         * @param webPropertyId Web property Id to which profile filter link belongs
         * @param profileId Profile ID to which filter link belongs
         * @param linkId ID of the profile filter link to be updated.
         * @param content the {@link com.google.api.services.analytics.model.ProfileFilterLink}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId, com.google.api.services.analytics.model.ProfileFilterLink content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.ProfileFilterLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.linkId = com.google.api.client.util.Preconditions.checkNotNull(linkId, "Required parameter linkId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(LINK_ID_PATTERN.matcher(linkId).matches(),
                "Parameter linkId must conform to the pattern " +
                "\\d+:\\d+");
          }
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID to which profile filter link belongs. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which profile filter link belongs.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which profile filter link belongs. */
        public Update setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id to which profile filter link belongs */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id to which profile filter link belongs
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id to which profile filter link belongs */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Profile ID to which filter link belongs */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** Profile ID to which filter link belongs
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** Profile ID to which filter link belongs */
        public Update setProfileId(java.lang.String profileId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "\\d+");
          }
          this.profileId = profileId;
          return this;
        }

        /** ID of the profile filter link to be updated. */
        @com.google.api.client.util.Key
        private java.lang.String linkId;

        /** ID of the profile filter link to be updated.
         */
        public java.lang.String getLinkId() {
          return linkId;
        }

        /** ID of the profile filter link to be updated. */
        public Update setLinkId(java.lang.String linkId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(LINK_ID_PATTERN.matcher(linkId).matches(),
                "Parameter linkId must conform to the pattern " +
                "\\d+:\\d+");
          }
          this.linkId = linkId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the ProfileUserLinks collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.ProfileUserLinks.List request = analytics.profileUserLinks().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public ProfileUserLinks profileUserLinks() {
      return new ProfileUserLinks();
    }

    /**
     * The "profileUserLinks" collection of methods.
     */
    public class ProfileUserLinks {

      /**
       * Removes a user from the given view (profile).
       *
       * Create a request for the method "profileUserLinks.delete".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to delete the user link for.
       * @param webPropertyId Web Property ID to delete the user link for.
       * @param profileId View (Profile) ID to delete the user link for.
       * @param linkId Link ID to delete the user link for.
       * @return the request
       */
      public Delete delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId) throws java.io.IOException {
        Delete result = new Delete(accountId, webPropertyId, profileId, linkId);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks/{linkId}";

        /**
         * Removes a user from the given view (profile).
         *
         * Create a request for the method "profileUserLinks.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to delete the user link for.
         * @param webPropertyId Web Property ID to delete the user link for.
         * @param profileId View (Profile) ID to delete the user link for.
         * @param linkId Link ID to delete the user link for.
         * @since 1.13
         */
        protected Delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.linkId = com.google.api.client.util.Preconditions.checkNotNull(linkId, "Required parameter linkId must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account ID to delete the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to delete the user link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to delete the user link for. */
        public Delete setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web Property ID to delete the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web Property ID to delete the user link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web Property ID to delete the user link for. */
        public Delete setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to delete the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to delete the user link for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to delete the user link for. */
        public Delete setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Link ID to delete the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String linkId;

        /** Link ID to delete the user link for.
         */
        public java.lang.String getLinkId() {
          return linkId;
        }

        /** Link ID to delete the user link for. */
        public Delete setLinkId(java.lang.String linkId) {
          this.linkId = linkId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Adds a new user to the given view (profile).
       *
       * Create a request for the method "profileUserLinks.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create the user link for.
       * @param webPropertyId Web Property ID to create the user link for.
       * @param profileId View (Profile) ID to create the user link for.
       * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.EntityUserLink content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, profileId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.EntityUserLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks";

        /**
         * Adds a new user to the given view (profile).
         *
         * Create a request for the method "profileUserLinks.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create the user link for.
         * @param webPropertyId Web Property ID to create the user link for.
         * @param profileId View (Profile) ID to create the user link for.
         * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.EntityUserLink content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.EntityUserLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create the user link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create the user link for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web Property ID to create the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web Property ID to create the user link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web Property ID to create the user link for. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to create the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to create the user link for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to create the user link for. */
        public Insert setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists profile-user links for a given view (profile).
       *
       * Create a request for the method "profileUserLinks.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID which the given view (profile) belongs to.
       * @param webPropertyId Web Property ID which the given view (profile) belongs to. Can either be a specific web property ID
       *        or '~all', which refers to all the web properties that user has access to.
       * @param profileId View (Profile) ID to retrieve the profile-user links for. Can either be a specific profile ID or
       *        '~all', which refers to all the profiles that user has access to.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.EntityUserLinks> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks";

        /**
         * Lists profile-user links for a given view (profile).
         *
         * Create a request for the method "profileUserLinks.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID which the given view (profile) belongs to.
         * @param webPropertyId Web Property ID which the given view (profile) belongs to. Can either be a specific web property ID
       *        or '~all', which refers to all the web properties that user has access to.
         * @param profileId View (Profile) ID to retrieve the profile-user links for. Can either be a specific profile ID or
       *        '~all', which refers to all the profiles that user has access to.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.EntityUserLinks.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account ID which the given view (profile) belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID which the given view (profile) belongs to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID which the given view (profile) belongs to. */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
         * Web Property ID which the given view (profile) belongs to. Can either be a specific web
         * property ID or '~all', which refers to all the web properties that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web Property ID which the given view (profile) belongs to. Can either be a specific web property ID
       or '~all', which refers to all the web properties that user has access to.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /**
         * Web Property ID which the given view (profile) belongs to. Can either be a specific web
         * property ID or '~all', which refers to all the web properties that user has access to.
         */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /**
         * View (Profile) ID to retrieve the profile-user links for. Can either be a specific
         * profile ID or '~all', which refers to all the profiles that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve the profile-user links for. Can either be a specific profile ID or
       '~all', which refers to all the profiles that user has access to.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /**
         * View (Profile) ID to retrieve the profile-user links for. Can either be a specific
         * profile ID or '~all', which refers to all the profiles that user has access to.
         */
        public List setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** The maximum number of profile-user links to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of profile-user links to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of profile-user links to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first profile-user link to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first profile-user link to retrieve. Use this parameter as a pagination mechanism
       along with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first profile-user link to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates permissions for an existing user on the given view (profile).
       *
       * Create a request for the method "profileUserLinks.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to update the user link for.
       * @param webPropertyId Web Property ID to update the user link for.
       * @param profileId View (Profile ID) to update the user link for.
       * @param linkId Link ID to update the user link for.
       * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId, com.google.api.services.analytics.model.EntityUserLink content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, profileId, linkId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.EntityUserLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks/{linkId}";

        /**
         * Updates permissions for an existing user on the given view (profile).
         *
         * Create a request for the method "profileUserLinks.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to update the user link for.
         * @param webPropertyId Web Property ID to update the user link for.
         * @param profileId View (Profile ID) to update the user link for.
         * @param linkId Link ID to update the user link for.
         * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String linkId, com.google.api.services.analytics.model.EntityUserLink content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.EntityUserLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.linkId = com.google.api.client.util.Preconditions.checkNotNull(linkId, "Required parameter linkId must be specified.");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID to update the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to update the user link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to update the user link for. */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web Property ID to update the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web Property ID to update the user link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web Property ID to update the user link for. */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile ID) to update the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile ID) to update the user link for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile ID) to update the user link for. */
        public Update setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** Link ID to update the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String linkId;

        /** Link ID to update the user link for.
         */
        public java.lang.String getLinkId() {
          return linkId;
        }

        /** Link ID to update the user link for. */
        public Update setLinkId(java.lang.String linkId) {
          this.linkId = linkId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Profiles collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Profiles.List request = analytics.profiles().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Profiles profiles() {
      return new Profiles();
    }

    /**
     * The "profiles" collection of methods.
     */
    public class Profiles {

      /**
       * Deletes a view (profile).
       *
       * Create a request for the method "profiles.delete".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to delete the view (profile) for.
       * @param webPropertyId Web property ID to delete the view (profile) for.
       * @param profileId ID of the view (profile) to be deleted.
       * @return the request
       */
      public Delete delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) throws java.io.IOException {
        Delete result = new Delete(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";

        /**
         * Deletes a view (profile).
         *
         * Create a request for the method "profiles.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to delete the view (profile) for.
         * @param webPropertyId Web property ID to delete the view (profile) for.
         * @param profileId ID of the view (profile) to be deleted.
         * @since 1.13
         */
        protected Delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account ID to delete the view (profile) for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to delete the view (profile) for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to delete the view (profile) for. */
        public Delete setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to delete the view (profile) for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to delete the view (profile) for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to delete the view (profile) for. */
        public Delete setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** ID of the view (profile) to be deleted. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** ID of the view (profile) to be deleted.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** ID of the view (profile) to be deleted. */
        public Delete setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets a view (profile) to which the user has access.
       *
       * Create a request for the method "profiles.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve the goal for.
       * @param webPropertyId Web property ID to retrieve the goal for.
       * @param profileId View (Profile) ID to retrieve the goal for.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.Profile> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("[0-9]+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-[0-9]+-[0-9]+");

        private final java.util.regex.Pattern PROFILE_ID_PATTERN =
            java.util.regex.Pattern.compile("[0-9]+");

        /**
         * Gets a view (profile) to which the user has access.
         *
         * Create a request for the method "profiles.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve the goal for.
         * @param webPropertyId Web property ID to retrieve the goal for.
         * @param profileId View (Profile) ID to retrieve the goal for.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Profile.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "[0-9]+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-[0-9]+-[0-9]+");
          }
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "[0-9]+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID to retrieve the goal for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve the goal for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve the goal for. */
        public Get setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "[0-9]+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve the goal for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve the goal for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve the goal for. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-[0-9]+-[0-9]+");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to retrieve the goal for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve the goal for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to retrieve the goal for. */
        public Get setProfileId(java.lang.String profileId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROFILE_ID_PATTERN.matcher(profileId).matches(),
                "Parameter profileId must conform to the pattern " +
                "[0-9]+");
          }
          this.profileId = profileId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Create a new view (profile).
       *
       * Create a request for the method "profiles.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create the view (profile) for.
       * @param webPropertyId Web property ID to create the view (profile) for.
       * @param content the {@link com.google.api.services.analytics.model.Profile}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.Profile content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.Profile> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";

        /**
         * Create a new view (profile).
         *
         * Create a request for the method "profiles.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create the view (profile) for.
         * @param webPropertyId Web property ID to create the view (profile) for.
         * @param content the {@link com.google.api.services.analytics.model.Profile}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.Profile content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.Profile.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create the view (profile) for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create the view (profile) for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create the view (profile) for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to create the view (profile) for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to create the view (profile) for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to create the view (profile) for. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists views (profiles) to which the user has access.
       *
       * Create a request for the method "profiles.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID for the view (profiles) to retrieve. Can either be a specific account ID or '~all', which
       *        refers to all the accounts to which the user has access.
       * @param webPropertyId Web property ID for the views (profiles) to retrieve. Can either be a specific web property ID or
       *        '~all', which refers to all the web properties to which the user has access.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Profiles> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";

        /**
         * Lists views (profiles) to which the user has access.
         *
         * Create a request for the method "profiles.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID for the view (profiles) to retrieve. Can either be a specific account ID or '~all', which
       *        refers to all the accounts to which the user has access.
         * @param webPropertyId Web property ID for the views (profiles) to retrieve. Can either be a specific web property ID or
       *        '~all', which refers to all the web properties to which the user has access.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Profiles.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
         * Account ID for the view (profiles) to retrieve. Can either be a specific account ID or
         * '~all', which refers to all the accounts to which the user has access.
         */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID for the view (profiles) to retrieve. Can either be a specific account ID or '~all',
       which refers to all the accounts to which the user has access.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /**
         * Account ID for the view (profiles) to retrieve. Can either be a specific account ID or
         * '~all', which refers to all the accounts to which the user has access.
         */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
         * Web property ID for the views (profiles) to retrieve. Can either be a specific web
         * property ID or '~all', which refers to all the web properties to which the user has
         * access.
         */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID for the views (profiles) to retrieve. Can either be a specific web property ID or
       '~all', which refers to all the web properties to which the user has access.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /**
         * Web property ID for the views (profiles) to retrieve. Can either be a specific web
         * property ID or '~all', which refers to all the web properties to which the user has
         * access.
         */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of views (profiles) to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of views (profiles) to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of views (profiles) to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing view (profile). This method supports patch semantics.
       *
       * Create a request for the method "profiles.patch".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which the view (profile) belongs
       * @param webPropertyId Web property ID to which the view (profile) belongs
       * @param profileId ID of the view (profile) to be updated.
       * @param content the {@link com.google.api.services.analytics.model.Profile}
       * @return the request
       */
      public Patch patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.Profile content) throws java.io.IOException {
        Patch result = new Patch(accountId, webPropertyId, profileId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.Profile> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";

        /**
         * Updates an existing view (profile). This method supports patch semantics.
         *
         * Create a request for the method "profiles.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which the view (profile) belongs
         * @param webPropertyId Web property ID to which the view (profile) belongs
         * @param profileId ID of the view (profile) to be updated.
         * @param content the {@link com.google.api.services.analytics.model.Profile}
         * @since 1.13
         */
        protected Patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.Profile content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.Profile.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** Account ID to which the view (profile) belongs */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which the view (profile) belongs
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which the view (profile) belongs */
        public Patch setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to which the view (profile) belongs */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to which the view (profile) belongs
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to which the view (profile) belongs */
        public Patch setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** ID of the view (profile) to be updated. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** ID of the view (profile) to be updated.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** ID of the view (profile) to be updated. */
        public Patch setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing view (profile).
       *
       * Create a request for the method "profiles.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which the view (profile) belongs
       * @param webPropertyId Web property ID to which the view (profile) belongs
       * @param profileId ID of the view (profile) to be updated.
       * @param content the {@link com.google.api.services.analytics.model.Profile}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.Profile content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, profileId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.Profile> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";

        /**
         * Updates an existing view (profile).
         *
         * Create a request for the method "profiles.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which the view (profile) belongs
         * @param webPropertyId Web property ID to which the view (profile) belongs
         * @param profileId ID of the view (profile) to be updated.
         * @param content the {@link com.google.api.services.analytics.model.Profile}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.Profile content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.Profile.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID to which the view (profile) belongs */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which the view (profile) belongs
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which the view (profile) belongs */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to which the view (profile) belongs */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to which the view (profile) belongs
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to which the view (profile) belongs */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** ID of the view (profile) to be updated. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** ID of the view (profile) to be updated.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** ID of the view (profile) to be updated. */
        public Update setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Segments collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Segments.List request = analytics.segments().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Segments segments() {
      return new Segments();
    }

    /**
     * The "segments" collection of methods.
     */
    public class Segments {

      /**
       * Lists segments to which the user has access.
       *
       * Create a request for the method "segments.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @return the request
       */
      public List list() throws java.io.IOException {
        List result = new List();
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Segments> {

        private static final String REST_PATH = "management/segments";

        /**
         * Lists segments to which the user has access.
         *
         * Create a request for the method "segments.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @since 1.13
         */
        protected List() {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Segments.class);
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** The maximum number of segments to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of segments to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of segments to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first segment to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first segment to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first segment to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the UnsampledReports collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.UnsampledReports.List request = analytics.unsampledReports().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public UnsampledReports unsampledReports() {
      return new UnsampledReports();
    }

    /**
     * The "unsampledReports" collection of methods.
     */
    public class UnsampledReports {

      /**
       * Returns a single unsampled report.
       *
       * Create a request for the method "unsampledReports.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve unsampled report for.
       * @param webPropertyId Web property ID to retrieve unsampled reports for.
       * @param profileId View (Profile) ID to retrieve unsampled report for.
       * @param unsampledReportId ID of the unsampled report to retrieve.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String unsampledReportId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, profileId, unsampledReportId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.UnsampledReport> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports/{unsampledReportId}";

        /**
         * Returns a single unsampled report.
         *
         * Create a request for the method "unsampledReports.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve unsampled report for.
         * @param webPropertyId Web property ID to retrieve unsampled reports for.
         * @param profileId View (Profile) ID to retrieve unsampled report for.
         * @param unsampledReportId ID of the unsampled report to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, java.lang.String unsampledReportId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.UnsampledReport.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          this.unsampledReportId = com.google.api.client.util.Preconditions.checkNotNull(unsampledReportId, "Required parameter unsampledReportId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID to retrieve unsampled report for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve unsampled report for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve unsampled report for. */
        public Get setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve unsampled reports for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve unsampled reports for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve unsampled reports for. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to retrieve unsampled report for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve unsampled report for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to retrieve unsampled report for. */
        public Get setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** ID of the unsampled report to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String unsampledReportId;

        /** ID of the unsampled report to retrieve.
         */
        public java.lang.String getUnsampledReportId() {
          return unsampledReportId;
        }

        /** ID of the unsampled report to retrieve. */
        public Get setUnsampledReportId(java.lang.String unsampledReportId) {
          this.unsampledReportId = unsampledReportId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Create a new unsampled report.
       *
       * Create a request for the method "unsampledReports.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create the unsampled report for.
       * @param webPropertyId Web property ID to create the unsampled report for.
       * @param profileId View (Profile) ID to create the unsampled report for.
       * @param content the {@link com.google.api.services.analytics.model.UnsampledReport}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.UnsampledReport content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, profileId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.UnsampledReport> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports";

        /**
         * Create a new unsampled report.
         *
         * Create a request for the method "unsampledReports.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create the unsampled report for.
         * @param webPropertyId Web property ID to create the unsampled report for.
         * @param profileId View (Profile) ID to create the unsampled report for.
         * @param content the {@link com.google.api.services.analytics.model.UnsampledReport}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId, com.google.api.services.analytics.model.UnsampledReport content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.UnsampledReport.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getEndDate(), "UnsampledReport.getEndDate()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getMetrics(), "UnsampledReport.getMetrics()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getStartDate(), "UnsampledReport.getStartDate()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getTitle(), "UnsampledReport.getTitle()");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create the unsampled report for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create the unsampled report for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create the unsampled report for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to create the unsampled report for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to create the unsampled report for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to create the unsampled report for. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** View (Profile) ID to create the unsampled report for. */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to create the unsampled report for.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /** View (Profile) ID to create the unsampled report for. */
        public Insert setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists unsampled reports to which the user has access.
       *
       * Create a request for the method "unsampledReports.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve unsampled reports for. Must be a specific account ID, ~all is not supported.
       * @param webPropertyId Web property ID to retrieve unsampled reports for. Must be a specific web property ID, ~all is not
       *        supported.
       * @param profileId View (Profile) ID to retrieve unsampled reports for. Must be a specific view (profile) ID, ~all is
       *        not supported.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, profileId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.UnsampledReports> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports";

        /**
         * Lists unsampled reports to which the user has access.
         *
         * Create a request for the method "unsampledReports.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve unsampled reports for. Must be a specific account ID, ~all is not supported.
         * @param webPropertyId Web property ID to retrieve unsampled reports for. Must be a specific web property ID, ~all is not
       *        supported.
         * @param profileId View (Profile) ID to retrieve unsampled reports for. Must be a specific view (profile) ID, ~all is
       *        not supported.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String profileId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.UnsampledReports.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.profileId = com.google.api.client.util.Preconditions.checkNotNull(profileId, "Required parameter profileId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
         * Account ID to retrieve unsampled reports for. Must be a specific account ID, ~all is not
         * supported.
         */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve unsampled reports for. Must be a specific account ID, ~all is not supported.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /**
         * Account ID to retrieve unsampled reports for. Must be a specific account ID, ~all is not
         * supported.
         */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
         * Web property ID to retrieve unsampled reports for. Must be a specific web property ID,
         * ~all is not supported.
         */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve unsampled reports for. Must be a specific web property ID, ~all is not
       supported.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /**
         * Web property ID to retrieve unsampled reports for. Must be a specific web property ID,
         * ~all is not supported.
         */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /**
         * View (Profile) ID to retrieve unsampled reports for. Must be a specific view (profile)
         * ID, ~all is not supported.
         */
        @com.google.api.client.util.Key
        private java.lang.String profileId;

        /** View (Profile) ID to retrieve unsampled reports for. Must be a specific view (profile) ID, ~all is
       not supported.
         */
        public java.lang.String getProfileId() {
          return profileId;
        }

        /**
         * View (Profile) ID to retrieve unsampled reports for. Must be a specific view (profile)
         * ID, ~all is not supported.
         */
        public List setProfileId(java.lang.String profileId) {
          this.profileId = profileId;
          return this;
        }

        /** The maximum number of unsampled reports to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of unsampled reports to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of unsampled reports to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first unsampled report to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first unsampled report to retrieve. Use this parameter as a pagination mechanism
       along with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first unsampled report to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Uploads collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Uploads.List request = analytics.uploads().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Uploads uploads() {
      return new Uploads();
    }

    /**
     * The "uploads" collection of methods.
     */
    public class Uploads {

      /**
       * Delete data associated with a previous upload.
       *
       * Create a request for the method "uploads.deleteUploadData".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link DeleteUploadData#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id for the uploads to be deleted.
       * @param webPropertyId Web property Id for the uploads to be deleted.
       * @param customDataSourceId Custom data source Id for the uploads to be deleted.
       * @param content the {@link com.google.api.services.analytics.model.AnalyticsDataimportDeleteUploadDataRequest}
       * @return the request
       */
      public DeleteUploadData deleteUploadData(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, com.google.api.services.analytics.model.AnalyticsDataimportDeleteUploadDataRequest content) throws java.io.IOException {
        DeleteUploadData result = new DeleteUploadData(accountId, webPropertyId, customDataSourceId, content);
        initialize(result);
        return result;
      }

      public class DeleteUploadData extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/deleteUploadData";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern CUSTOM_DATA_SOURCE_ID_PATTERN =
            java.util.regex.Pattern.compile(".{22}");

        /**
         * Delete data associated with a previous upload.
         *
         * Create a request for the method "uploads.deleteUploadData".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link DeleteUploadData#execute()} method to invoke the remote
         * operation. <p> {@link DeleteUploadData#initialize(com.google.api.client.googleapis.services.Abs
         * tractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param accountId Account Id for the uploads to be deleted.
         * @param webPropertyId Web property Id for the uploads to be deleted.
         * @param customDataSourceId Custom data source Id for the uploads to be deleted.
         * @param content the {@link com.google.api.services.analytics.model.AnalyticsDataimportDeleteUploadDataRequest}
         * @since 1.13
         */
        protected DeleteUploadData(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, com.google.api.services.analytics.model.AnalyticsDataimportDeleteUploadDataRequest content) {
          super(Analytics.this, "POST", REST_PATH, content, Void.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.customDataSourceId = com.google.api.client.util.Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(),
                "Parameter customDataSourceId must conform to the pattern " +
                ".{22}");
          }
        }

        @Override
        public DeleteUploadData setAlt(java.lang.String alt) {
          return (DeleteUploadData) super.setAlt(alt);
        }

        @Override
        public DeleteUploadData setFields(java.lang.String fields) {
          return (DeleteUploadData) super.setFields(fields);
        }

        @Override
        public DeleteUploadData setKey(java.lang.String key) {
          return (DeleteUploadData) super.setKey(key);
        }

        @Override
        public DeleteUploadData setOauthToken(java.lang.String oauthToken) {
          return (DeleteUploadData) super.setOauthToken(oauthToken);
        }

        @Override
        public DeleteUploadData setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (DeleteUploadData) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public DeleteUploadData setQuotaUser(java.lang.String quotaUser) {
          return (DeleteUploadData) super.setQuotaUser(quotaUser);
        }

        @Override
        public DeleteUploadData setUserIp(java.lang.String userIp) {
          return (DeleteUploadData) super.setUserIp(userIp);
        }

        /** Account Id for the uploads to be deleted. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account Id for the uploads to be deleted.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account Id for the uploads to be deleted. */
        public DeleteUploadData setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id for the uploads to be deleted. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id for the uploads to be deleted.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id for the uploads to be deleted. */
        public DeleteUploadData setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom data source Id for the uploads to be deleted. */
        @com.google.api.client.util.Key
        private java.lang.String customDataSourceId;

        /** Custom data source Id for the uploads to be deleted.
         */
        public java.lang.String getCustomDataSourceId() {
          return customDataSourceId;
        }

        /** Custom data source Id for the uploads to be deleted. */
        public DeleteUploadData setCustomDataSourceId(java.lang.String customDataSourceId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(),
                "Parameter customDataSourceId must conform to the pattern " +
                ".{22}");
          }
          this.customDataSourceId = customDataSourceId;
          return this;
        }

        @Override
        public DeleteUploadData set(String parameterName, Object value) {
          return (DeleteUploadData) super.set(parameterName, value);
        }
      }
      /**
       * List uploads to which the user has access.
       *
       * Create a request for the method "uploads.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id for the upload to retrieve.
       * @param webPropertyId Web property Id for the upload to retrieve.
       * @param customDataSourceId Custom data source Id for upload to retrieve.
       * @param uploadId Upload Id to retrieve.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, java.lang.String uploadId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, customDataSourceId, uploadId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.Upload> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/uploads/{uploadId}";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern CUSTOM_DATA_SOURCE_ID_PATTERN =
            java.util.regex.Pattern.compile(".{22}");

        private final java.util.regex.Pattern UPLOAD_ID_PATTERN =
            java.util.regex.Pattern.compile(".{22}");

        /**
         * List uploads to which the user has access.
         *
         * Create a request for the method "uploads.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id for the upload to retrieve.
         * @param webPropertyId Web property Id for the upload to retrieve.
         * @param customDataSourceId Custom data source Id for upload to retrieve.
         * @param uploadId Upload Id to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, java.lang.String uploadId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Upload.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.customDataSourceId = com.google.api.client.util.Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(),
                "Parameter customDataSourceId must conform to the pattern " +
                ".{22}");
          }
          this.uploadId = com.google.api.client.util.Preconditions.checkNotNull(uploadId, "Required parameter uploadId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(UPLOAD_ID_PATTERN.matcher(uploadId).matches(),
                "Parameter uploadId must conform to the pattern " +
                ".{22}");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account Id for the upload to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account Id for the upload to retrieve.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account Id for the upload to retrieve. */
        public Get setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id for the upload to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id for the upload to retrieve.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id for the upload to retrieve. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom data source Id for upload to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String customDataSourceId;

        /** Custom data source Id for upload to retrieve.
         */
        public java.lang.String getCustomDataSourceId() {
          return customDataSourceId;
        }

        /** Custom data source Id for upload to retrieve. */
        public Get setCustomDataSourceId(java.lang.String customDataSourceId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(),
                "Parameter customDataSourceId must conform to the pattern " +
                ".{22}");
          }
          this.customDataSourceId = customDataSourceId;
          return this;
        }

        /** Upload Id to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String uploadId;

        /** Upload Id to retrieve.
         */
        public java.lang.String getUploadId() {
          return uploadId;
        }

        /** Upload Id to retrieve. */
        public Get setUploadId(java.lang.String uploadId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(UPLOAD_ID_PATTERN.matcher(uploadId).matches(),
                "Parameter uploadId must conform to the pattern " +
                ".{22}");
          }
          this.uploadId = uploadId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * List uploads to which the user has access.
       *
       * Create a request for the method "uploads.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id for the uploads to retrieve.
       * @param webPropertyId Web property Id for the uploads to retrieve.
       * @param customDataSourceId Custom data source Id for uploads to retrieve.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId, customDataSourceId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Uploads> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/uploads";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-(\\d+)-(\\d+)");

        private final java.util.regex.Pattern CUSTOM_DATA_SOURCE_ID_PATTERN =
            java.util.regex.Pattern.compile(".{22}");

        /**
         * List uploads to which the user has access.
         *
         * Create a request for the method "uploads.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id for the uploads to retrieve.
         * @param webPropertyId Web property Id for the uploads to retrieve.
         * @param customDataSourceId Custom data source Id for uploads to retrieve.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Uploads.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.customDataSourceId = com.google.api.client.util.Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(),
                "Parameter customDataSourceId must conform to the pattern " +
                ".{22}");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account Id for the uploads to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account Id for the uploads to retrieve.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account Id for the uploads to retrieve. */
        public List setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property Id for the uploads to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property Id for the uploads to retrieve.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property Id for the uploads to retrieve. */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-(\\d+)-(\\d+)");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom data source Id for uploads to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String customDataSourceId;

        /** Custom data source Id for uploads to retrieve.
         */
        public java.lang.String getCustomDataSourceId() {
          return customDataSourceId;
        }

        /** Custom data source Id for uploads to retrieve. */
        public List setCustomDataSourceId(java.lang.String customDataSourceId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(),
                "Parameter customDataSourceId must conform to the pattern " +
                ".{22}");
          }
          this.customDataSourceId = customDataSourceId;
          return this;
        }

        /** The maximum number of uploads to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of uploads to include in this response.

       [minimum: 1]
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of uploads to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A 1-based index of the first upload to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** A 1-based index of the first upload to retrieve. Use this parameter as a pagination mechanism along
       with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * A 1-based index of the first upload to retrieve. Use this parameter as a pagination
         * mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Upload data for a custom data source.
       *
       * Create a request for the method "uploads.uploadData".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link UploadData#execute()} method to invoke the remote operation.
       *
       * @param accountId Account Id associated with the upload.
       * @param webPropertyId Web property UA-string associated with the upload.
       * @param customDataSourceId Custom data source Id to which the data being uploaded belongs.
       * @return the request
       */
      public UploadData uploadData(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId) throws java.io.IOException {
        UploadData result = new UploadData(accountId, webPropertyId, customDataSourceId);
        initialize(result);
        return result;
      }

      /**
       * Upload data for a custom data source.
       *
       * Create a request for the method "uploads.uploadData".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any optional
       * parameters, call the {@link UploadData#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param accountId Account Id associated with the upload.@param webPropertyId Web property UA-string associated with the upload.@param customDataSourceId Custom data source Id to which the data being uploaded belongs.
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public UploadData uploadData(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        UploadData result = new UploadData(accountId, webPropertyId, customDataSourceId, mediaContent);
        initialize(result);
        return result;
      }

      public class UploadData extends AnalyticsRequest<com.google.api.services.analytics.model.Upload> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/uploads";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-\\d+-\\d+");

        /**
         * Upload data for a custom data source.
         *
         * Create a request for the method "uploads.uploadData".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link UploadData#execute()} method to invoke the remote
         * operation. <p> {@link
         * UploadData#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account Id associated with the upload.
         * @param webPropertyId Web property UA-string associated with the upload.
         * @param customDataSourceId Custom data source Id to which the data being uploaded belongs.
         * @since 1.13
         */
        protected UploadData(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId) {
          super(Analytics.this, "POST", REST_PATH, null, com.google.api.services.analytics.model.Upload.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-\\d+-\\d+");
          }
          this.customDataSourceId = com.google.api.client.util.Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
        }

        /**
         * Upload data for a custom data source.
         *
         * Create a request for the method "uploads.uploadData".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link UploadData#execute()} method to invoke the remote
         * operation. <p> {@link
         * UploadData#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param accountId Account Id associated with the upload.@param webPropertyId Web property UA-string associated with the upload.@param customDataSourceId Custom data source Id to which the data being uploaded belongs.
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected UploadData(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String customDataSourceId, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(Analytics.this, "POST", "/upload/" + getServicePath() + REST_PATH, null, com.google.api.services.analytics.model.Upload.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.customDataSourceId = com.google.api.client.util.Preconditions.checkNotNull(customDataSourceId, "Required parameter customDataSourceId must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public UploadData setAlt(java.lang.String alt) {
          return (UploadData) super.setAlt(alt);
        }

        @Override
        public UploadData setFields(java.lang.String fields) {
          return (UploadData) super.setFields(fields);
        }

        @Override
        public UploadData setKey(java.lang.String key) {
          return (UploadData) super.setKey(key);
        }

        @Override
        public UploadData setOauthToken(java.lang.String oauthToken) {
          return (UploadData) super.setOauthToken(oauthToken);
        }

        @Override
        public UploadData setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UploadData) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UploadData setQuotaUser(java.lang.String quotaUser) {
          return (UploadData) super.setQuotaUser(quotaUser);
        }

        @Override
        public UploadData setUserIp(java.lang.String userIp) {
          return (UploadData) super.setUserIp(userIp);
        }

        /** Account Id associated with the upload. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account Id associated with the upload.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account Id associated with the upload. */
        public UploadData setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property UA-string associated with the upload. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property UA-string associated with the upload.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property UA-string associated with the upload. */
        public UploadData setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-\\d+-\\d+");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Custom data source Id to which the data being uploaded belongs. */
        @com.google.api.client.util.Key
        private java.lang.String customDataSourceId;

        /** Custom data source Id to which the data being uploaded belongs.
         */
        public java.lang.String getCustomDataSourceId() {
          return customDataSourceId;
        }

        /** Custom data source Id to which the data being uploaded belongs. */
        public UploadData setCustomDataSourceId(java.lang.String customDataSourceId) {
          this.customDataSourceId = customDataSourceId;
          return this;
        }

        @Override
        public UploadData set(String parameterName, Object value) {
          return (UploadData) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the WebPropertyAdWordsLinks collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.WebPropertyAdWordsLinks.List request = analytics.webPropertyAdWordsLinks().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public WebPropertyAdWordsLinks webPropertyAdWordsLinks() {
      return new WebPropertyAdWordsLinks();
    }

    /**
     * The "webPropertyAdWordsLinks" collection of methods.
     */
    public class WebPropertyAdWordsLinks {

      /**
       * Deletes a web property-AdWords link.
       *
       * Create a request for the method "webPropertyAdWordsLinks.delete".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId ID of the account which the given web property belongs to.
       * @param webPropertyId Web property ID to delete the AdWords link for.
       * @param webPropertyAdWordsLinkId Web property AdWords link ID.
       * @return the request
       */
      public Delete delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String webPropertyAdWordsLinkId) throws java.io.IOException {
        Delete result = new Delete(accountId, webPropertyId, webPropertyAdWordsLinkId);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";

        /**
         * Deletes a web property-AdWords link.
         *
         * Create a request for the method "webPropertyAdWordsLinks.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId ID of the account which the given web property belongs to.
         * @param webPropertyId Web property ID to delete the AdWords link for.
         * @param webPropertyAdWordsLinkId Web property AdWords link ID.
         * @since 1.13
         */
        protected Delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String webPropertyAdWordsLinkId) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.webPropertyAdWordsLinkId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyAdWordsLinkId, "Required parameter webPropertyAdWordsLinkId must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** ID of the account which the given web property belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** ID of the account which the given web property belongs to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** ID of the account which the given web property belongs to. */
        public Delete setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to delete the AdWords link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to delete the AdWords link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to delete the AdWords link for. */
        public Delete setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Web property AdWords link ID. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyAdWordsLinkId;

        /** Web property AdWords link ID.
         */
        public java.lang.String getWebPropertyAdWordsLinkId() {
          return webPropertyAdWordsLinkId;
        }

        /** Web property AdWords link ID. */
        public Delete setWebPropertyAdWordsLinkId(java.lang.String webPropertyAdWordsLinkId) {
          this.webPropertyAdWordsLinkId = webPropertyAdWordsLinkId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns a web property-AdWords link to which the user has access.
       *
       * Create a request for the method "webPropertyAdWordsLinks.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId ID of the account which the given web property belongs to.
       * @param webPropertyId Web property ID to retrieve the AdWords link for.
       * @param webPropertyAdWordsLinkId Web property-AdWords link ID.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String webPropertyAdWordsLinkId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId, webPropertyAdWordsLinkId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.EntityAdWordsLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";

        /**
         * Returns a web property-AdWords link to which the user has access.
         *
         * Create a request for the method "webPropertyAdWordsLinks.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId ID of the account which the given web property belongs to.
         * @param webPropertyId Web property ID to retrieve the AdWords link for.
         * @param webPropertyAdWordsLinkId Web property-AdWords link ID.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String webPropertyAdWordsLinkId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.EntityAdWordsLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.webPropertyAdWordsLinkId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyAdWordsLinkId, "Required parameter webPropertyAdWordsLinkId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** ID of the account which the given web property belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** ID of the account which the given web property belongs to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** ID of the account which the given web property belongs to. */
        public Get setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve the AdWords link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve the AdWords link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve the AdWords link for. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Web property-AdWords link ID. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyAdWordsLinkId;

        /** Web property-AdWords link ID.
         */
        public java.lang.String getWebPropertyAdWordsLinkId() {
          return webPropertyAdWordsLinkId;
        }

        /** Web property-AdWords link ID. */
        public Get setWebPropertyAdWordsLinkId(java.lang.String webPropertyAdWordsLinkId) {
          this.webPropertyAdWordsLinkId = webPropertyAdWordsLinkId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Creates a webProperty-AdWords link.
       *
       * Create a request for the method "webPropertyAdWordsLinks.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId ID of the Google Analytics account to create the link for.
       * @param webPropertyId Web property ID to create the link for.
       * @param content the {@link com.google.api.services.analytics.model.EntityAdWordsLink}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.EntityAdWordsLink content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.EntityAdWordsLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks";

        /**
         * Creates a webProperty-AdWords link.
         *
         * Create a request for the method "webPropertyAdWordsLinks.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId ID of the Google Analytics account to create the link for.
         * @param webPropertyId Web property ID to create the link for.
         * @param content the {@link com.google.api.services.analytics.model.EntityAdWordsLink}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.EntityAdWordsLink content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.EntityAdWordsLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "EntityAdWordsLink.getName()");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** ID of the Google Analytics account to create the link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** ID of the Google Analytics account to create the link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** ID of the Google Analytics account to create the link for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to create the link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to create the link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to create the link for. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists webProperty-AdWords links for a given web property.
       *
       * Create a request for the method "webPropertyAdWordsLinks.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId ID of the account which the given web property belongs to.
       * @param webPropertyId Web property ID to retrieve the AdWords links for.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.EntityAdWordsLinks> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("\\d+");

        /**
         * Lists webProperty-AdWords links for a given web property.
         *
         * Create a request for the method "webPropertyAdWordsLinks.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId ID of the account which the given web property belongs to.
         * @param webPropertyId Web property ID to retrieve the AdWords links for.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.EntityAdWordsLinks.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** ID of the account which the given web property belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** ID of the account which the given web property belongs to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** ID of the account which the given web property belongs to. */
        public List setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "\\d+");
          }
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve the AdWords links for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve the AdWords links for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve the AdWords links for. */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of webProperty-AdWords links to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of webProperty-AdWords links to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of webProperty-AdWords links to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first webProperty-AdWords link to retrieve. Use this parameter as a
         * pagination mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first webProperty-AdWords link to retrieve. Use this parameter as a pagination
       mechanism along with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first webProperty-AdWords link to retrieve. Use this parameter as a
         * pagination mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing webProperty-AdWords link. This method supports patch semantics.
       *
       * Create a request for the method "webPropertyAdWordsLinks.patch".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId ID of the account which the given web property belongs to.
       * @param webPropertyId Web property ID to retrieve the AdWords link for.
       * @param webPropertyAdWordsLinkId Web property-AdWords link ID.
       * @param content the {@link com.google.api.services.analytics.model.EntityAdWordsLink}
       * @return the request
       */
      public Patch patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String webPropertyAdWordsLinkId, com.google.api.services.analytics.model.EntityAdWordsLink content) throws java.io.IOException {
        Patch result = new Patch(accountId, webPropertyId, webPropertyAdWordsLinkId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.EntityAdWordsLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";

        /**
         * Updates an existing webProperty-AdWords link. This method supports patch semantics.
         *
         * Create a request for the method "webPropertyAdWordsLinks.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId ID of the account which the given web property belongs to.
         * @param webPropertyId Web property ID to retrieve the AdWords link for.
         * @param webPropertyAdWordsLinkId Web property-AdWords link ID.
         * @param content the {@link com.google.api.services.analytics.model.EntityAdWordsLink}
         * @since 1.13
         */
        protected Patch(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String webPropertyAdWordsLinkId, com.google.api.services.analytics.model.EntityAdWordsLink content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.EntityAdWordsLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.webPropertyAdWordsLinkId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyAdWordsLinkId, "Required parameter webPropertyAdWordsLinkId must be specified.");
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** ID of the account which the given web property belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** ID of the account which the given web property belongs to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** ID of the account which the given web property belongs to. */
        public Patch setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve the AdWords link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve the AdWords link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve the AdWords link for. */
        public Patch setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Web property-AdWords link ID. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyAdWordsLinkId;

        /** Web property-AdWords link ID.
         */
        public java.lang.String getWebPropertyAdWordsLinkId() {
          return webPropertyAdWordsLinkId;
        }

        /** Web property-AdWords link ID. */
        public Patch setWebPropertyAdWordsLinkId(java.lang.String webPropertyAdWordsLinkId) {
          this.webPropertyAdWordsLinkId = webPropertyAdWordsLinkId;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing webProperty-AdWords link.
       *
       * Create a request for the method "webPropertyAdWordsLinks.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId ID of the account which the given web property belongs to.
       * @param webPropertyId Web property ID to retrieve the AdWords link for.
       * @param webPropertyAdWordsLinkId Web property-AdWords link ID.
       * @param content the {@link com.google.api.services.analytics.model.EntityAdWordsLink}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String webPropertyAdWordsLinkId, com.google.api.services.analytics.model.EntityAdWordsLink content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, webPropertyAdWordsLinkId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.EntityAdWordsLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";

        /**
         * Updates an existing webProperty-AdWords link.
         *
         * Create a request for the method "webPropertyAdWordsLinks.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId ID of the account which the given web property belongs to.
         * @param webPropertyId Web property ID to retrieve the AdWords link for.
         * @param webPropertyAdWordsLinkId Web property-AdWords link ID.
         * @param content the {@link com.google.api.services.analytics.model.EntityAdWordsLink}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String webPropertyAdWordsLinkId, com.google.api.services.analytics.model.EntityAdWordsLink content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.EntityAdWordsLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.webPropertyAdWordsLinkId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyAdWordsLinkId, "Required parameter webPropertyAdWordsLinkId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "EntityAdWordsLink.getName()");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** ID of the account which the given web property belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** ID of the account which the given web property belongs to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** ID of the account which the given web property belongs to. */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to retrieve the AdWords link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to retrieve the AdWords link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to retrieve the AdWords link for. */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Web property-AdWords link ID. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyAdWordsLinkId;

        /** Web property-AdWords link ID.
         */
        public java.lang.String getWebPropertyAdWordsLinkId() {
          return webPropertyAdWordsLinkId;
        }

        /** Web property-AdWords link ID. */
        public Update setWebPropertyAdWordsLinkId(java.lang.String webPropertyAdWordsLinkId) {
          this.webPropertyAdWordsLinkId = webPropertyAdWordsLinkId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Webproperties collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Webproperties.List request = analytics.webproperties().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Webproperties webproperties() {
      return new Webproperties();
    }

    /**
     * The "webproperties" collection of methods.
     */
    public class Webproperties {

      /**
       * Gets a web property to which the user has access.
       *
       * Create a request for the method "webproperties.get".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve the web property for.
       * @param webPropertyId ID to retrieve the web property for.
       * @return the request
       */
      public Get get(java.lang.String accountId, java.lang.String webPropertyId) throws java.io.IOException {
        Get result = new Get(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class Get extends AnalyticsRequest<com.google.api.services.analytics.model.Webproperty> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}";

        private final java.util.regex.Pattern ACCOUNT_ID_PATTERN =
            java.util.regex.Pattern.compile("[0-9]+");

        private final java.util.regex.Pattern WEB_PROPERTY_ID_PATTERN =
            java.util.regex.Pattern.compile("UA-[0-9]+-[0-9]+");

        /**
         * Gets a web property to which the user has access.
         *
         * Create a request for the method "webproperties.get".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve the web property for.
         * @param webPropertyId ID to retrieve the web property for.
         * @since 1.13
         */
        protected Get(java.lang.String accountId, java.lang.String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Webproperty.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "[0-9]+");
          }
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-[0-9]+-[0-9]+");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUserIp(java.lang.String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Account ID to retrieve the web property for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve the web property for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to retrieve the web property for. */
        public Get setAccountId(java.lang.String accountId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_ID_PATTERN.matcher(accountId).matches(),
                "Parameter accountId must conform to the pattern " +
                "[0-9]+");
          }
          this.accountId = accountId;
          return this;
        }

        /** ID to retrieve the web property for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** ID to retrieve the web property for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** ID to retrieve the web property for. */
        public Get setWebPropertyId(java.lang.String webPropertyId) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(),
                "Parameter webPropertyId must conform to the pattern " +
                "UA-[0-9]+-[0-9]+");
          }
          this.webPropertyId = webPropertyId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Create a new property if the account has fewer than 20 properties. Web properties are visible in
       * the Google Analytics interface only if they have at least one profile.
       *
       * Create a request for the method "webproperties.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create the web property for.
       * @param content the {@link com.google.api.services.analytics.model.Webproperty}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, com.google.api.services.analytics.model.Webproperty content) throws java.io.IOException {
        Insert result = new Insert(accountId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.Webproperty> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties";

        /**
         * Create a new property if the account has fewer than 20 properties. Web properties are visible
         * in the Google Analytics interface only if they have at least one profile.
         *
         * Create a request for the method "webproperties.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create the web property for.
         * @param content the {@link com.google.api.services.analytics.model.Webproperty}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, com.google.api.services.analytics.model.Webproperty content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.Webproperty.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create the web property for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create the web property for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create the web property for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists web properties to which the user has access.
       *
       * Create a request for the method "webproperties.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       *        refers to all the accounts that user has access to.
       * @return the request
       */
      public List list(java.lang.String accountId) throws java.io.IOException {
        List result = new List(accountId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Webproperties> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties";

        /**
         * Lists web properties to which the user has access.
         *
         * Create a request for the method "webproperties.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       *        refers to all the accounts that user has access to.
         * @since 1.13
         */
        protected List(java.lang.String accountId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Webproperties.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /**
         * Account ID to retrieve web properties for. Can either be a specific account ID or '~all',
         * which refers to all the accounts that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which
       refers to all the accounts that user has access to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /**
         * Account ID to retrieve web properties for. Can either be a specific account ID or '~all',
         * which refers to all the accounts that user has access to.
         */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** The maximum number of web properties to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of web properties to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of web properties to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
       the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
         * along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing web property. This method supports patch semantics.
       *
       * Create a request for the method "webproperties.patch".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which the web property belongs
       * @param webPropertyId Web property ID
       * @param content the {@link com.google.api.services.analytics.model.Webproperty}
       * @return the request
       */
      public Patch patch(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.Webproperty content) throws java.io.IOException {
        Patch result = new Patch(accountId, webPropertyId, content);
        initialize(result);
        return result;
      }

      public class Patch extends AnalyticsRequest<com.google.api.services.analytics.model.Webproperty> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}";

        /**
         * Updates an existing web property. This method supports patch semantics.
         *
         * Create a request for the method "webproperties.patch".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which the web property belongs
         * @param webPropertyId Web property ID
         * @param content the {@link com.google.api.services.analytics.model.Webproperty}
         * @since 1.13
         */
        protected Patch(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.Webproperty content) {
          super(Analytics.this, "PATCH", REST_PATH, content, com.google.api.services.analytics.model.Webproperty.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUserIp(java.lang.String userIp) {
          return (Patch) super.setUserIp(userIp);
        }

        /** Account ID to which the web property belongs */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which the web property belongs
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which the web property belongs */
        public Patch setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID */
        public Patch setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing web property.
       *
       * Create a request for the method "webproperties.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to which the web property belongs
       * @param webPropertyId Web property ID
       * @param content the {@link com.google.api.services.analytics.model.Webproperty}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.Webproperty content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.Webproperty> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}";

        /**
         * Updates an existing web property.
         *
         * Create a request for the method "webproperties.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to which the web property belongs
         * @param webPropertyId Web property ID
         * @param content the {@link com.google.api.services.analytics.model.Webproperty}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.Webproperty content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.Webproperty.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID to which the web property belongs */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to which the web property belongs
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to which the web property belongs */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the WebpropertyUserLinks collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.WebpropertyUserLinks.List request = analytics.webpropertyUserLinks().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public WebpropertyUserLinks webpropertyUserLinks() {
      return new WebpropertyUserLinks();
    }

    /**
     * The "webpropertyUserLinks" collection of methods.
     */
    public class WebpropertyUserLinks {

      /**
       * Removes a user from the given web property.
       *
       * Create a request for the method "webpropertyUserLinks.delete".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to delete the user link for.
       * @param webPropertyId Web Property ID to delete the user link for.
       * @param linkId Link ID to delete the user link for.
       * @return the request
       */
      public Delete delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String linkId) throws java.io.IOException {
        Delete result = new Delete(accountId, webPropertyId, linkId);
        initialize(result);
        return result;
      }

      public class Delete extends AnalyticsRequest<Void> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks/{linkId}";

        /**
         * Removes a user from the given web property.
         *
         * Create a request for the method "webpropertyUserLinks.delete".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to delete the user link for.
         * @param webPropertyId Web Property ID to delete the user link for.
         * @param linkId Link ID to delete the user link for.
         * @since 1.13
         */
        protected Delete(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String linkId) {
          super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.linkId = com.google.api.client.util.Preconditions.checkNotNull(linkId, "Required parameter linkId must be specified.");
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUserIp(java.lang.String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Account ID to delete the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to delete the user link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to delete the user link for. */
        public Delete setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web Property ID to delete the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web Property ID to delete the user link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web Property ID to delete the user link for. */
        public Delete setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Link ID to delete the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String linkId;

        /** Link ID to delete the user link for.
         */
        public java.lang.String getLinkId() {
          return linkId;
        }

        /** Link ID to delete the user link for. */
        public Delete setLinkId(java.lang.String linkId) {
          this.linkId = linkId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Adds a new user to the given web property.
       *
       * Create a request for the method "webpropertyUserLinks.insert".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to create the user link for.
       * @param webPropertyId Web Property ID to create the user link for.
       * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
       * @return the request
       */
      public Insert insert(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.EntityUserLink content) throws java.io.IOException {
        Insert result = new Insert(accountId, webPropertyId, content);
        initialize(result);
        return result;
      }

      public class Insert extends AnalyticsRequest<com.google.api.services.analytics.model.EntityUserLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks";

        /**
         * Adds a new user to the given web property.
         *
         * Create a request for the method "webpropertyUserLinks.insert".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
         * <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to create the user link for.
         * @param webPropertyId Web Property ID to create the user link for.
         * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
         * @since 1.13
         */
        protected Insert(java.lang.String accountId, java.lang.String webPropertyId, com.google.api.services.analytics.model.EntityUserLink content) {
          super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.EntityUserLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUserIp(java.lang.String userIp) {
          return (Insert) super.setUserIp(userIp);
        }

        /** Account ID to create the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to create the user link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to create the user link for. */
        public Insert setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web Property ID to create the user link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web Property ID to create the user link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web Property ID to create the user link for. */
        public Insert setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists webProperty-user links for a given web property.
       *
       * Create a request for the method "webpropertyUserLinks.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID which the given web property belongs to.
       * @param webPropertyId Web Property ID for the webProperty-user links to retrieve. Can either be a specific web property ID
       *        or '~all', which refers to all the web properties that user has access to.
       * @return the request
       */
      public List list(java.lang.String accountId, java.lang.String webPropertyId) throws java.io.IOException {
        List result = new List(accountId, webPropertyId);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.EntityUserLinks> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks";

        /**
         * Lists webProperty-user links for a given web property.
         *
         * Create a request for the method "webpropertyUserLinks.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID which the given web property belongs to.
         * @param webPropertyId Web Property ID for the webProperty-user links to retrieve. Can either be a specific web property ID
       *        or '~all', which refers to all the web properties that user has access to.
         * @since 1.13
         */
        protected List(java.lang.String accountId, java.lang.String webPropertyId) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.EntityUserLinks.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Account ID which the given web property belongs to. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID which the given web property belongs to.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID which the given web property belongs to. */
        public List setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /**
         * Web Property ID for the webProperty-user links to retrieve. Can either be a specific web
         * property ID or '~all', which refers to all the web properties that user has access to.
         */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web Property ID for the webProperty-user links to retrieve. Can either be a specific web property
       ID or '~all', which refers to all the web properties that user has access to.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /**
         * Web Property ID for the webProperty-user links to retrieve. Can either be a specific web
         * property ID or '~all', which refers to all the web properties that user has access to.
         */
        public List setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** The maximum number of webProperty-user Links to include in this response. */
        @com.google.api.client.util.Key("max-results")
        private java.lang.Integer maxResults;

        /** The maximum number of webProperty-user Links to include in this response.
         */
        public java.lang.Integer getMaxResults() {
          return maxResults;
        }

        /** The maximum number of webProperty-user Links to include in this response. */
        public List setMaxResults(java.lang.Integer maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * An index of the first webProperty-user link to retrieve. Use this parameter as a
         * pagination mechanism along with the max-results parameter.
         */
        @com.google.api.client.util.Key("start-index")
        private java.lang.Integer startIndex;

        /** An index of the first webProperty-user link to retrieve. Use this parameter as a pagination
       mechanism along with the max-results parameter.

       [minimum: 1]
         */
        public java.lang.Integer getStartIndex() {
          return startIndex;
        }

        /**
         * An index of the first webProperty-user link to retrieve. Use this parameter as a
         * pagination mechanism along with the max-results parameter.
         */
        public List setStartIndex(java.lang.Integer startIndex) {
          this.startIndex = startIndex;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates permissions for an existing user on the given web property.
       *
       * Create a request for the method "webpropertyUserLinks.update".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param accountId Account ID to update the account-user link for.
       * @param webPropertyId Web property ID to update the account-user link for.
       * @param linkId Link ID to update the account-user link for.
       * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
       * @return the request
       */
      public Update update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String linkId, com.google.api.services.analytics.model.EntityUserLink content) throws java.io.IOException {
        Update result = new Update(accountId, webPropertyId, linkId, content);
        initialize(result);
        return result;
      }

      public class Update extends AnalyticsRequest<com.google.api.services.analytics.model.EntityUserLink> {

        private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks/{linkId}";

        /**
         * Updates permissions for an existing user on the given web property.
         *
         * Create a request for the method "webpropertyUserLinks.update".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param accountId Account ID to update the account-user link for.
         * @param webPropertyId Web property ID to update the account-user link for.
         * @param linkId Link ID to update the account-user link for.
         * @param content the {@link com.google.api.services.analytics.model.EntityUserLink}
         * @since 1.13
         */
        protected Update(java.lang.String accountId, java.lang.String webPropertyId, java.lang.String linkId, com.google.api.services.analytics.model.EntityUserLink content) {
          super(Analytics.this, "PUT", REST_PATH, content, com.google.api.services.analytics.model.EntityUserLink.class);
          this.accountId = com.google.api.client.util.Preconditions.checkNotNull(accountId, "Required parameter accountId must be specified.");
          this.webPropertyId = com.google.api.client.util.Preconditions.checkNotNull(webPropertyId, "Required parameter webPropertyId must be specified.");
          this.linkId = com.google.api.client.util.Preconditions.checkNotNull(linkId, "Required parameter linkId must be specified.");
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUserIp(java.lang.String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Account ID to update the account-user link for. */
        @com.google.api.client.util.Key
        private java.lang.String accountId;

        /** Account ID to update the account-user link for.
         */
        public java.lang.String getAccountId() {
          return accountId;
        }

        /** Account ID to update the account-user link for. */
        public Update setAccountId(java.lang.String accountId) {
          this.accountId = accountId;
          return this;
        }

        /** Web property ID to update the account-user link for. */
        @com.google.api.client.util.Key
        private java.lang.String webPropertyId;

        /** Web property ID to update the account-user link for.
         */
        public java.lang.String getWebPropertyId() {
          return webPropertyId;
        }

        /** Web property ID to update the account-user link for. */
        public Update setWebPropertyId(java.lang.String webPropertyId) {
          this.webPropertyId = webPropertyId;
          return this;
        }

        /** Link ID to update the account-user link for. */
        @com.google.api.client.util.Key
        private java.lang.String linkId;

        /** Link ID to update the account-user link for.
         */
        public java.lang.String getLinkId() {
          return linkId;
        }

        /** Link ID to update the account-user link for. */
        public Update setLinkId(java.lang.String linkId) {
          this.linkId = linkId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Metadata collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Metadata.List request = analytics.metadata().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Metadata metadata() {
    return new Metadata();
  }

  /**
   * The "metadata" collection of methods.
   */
  public class Metadata {

    /**
     * An accessor for creating requests from the Columns collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Analytics analytics = new Analytics(...);}
     *   {@code Analytics.Columns.List request = analytics.columns().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Columns columns() {
      return new Columns();
    }

    /**
     * The "columns" collection of methods.
     */
    public class Columns {

      /**
       * Lists all columns for a report type
       *
       * Create a request for the method "columns.list".
       *
       * This request holds the parameters needed by the analytics server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param reportType Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API
       * @return the request
       */
      public List list(java.lang.String reportType) throws java.io.IOException {
        List result = new List(reportType);
        initialize(result);
        return result;
      }

      public class List extends AnalyticsRequest<com.google.api.services.analytics.model.Columns> {

        private static final String REST_PATH = "metadata/{reportType}/columns";

        private final java.util.regex.Pattern REPORT_TYPE_PATTERN =
            java.util.regex.Pattern.compile("ga");

        /**
         * Lists all columns for a report type
         *
         * Create a request for the method "columns.list".
         *
         * This request holds the parameters needed by the the analytics server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param reportType Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API
         * @since 1.13
         */
        protected List(java.lang.String reportType) {
          super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Columns.class);
          this.reportType = com.google.api.client.util.Preconditions.checkNotNull(reportType, "Required parameter reportType must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(REPORT_TYPE_PATTERN.matcher(reportType).matches(),
                "Parameter reportType must conform to the pattern " +
                "ga");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUserIp(java.lang.String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API */
        @com.google.api.client.util.Key
        private java.lang.String reportType;

        /** Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API
         */
        public java.lang.String getReportType() {
          return reportType;
        }

        /** Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API */
        public List setReportType(java.lang.String reportType) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(REPORT_TYPE_PATTERN.matcher(reportType).matches(),
                "Parameter reportType must conform to the pattern " +
                "ga");
          }
          this.reportType = reportType;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Provisioning collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Analytics analytics = new Analytics(...);}
   *   {@code Analytics.Provisioning.List request = analytics.provisioning().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Provisioning provisioning() {
    return new Provisioning();
  }

  /**
   * The "provisioning" collection of methods.
   */
  public class Provisioning {

    /**
     * Creates an account ticket.
     *
     * Create a request for the method "provisioning.createAccountTicket".
     *
     * This request holds the parameters needed by the analytics server.  After setting any optional
     * parameters, call the {@link CreateAccountTicket#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.analytics.model.AccountTicket}
     * @return the request
     */
    public CreateAccountTicket createAccountTicket(com.google.api.services.analytics.model.AccountTicket content) throws java.io.IOException {
      CreateAccountTicket result = new CreateAccountTicket(content);
      initialize(result);
      return result;
    }

    public class CreateAccountTicket extends AnalyticsRequest<com.google.api.services.analytics.model.AccountTicket> {

      private static final String REST_PATH = "provisioning/createAccountTicket";

      /**
       * Creates an account ticket.
       *
       * Create a request for the method "provisioning.createAccountTicket".
       *
       * This request holds the parameters needed by the the analytics server.  After setting any
       * optional parameters, call the {@link CreateAccountTicket#execute()} method to invoke the remote
       * operation. <p> {@link CreateAccountTicket#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.analytics.model.AccountTicket}
       * @since 1.13
       */
      protected CreateAccountTicket(com.google.api.services.analytics.model.AccountTicket content) {
        super(Analytics.this, "POST", REST_PATH, content, com.google.api.services.analytics.model.AccountTicket.class);
      }

      @Override
      public CreateAccountTicket setAlt(java.lang.String alt) {
        return (CreateAccountTicket) super.setAlt(alt);
      }

      @Override
      public CreateAccountTicket setFields(java.lang.String fields) {
        return (CreateAccountTicket) super.setFields(fields);
      }

      @Override
      public CreateAccountTicket setKey(java.lang.String key) {
        return (CreateAccountTicket) super.setKey(key);
      }

      @Override
      public CreateAccountTicket setOauthToken(java.lang.String oauthToken) {
        return (CreateAccountTicket) super.setOauthToken(oauthToken);
      }

      @Override
      public CreateAccountTicket setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CreateAccountTicket) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CreateAccountTicket setQuotaUser(java.lang.String quotaUser) {
        return (CreateAccountTicket) super.setQuotaUser(quotaUser);
      }

      @Override
      public CreateAccountTicket setUserIp(java.lang.String userIp) {
        return (CreateAccountTicket) super.setUserIp(userIp);
      }

      @Override
      public CreateAccountTicket set(String parameterName, Object value) {
        return (CreateAccountTicket) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Analytics}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Analytics}. */
    @Override
    public Analytics build() {
      return new Analytics(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link AnalyticsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setAnalyticsRequestInitializer(
        AnalyticsRequestInitializer analyticsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(analyticsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
