/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vectorsearch.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataObjectName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATAOBJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataObjects/{dataObject}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String collection;
    private final String dataObject;

    @Deprecated
    protected DataObjectName() {
        this.project = null;
        this.location = null;
        this.collection = null;
        this.dataObject = null;
    }

    private DataObjectName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataObject = (String)Preconditions.checkNotNull((Object)builder.getDataObject());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getDataObject() {
        return this.dataObject;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataObjectName of(String project, String location, String collection, String dataObject) {
        return DataObjectName.newBuilder().setProject(project).setLocation(location).setCollection(collection).setDataObject(dataObject).build();
    }

    public static String format(String project, String location, String collection, String dataObject) {
        return DataObjectName.newBuilder().setProject(project).setLocation(location).setCollection(collection).setDataObject(dataObject).build().toString();
    }

    public static DataObjectName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_COLLECTION_DATAOBJECT.validatedMatch(formattedString, "DataObjectName.parse: formattedString not in valid format");
        return DataObjectName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("dataObject"));
    }

    public static List<DataObjectName> parseList(List<String> formattedStrings) {
        ArrayList<DataObjectName> list = new ArrayList<DataObjectName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataObjectName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataObjectName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataObjectName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_COLLECTION_DATAOBJECT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataObjectName dataObjectName = this;
            synchronized (dataObjectName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    if (this.dataObject != null) {
                        fieldMapBuilder.put((Object)"dataObject", (Object)this.dataObject);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_COLLECTION_DATAOBJECT.instantiate(new String[]{"project", this.project, "location", this.location, "collection", this.collection, "dataObject", this.dataObject});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataObjectName that = (DataObjectName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.collection, that.collection) && Objects.equals(this.dataObject, that.dataObject);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.collection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataObject);
    }

    public static class Builder {
        private String project;
        private String location;
        private String collection;
        private String dataObject;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataObject() {
            return this.dataObject;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public Builder setDataObject(String dataObject) {
            this.dataObject = dataObject;
            return this;
        }

        private Builder(DataObjectName dataObjectName) {
            this.project = dataObjectName.project;
            this.location = dataObjectName.location;
            this.collection = dataObjectName.collection;
            this.dataObject = dataObjectName.dataObject;
        }

        public DataObjectName build() {
            return new DataObjectName(this);
        }
    }
}

