/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/type.proto

package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * `StructType` defines the fields of a [STRUCT][google.spanner.v1.TypeCode.STRUCT] type.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.StructType}
 */
public final class StructType extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.StructType)
    StructTypeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StructType.newBuilder() to construct.
  private StructType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StructType() {
    fields_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StructType();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.TypeProto.internal_static_google_spanner_v1_StructType_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.TypeProto
        .internal_static_google_spanner_v1_StructType_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.StructType.class, com.google.spanner.v1.StructType.Builder.class);
  }

  public interface FieldOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.StructType.Field)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the field. For reads, this is the column name. For
     * SQL queries, it is the column alias (e.g., `"Word"` in the
     * query `"SELECT 'hello' AS Word"`), or the column name (e.g.,
     * `"ColName"` in the query `"SELECT ColName FROM Table"`). Some
     * columns might have an empty name (e.g., `"SELECT
     * UPPER(ColName)"`). Note that a query result can contain
     * multiple fields with the same name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The name of the field. For reads, this is the column name. For
     * SQL queries, it is the column alias (e.g., `"Word"` in the
     * query `"SELECT 'hello' AS Word"`), or the column name (e.g.,
     * `"ColName"` in the query `"SELECT ColName FROM Table"`). Some
     * columns might have an empty name (e.g., `"SELECT
     * UPPER(ColName)"`). Note that a query result can contain
     * multiple fields with the same name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The type of the field.
     * </pre>
     *
     * <code>.google.spanner.v1.Type type = 2;</code>
     *
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     *
     *
     * <pre>
     * The type of the field.
     * </pre>
     *
     * <code>.google.spanner.v1.Type type = 2;</code>
     *
     * @return The type.
     */
    com.google.spanner.v1.Type getType();
    /**
     *
     *
     * <pre>
     * The type of the field.
     * </pre>
     *
     * <code>.google.spanner.v1.Type type = 2;</code>
     */
    com.google.spanner.v1.TypeOrBuilder getTypeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Message representing a single field of a struct.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.StructType.Field}
   */
  public static final class Field extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.StructType.Field)
      FieldOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Field.newBuilder() to construct.
    private Field(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Field() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Field();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TypeProto
          .internal_static_google_spanner_v1_StructType_Field_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TypeProto
          .internal_static_google_spanner_v1_StructType_Field_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.StructType.Field.class,
              com.google.spanner.v1.StructType.Field.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the field. For reads, this is the column name. For
     * SQL queries, it is the column alias (e.g., `"Word"` in the
     * query `"SELECT 'hello' AS Word"`), or the column name (e.g.,
     * `"ColName"` in the query `"SELECT ColName FROM Table"`). Some
     * columns might have an empty name (e.g., `"SELECT
     * UPPER(ColName)"`). Note that a query result can contain
     * multiple fields with the same name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the field. For reads, this is the column name. For
     * SQL queries, it is the column alias (e.g., `"Word"` in the
     * query `"SELECT 'hello' AS Word"`), or the column name (e.g.,
     * `"ColName"` in the query `"SELECT ColName FROM Table"`). Some
     * columns might have an empty name (e.g., `"SELECT
     * UPPER(ColName)"`). Note that a query result can contain
     * multiple fields with the same name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private com.google.spanner.v1.Type type_;
    /**
     *
     *
     * <pre>
     * The type of the field.
     * </pre>
     *
     * <code>.google.spanner.v1.Type type = 2;</code>
     *
     * @return Whether the type field is set.
     */
    @java.lang.Override
    public boolean hasType() {
      return type_ != null;
    }
    /**
     *
     *
     * <pre>
     * The type of the field.
     * </pre>
     *
     * <code>.google.spanner.v1.Type type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.spanner.v1.Type getType() {
      return type_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : type_;
    }
    /**
     *
     *
     * <pre>
     * The type of the field.
     * </pre>
     *
     * <code>.google.spanner.v1.Type type = 2;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.TypeOrBuilder getTypeOrBuilder() {
      return type_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : type_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (type_ != null) {
        output.writeMessage(2, getType());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (type_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getType());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.StructType.Field)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.StructType.Field other = (com.google.spanner.v1.StructType.Field) obj;

      if (!getName().equals(other.getName())) return false;
      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (!getType().equals(other.getType())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.StructType.Field parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.StructType.Field parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.StructType.Field parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.StructType.Field parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.StructType.Field parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.StructType.Field parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.StructType.Field parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.StructType.Field parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.StructType.Field parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.StructType.Field parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.StructType.Field parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.StructType.Field parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.spanner.v1.StructType.Field prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message representing a single field of a struct.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.StructType.Field}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.StructType.Field)
        com.google.spanner.v1.StructType.FieldOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.TypeProto
            .internal_static_google_spanner_v1_StructType_Field_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.TypeProto
            .internal_static_google_spanner_v1_StructType_Field_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.StructType.Field.class,
                com.google.spanner.v1.StructType.Field.Builder.class);
      }

      // Construct using com.google.spanner.v1.StructType.Field.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        type_ = null;
        if (typeBuilder_ != null) {
          typeBuilder_.dispose();
          typeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.TypeProto
            .internal_static_google_spanner_v1_StructType_Field_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.StructType.Field getDefaultInstanceForType() {
        return com.google.spanner.v1.StructType.Field.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.StructType.Field build() {
        com.google.spanner.v1.StructType.Field result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.StructType.Field buildPartial() {
        com.google.spanner.v1.StructType.Field result =
            new com.google.spanner.v1.StructType.Field(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.spanner.v1.StructType.Field result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.type_ = typeBuilder_ == null ? type_ : typeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.StructType.Field) {
          return mergeFrom((com.google.spanner.v1.StructType.Field) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.StructType.Field other) {
        if (other == com.google.spanner.v1.StructType.Field.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasType()) {
          mergeType(other.getType());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getTypeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of the field. For reads, this is the column name. For
       * SQL queries, it is the column alias (e.g., `"Word"` in the
       * query `"SELECT 'hello' AS Word"`), or the column name (e.g.,
       * `"ColName"` in the query `"SELECT ColName FROM Table"`). Some
       * columns might have an empty name (e.g., `"SELECT
       * UPPER(ColName)"`). Note that a query result can contain
       * multiple fields with the same name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the field. For reads, this is the column name. For
       * SQL queries, it is the column alias (e.g., `"Word"` in the
       * query `"SELECT 'hello' AS Word"`), or the column name (e.g.,
       * `"ColName"` in the query `"SELECT ColName FROM Table"`). Some
       * columns might have an empty name (e.g., `"SELECT
       * UPPER(ColName)"`). Note that a query result can contain
       * multiple fields with the same name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the field. For reads, this is the column name. For
       * SQL queries, it is the column alias (e.g., `"Word"` in the
       * query `"SELECT 'hello' AS Word"`), or the column name (e.g.,
       * `"ColName"` in the query `"SELECT ColName FROM Table"`). Some
       * columns might have an empty name (e.g., `"SELECT
       * UPPER(ColName)"`). Note that a query result can contain
       * multiple fields with the same name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the field. For reads, this is the column name. For
       * SQL queries, it is the column alias (e.g., `"Word"` in the
       * query `"SELECT 'hello' AS Word"`), or the column name (e.g.,
       * `"ColName"` in the query `"SELECT ColName FROM Table"`). Some
       * columns might have an empty name (e.g., `"SELECT
       * UPPER(ColName)"`). Note that a query result can contain
       * multiple fields with the same name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the field. For reads, this is the column name. For
       * SQL queries, it is the column alias (e.g., `"Word"` in the
       * query `"SELECT 'hello' AS Word"`), or the column name (e.g.,
       * `"ColName"` in the query `"SELECT ColName FROM Table"`). Some
       * columns might have an empty name (e.g., `"SELECT
       * UPPER(ColName)"`). Note that a query result can contain
       * multiple fields with the same name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.spanner.v1.Type type_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.spanner.v1.Type,
              com.google.spanner.v1.Type.Builder,
              com.google.spanner.v1.TypeOrBuilder>
          typeBuilder_;
      /**
       *
       *
       * <pre>
       * The type of the field.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       *
       * @return Whether the type field is set.
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The type of the field.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       *
       * @return The type.
       */
      public com.google.spanner.v1.Type getType() {
        if (typeBuilder_ == null) {
          return type_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : type_;
        } else {
          return typeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The type of the field.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       */
      public Builder setType(com.google.spanner.v1.Type value) {
        if (typeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          type_ = value;
        } else {
          typeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the field.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       */
      public Builder setType(com.google.spanner.v1.Type.Builder builderForValue) {
        if (typeBuilder_ == null) {
          type_ = builderForValue.build();
        } else {
          typeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the field.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       */
      public Builder mergeType(com.google.spanner.v1.Type value) {
        if (typeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && type_ != null
              && type_ != com.google.spanner.v1.Type.getDefaultInstance()) {
            getTypeBuilder().mergeFrom(value);
          } else {
            type_ = value;
          }
        } else {
          typeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the field.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        type_ = null;
        if (typeBuilder_ != null) {
          typeBuilder_.dispose();
          typeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the field.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       */
      public com.google.spanner.v1.Type.Builder getTypeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getTypeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The type of the field.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       */
      public com.google.spanner.v1.TypeOrBuilder getTypeOrBuilder() {
        if (typeBuilder_ != null) {
          return typeBuilder_.getMessageOrBuilder();
        } else {
          return type_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : type_;
        }
      }
      /**
       *
       *
       * <pre>
       * The type of the field.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.spanner.v1.Type,
              com.google.spanner.v1.Type.Builder,
              com.google.spanner.v1.TypeOrBuilder>
          getTypeFieldBuilder() {
        if (typeBuilder_ == null) {
          typeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.spanner.v1.Type,
                  com.google.spanner.v1.Type.Builder,
                  com.google.spanner.v1.TypeOrBuilder>(
                  getType(), getParentForChildren(), isClean());
          type_ = null;
        }
        return typeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.StructType.Field)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.StructType.Field)
    private static final com.google.spanner.v1.StructType.Field DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.StructType.Field();
    }

    public static com.google.spanner.v1.StructType.Field getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Field> PARSER =
        new com.google.protobuf.AbstractParser<Field>() {
          @java.lang.Override
          public Field parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Field> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Field> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.StructType.Field getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int FIELDS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.v1.StructType.Field> fields_;
  /**
   *
   *
   * <pre>
   * The list of fields that make up this struct. Order is
   * significant, because values of this struct type are represented as
   * lists, where the order of field values matches the order of
   * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
   * matches the order of columns in a read request, or the order of
   * fields in the `SELECT` clause of a query.
   * </pre>
   *
   * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.v1.StructType.Field> getFieldsList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * The list of fields that make up this struct. Order is
   * significant, because values of this struct type are represented as
   * lists, where the order of field values matches the order of
   * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
   * matches the order of columns in a read request, or the order of
   * fields in the `SELECT` clause of a query.
   * </pre>
   *
   * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.v1.StructType.FieldOrBuilder>
      getFieldsOrBuilderList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * The list of fields that make up this struct. Order is
   * significant, because values of this struct type are represented as
   * lists, where the order of field values matches the order of
   * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
   * matches the order of columns in a read request, or the order of
   * fields in the `SELECT` clause of a query.
   * </pre>
   *
   * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
   */
  @java.lang.Override
  public int getFieldsCount() {
    return fields_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of fields that make up this struct. Order is
   * significant, because values of this struct type are represented as
   * lists, where the order of field values matches the order of
   * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
   * matches the order of columns in a read request, or the order of
   * fields in the `SELECT` clause of a query.
   * </pre>
   *
   * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.StructType.Field getFields(int index) {
    return fields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of fields that make up this struct. Order is
   * significant, because values of this struct type are represented as
   * lists, where the order of field values matches the order of
   * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
   * matches the order of columns in a read request, or the order of
   * fields in the `SELECT` clause of a query.
   * </pre>
   *
   * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.StructType.FieldOrBuilder getFieldsOrBuilder(int index) {
    return fields_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < fields_.size(); i++) {
      output.writeMessage(1, fields_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < fields_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, fields_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.StructType)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.StructType other = (com.google.spanner.v1.StructType) obj;

    if (!getFieldsList().equals(other.getFieldsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFieldsCount() > 0) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.StructType parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.StructType parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.StructType parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.StructType parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.StructType parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.StructType parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.StructType parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.StructType parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.StructType parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.StructType parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.StructType parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.StructType parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.StructType prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `StructType` defines the fields of a [STRUCT][google.spanner.v1.TypeCode.STRUCT] type.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.StructType}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.StructType)
      com.google.spanner.v1.StructTypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TypeProto
          .internal_static_google_spanner_v1_StructType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TypeProto
          .internal_static_google_spanner_v1_StructType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.StructType.class,
              com.google.spanner.v1.StructType.Builder.class);
    }

    // Construct using com.google.spanner.v1.StructType.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
      } else {
        fields_ = null;
        fieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.TypeProto
          .internal_static_google_spanner_v1_StructType_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.StructType getDefaultInstanceForType() {
      return com.google.spanner.v1.StructType.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.StructType build() {
      com.google.spanner.v1.StructType result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.StructType buildPartial() {
      com.google.spanner.v1.StructType result = new com.google.spanner.v1.StructType(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.spanner.v1.StructType result) {
      if (fieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          fields_ = java.util.Collections.unmodifiableList(fields_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.fields_ = fields_;
      } else {
        result.fields_ = fieldsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.v1.StructType result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.StructType) {
        return mergeFrom((com.google.spanner.v1.StructType) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.StructType other) {
      if (other == com.google.spanner.v1.StructType.getDefaultInstance()) return this;
      if (fieldsBuilder_ == null) {
        if (!other.fields_.isEmpty()) {
          if (fields_.isEmpty()) {
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFieldsIsMutable();
            fields_.addAll(other.fields_);
          }
          onChanged();
        }
      } else {
        if (!other.fields_.isEmpty()) {
          if (fieldsBuilder_.isEmpty()) {
            fieldsBuilder_.dispose();
            fieldsBuilder_ = null;
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000001);
            fieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFieldsFieldBuilder()
                    : null;
          } else {
            fieldsBuilder_.addAllMessages(other.fields_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.spanner.v1.StructType.Field m =
                    input.readMessage(
                        com.google.spanner.v1.StructType.Field.parser(), extensionRegistry);
                if (fieldsBuilder_ == null) {
                  ensureFieldsIsMutable();
                  fields_.add(m);
                } else {
                  fieldsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.spanner.v1.StructType.Field> fields_ =
        java.util.Collections.emptyList();

    private void ensureFieldsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        fields_ = new java.util.ArrayList<com.google.spanner.v1.StructType.Field>(fields_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.v1.StructType.Field,
            com.google.spanner.v1.StructType.Field.Builder,
            com.google.spanner.v1.StructType.FieldOrBuilder>
        fieldsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public java.util.List<com.google.spanner.v1.StructType.Field> getFieldsList() {
      if (fieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fields_);
      } else {
        return fieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public int getFieldsCount() {
      if (fieldsBuilder_ == null) {
        return fields_.size();
      } else {
        return fieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public com.google.spanner.v1.StructType.Field getFields(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public Builder setFields(int index, com.google.spanner.v1.StructType.Field value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.set(index, value);
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public Builder setFields(
        int index, com.google.spanner.v1.StructType.Field.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.set(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public Builder addFields(com.google.spanner.v1.StructType.Field value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public Builder addFields(int index, com.google.spanner.v1.StructType.Field value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(index, value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public Builder addFields(com.google.spanner.v1.StructType.Field.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public Builder addFields(
        int index, com.google.spanner.v1.StructType.Field.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public Builder addAllFields(
        java.lang.Iterable<? extends com.google.spanner.v1.StructType.Field> values) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
        onChanged();
      } else {
        fieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public Builder clearFields() {
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        fieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public Builder removeFields(int index) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.remove(index);
        onChanged();
      } else {
        fieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public com.google.spanner.v1.StructType.Field.Builder getFieldsBuilder(int index) {
      return getFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public com.google.spanner.v1.StructType.FieldOrBuilder getFieldsOrBuilder(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public java.util.List<? extends com.google.spanner.v1.StructType.FieldOrBuilder>
        getFieldsOrBuilderList() {
      if (fieldsBuilder_ != null) {
        return fieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fields_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public com.google.spanner.v1.StructType.Field.Builder addFieldsBuilder() {
      return getFieldsFieldBuilder()
          .addBuilder(com.google.spanner.v1.StructType.Field.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public com.google.spanner.v1.StructType.Field.Builder addFieldsBuilder(int index) {
      return getFieldsFieldBuilder()
          .addBuilder(index, com.google.spanner.v1.StructType.Field.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of fields that make up this struct. Order is
     * significant, because values of this struct type are represented as
     * lists, where the order of field values matches the order of
     * fields in the [StructType][google.spanner.v1.StructType]. In turn, the order of fields
     * matches the order of columns in a read request, or the order of
     * fields in the `SELECT` clause of a query.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.StructType.Field fields = 1;</code>
     */
    public java.util.List<com.google.spanner.v1.StructType.Field.Builder> getFieldsBuilderList() {
      return getFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.v1.StructType.Field,
            com.google.spanner.v1.StructType.Field.Builder,
            com.google.spanner.v1.StructType.FieldOrBuilder>
        getFieldsFieldBuilder() {
      if (fieldsBuilder_ == null) {
        fieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.v1.StructType.Field,
                com.google.spanner.v1.StructType.Field.Builder,
                com.google.spanner.v1.StructType.FieldOrBuilder>(
                fields_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        fields_ = null;
      }
      return fieldsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.StructType)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.StructType)
  private static final com.google.spanner.v1.StructType DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.StructType();
  }

  public static com.google.spanner.v1.StructType getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StructType> PARSER =
      new com.google.protobuf.AbstractParser<StructType>() {
        @java.lang.Override
        public StructType parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StructType> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StructType> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.StructType getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
