/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/commit_response.proto

package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * The response for [Commit][google.spanner.v1.Spanner.Commit].
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.CommitResponse}
 */
public final class CommitResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.CommitResponse)
    CommitResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CommitResponse.newBuilder() to construct.
  private CommitResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CommitResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CommitResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.CommitResponseProto
        .internal_static_google_spanner_v1_CommitResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.CommitResponseProto
        .internal_static_google_spanner_v1_CommitResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.CommitResponse.class,
            com.google.spanner.v1.CommitResponse.Builder.class);
  }

  public interface CommitStatsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.CommitResponse.CommitStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The total number of mutations for the transaction. Knowing the
     * `mutation_count` value can help you maximize the number of mutations
     * in a transaction and minimize the number of API round trips. You can
     * also monitor this value to prevent transactions from exceeding the system
     * [limit](https://cloud.google.com/spanner/quotas#limits_for_creating_reading_updating_and_deleting_data).
     * If the number of mutations exceeds the limit, the server returns
     * [INVALID_ARGUMENT](https://cloud.google.com/spanner/docs/reference/rest/v1/Code#ENUM_VALUES.INVALID_ARGUMENT).
     * </pre>
     *
     * <code>int64 mutation_count = 1;</code>
     *
     * @return The mutationCount.
     */
    long getMutationCount();
  }
  /**
   *
   *
   * <pre>
   * Additional statistics about a commit.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.CommitResponse.CommitStats}
   */
  public static final class CommitStats extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.CommitResponse.CommitStats)
      CommitStatsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CommitStats.newBuilder() to construct.
    private CommitStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CommitStats() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CommitStats();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.CommitResponseProto
          .internal_static_google_spanner_v1_CommitResponse_CommitStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.CommitResponseProto
          .internal_static_google_spanner_v1_CommitResponse_CommitStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.CommitResponse.CommitStats.class,
              com.google.spanner.v1.CommitResponse.CommitStats.Builder.class);
    }

    public static final int MUTATION_COUNT_FIELD_NUMBER = 1;
    private long mutationCount_ = 0L;
    /**
     *
     *
     * <pre>
     * The total number of mutations for the transaction. Knowing the
     * `mutation_count` value can help you maximize the number of mutations
     * in a transaction and minimize the number of API round trips. You can
     * also monitor this value to prevent transactions from exceeding the system
     * [limit](https://cloud.google.com/spanner/quotas#limits_for_creating_reading_updating_and_deleting_data).
     * If the number of mutations exceeds the limit, the server returns
     * [INVALID_ARGUMENT](https://cloud.google.com/spanner/docs/reference/rest/v1/Code#ENUM_VALUES.INVALID_ARGUMENT).
     * </pre>
     *
     * <code>int64 mutation_count = 1;</code>
     *
     * @return The mutationCount.
     */
    @java.lang.Override
    public long getMutationCount() {
      return mutationCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (mutationCount_ != 0L) {
        output.writeInt64(1, mutationCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (mutationCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, mutationCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.CommitResponse.CommitStats)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.CommitResponse.CommitStats other =
          (com.google.spanner.v1.CommitResponse.CommitStats) obj;

      if (getMutationCount() != other.getMutationCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MUTATION_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMutationCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.spanner.v1.CommitResponse.CommitStats prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Additional statistics about a commit.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.CommitResponse.CommitStats}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.CommitResponse.CommitStats)
        com.google.spanner.v1.CommitResponse.CommitStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.CommitResponseProto
            .internal_static_google_spanner_v1_CommitResponse_CommitStats_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.CommitResponseProto
            .internal_static_google_spanner_v1_CommitResponse_CommitStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.CommitResponse.CommitStats.class,
                com.google.spanner.v1.CommitResponse.CommitStats.Builder.class);
      }

      // Construct using com.google.spanner.v1.CommitResponse.CommitStats.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mutationCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.CommitResponseProto
            .internal_static_google_spanner_v1_CommitResponse_CommitStats_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.CommitResponse.CommitStats getDefaultInstanceForType() {
        return com.google.spanner.v1.CommitResponse.CommitStats.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.CommitResponse.CommitStats build() {
        com.google.spanner.v1.CommitResponse.CommitStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.CommitResponse.CommitStats buildPartial() {
        com.google.spanner.v1.CommitResponse.CommitStats result =
            new com.google.spanner.v1.CommitResponse.CommitStats(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.spanner.v1.CommitResponse.CommitStats result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.mutationCount_ = mutationCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.CommitResponse.CommitStats) {
          return mergeFrom((com.google.spanner.v1.CommitResponse.CommitStats) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.CommitResponse.CommitStats other) {
        if (other == com.google.spanner.v1.CommitResponse.CommitStats.getDefaultInstance())
          return this;
        if (other.getMutationCount() != 0L) {
          setMutationCount(other.getMutationCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  mutationCount_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long mutationCount_;
      /**
       *
       *
       * <pre>
       * The total number of mutations for the transaction. Knowing the
       * `mutation_count` value can help you maximize the number of mutations
       * in a transaction and minimize the number of API round trips. You can
       * also monitor this value to prevent transactions from exceeding the system
       * [limit](https://cloud.google.com/spanner/quotas#limits_for_creating_reading_updating_and_deleting_data).
       * If the number of mutations exceeds the limit, the server returns
       * [INVALID_ARGUMENT](https://cloud.google.com/spanner/docs/reference/rest/v1/Code#ENUM_VALUES.INVALID_ARGUMENT).
       * </pre>
       *
       * <code>int64 mutation_count = 1;</code>
       *
       * @return The mutationCount.
       */
      @java.lang.Override
      public long getMutationCount() {
        return mutationCount_;
      }
      /**
       *
       *
       * <pre>
       * The total number of mutations for the transaction. Knowing the
       * `mutation_count` value can help you maximize the number of mutations
       * in a transaction and minimize the number of API round trips. You can
       * also monitor this value to prevent transactions from exceeding the system
       * [limit](https://cloud.google.com/spanner/quotas#limits_for_creating_reading_updating_and_deleting_data).
       * If the number of mutations exceeds the limit, the server returns
       * [INVALID_ARGUMENT](https://cloud.google.com/spanner/docs/reference/rest/v1/Code#ENUM_VALUES.INVALID_ARGUMENT).
       * </pre>
       *
       * <code>int64 mutation_count = 1;</code>
       *
       * @param value The mutationCount to set.
       * @return This builder for chaining.
       */
      public Builder setMutationCount(long value) {

        mutationCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The total number of mutations for the transaction. Knowing the
       * `mutation_count` value can help you maximize the number of mutations
       * in a transaction and minimize the number of API round trips. You can
       * also monitor this value to prevent transactions from exceeding the system
       * [limit](https://cloud.google.com/spanner/quotas#limits_for_creating_reading_updating_and_deleting_data).
       * If the number of mutations exceeds the limit, the server returns
       * [INVALID_ARGUMENT](https://cloud.google.com/spanner/docs/reference/rest/v1/Code#ENUM_VALUES.INVALID_ARGUMENT).
       * </pre>
       *
       * <code>int64 mutation_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMutationCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        mutationCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.CommitResponse.CommitStats)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.CommitResponse.CommitStats)
    private static final com.google.spanner.v1.CommitResponse.CommitStats DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.CommitResponse.CommitStats();
    }

    public static com.google.spanner.v1.CommitResponse.CommitStats getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CommitStats> PARSER =
        new com.google.protobuf.AbstractParser<CommitStats>() {
          @java.lang.Override
          public CommitStats parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CommitStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CommitStats> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.CommitResponse.CommitStats getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int COMMIT_TIMESTAMP_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp commitTimestamp_;
  /**
   *
   *
   * <pre>
   * The Cloud Spanner timestamp at which the transaction committed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
   *
   * @return Whether the commitTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCommitTimestamp() {
    return commitTimestamp_ != null;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Spanner timestamp at which the transaction committed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
   *
   * @return The commitTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCommitTimestamp() {
    return commitTimestamp_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : commitTimestamp_;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Spanner timestamp at which the transaction committed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder() {
    return commitTimestamp_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : commitTimestamp_;
  }

  public static final int COMMIT_STATS_FIELD_NUMBER = 2;
  private com.google.spanner.v1.CommitResponse.CommitStats commitStats_;
  /**
   *
   *
   * <pre>
   * The statistics about this Commit. Not returned by default.
   * For more information, see
   * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
   * </pre>
   *
   * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
   *
   * @return Whether the commitStats field is set.
   */
  @java.lang.Override
  public boolean hasCommitStats() {
    return commitStats_ != null;
  }
  /**
   *
   *
   * <pre>
   * The statistics about this Commit. Not returned by default.
   * For more information, see
   * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
   * </pre>
   *
   * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
   *
   * @return The commitStats.
   */
  @java.lang.Override
  public com.google.spanner.v1.CommitResponse.CommitStats getCommitStats() {
    return commitStats_ == null
        ? com.google.spanner.v1.CommitResponse.CommitStats.getDefaultInstance()
        : commitStats_;
  }
  /**
   *
   *
   * <pre>
   * The statistics about this Commit. Not returned by default.
   * For more information, see
   * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
   * </pre>
   *
   * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.CommitResponse.CommitStatsOrBuilder getCommitStatsOrBuilder() {
    return commitStats_ == null
        ? com.google.spanner.v1.CommitResponse.CommitStats.getDefaultInstance()
        : commitStats_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (commitTimestamp_ != null) {
      output.writeMessage(1, getCommitTimestamp());
    }
    if (commitStats_ != null) {
      output.writeMessage(2, getCommitStats());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (commitTimestamp_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCommitTimestamp());
    }
    if (commitStats_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCommitStats());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.CommitResponse)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.CommitResponse other = (com.google.spanner.v1.CommitResponse) obj;

    if (hasCommitTimestamp() != other.hasCommitTimestamp()) return false;
    if (hasCommitTimestamp()) {
      if (!getCommitTimestamp().equals(other.getCommitTimestamp())) return false;
    }
    if (hasCommitStats() != other.hasCommitStats()) return false;
    if (hasCommitStats()) {
      if (!getCommitStats().equals(other.getCommitStats())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCommitTimestamp()) {
      hash = (37 * hash) + COMMIT_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCommitTimestamp().hashCode();
    }
    if (hasCommitStats()) {
      hash = (37 * hash) + COMMIT_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getCommitStats().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.CommitResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.CommitResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.CommitResponse parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.CommitResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.CommitResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.CommitResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.CommitResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.CommitResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.CommitResponse parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.CommitResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.CommitResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.CommitResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.CommitResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for [Commit][google.spanner.v1.Spanner.Commit].
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.CommitResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.CommitResponse)
      com.google.spanner.v1.CommitResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.CommitResponseProto
          .internal_static_google_spanner_v1_CommitResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.CommitResponseProto
          .internal_static_google_spanner_v1_CommitResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.CommitResponse.class,
              com.google.spanner.v1.CommitResponse.Builder.class);
    }

    // Construct using com.google.spanner.v1.CommitResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      commitTimestamp_ = null;
      if (commitTimestampBuilder_ != null) {
        commitTimestampBuilder_.dispose();
        commitTimestampBuilder_ = null;
      }
      commitStats_ = null;
      if (commitStatsBuilder_ != null) {
        commitStatsBuilder_.dispose();
        commitStatsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.CommitResponseProto
          .internal_static_google_spanner_v1_CommitResponse_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.CommitResponse getDefaultInstanceForType() {
      return com.google.spanner.v1.CommitResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.CommitResponse build() {
      com.google.spanner.v1.CommitResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.CommitResponse buildPartial() {
      com.google.spanner.v1.CommitResponse result = new com.google.spanner.v1.CommitResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.v1.CommitResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.commitTimestamp_ =
            commitTimestampBuilder_ == null ? commitTimestamp_ : commitTimestampBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.commitStats_ =
            commitStatsBuilder_ == null ? commitStats_ : commitStatsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.CommitResponse) {
        return mergeFrom((com.google.spanner.v1.CommitResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.CommitResponse other) {
      if (other == com.google.spanner.v1.CommitResponse.getDefaultInstance()) return this;
      if (other.hasCommitTimestamp()) {
        mergeCommitTimestamp(other.getCommitTimestamp());
      }
      if (other.hasCommitStats()) {
        mergeCommitStats(other.getCommitStats());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCommitTimestampFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCommitStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp commitTimestamp_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        commitTimestampBuilder_;
    /**
     *
     *
     * <pre>
     * The Cloud Spanner timestamp at which the transaction committed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     *
     * @return Whether the commitTimestamp field is set.
     */
    public boolean hasCommitTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Cloud Spanner timestamp at which the transaction committed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     *
     * @return The commitTimestamp.
     */
    public com.google.protobuf.Timestamp getCommitTimestamp() {
      if (commitTimestampBuilder_ == null) {
        return commitTimestamp_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitTimestamp_;
      } else {
        return commitTimestampBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Spanner timestamp at which the transaction committed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    public Builder setCommitTimestamp(com.google.protobuf.Timestamp value) {
      if (commitTimestampBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitTimestamp_ = value;
      } else {
        commitTimestampBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Spanner timestamp at which the transaction committed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    public Builder setCommitTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimestampBuilder_ == null) {
        commitTimestamp_ = builderForValue.build();
      } else {
        commitTimestampBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Spanner timestamp at which the transaction committed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    public Builder mergeCommitTimestamp(com.google.protobuf.Timestamp value) {
      if (commitTimestampBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && commitTimestamp_ != null
            && commitTimestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCommitTimestampBuilder().mergeFrom(value);
        } else {
          commitTimestamp_ = value;
        }
      } else {
        commitTimestampBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Spanner timestamp at which the transaction committed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    public Builder clearCommitTimestamp() {
      bitField0_ = (bitField0_ & ~0x00000001);
      commitTimestamp_ = null;
      if (commitTimestampBuilder_ != null) {
        commitTimestampBuilder_.dispose();
        commitTimestampBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Spanner timestamp at which the transaction committed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCommitTimestampBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCommitTimestampFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Cloud Spanner timestamp at which the transaction committed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder() {
      if (commitTimestampBuilder_ != null) {
        return commitTimestampBuilder_.getMessageOrBuilder();
      } else {
        return commitTimestamp_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitTimestamp_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Spanner timestamp at which the transaction committed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCommitTimestampFieldBuilder() {
      if (commitTimestampBuilder_ == null) {
        commitTimestampBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCommitTimestamp(), getParentForChildren(), isClean());
        commitTimestamp_ = null;
      }
      return commitTimestampBuilder_;
    }

    private com.google.spanner.v1.CommitResponse.CommitStats commitStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.CommitResponse.CommitStats,
            com.google.spanner.v1.CommitResponse.CommitStats.Builder,
            com.google.spanner.v1.CommitResponse.CommitStatsOrBuilder>
        commitStatsBuilder_;
    /**
     *
     *
     * <pre>
     * The statistics about this Commit. Not returned by default.
     * For more information, see
     * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
     * </pre>
     *
     * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
     *
     * @return Whether the commitStats field is set.
     */
    public boolean hasCommitStats() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The statistics about this Commit. Not returned by default.
     * For more information, see
     * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
     * </pre>
     *
     * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
     *
     * @return The commitStats.
     */
    public com.google.spanner.v1.CommitResponse.CommitStats getCommitStats() {
      if (commitStatsBuilder_ == null) {
        return commitStats_ == null
            ? com.google.spanner.v1.CommitResponse.CommitStats.getDefaultInstance()
            : commitStats_;
      } else {
        return commitStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The statistics about this Commit. Not returned by default.
     * For more information, see
     * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
     * </pre>
     *
     * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
     */
    public Builder setCommitStats(com.google.spanner.v1.CommitResponse.CommitStats value) {
      if (commitStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitStats_ = value;
      } else {
        commitStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics about this Commit. Not returned by default.
     * For more information, see
     * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
     * </pre>
     *
     * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
     */
    public Builder setCommitStats(
        com.google.spanner.v1.CommitResponse.CommitStats.Builder builderForValue) {
      if (commitStatsBuilder_ == null) {
        commitStats_ = builderForValue.build();
      } else {
        commitStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics about this Commit. Not returned by default.
     * For more information, see
     * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
     * </pre>
     *
     * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
     */
    public Builder mergeCommitStats(com.google.spanner.v1.CommitResponse.CommitStats value) {
      if (commitStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && commitStats_ != null
            && commitStats_
                != com.google.spanner.v1.CommitResponse.CommitStats.getDefaultInstance()) {
          getCommitStatsBuilder().mergeFrom(value);
        } else {
          commitStats_ = value;
        }
      } else {
        commitStatsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics about this Commit. Not returned by default.
     * For more information, see
     * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
     * </pre>
     *
     * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
     */
    public Builder clearCommitStats() {
      bitField0_ = (bitField0_ & ~0x00000002);
      commitStats_ = null;
      if (commitStatsBuilder_ != null) {
        commitStatsBuilder_.dispose();
        commitStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The statistics about this Commit. Not returned by default.
     * For more information, see
     * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
     * </pre>
     *
     * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
     */
    public com.google.spanner.v1.CommitResponse.CommitStats.Builder getCommitStatsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCommitStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The statistics about this Commit. Not returned by default.
     * For more information, see
     * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
     * </pre>
     *
     * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
     */
    public com.google.spanner.v1.CommitResponse.CommitStatsOrBuilder getCommitStatsOrBuilder() {
      if (commitStatsBuilder_ != null) {
        return commitStatsBuilder_.getMessageOrBuilder();
      } else {
        return commitStats_ == null
            ? com.google.spanner.v1.CommitResponse.CommitStats.getDefaultInstance()
            : commitStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * The statistics about this Commit. Not returned by default.
     * For more information, see
     * [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
     * </pre>
     *
     * <code>.google.spanner.v1.CommitResponse.CommitStats commit_stats = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.CommitResponse.CommitStats,
            com.google.spanner.v1.CommitResponse.CommitStats.Builder,
            com.google.spanner.v1.CommitResponse.CommitStatsOrBuilder>
        getCommitStatsFieldBuilder() {
      if (commitStatsBuilder_ == null) {
        commitStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.CommitResponse.CommitStats,
                com.google.spanner.v1.CommitResponse.CommitStats.Builder,
                com.google.spanner.v1.CommitResponse.CommitStatsOrBuilder>(
                getCommitStats(), getParentForChildren(), isClean());
        commitStats_ = null;
      }
      return commitStatsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.CommitResponse)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.CommitResponse)
  private static final com.google.spanner.v1.CommitResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.CommitResponse();
  }

  public static com.google.spanner.v1.CommitResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CommitResponse> PARSER =
      new com.google.protobuf.AbstractParser<CommitResponse>() {
        @java.lang.Override
        public CommitResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CommitResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CommitResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.CommitResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
